/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner.listener;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.tracing.Trace;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;

public class TraceRunListener
extends RunListener {
    private static final String TAG = TraceRunListener.class.getSimpleName();
    private static final int MAX_SECTION_NAME_LEN = 127;
    private Thread startedThread = null;

    public void testStarted(Description description) throws Exception {
        this.startedThread = Thread.currentThread();
        String testClassName = description.getTestClass() != null ? description.getTestClass().getSimpleName() : "None";
        String methodName = description.getMethodName() != null ? description.getMethodName() : "None";
        Trace.beginSection((String)TraceRunListener.sanitizeSpanName(testClassName + "#" + methodName));
    }

    public void testFinished(Description description) throws Exception {
        if (Thread.currentThread().equals(this.startedThread)) {
            Trace.endSection();
        } else {
            Log.e((String)"TraceRunListener", (String)"testFinished called on different thread than testStarted");
        }
        this.startedThread = null;
    }

    @NonNull
    private static String sanitizeSpanName(@NonNull String name) {
        if (name.length() > 127) {
            Log.w((String)TAG, (String)("Span name exceeds limits: " + name));
            name = name.substring(0, 127);
        }
        return name;
    }
}

