/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.orchestrator.listeners.result;

import android.util.Log;
import androidx.test.orchestrator.listeners.result.ITestRunListener;
import androidx.test.orchestrator.listeners.result.TestIdentifier;
import androidx.test.orchestrator.listeners.result.TestResult;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class TestRunResult
implements ITestRunListener {
    private static final String LOG_TAG = TestRunResult.class.getSimpleName();
    private String testRunName = "not started";
    private Map<TestIdentifier, TestResult> testResults = new LinkedHashMap<TestIdentifier, TestResult>();
    private Map<String, String> runMetrics = new HashMap<String, String>();
    private boolean isRunComplete = false;
    private long elapsedTime = 0L;
    private int[] statusCounts = new int[TestResult.TestStatus.values().length];
    private boolean isCountDirty = true;
    private String runFailureError = null;
    private boolean aggregateMetrics = false;

    public void setAggregateMetrics(boolean metricAggregation) {
        this.aggregateMetrics = metricAggregation;
    }

    public String getName() {
        return this.testRunName;
    }

    public Map<TestIdentifier, TestResult> getTestResults() {
        return this.testResults;
    }

    public Map<String, String> getRunMetrics() {
        return this.runMetrics;
    }

    public Set<TestIdentifier> getCompletedTests() {
        LinkedHashSet<TestIdentifier> completedTests = new LinkedHashSet<TestIdentifier>();
        for (Map.Entry<TestIdentifier, TestResult> testEntry : this.getTestResults().entrySet()) {
            if (testEntry.getValue().getStatus().equals((Object)TestResult.TestStatus.INCOMPLETE)) continue;
            completedTests.add(testEntry.getKey());
        }
        return completedTests;
    }

    public boolean isRunFailure() {
        return this.runFailureError != null;
    }

    public boolean isRunComplete() {
        return this.isRunComplete;
    }

    public void setRunComplete(boolean runComplete) {
        this.isRunComplete = runComplete;
    }

    public int getNumTestsInState(TestResult.TestStatus status) {
        if (this.isCountDirty) {
            for (int i = 0; i < this.statusCounts.length; ++i) {
                this.statusCounts[i] = 0;
            }
            for (TestResult r : this.testResults.values()) {
                int n = r.getStatus().ordinal();
                this.statusCounts[n] = this.statusCounts[n] + 1;
            }
            this.isCountDirty = false;
        }
        return this.statusCounts[status.ordinal()];
    }

    public int getNumTests() {
        return this.testResults.size();
    }

    public int getNumCompleteTests() {
        return this.getNumTests() - this.getNumTestsInState(TestResult.TestStatus.INCOMPLETE);
    }

    public boolean hasFailedTests() {
        return this.getNumAllFailedTests() > 0;
    }

    public int getNumAllFailedTests() {
        return this.getNumTestsInState(TestResult.TestStatus.FAILURE);
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String getRunFailureMessage() {
        return this.runFailureError;
    }

    @Override
    public void testRunStarted(String runName, int testCount) {
        this.testRunName = runName;
        this.isRunComplete = false;
        this.runFailureError = null;
    }

    @Override
    public void testStarted(TestIdentifier test) {
        this.addTestResult(test, new TestResult());
    }

    private void addTestResult(TestIdentifier test, TestResult testResult) {
        this.isCountDirty = true;
        this.testResults.put(test, testResult);
    }

    private void updateTestResult(TestIdentifier test, TestResult.TestStatus status, String trace) {
        TestResult r = this.testResults.get(test);
        if (r == null) {
            Log.w((String)LOG_TAG, (String)String.format("received test event %s without test start for %s. trace: %s", status.name(), test, trace));
            r = new TestResult();
        }
        r.setStatus(status);
        r.setStackTrace(trace);
        this.addTestResult(test, r);
    }

    @Override
    public void testFailed(TestIdentifier test, String trace) {
        this.updateTestResult(test, TestResult.TestStatus.FAILURE, trace);
    }

    @Override
    public void testAssumptionFailure(TestIdentifier test, String trace) {
        this.updateTestResult(test, TestResult.TestStatus.ASSUMPTION_FAILURE, trace);
    }

    @Override
    public void testIgnored(TestIdentifier test) {
        this.updateTestResult(test, TestResult.TestStatus.IGNORED, null);
    }

    @Override
    public void testEnded(TestIdentifier test, Map<String, String> testMetrics) {
        TestResult result = this.testResults.get(test);
        if (result == null) {
            result = new TestResult();
        }
        if (result.getStatus().equals((Object)TestResult.TestStatus.INCOMPLETE)) {
            result.setStatus(TestResult.TestStatus.PASSED);
        }
        result.setEndTime(System.currentTimeMillis());
        result.setMetrics(testMetrics);
        this.addTestResult(test, result);
    }

    @Override
    public void testRunFailed(String errorMessage) {
        this.runFailureError = errorMessage;
    }

    @Override
    public void testRunStopped(long elapsedTime) {
        this.elapsedTime += elapsedTime;
        this.isRunComplete = true;
    }

    @Override
    public void testRunEnded(long elapsedTime, Map<String, String> runMetrics) {
        if (this.aggregateMetrics) {
            for (Map.Entry<String, String> entry : runMetrics.entrySet()) {
                String existingValue = this.runMetrics.get(entry.getKey());
                String combinedValue = this.combineValues(existingValue, entry.getValue());
                this.runMetrics.put(entry.getKey(), combinedValue);
            }
        } else {
            this.runMetrics.putAll(runMetrics);
        }
        this.elapsedTime += elapsedTime;
        this.isRunComplete = true;
    }

    private String combineValues(String existingValue, String newValue) {
        if (existingValue != null) {
            try {
                Long existingLong = Long.parseLong(existingValue);
                Long newLong = Long.parseLong(newValue);
                return Long.toString(existingLong + newLong);
            }
            catch (NumberFormatException existingLong) {
                try {
                    Double existingDouble = Double.parseDouble(existingValue);
                    Double newDouble = Double.parseDouble(newValue);
                    return Double.toString(existingDouble + newDouble);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return newValue;
    }

    public String getTextSummary() {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Total tests %d, ", this.getNumTests()));
        for (TestResult.TestStatus status : TestResult.TestStatus.values()) {
            int count = this.getNumTestsInState(status);
            if (count <= 0) continue;
            builder.append(String.format("%s %d, ", status.toString().toLowerCase(), count));
        }
        return builder.toString();
    }
}

