/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.events.discovery;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.RestrictTo;
import androidx.test.services.events.discovery.TestDiscoveryErrorEvent;
import androidx.test.services.events.discovery.TestDiscoveryEvent;
import androidx.test.services.events.discovery.TestDiscoveryFinishedEvent;
import androidx.test.services.events.discovery.TestDiscoveryStartedEvent;
import androidx.test.services.events.discovery.TestFoundEvent;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
final class TestDiscoveryEventFactory
implements Parcelable.Creator<TestDiscoveryEvent> {
    TestDiscoveryEventFactory() {
    }

    public TestDiscoveryEvent createFromParcel(Parcel source) {
        TestDiscoveryEvent.EventType instanceType = TestDiscoveryEvent.EventType.valueOf(source.readString());
        switch (instanceType) {
            case STARTED: {
                return new TestDiscoveryStartedEvent();
            }
            case TEST_FOUND: {
                return new TestFoundEvent(source);
            }
            case ERROR: {
                return new TestDiscoveryErrorEvent(source);
            }
            case FINISHED: {
                return new TestDiscoveryFinishedEvent();
            }
        }
        throw new IllegalArgumentException("Unhandled event type: " + (Object)((Object)instanceType));
    }

    public TestDiscoveryEvent[] newArray(int size) {
        return new TestDiscoveryEvent[size];
    }
}

