/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.internal.runner;

import android.app.Instrumentation;
import android.os.Bundle;
import androidx.test.internal.runner.listener.InstrumentationRunListener;
import androidx.test.internal.util.Checks;
import androidx.test.services.events.internal.StackTrimmer;
import androidx.tracing.Trace;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.junit.runner.JUnitCore;
import org.junit.runner.Request;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public final class TestExecutor {
    private final List<RunListener> listeners;
    private final Instrumentation instr;

    private TestExecutor(Builder builder) {
        this.listeners = (List)Checks.checkNotNull((Object)builder.listeners);
        this.instr = builder.instr;
    }

    public Bundle execute(Request request) throws UnsupportedEncodingException {
        Trace.beginSection((String)"execute tests");
        try {
            Bundle bundle = this.execute(new JUnitCore(), request);
            return bundle;
        }
        finally {
            Trace.endSection();
        }
    }

    Bundle execute(JUnitCore junitRunner, Request request) throws UnsupportedEncodingException {
        Bundle resultBundle = new Bundle();
        this.setUpListeners(junitRunner);
        Result junitResults = junitRunner.run(request);
        ByteArrayOutputStream summaryStream = new ByteArrayOutputStream();
        try (PrintStream summaryWriter = new PrintStream(summaryStream);){
            this.reportRunEnded(this.listeners, summaryWriter, resultBundle, junitResults);
        }
        String summaryOutput = StackTrimmer.getTrimmedSummary(summaryStream.toString("UTF_8"));
        resultBundle.putString("stream", String.format("\n%s", summaryOutput));
        return resultBundle;
    }

    private void setUpListeners(JUnitCore testRunner) {
        for (RunListener listener : this.listeners) {
            testRunner.addListener(listener);
            if (!(listener instanceof InstrumentationRunListener)) continue;
            ((InstrumentationRunListener)listener).setInstrumentation(this.instr);
        }
    }

    private void reportRunEnded(List<RunListener> listeners, PrintStream summaryWriter, Bundle resultBundle, Result jUnitResults) {
        for (RunListener listener : listeners) {
            if (!(listener instanceof InstrumentationRunListener)) continue;
            ((InstrumentationRunListener)listener).instrumentationRunFinished(summaryWriter, resultBundle, jUnitResults);
        }
    }

    public static class Builder {
        private final List<RunListener> listeners = new ArrayList<RunListener>();
        private final Instrumentation instr;

        public Builder(Instrumentation instr) {
            this.instr = instr;
        }

        public Builder addRunListener(RunListener listener) {
            this.listeners.add((RunListener)Checks.checkNotNull((Object)listener));
            return this;
        }

        public TestExecutor build() {
            return new TestExecutor(this);
        }
    }
}

