/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.services.storage.internal;

import android.content.ContentResolver;
import android.net.Uri;
import androidx.test.internal.util.Checks;
import androidx.test.platform.app.InstrumentationRegistry;
import androidx.test.services.storage.file.HostedFile;
import androidx.test.services.storage.internal.TestStorageUtil;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public final class InternalTestStorage {
    private final ContentResolver contentResolver = InstrumentationRegistry.getInstrumentation().getTargetContext().getContentResolver();

    public InputStream openInternalInputStream(@Nonnull String pathname) throws FileNotFoundException {
        Checks.checkNotNull((Object)pathname);
        Uri outputUri = HostedFile.buildUri(HostedFile.FileHost.INTERNAL_USE_ONLY, pathname);
        return TestStorageUtil.getInputStream(outputUri, this.contentResolver);
    }

    public OutputStream openInternalOutputStream(@Nonnull String pathname) throws FileNotFoundException {
        Checks.checkNotNull((Object)pathname);
        Uri outputUri = HostedFile.buildUri(HostedFile.FileHost.INTERNAL_USE_ONLY, pathname);
        return TestStorageUtil.getOutputStream(outputUri, this.contentResolver);
    }
}

