/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Pair;
import androidx.wear.protolayout.expression.pipeline.AnimationsHelper;
import androidx.wear.protolayout.expression.pipeline.QuotaAwareAnimator;
import androidx.wear.protolayout.expression.pipeline.QuotaAwareAnimatorWithAux;
import androidx.wear.protolayout.expression.pipeline.QuotaManager;
import androidx.wear.protolayout.expression.proto.AnimationParameterProto;

abstract class AnimatableNode {
    static final ArgbEvaluator ARGB_EVALUATOR = new ArgbEvaluator();
    private boolean mIsVisible = false;
    @NonNull
    final QuotaAwareAnimator mQuotaAwareAnimator;

    protected AnimatableNode(@NonNull QuotaManager quotaManager, @NonNull AnimationParameterProto.AnimationSpec spec) {
        this(quotaManager, spec, null);
    }

    protected AnimatableNode(@NonNull QuotaManager quotaManager, @NonNull AnimationParameterProto.AnimationSpec spec, @Nullable TypeEvaluator<?> evaluator) {
        Pair<AnimationParameterProto.AnimationSpec, AnimationParameterProto.AnimationSpec> specs = AnimationsHelper.maybeSplitToMainAndAuxAnimationSpec(spec);
        this.mQuotaAwareAnimator = specs != null ? new QuotaAwareAnimatorWithAux(quotaManager, (AnimationParameterProto.AnimationSpec)specs.first, (AnimationParameterProto.AnimationSpec)specs.second, evaluator) : new QuotaAwareAnimator(quotaManager, spec, evaluator);
    }

    @VisibleForTesting(otherwise=5)
    AnimatableNode(@NonNull QuotaAwareAnimator quotaAwareAnimator) {
        this.mQuotaAwareAnimator = quotaAwareAnimator;
    }

    @UiThread
    protected void startOrSkipAnimator() {
        if (this.mIsVisible) {
            this.mQuotaAwareAnimator.tryStartAnimation();
        } else {
            this.stopOrPauseAnimator();
        }
    }

    @UiThread
    void setVisibility(boolean visible) {
        if (this.mIsVisible == visible) {
            return;
        }
        this.mIsVisible = visible;
        if (this.mIsVisible) {
            this.startOrResumeAnimator();
        } else if (this.mQuotaAwareAnimator.isRunning()) {
            this.stopOrPauseAnimator();
        }
    }

    private void startOrResumeAnimator() {
        this.mQuotaAwareAnimator.tryStartOrResumeInfiniteAnimation();
    }

    boolean hasRunningAnimation() {
        return this.mQuotaAwareAnimator.isRunning();
    }

    @VisibleForTesting(otherwise=3)
    protected boolean isInfiniteAnimator() {
        return this.mQuotaAwareAnimator.isInfiniteAnimator();
    }

    private void stopOrPauseAnimator() {
        this.mQuotaAwareAnimator.stopOrPauseAnimator();
    }
}

