/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.PathInterpolator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.Pair;
import androidx.wear.protolayout.expression.proto.AnimationParameterProto;
import java.time.Duration;
import java.util.EnumMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class AnimationsHelper {
    private static final Duration DEFAULT_ANIM_DURATION = Duration.ofMillis(300L);
    private static final Interpolator DEFAULT_ANIM_INTERPOLATOR = new LinearInterpolator();
    private static final Duration DEFAULT_ANIM_DELAY = Duration.ZERO;
    private static final int DEFAULT_REPEAT_COUNT = 0;
    private static final int DEFAULT_REPEAT_MODE = 1;
    private static final Map<AnimationParameterProto.RepeatMode, Integer> sRepeatModeForAnimator = new EnumMap<AnimationParameterProto.RepeatMode, Integer>(AnimationParameterProto.RepeatMode.class);

    private AnimationsHelper() {
    }

    @NonNull
    public static Duration getMainDurationOrDefault(@NonNull AnimationParameterProto.AnimationSpec spec) {
        return spec.hasAnimationParameters() && spec.getAnimationParameters().getDurationMillis() > 0L ? Duration.ofMillis(spec.getAnimationParameters().getDurationMillis()) : (spec.getDurationMillis() > 0 ? Duration.ofMillis(spec.getDurationMillis()) : DEFAULT_ANIM_DURATION);
    }

    @NonNull
    public static Duration getMainDelayOrDefault(@NonNull AnimationParameterProto.AnimationSpec spec) {
        return spec.getAnimationParameters().hasDelayMillis() ? Duration.ofMillis(spec.getAnimationParameters().getDelayMillis()) : (spec.getStartDelayMillis() > 0 ? Duration.ofMillis(spec.getStartDelayMillis()) : DEFAULT_ANIM_DELAY);
    }

    @NonNull
    public static Interpolator getMainInterpolatorOrDefault(@NonNull AnimationParameterProto.AnimationSpec spec) {
        Interpolator interpolator = DEFAULT_ANIM_INTERPOLATOR;
        AnimationParameterProto.Easing easing = null;
        if (spec.getAnimationParameters().hasEasing()) {
            easing = spec.getAnimationParameters().getEasing();
        } else if (spec.hasEasing()) {
            easing = spec.getEasing();
        }
        if (easing != null) {
            switch (easing.getInnerCase()) {
                case CUBIC_BEZIER: {
                    if (!easing.hasCubicBezier()) break;
                    AnimationParameterProto.CubicBezierEasing cbe = easing.getCubicBezier();
                    interpolator = new PathInterpolator(cbe.getX1(), cbe.getY1(), cbe.getX2(), cbe.getY2());
                    break;
                }
            }
        }
        return interpolator;
    }

    public static int getRepeatCountOrDefault(@NonNull AnimationParameterProto.AnimationSpec spec) {
        int repeatCount = 0;
        if (spec.hasRepeatable()) {
            AnimationParameterProto.Repeatable repeatable = spec.getRepeatable();
            repeatCount = repeatable.getIterations() <= 0 ? -1 : repeatable.getIterations() - 1;
        }
        return repeatCount;
    }

    public static int getRepeatModeOrDefault(@NonNull AnimationParameterProto.AnimationSpec spec) {
        AnimationParameterProto.Repeatable repeatable;
        Integer repeatModeFromMap;
        int repeatMode = 1;
        if (spec.hasRepeatable() && (repeatModeFromMap = sRepeatModeForAnimator.get((repeatable = spec.getRepeatable()).getRepeatMode())) != null) {
            repeatMode = repeatModeFromMap;
        }
        return repeatMode;
    }

    @NonNull
    public static Duration getOverrideReverseDurationOrDefault(@NonNull AnimationParameterProto.AnimationSpec spec) {
        AnimationParameterProto.Repeatable repeatable;
        if (spec.hasRepeatable() && (repeatable = spec.getRepeatable()).hasReverseRepeatOverride()) {
            AnimationParameterProto.AnimationParameters reverseParameters = repeatable.getReverseRepeatOverride();
            return reverseParameters.getDurationMillis() > 0L ? Duration.ofMillis(reverseParameters.getDurationMillis()) : AnimationsHelper.getMainDurationOrDefault(spec);
        }
        return AnimationsHelper.getMainDurationOrDefault(spec);
    }

    static boolean hasCustomReverseDuration(@NonNull AnimationParameterProto.AnimationSpec spec) {
        return spec.hasRepeatable() && AnimationsHelper.getRepeatCountOrDefault(spec) != 0 && AnimationsHelper.getRepeatModeOrDefault(spec) == 2 && AnimationsHelper.getOverrideReverseDurationOrDefault(spec).toMillis() != AnimationsHelper.getMainDurationOrDefault(spec).toMillis();
    }

    static RepeatDelays getRepeatDelays(AnimationParameterProto.AnimationSpec spec) {
        long mainDelay;
        long forwardRepeatDelay = mainDelay = AnimationsHelper.getMainDelayOrDefault(spec).toMillis();
        long reverseRepeatDelay = mainDelay;
        int repeatCount = AnimationsHelper.getRepeatCountOrDefault(spec);
        if (repeatCount > 0 || repeatCount == -1) {
            if (spec.getRepeatable().getForwardRepeatOverride().hasDelayMillis()) {
                forwardRepeatDelay = spec.getRepeatable().getForwardRepeatOverride().getDelayMillis();
            }
            if (AnimationsHelper.getRepeatModeOrDefault(spec) == 2 && spec.getRepeatable().getReverseRepeatOverride().hasDelayMillis()) {
                reverseRepeatDelay = spec.getRepeatable().getReverseRepeatOverride().getDelayMillis();
            }
        }
        return new RepeatDelays(forwardRepeatDelay, reverseRepeatDelay);
    }

    @Nullable
    static Pair<AnimationParameterProto.AnimationSpec, AnimationParameterProto.AnimationSpec> maybeSplitToMainAndAuxAnimationSpec(@NonNull AnimationParameterProto.AnimationSpec spec) {
        if (!AnimationsHelper.hasCustomReverseDuration(spec)) {
            return null;
        }
        long forwardDuration = AnimationsHelper.getMainDurationOrDefault(spec).toMillis();
        long reverseDuration = AnimationsHelper.getOverrideReverseDurationOrDefault(spec).toMillis();
        AnimationParameterProto.Repeatable repeatable = spec.getRepeatable();
        RepeatDelays repeatDelays = AnimationsHelper.getRepeatDelays(spec);
        AnimationParameterProto.Easing easing = null;
        if (spec.getAnimationParameters().hasEasing()) {
            easing = spec.getAnimationParameters().getEasing();
        }
        AnimationParameterProto.AnimationParameters.Builder mainParametersBuilder = AnimationParameterProto.AnimationParameters.newBuilder().setDurationMillis(forwardDuration).setDelayMillis(AnimationsHelper.getMainDelayOrDefault(spec).toMillis());
        if (easing != null) {
            mainParametersBuilder.setEasing(easing);
        }
        AnimationParameterProto.AnimationSpec mainAnimatorSpec = (AnimationParameterProto.AnimationSpec)AnimationParameterProto.AnimationSpec.newBuilder().setAnimationParameters((AnimationParameterProto.AnimationParameters)mainParametersBuilder.build()).setRepeatable((AnimationParameterProto.Repeatable)AnimationParameterProto.Repeatable.newBuilder().setIterations((repeatable.getIterations() + 1) / 2).setRepeatMode(AnimationParameterProto.RepeatMode.REPEAT_MODE_RESTART).setForwardRepeatOverride((AnimationParameterProto.AnimationParameters)AnimationParameterProto.AnimationParameters.newBuilder().setDelayMillis(repeatDelays.mReverseRepeatDelay).build()).build()).build();
        AnimationParameterProto.AnimationParameters.Builder auxParametersBuilder = AnimationParameterProto.AnimationParameters.newBuilder().setDurationMillis(reverseDuration).setDelayMillis(forwardDuration + repeatDelays.mReverseRepeatDelay);
        if (spec.getRepeatable().getReverseRepeatOverride().hasEasing()) {
            easing = spec.getRepeatable().getReverseRepeatOverride().getEasing();
        }
        if (easing != null) {
            auxParametersBuilder.setEasing(easing);
        }
        AnimationParameterProto.AnimationSpec auxAnimatorSpec = (AnimationParameterProto.AnimationSpec)AnimationParameterProto.AnimationSpec.newBuilder().setAnimationParameters((AnimationParameterProto.AnimationParameters)auxParametersBuilder.build()).setRepeatable((AnimationParameterProto.Repeatable)AnimationParameterProto.Repeatable.newBuilder().setIterations(repeatable.getIterations() / 2).setRepeatMode(AnimationParameterProto.RepeatMode.REPEAT_MODE_RESTART).setForwardRepeatOverride((AnimationParameterProto.AnimationParameters)AnimationParameterProto.AnimationParameters.newBuilder().setDelayMillis(repeatDelays.mForwardRepeatDelay).build()).build()).build();
        return Pair.create((Object)mainAnimatorSpec, (Object)auxAnimatorSpec);
    }

    public static void applyAnimationSpecToAnimator(@NonNull ValueAnimator animator, @NonNull AnimationParameterProto.AnimationSpec spec) {
        animator.setDuration(AnimationsHelper.getMainDurationOrDefault(spec).toMillis());
        animator.setStartDelay(AnimationsHelper.getMainDelayOrDefault(spec).toMillis());
        animator.setInterpolator((TimeInterpolator)AnimationsHelper.getMainInterpolatorOrDefault(spec));
        animator.setRepeatCount(AnimationsHelper.getRepeatCountOrDefault(spec));
        animator.setRepeatMode(AnimationsHelper.getRepeatModeOrDefault(spec));
    }

    public static void applyAnimationSpecToAnimation(@NonNull Animation animation, @NonNull AnimationParameterProto.AnimationSpec spec) {
        animation.setDuration(AnimationsHelper.getMainDurationOrDefault(spec).toMillis());
        animation.setStartOffset(AnimationsHelper.getMainDelayOrDefault(spec).toMillis());
        animation.setInterpolator(AnimationsHelper.getMainInterpolatorOrDefault(spec));
        animation.setRepeatCount(AnimationsHelper.getRepeatCountOrDefault(spec));
        animation.setRepeatMode(AnimationsHelper.getRepeatModeOrDefault(spec));
    }

    static {
        sRepeatModeForAnimator.put(AnimationParameterProto.RepeatMode.REPEAT_MODE_UNKNOWN, 1);
        sRepeatModeForAnimator.put(AnimationParameterProto.RepeatMode.REPEAT_MODE_RESTART, 1);
        sRepeatModeForAnimator.put(AnimationParameterProto.RepeatMode.REPEAT_MODE_REVERSE, 2);
    }

    static class RepeatDelays {
        long mForwardRepeatDelay;
        long mReverseRepeatDelay;

        RepeatDelays(long forwardRepeatDelay, long reverseRepeatDelay) {
            this.mForwardRepeatDelay = forwardRepeatDelay;
            this.mReverseRepeatDelay = reverseRepeatDelay;
        }
    }
}

