/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import android.util.Log;
import androidx.annotation.UiThread;
import androidx.wear.protolayout.expression.pipeline.DynamicDataBiTransformNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataSourceNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataTransformNode;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiverWithPreUpdate;
import androidx.wear.protolayout.expression.pipeline.StateSourceNode;
import androidx.wear.protolayout.expression.pipeline.StateStore;
import androidx.wear.protolayout.expression.proto.DynamicProto;
import androidx.wear.protolayout.expression.proto.FixedProto;

class BoolNodes {
    private BoolNodes() {
    }

    static class LogicalBoolOp
    extends DynamicDataBiTransformNode<Boolean, Boolean, Boolean> {
        private static final String TAG = "LogicalBooleanOp";

        LogicalBoolOp(DynamicProto.LogicalBoolOp protoNode, DynamicTypeValueReceiverWithPreUpdate<Boolean> downstream) {
            super(downstream, (LhsT a, RhsT b) -> {
                switch (protoNode.getOperationType()) {
                    case LOGICAL_OP_TYPE_AND: {
                        return a != false && b != false;
                    }
                    case LOGICAL_OP_TYPE_OR: {
                        return a != false || b != false;
                    }
                }
                Log.e((String)TAG, (String)"Unknown operation type in LogicalBoolOp");
                return false;
            });
        }
    }

    static class NotBoolOp
    extends DynamicDataTransformNode<Boolean, Boolean> {
        NotBoolOp(DynamicTypeValueReceiverWithPreUpdate<Boolean> downstream) {
            super(downstream, b -> b == false);
        }
    }

    static class ComparisonFloatNode
    extends DynamicDataBiTransformNode<Float, Float, Boolean> {
        private static final String TAG = "ComparisonFloatNode";
        public static final float EPSILON = 1.0E-6f;

        ComparisonFloatNode(DynamicProto.ComparisonFloatOp protoNode, DynamicTypeValueReceiverWithPreUpdate<Boolean> downstream) {
            super(downstream, (LhsT lhs, RhsT rhs) -> {
                float unboxedLhs = lhs.floatValue();
                float unboxedRhs = rhs.floatValue();
                switch (protoNode.getOperationType()) {
                    case COMPARISON_OP_TYPE_EQUALS: {
                        return ComparisonFloatNode.equalFloats(unboxedLhs, unboxedRhs);
                    }
                    case COMPARISON_OP_TYPE_NOT_EQUALS: {
                        return !ComparisonFloatNode.equalFloats(unboxedLhs, unboxedRhs);
                    }
                    case COMPARISON_OP_TYPE_LESS_THAN: {
                        return unboxedLhs < unboxedRhs && !ComparisonFloatNode.equalFloats(unboxedLhs, unboxedRhs);
                    }
                    case COMPARISON_OP_TYPE_LESS_THAN_OR_EQUAL_TO: {
                        return unboxedLhs < unboxedRhs || ComparisonFloatNode.equalFloats(unboxedLhs, unboxedRhs);
                    }
                    case COMPARISON_OP_TYPE_GREATER_THAN: {
                        return unboxedLhs > unboxedRhs && !ComparisonFloatNode.equalFloats(unboxedLhs, unboxedRhs);
                    }
                    case COMPARISON_OP_TYPE_GREATER_THAN_OR_EQUAL_TO: {
                        return unboxedLhs > unboxedRhs || ComparisonFloatNode.equalFloats(unboxedLhs, unboxedRhs);
                    }
                }
                Log.e((String)TAG, (String)"Unknown operation type in ComparisonInt32Node");
                return false;
            });
        }

        private static boolean equalFloats(float lhs, float rhs) {
            return Math.abs(lhs - rhs) < 1.0E-6f;
        }
    }

    static class ComparisonInt32Node
    extends DynamicDataBiTransformNode<Integer, Integer, Boolean> {
        private static final String TAG = "ComparisonInt32Node";

        ComparisonInt32Node(DynamicProto.ComparisonInt32Op protoNode, DynamicTypeValueReceiverWithPreUpdate<Boolean> downstream) {
            super(downstream, (LhsT lhs, RhsT rhs) -> {
                int unboxedLhs = lhs;
                int unboxedRhs = rhs;
                switch (protoNode.getOperationType()) {
                    case COMPARISON_OP_TYPE_EQUALS: {
                        return unboxedLhs == unboxedRhs;
                    }
                    case COMPARISON_OP_TYPE_NOT_EQUALS: {
                        return unboxedLhs != unboxedRhs;
                    }
                    case COMPARISON_OP_TYPE_LESS_THAN: {
                        return unboxedLhs < unboxedRhs;
                    }
                    case COMPARISON_OP_TYPE_LESS_THAN_OR_EQUAL_TO: {
                        return unboxedLhs <= unboxedRhs;
                    }
                    case COMPARISON_OP_TYPE_GREATER_THAN: {
                        return unboxedLhs > unboxedRhs;
                    }
                    case COMPARISON_OP_TYPE_GREATER_THAN_OR_EQUAL_TO: {
                        return unboxedLhs >= unboxedRhs;
                    }
                }
                Log.e((String)TAG, (String)"Unknown operation type in ComparisonInt32Node");
                return false;
            });
        }
    }

    static class StateBoolNode
    extends StateSourceNode<Boolean> {
        StateBoolNode(StateStore stateStore, DynamicProto.StateBoolSource protoNode, DynamicTypeValueReceiverWithPreUpdate<Boolean> downstream) {
            super(stateStore, protoNode.getSourceKey(), se -> se.getBoolVal().getValue(), downstream);
        }
    }

    static class FixedBoolNode
    implements DynamicDataSourceNode<Boolean> {
        private final boolean mValue;
        private final DynamicTypeValueReceiverWithPreUpdate<Boolean> mDownstream;

        FixedBoolNode(FixedProto.FixedBool protoNode, DynamicTypeValueReceiverWithPreUpdate<Boolean> downstream) {
            this.mValue = protoNode.getValue();
            this.mDownstream = downstream;
        }

        @Override
        @UiThread
        public void preInit() {
            this.mDownstream.onPreUpdate();
        }

        @Override
        @UiThread
        public void init() {
            this.mDownstream.onData(this.mValue);
        }

        @Override
        @UiThread
        public void destroy() {
        }
    }
}

