/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import androidx.wear.protolayout.expression.pipeline.AnimatableNode;
import androidx.wear.protolayout.expression.pipeline.BoundDynamicType;
import androidx.wear.protolayout.expression.pipeline.DynamicDataNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataSourceNode;
import androidx.wear.protolayout.expression.pipeline.QuotaManager;
import java.util.List;

class BoundDynamicTypeImpl
implements BoundDynamicType {
    private final List<DynamicDataNode<?>> mNodes;
    private final QuotaManager mDynamicDataNodesQuotaManager;

    BoundDynamicTypeImpl(List<DynamicDataNode<?>> nodes, QuotaManager dynamicDataNodesQuotaManager) {
        this.mNodes = nodes;
        this.mDynamicDataNodesQuotaManager = dynamicDataNodesQuotaManager;
    }

    @Override
    public void startEvaluation() {
        this.mNodes.stream().filter(n -> n instanceof DynamicDataSourceNode).forEach(n -> ((DynamicDataSourceNode)n).preInit());
        this.mNodes.stream().filter(n -> n instanceof DynamicDataSourceNode).forEach(n -> ((DynamicDataSourceNode)n).init());
    }

    @Override
    public void setAnimationVisibility(boolean visible) {
        this.mNodes.stream().filter(n -> n instanceof AnimatableNode).forEach(n -> ((AnimatableNode)((Object)n)).setVisibility(visible));
    }

    @Override
    public int getRunningAnimationCount() {
        return (int)this.mNodes.stream().filter(n -> n instanceof AnimatableNode).filter(n -> ((AnimatableNode)((Object)n)).hasRunningAnimation()).count();
    }

    @Override
    public int getDynamicNodeCount() {
        return this.mNodes.size();
    }

    @Override
    public void close() {
        this.mNodes.stream().filter(n -> n instanceof DynamicDataSourceNode).forEach(n -> ((DynamicDataSourceNode)n).destroy());
        this.mDynamicDataNodesQuotaManager.releaseQuota(this.getDynamicNodeCount());
    }
}

