/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import android.animation.TypeEvaluator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.wear.protolayout.expression.pipeline.AnimatableNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataSourceNode;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiverWithPreUpdate;
import androidx.wear.protolayout.expression.pipeline.QuotaManager;
import androidx.wear.protolayout.expression.pipeline.StateSourceNode;
import androidx.wear.protolayout.expression.pipeline.StateStore;
import androidx.wear.protolayout.expression.proto.AnimationParameterProto;
import androidx.wear.protolayout.expression.proto.DynamicProto;
import androidx.wear.protolayout.expression.proto.FixedProto;

class ColorNodes {
    private ColorNodes() {
    }

    static class DynamicAnimatedColorNode
    extends AnimatableNode
    implements DynamicDataNode<Integer> {
        final DynamicTypeValueReceiverWithPreUpdate<Integer> mDownstream;
        private final DynamicTypeValueReceiverWithPreUpdate<Integer> mInputCallback;
        @Nullable
        Integer mCurrentValue = null;
        int mPendingCalls = 0;

        DynamicAnimatedColorNode(DynamicTypeValueReceiverWithPreUpdate<Integer> downstream, @NonNull AnimationParameterProto.AnimationSpec spec, QuotaManager quotaManager) {
            super(quotaManager, spec, (TypeEvaluator<?>)ARGB_EVALUATOR);
            this.mDownstream = downstream;
            this.mQuotaAwareAnimator.addUpdateCallback(animatedValue -> {
                if (this.mPendingCalls == 0) {
                    this.mCurrentValue = (Integer)animatedValue;
                    this.mDownstream.onData(this.mCurrentValue);
                }
            });
            this.mInputCallback = new DynamicTypeValueReceiverWithPreUpdate<Integer>(){

                @Override
                public void onPreUpdate() {
                    ++mPendingCalls;
                    if (mPendingCalls == 1) {
                        mDownstream.onPreUpdate();
                    }
                }

                @Override
                public void onData(@NonNull Integer newData) {
                    if (mPendingCalls > 0) {
                        --mPendingCalls;
                    }
                    if (mPendingCalls == 0) {
                        if (mCurrentValue == null) {
                            mCurrentValue = newData;
                            mDownstream.onData(mCurrentValue);
                        } else {
                            mQuotaAwareAnimator.setIntValues(mCurrentValue, newData);
                            this.startOrSkipAnimator();
                        }
                    }
                }

                @Override
                public void onInvalidated() {
                    if (mPendingCalls > 0) {
                        --mPendingCalls;
                    }
                    if (mPendingCalls == 0) {
                        mCurrentValue = null;
                        mDownstream.onInvalidated();
                    }
                }
            };
        }

        public DynamicTypeValueReceiverWithPreUpdate<Integer> getInputCallback() {
            return this.mInputCallback;
        }
    }

    static class AnimatableFixedColorNode
    extends AnimatableNode
    implements DynamicDataSourceNode<Integer> {
        private final DynamicProto.AnimatableFixedColor mProtoNode;
        private final DynamicTypeValueReceiverWithPreUpdate<Integer> mDownstream;

        AnimatableFixedColorNode(DynamicProto.AnimatableFixedColor protoNode, DynamicTypeValueReceiverWithPreUpdate<Integer> downstream, QuotaManager quotaManager) {
            super(quotaManager, protoNode.getAnimationSpec(), (TypeEvaluator<?>)ARGB_EVALUATOR);
            this.mProtoNode = protoNode;
            this.mDownstream = downstream;
            this.mQuotaAwareAnimator.addUpdateCallback(animatedValue -> this.mDownstream.onData((Integer)animatedValue));
        }

        @Override
        @UiThread
        public void preInit() {
            this.mDownstream.onPreUpdate();
        }

        @Override
        @UiThread
        public void init() {
            this.mQuotaAwareAnimator.setIntValues(this.mProtoNode.getFromArgb(), this.mProtoNode.getToArgb());
            this.startOrSkipAnimator();
        }

        @Override
        @UiThread
        public void destroy() {
            this.mQuotaAwareAnimator.stopAnimator();
        }
    }

    static class StateColorSourceNode
    extends StateSourceNode<Integer> {
        StateColorSourceNode(StateStore stateStore, DynamicProto.StateColorSource protoNode, DynamicTypeValueReceiverWithPreUpdate<Integer> downstream) {
            super(stateStore, protoNode.getSourceKey(), se -> se.getColorVal().getArgb(), downstream);
        }
    }

    static class FixedColorNode
    implements DynamicDataSourceNode<Integer> {
        private final int mValue;
        private final DynamicTypeValueReceiverWithPreUpdate<Integer> mDownstream;

        FixedColorNode(FixedProto.FixedColor protoNode, DynamicTypeValueReceiverWithPreUpdate<Integer> downstream) {
            this.mValue = protoNode.getArgb();
            this.mDownstream = downstream;
        }

        @Override
        @UiThread
        public void preInit() {
            this.mDownstream.onPreUpdate();
        }

        @Override
        @UiThread
        public void init() {
            this.mDownstream.onData(this.mValue);
        }

        @Override
        public void destroy() {
        }
    }
}

