/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.wear.protolayout.expression.pipeline.DynamicDataNode;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiverWithPreUpdate;

class ConditionalOpNode<T>
implements DynamicDataNode<T> {
    private final DynamicTypeValueReceiverWithPreUpdate<T> mTrueValueIncomingCallback;
    private final DynamicTypeValueReceiverWithPreUpdate<T> mFalseValueIncomingCallback;
    private final DynamicTypeValueReceiverWithPreUpdate<Boolean> mConditionIncomingCallback;
    final DynamicTypeValueReceiverWithPreUpdate<T> mDownstream;
    @Nullable
    Boolean mLastConditional;
    @Nullable
    T mLastTrueValue;
    @Nullable
    T mLastFalseValue;
    int mPendingConditionalUpdates = 0;
    int mPendingTrueValueUpdates = 0;
    int mPendingFalseValueUpdates = 0;

    ConditionalOpNode(DynamicTypeValueReceiverWithPreUpdate<T> downstream) {
        this.mDownstream = downstream;
        this.mTrueValueIncomingCallback = new DynamicTypeValueReceiverWithPreUpdate<T>(){

            @Override
            public void onPreUpdate() {
                ++ConditionalOpNode.this.mPendingTrueValueUpdates;
                if (ConditionalOpNode.this.mPendingTrueValueUpdates == 1 && ConditionalOpNode.this.mPendingFalseValueUpdates == 0 && ConditionalOpNode.this.mPendingConditionalUpdates == 0) {
                    ConditionalOpNode.this.mDownstream.onPreUpdate();
                }
            }

            @Override
            public void onData(@NonNull T newData) {
                if (ConditionalOpNode.this.mPendingTrueValueUpdates > 0) {
                    --ConditionalOpNode.this.mPendingTrueValueUpdates;
                }
                ConditionalOpNode.this.mLastTrueValue = newData;
                ConditionalOpNode.this.handleUpdate();
            }

            @Override
            public void onInvalidated() {
                if (ConditionalOpNode.this.mPendingTrueValueUpdates > 0) {
                    --ConditionalOpNode.this.mPendingTrueValueUpdates;
                }
                ConditionalOpNode.this.mLastTrueValue = null;
                ConditionalOpNode.this.handleUpdate();
            }
        };
        this.mFalseValueIncomingCallback = new DynamicTypeValueReceiverWithPreUpdate<T>(){

            @Override
            public void onPreUpdate() {
                ++ConditionalOpNode.this.mPendingFalseValueUpdates;
                if (ConditionalOpNode.this.mPendingTrueValueUpdates == 0 && ConditionalOpNode.this.mPendingFalseValueUpdates == 1 && ConditionalOpNode.this.mPendingConditionalUpdates == 0) {
                    ConditionalOpNode.this.mDownstream.onPreUpdate();
                }
            }

            @Override
            public void onData(@NonNull T newData) {
                if (ConditionalOpNode.this.mPendingFalseValueUpdates > 0) {
                    --ConditionalOpNode.this.mPendingFalseValueUpdates;
                }
                ConditionalOpNode.this.mLastFalseValue = newData;
                ConditionalOpNode.this.handleUpdate();
            }

            @Override
            public void onInvalidated() {
                if (ConditionalOpNode.this.mPendingFalseValueUpdates > 0) {
                    --ConditionalOpNode.this.mPendingFalseValueUpdates;
                }
                ConditionalOpNode.this.mLastFalseValue = null;
                ConditionalOpNode.this.handleUpdate();
            }
        };
        this.mConditionIncomingCallback = new DynamicTypeValueReceiverWithPreUpdate<Boolean>(){

            @Override
            public void onPreUpdate() {
                ++ConditionalOpNode.this.mPendingConditionalUpdates;
                if (ConditionalOpNode.this.mPendingTrueValueUpdates == 0 && ConditionalOpNode.this.mPendingFalseValueUpdates == 0 && ConditionalOpNode.this.mPendingConditionalUpdates == 1) {
                    ConditionalOpNode.this.mDownstream.onPreUpdate();
                }
            }

            @Override
            public void onData(@NonNull Boolean newData) {
                if (ConditionalOpNode.this.mPendingConditionalUpdates > 0) {
                    --ConditionalOpNode.this.mPendingConditionalUpdates;
                }
                ConditionalOpNode.this.mLastConditional = newData;
                ConditionalOpNode.this.handleUpdate();
            }

            @Override
            public void onInvalidated() {
                if (ConditionalOpNode.this.mPendingConditionalUpdates > 0) {
                    --ConditionalOpNode.this.mPendingConditionalUpdates;
                }
                ConditionalOpNode.this.mLastConditional = null;
                ConditionalOpNode.this.handleUpdate();
            }
        };
    }

    public DynamicTypeValueReceiverWithPreUpdate<T> getTrueValueIncomingCallback() {
        return this.mTrueValueIncomingCallback;
    }

    public DynamicTypeValueReceiverWithPreUpdate<T> getFalseValueIncomingCallback() {
        return this.mFalseValueIncomingCallback;
    }

    public DynamicTypeValueReceiverWithPreUpdate<Boolean> getConditionIncomingCallback() {
        return this.mConditionIncomingCallback;
    }

    void handleUpdate() {
        if (this.mPendingTrueValueUpdates > 0 || this.mPendingFalseValueUpdates > 0 || this.mPendingConditionalUpdates > 0) {
            return;
        }
        if (this.mLastTrueValue == null || this.mLastFalseValue == null || this.mLastConditional == null) {
            this.mDownstream.onInvalidated();
            return;
        }
        if (this.mLastConditional.booleanValue()) {
            this.mDownstream.onData(this.mLastTrueValue);
        } else {
            this.mDownstream.onData(this.mLastFalseValue);
        }
    }
}

