/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import androidx.annotation.UiThread;
import androidx.wear.protolayout.expression.pipeline.DynamicDataBiTransformNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataSourceNode;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiverWithPreUpdate;
import androidx.wear.protolayout.expression.proto.FixedProto;
import java.time.Duration;
import java.time.Instant;

class DurationNodes {
    private DurationNodes() {
    }

    static class BetweenInstancesNode
    extends DynamicDataBiTransformNode<Instant, Instant, Duration> {
        BetweenInstancesNode(DynamicTypeValueReceiverWithPreUpdate<Duration> downstream) {
            super(downstream, Duration::between);
        }
    }

    static class FixedDurationNode
    implements DynamicDataSourceNode<Duration> {
        private final Duration mValue;
        private final DynamicTypeValueReceiverWithPreUpdate<Duration> mDownstream;

        FixedDurationNode(FixedProto.FixedDuration protoNode, DynamicTypeValueReceiverWithPreUpdate<Duration> downstream) {
            this.mValue = Duration.ofSeconds(protoNode.getSeconds());
            this.mDownstream = downstream;
        }

        @Override
        @UiThread
        public void preInit() {
            this.mDownstream.onPreUpdate();
        }

        @Override
        @UiThread
        public void init() {
            this.mDownstream.onData(this.mValue);
        }

        @Override
        public void destroy() {
        }
    }
}

