/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.wear.protolayout.expression.pipeline.DynamicDataNode;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiverWithPreUpdate;
import java.util.function.BiFunction;

class DynamicDataBiTransformNode<LhsT, RhsT, O>
implements DynamicDataNode<O> {
    private static final String TAG = "DynamicDataBiTransform";
    private final DynamicTypeValueReceiverWithPreUpdate<LhsT> mLhsIncomingCallback;
    private final DynamicTypeValueReceiverWithPreUpdate<RhsT> mRhsIncomingCallback;
    final DynamicTypeValueReceiverWithPreUpdate<O> mDownstream;
    private final BiFunction<LhsT, RhsT, O> mTransformer;
    @Nullable
    LhsT mCachedLhsData;
    @Nullable
    RhsT mCachedRhsData;
    int mPendingLhsStateUpdates = 0;
    int mPendingRhsStateUpdates = 0;

    DynamicDataBiTransformNode(DynamicTypeValueReceiverWithPreUpdate<O> downstream, BiFunction<LhsT, RhsT, O> transformer) {
        this.mDownstream = downstream;
        this.mTransformer = transformer;
        this.mLhsIncomingCallback = new DynamicTypeValueReceiverWithPreUpdate<LhsT>(){

            @Override
            public void onPreUpdate() {
                ++DynamicDataBiTransformNode.this.mPendingLhsStateUpdates;
                if (DynamicDataBiTransformNode.this.mPendingLhsStateUpdates == 1 && DynamicDataBiTransformNode.this.mPendingRhsStateUpdates == 0) {
                    DynamicDataBiTransformNode.this.mDownstream.onPreUpdate();
                }
            }

            @Override
            public void onData(@NonNull LhsT newData) {
                this.onUpdatedImpl(newData);
            }

            private void onUpdatedImpl(@Nullable LhsT newData) {
                if (DynamicDataBiTransformNode.this.mPendingLhsStateUpdates == 0) {
                    Log.w((String)DynamicDataBiTransformNode.TAG, (String)"Received a state update, but one or more suppliers did not call onPreStateUpdate");
                } else {
                    --DynamicDataBiTransformNode.this.mPendingLhsStateUpdates;
                }
                DynamicDataBiTransformNode.this.mCachedLhsData = newData;
                DynamicDataBiTransformNode.this.handleStateUpdate();
            }

            @Override
            public void onInvalidated() {
                this.onUpdatedImpl(null);
            }
        };
        this.mRhsIncomingCallback = new DynamicTypeValueReceiverWithPreUpdate<RhsT>(){

            @Override
            public void onPreUpdate() {
                ++DynamicDataBiTransformNode.this.mPendingRhsStateUpdates;
                if (DynamicDataBiTransformNode.this.mPendingLhsStateUpdates == 0 && DynamicDataBiTransformNode.this.mPendingRhsStateUpdates == 1) {
                    DynamicDataBiTransformNode.this.mDownstream.onPreUpdate();
                }
            }

            @Override
            public void onData(@NonNull RhsT newData) {
                this.onUpdatedImpl(newData);
            }

            private void onUpdatedImpl(@Nullable RhsT newData) {
                if (DynamicDataBiTransformNode.this.mPendingRhsStateUpdates == 0) {
                    Log.w((String)DynamicDataBiTransformNode.TAG, (String)"Received a state update, but one or more suppliers did not call onPreStateUpdate");
                } else {
                    --DynamicDataBiTransformNode.this.mPendingRhsStateUpdates;
                }
                DynamicDataBiTransformNode.this.mCachedRhsData = newData;
                DynamicDataBiTransformNode.this.handleStateUpdate();
            }

            @Override
            public void onInvalidated() {
                this.onUpdatedImpl(null);
            }
        };
    }

    void handleStateUpdate() {
        if (this.mPendingLhsStateUpdates == 0 && this.mPendingRhsStateUpdates == 0) {
            LhsT lhs = this.mCachedLhsData;
            RhsT rhs = this.mCachedRhsData;
            if (lhs == null || rhs == null) {
                this.mDownstream.onInvalidated();
            } else {
                O result = this.mTransformer.apply(lhs, rhs);
                this.mDownstream.onData(result);
            }
        }
    }

    public DynamicTypeValueReceiverWithPreUpdate<LhsT> getLhsIncomingCallback() {
        return this.mLhsIncomingCallback;
    }

    public DynamicTypeValueReceiverWithPreUpdate<RhsT> getRhsIncomingCallback() {
        return this.mRhsIncomingCallback;
    }
}

