/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.wear.protolayout.expression.pipeline.DynamicDataNode;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiverWithPreUpdate;
import java.util.function.Function;
import java.util.function.Predicate;

class DynamicDataTransformNode<I, O>
implements DynamicDataNode<O> {
    private final DynamicTypeValueReceiverWithPreUpdate<I> mCallback;
    final DynamicTypeValueReceiverWithPreUpdate<O> mDownstream;
    final Function<I, O> mTransformer;

    DynamicDataTransformNode(DynamicTypeValueReceiverWithPreUpdate<O> downstream, Function<I, O> transformer) {
        this(downstream, transformer, null);
    }

    DynamicDataTransformNode(DynamicTypeValueReceiverWithPreUpdate<O> downstream, Function<I, O> transformer, final @Nullable Predicate<I> validator) {
        this.mDownstream = downstream;
        this.mTransformer = transformer;
        this.mCallback = new DynamicTypeValueReceiverWithPreUpdate<I>(){

            @Override
            public void onPreUpdate() {
                DynamicDataTransformNode.this.mDownstream.onPreUpdate();
            }

            @Override
            public void onData(@NonNull I newData) {
                if (validator != null && !validator.test(newData)) {
                    DynamicDataTransformNode.this.mDownstream.onInvalidated();
                    return;
                }
                Object result = DynamicDataTransformNode.this.mTransformer.apply(newData);
                DynamicDataTransformNode.this.mDownstream.onData(result);
            }

            @Override
            public void onInvalidated() {
                DynamicDataTransformNode.this.mDownstream.onInvalidated();
            }
        };
    }

    public DynamicTypeValueReceiverWithPreUpdate<I> getIncomingCallback() {
        return this.mCallback;
    }
}

