/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import android.icu.util.ULocale;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.wear.protolayout.expression.DynamicBuilders;
import androidx.wear.protolayout.expression.pipeline.BoundDynamicTypeImpl;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeEvaluator;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiver;
import androidx.wear.protolayout.expression.proto.DynamicProto;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Executor;

public abstract class DynamicTypeBindingRequest {
    private DynamicTypeBindingRequest() {
    }

    abstract BoundDynamicTypeImpl callBindOn(DynamicTypeEvaluator var1);

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static DynamicTypeBindingRequest forDynamicFloatInternal(@NonNull DynamicProto.DynamicFloat floatSource, @NonNull DynamicTypeValueReceiver<Float> consumer) {
        return new DynamicFloatBindingRequest(floatSource, consumer);
    }

    @NonNull
    public static DynamicTypeBindingRequest forDynamicFloat(@NonNull DynamicBuilders.DynamicFloat floatSource, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Float> consumer) {
        return new DynamicFloatBindingRequestWithExecutor(floatSource, executor, consumer);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static DynamicTypeBindingRequest forDynamicInt32Internal(@NonNull DynamicProto.DynamicInt32 int32Source, @NonNull DynamicTypeValueReceiver<Integer> consumer) {
        return new DynamicInt32BindingRequest(int32Source, consumer);
    }

    @NonNull
    public static DynamicTypeBindingRequest forDynamicInt32(@NonNull DynamicBuilders.DynamicInt32 int32Source, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Integer> consumer) {
        return new DynamicInt32BindingRequestWithExecutor(int32Source, executor, consumer);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static DynamicTypeBindingRequest forDynamicColorInternal(@NonNull DynamicProto.DynamicColor colorSource, @NonNull DynamicTypeValueReceiver<Integer> consumer) {
        return new DynamicColorBindingRequest(colorSource, consumer);
    }

    @NonNull
    public static DynamicTypeBindingRequest forDynamicColor(@NonNull DynamicBuilders.DynamicColor colorSource, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Integer> consumer) {
        return new DynamicColorBindingRequestWithExecutor(colorSource, executor, consumer);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static DynamicTypeBindingRequest forDynamicBoolInternal(@NonNull DynamicProto.DynamicBool boolSource, @NonNull DynamicTypeValueReceiver<Boolean> consumer) {
        return new DynamicBoolBindingRequest(boolSource, consumer);
    }

    @NonNull
    public static DynamicTypeBindingRequest forDynamicBool(@NonNull DynamicBuilders.DynamicBool boolSource, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Boolean> consumer) {
        return new DynamicBoolBindingRequestWithExecutor(boolSource, executor, consumer);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static DynamicTypeBindingRequest forDynamicStringInternal(@NonNull DynamicProto.DynamicString stringSource, @NonNull ULocale locale, @NonNull DynamicTypeValueReceiver<String> consumer) {
        return new DynamicStringBindingRequest(stringSource, locale, consumer);
    }

    @NonNull
    public static DynamicTypeBindingRequest forDynamicString(@NonNull DynamicBuilders.DynamicString stringSource, @NonNull ULocale locale, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<String> consumer) {
        return new DynamicStringBindingRequestWithExecutor(stringSource, locale, executor, consumer);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static DynamicTypeBindingRequest forDynamicDurationInternal(@NonNull DynamicProto.DynamicDuration durationSource, @NonNull DynamicTypeValueReceiver<Duration> consumer) {
        return new DynamicDurationBindingRequest(durationSource, consumer);
    }

    @NonNull
    public static DynamicTypeBindingRequest forDynamicDuration(@NonNull DynamicBuilders.DynamicDuration durationSource, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Duration> consumer) {
        return new DynamicDurationBindingRequestWithExecutor(durationSource, executor, consumer);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static DynamicTypeBindingRequest forDynamicInstantInternal(@NonNull DynamicProto.DynamicInstant instantSource, @NonNull DynamicTypeValueReceiver<Instant> consumer) {
        return new DynamicInstantBindingRequest(instantSource, consumer);
    }

    @NonNull
    public static DynamicTypeBindingRequest forDynamicInstant(@NonNull DynamicBuilders.DynamicInstant instantSource, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Instant> consumer) {
        return new DynamicInstantBindingRequestWithExecutor(instantSource, executor, consumer);
    }

    private static class DynamicFloatBindingRequest
    extends DynamicTypeBindingRequest {
        @NonNull
        private final DynamicProto.DynamicFloat mFloatSource;
        @NonNull
        private final DynamicTypeValueReceiver<Float> mConsumer;

        DynamicFloatBindingRequest(@NonNull DynamicProto.DynamicFloat floatSource, @NonNull DynamicTypeValueReceiver<Float> consumer) {
            this.mFloatSource = floatSource;
            this.mConsumer = consumer;
        }

        @Override
        BoundDynamicTypeImpl callBindOn(DynamicTypeEvaluator evaluator) {
            return evaluator.bindInternal(this.mFloatSource, this.mConsumer);
        }
    }

    private static class DynamicFloatBindingRequestWithExecutor
    extends DynamicTypeBindingRequest {
        @NonNull
        private final DynamicBuilders.DynamicFloat mFloatSource;
        @NonNull
        private final Executor mExecutor;
        @NonNull
        private final DynamicTypeValueReceiver<Float> mConsumer;

        DynamicFloatBindingRequestWithExecutor(@NonNull DynamicBuilders.DynamicFloat floatSource, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Float> consumer) {
            this.mFloatSource = floatSource;
            this.mExecutor = executor;
            this.mConsumer = consumer;
        }

        @Override
        BoundDynamicTypeImpl callBindOn(DynamicTypeEvaluator evaluator) {
            return evaluator.bindInternal(this.mFloatSource, this.mExecutor, this.mConsumer);
        }
    }

    private static class DynamicInt32BindingRequest
    extends DynamicTypeBindingRequest {
        @NonNull
        private final DynamicProto.DynamicInt32 mInt32Source;
        @NonNull
        private final DynamicTypeValueReceiver<Integer> mConsumer;

        DynamicInt32BindingRequest(@NonNull DynamicProto.DynamicInt32 int32Source, @NonNull DynamicTypeValueReceiver<Integer> consumer) {
            this.mInt32Source = int32Source;
            this.mConsumer = consumer;
        }

        @Override
        BoundDynamicTypeImpl callBindOn(DynamicTypeEvaluator evaluator) {
            return evaluator.bindInternal(this.mInt32Source, this.mConsumer);
        }
    }

    private static class DynamicInt32BindingRequestWithExecutor
    extends DynamicTypeBindingRequest {
        @NonNull
        private final DynamicBuilders.DynamicInt32 mInt32Source;
        @NonNull
        private final Executor mExecutor;
        @NonNull
        private final DynamicTypeValueReceiver<Integer> mConsumer;

        DynamicInt32BindingRequestWithExecutor(@NonNull DynamicBuilders.DynamicInt32 int32Source, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Integer> consumer) {
            this.mInt32Source = int32Source;
            this.mExecutor = executor;
            this.mConsumer = consumer;
        }

        @Override
        BoundDynamicTypeImpl callBindOn(DynamicTypeEvaluator evaluator) {
            return evaluator.bindInternal(this.mInt32Source, this.mExecutor, this.mConsumer);
        }
    }

    private static class DynamicColorBindingRequest
    extends DynamicTypeBindingRequest {
        @NonNull
        private final DynamicProto.DynamicColor mColorSource;
        @NonNull
        private final DynamicTypeValueReceiver<Integer> mConsumer;

        DynamicColorBindingRequest(@NonNull DynamicProto.DynamicColor colorSource, @NonNull DynamicTypeValueReceiver<Integer> consumer) {
            this.mColorSource = colorSource;
            this.mConsumer = consumer;
        }

        @Override
        BoundDynamicTypeImpl callBindOn(DynamicTypeEvaluator evaluator) {
            return evaluator.bindInternal(this.mColorSource, this.mConsumer);
        }
    }

    private static class DynamicColorBindingRequestWithExecutor
    extends DynamicTypeBindingRequest {
        @NonNull
        private final DynamicBuilders.DynamicColor mColorSource;
        @NonNull
        private final Executor mExecutor;
        @NonNull
        private final DynamicTypeValueReceiver<Integer> mConsumer;

        DynamicColorBindingRequestWithExecutor(@NonNull DynamicBuilders.DynamicColor colorSource, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Integer> consumer) {
            this.mColorSource = colorSource;
            this.mExecutor = executor;
            this.mConsumer = consumer;
        }

        @Override
        BoundDynamicTypeImpl callBindOn(DynamicTypeEvaluator evaluator) {
            return evaluator.bindInternal(this.mColorSource, this.mExecutor, this.mConsumer);
        }
    }

    private static class DynamicBoolBindingRequest
    extends DynamicTypeBindingRequest {
        @NonNull
        private final DynamicProto.DynamicBool mBoolSource;
        @NonNull
        private final DynamicTypeValueReceiver<Boolean> mConsumer;

        DynamicBoolBindingRequest(@NonNull DynamicProto.DynamicBool boolSource, @NonNull DynamicTypeValueReceiver<Boolean> consumer) {
            this.mBoolSource = boolSource;
            this.mConsumer = consumer;
        }

        @Override
        BoundDynamicTypeImpl callBindOn(DynamicTypeEvaluator evaluator) {
            return evaluator.bindInternal(this.mBoolSource, this.mConsumer);
        }
    }

    private static class DynamicBoolBindingRequestWithExecutor
    extends DynamicTypeBindingRequest {
        @NonNull
        private final DynamicBuilders.DynamicBool mBoolSource;
        @NonNull
        private final Executor mExecutor;
        @NonNull
        private final DynamicTypeValueReceiver<Boolean> mConsumer;

        DynamicBoolBindingRequestWithExecutor(@NonNull DynamicBuilders.DynamicBool boolSource, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Boolean> consumer) {
            this.mBoolSource = boolSource;
            this.mExecutor = executor;
            this.mConsumer = consumer;
        }

        @Override
        BoundDynamicTypeImpl callBindOn(DynamicTypeEvaluator evaluator) {
            return evaluator.bindInternal(this.mBoolSource, this.mExecutor, this.mConsumer);
        }
    }

    private static class DynamicStringBindingRequest
    extends DynamicTypeBindingRequest {
        @NonNull
        private final DynamicProto.DynamicString mStringSource;
        @NonNull
        private final ULocale mLocale;
        @NonNull
        private final DynamicTypeValueReceiver<String> mConsumer;

        DynamicStringBindingRequest(@NonNull DynamicProto.DynamicString stringSource, @NonNull ULocale locale, @NonNull DynamicTypeValueReceiver<String> consumer) {
            this.mStringSource = stringSource;
            this.mLocale = locale;
            this.mConsumer = consumer;
        }

        @Override
        BoundDynamicTypeImpl callBindOn(DynamicTypeEvaluator evaluator) {
            return evaluator.bindInternal(this.mStringSource, this.mLocale, this.mConsumer);
        }
    }

    private static class DynamicStringBindingRequestWithExecutor
    extends DynamicTypeBindingRequest {
        @NonNull
        private final DynamicBuilders.DynamicString mStringSource;
        @NonNull
        private final ULocale mLocale;
        @NonNull
        private final Executor mExecutor;
        @NonNull
        private final DynamicTypeValueReceiver<String> mConsumer;

        DynamicStringBindingRequestWithExecutor(@NonNull DynamicBuilders.DynamicString stringSource, @NonNull ULocale locale, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<String> consumer) {
            this.mStringSource = stringSource;
            this.mExecutor = executor;
            this.mConsumer = consumer;
            this.mLocale = locale;
        }

        @Override
        BoundDynamicTypeImpl callBindOn(DynamicTypeEvaluator evaluator) {
            return evaluator.bindInternal(this.mStringSource, this.mLocale, this.mExecutor, this.mConsumer);
        }
    }

    private static class DynamicDurationBindingRequest
    extends DynamicTypeBindingRequest {
        @NonNull
        private final DynamicProto.DynamicDuration mDurationSource;
        @NonNull
        private final DynamicTypeValueReceiver<Duration> mConsumer;

        DynamicDurationBindingRequest(@NonNull DynamicProto.DynamicDuration durationSource, @NonNull DynamicTypeValueReceiver<Duration> consumer) {
            this.mDurationSource = durationSource;
            this.mConsumer = consumer;
        }

        @Override
        BoundDynamicTypeImpl callBindOn(DynamicTypeEvaluator evaluator) {
            return evaluator.bindInternal(this.mDurationSource, this.mConsumer);
        }
    }

    private static class DynamicDurationBindingRequestWithExecutor
    extends DynamicTypeBindingRequest {
        @NonNull
        private final DynamicBuilders.DynamicDuration mDurationSource;
        @NonNull
        private final Executor mExecutor;
        @NonNull
        private final DynamicTypeValueReceiver<Duration> mConsumer;

        DynamicDurationBindingRequestWithExecutor(@NonNull DynamicBuilders.DynamicDuration durationSource, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Duration> consumer) {
            this.mDurationSource = durationSource;
            this.mExecutor = executor;
            this.mConsumer = consumer;
        }

        @Override
        BoundDynamicTypeImpl callBindOn(DynamicTypeEvaluator evaluator) {
            return evaluator.bindInternal(this.mDurationSource, this.mExecutor, this.mConsumer);
        }
    }

    private static class DynamicInstantBindingRequest
    extends DynamicTypeBindingRequest {
        @NonNull
        private final DynamicProto.DynamicInstant mInstantSource;
        @NonNull
        private final DynamicTypeValueReceiver<Instant> mConsumer;

        DynamicInstantBindingRequest(@NonNull DynamicProto.DynamicInstant instantSource, @NonNull DynamicTypeValueReceiver<Instant> consumer) {
            this.mInstantSource = instantSource;
            this.mConsumer = consumer;
        }

        @Override
        BoundDynamicTypeImpl callBindOn(DynamicTypeEvaluator evaluator) {
            return evaluator.bindInternal(this.mInstantSource, this.mConsumer);
        }
    }

    private static class DynamicInstantBindingRequestWithExecutor
    extends DynamicTypeBindingRequest {
        @NonNull
        private final DynamicBuilders.DynamicInstant mInstantSource;
        @NonNull
        private final Executor mExecutor;
        @NonNull
        private final DynamicTypeValueReceiver<Instant> mConsumer;

        DynamicInstantBindingRequestWithExecutor(@NonNull DynamicBuilders.DynamicInstant instantSource, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Instant> consumer) {
            this.mInstantSource = instantSource;
            this.mExecutor = executor;
            this.mConsumer = consumer;
        }

        @Override
        BoundDynamicTypeImpl callBindOn(DynamicTypeEvaluator evaluator) {
            return evaluator.bindInternal(this.mInstantSource, this.mExecutor, this.mConsumer);
        }
    }
}

