/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import android.icu.util.ULocale;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.wear.protolayout.expression.DynamicBuilders;
import androidx.wear.protolayout.expression.pipeline.BoolNodes;
import androidx.wear.protolayout.expression.pipeline.BoundDynamicType;
import androidx.wear.protolayout.expression.pipeline.BoundDynamicTypeImpl;
import androidx.wear.protolayout.expression.pipeline.ColorNodes;
import androidx.wear.protolayout.expression.pipeline.ConditionalOpNode;
import androidx.wear.protolayout.expression.pipeline.DurationNodes;
import androidx.wear.protolayout.expression.pipeline.DynamicDataNode;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeBindingRequest;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiver;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiverWithPreUpdate;
import androidx.wear.protolayout.expression.pipeline.EpochTimePlatformDataSource;
import androidx.wear.protolayout.expression.pipeline.FixedQuotaManagerImpl;
import androidx.wear.protolayout.expression.pipeline.FloatNodes;
import androidx.wear.protolayout.expression.pipeline.InstantNodes;
import androidx.wear.protolayout.expression.pipeline.Int32Nodes;
import androidx.wear.protolayout.expression.pipeline.MainThreadExecutor;
import androidx.wear.protolayout.expression.pipeline.NumberFormatter;
import androidx.wear.protolayout.expression.pipeline.QuotaManager;
import androidx.wear.protolayout.expression.pipeline.SensorGatewayPlatformDataSource;
import androidx.wear.protolayout.expression.pipeline.StateStore;
import androidx.wear.protolayout.expression.pipeline.StringNodes;
import androidx.wear.protolayout.expression.pipeline.TimeGateway;
import androidx.wear.protolayout.expression.pipeline.TimeGatewayImpl;
import androidx.wear.protolayout.expression.pipeline.sensor.SensorGateway;
import androidx.wear.protolayout.expression.proto.DynamicProto;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;

public class DynamicTypeEvaluator {
    private static final String TAG = "DynamicTypeEvaluator";
    private static final QuotaManager NO_OP_QUOTA_MANAGER = new FixedQuotaManagerImpl(Integer.MAX_VALUE);
    @NonNull
    private static final QuotaManager DISABLED_ANIMATIONS_QUOTA_MANAGER = new QuotaManager(){

        @Override
        public boolean tryAcquireQuota(int quota) {
            return false;
        }

        @Override
        public void releaseQuota(int quota) {
            throw new IllegalStateException("releaseQuota method is called when no quota is acquired!");
        }
    };
    @NonNull
    private static final StateStore EMPTY_STATE_STORE = new StateStore(Collections.emptyMap());
    @NonNull
    private final StateStore mStateStore;
    @NonNull
    private final QuotaManager mAnimationQuotaManager;
    @NonNull
    private final QuotaManager mDynamicTypesQuotaManager;
    @NonNull
    private final EpochTimePlatformDataSource mTimeDataSource;
    @Nullable
    private final SensorGatewayPlatformDataSource mSensorGatewayDataSource;

    public DynamicTypeEvaluator(@NonNull Config config) {
        this.mStateStore = config.getStateStore() != null ? config.getStateStore() : EMPTY_STATE_STORE;
        this.mAnimationQuotaManager = config.getAnimationQuotaManager() != null ? config.getAnimationQuotaManager() : DISABLED_ANIMATIONS_QUOTA_MANAGER;
        this.mDynamicTypesQuotaManager = config.getDynamicTypesQuotaManager() != null ? config.getDynamicTypesQuotaManager() : NO_OP_QUOTA_MANAGER;
        Handler uiHandler = new Handler(Looper.getMainLooper());
        MainThreadExecutor uiExecutor = new MainThreadExecutor(uiHandler);
        TimeGateway timeGateway = config.getTimeGateway();
        if (timeGateway == null) {
            timeGateway = new TimeGatewayImpl(uiHandler);
            ((TimeGatewayImpl)timeGateway).enableUpdates();
        }
        this.mTimeDataSource = new EpochTimePlatformDataSource(uiExecutor, timeGateway);
        this.mSensorGatewayDataSource = config.getSensorGateway() != null ? new SensorGatewayPlatformDataSource(uiExecutor, config.getSensorGateway()) : null;
    }

    @NonNull
    public BoundDynamicType bind(@NonNull DynamicTypeBindingRequest request) throws EvaluationException {
        BoundDynamicTypeImpl boundDynamicType = request.callBindOn(this);
        if (!this.mDynamicTypesQuotaManager.tryAcquireQuota(boundDynamicType.getDynamicNodeCount())) {
            throw new EvaluationException("Dynamic type expression limit reached. Try making the dynamic type expression shorter or reduce the number of dynamic type expressions.");
        }
        return boundDynamicType;
    }

    @NonNull
    BoundDynamicTypeImpl bindInternal(@NonNull DynamicBuilders.DynamicString stringSource, @NonNull ULocale locale, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<String> consumer) {
        return this.bindInternal(stringSource.toDynamicStringProto(), locale, new DynamicTypeValueReceiverOnExecutor<String>(executor, consumer));
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    BoundDynamicTypeImpl bindInternal(@NonNull DynamicProto.DynamicString stringSource, @NonNull ULocale locale, @NonNull DynamicTypeValueReceiver<String> consumer) {
        ArrayList resultBuilder = new ArrayList();
        this.bindRecursively(stringSource, new DynamicTypeValueReceiverOnExecutor<String>(consumer), locale, resultBuilder);
        return new BoundDynamicTypeImpl(resultBuilder, this.mDynamicTypesQuotaManager);
    }

    @NonNull
    BoundDynamicTypeImpl bindInternal(@NonNull DynamicBuilders.DynamicInt32 int32Source, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Integer> consumer) {
        return this.bindInternal(int32Source.toDynamicInt32Proto(), new DynamicTypeValueReceiverOnExecutor<Integer>(executor, consumer));
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    BoundDynamicTypeImpl bindInternal(@NonNull DynamicProto.DynamicInt32 int32Source, @NonNull DynamicTypeValueReceiver<Integer> consumer) {
        ArrayList resultBuilder = new ArrayList();
        this.bindRecursively(int32Source, new DynamicTypeValueReceiverOnExecutor<Integer>(consumer), resultBuilder);
        return new BoundDynamicTypeImpl(resultBuilder, this.mDynamicTypesQuotaManager);
    }

    @NonNull
    BoundDynamicTypeImpl bindInternal(@NonNull DynamicBuilders.DynamicFloat floatSource, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Float> consumer) {
        return this.bindInternal(floatSource.toDynamicFloatProto(), new DynamicTypeValueReceiverOnExecutor<Float>(executor, consumer));
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    BoundDynamicTypeImpl bindInternal(@NonNull DynamicProto.DynamicFloat floatSource, @NonNull DynamicTypeValueReceiver<Float> consumer) {
        ArrayList resultBuilder = new ArrayList();
        this.bindRecursively(floatSource, new DynamicTypeValueReceiverOnExecutor<Float>(consumer), resultBuilder);
        return new BoundDynamicTypeImpl(resultBuilder, this.mDynamicTypesQuotaManager);
    }

    @NonNull
    BoundDynamicTypeImpl bindInternal(@NonNull DynamicBuilders.DynamicColor colorSource, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Integer> consumer) {
        return this.bindInternal(colorSource.toDynamicColorProto(), new DynamicTypeValueReceiverOnExecutor<Integer>(executor, consumer));
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    BoundDynamicTypeImpl bindInternal(@NonNull DynamicProto.DynamicColor colorSource, @NonNull DynamicTypeValueReceiver<Integer> consumer) {
        ArrayList resultBuilder = new ArrayList();
        this.bindRecursively(colorSource, new DynamicTypeValueReceiverOnExecutor<Integer>(consumer), resultBuilder);
        return new BoundDynamicTypeImpl(resultBuilder, this.mDynamicTypesQuotaManager);
    }

    @NonNull
    BoundDynamicTypeImpl bindInternal(@NonNull DynamicBuilders.DynamicDuration durationSource, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Duration> consumer) {
        return this.bindInternal(durationSource.toDynamicDurationProto(), new DynamicTypeValueReceiverOnExecutor<Duration>(executor, consumer));
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    BoundDynamicTypeImpl bindInternal(@NonNull DynamicProto.DynamicDuration durationSource, @NonNull DynamicTypeValueReceiver<Duration> consumer) {
        ArrayList resultBuilder = new ArrayList();
        this.bindRecursively(durationSource, new DynamicTypeValueReceiverOnExecutor<Duration>(consumer), resultBuilder);
        return new BoundDynamicTypeImpl(resultBuilder, this.mDynamicTypesQuotaManager);
    }

    @NonNull
    BoundDynamicTypeImpl bindInternal(@NonNull DynamicBuilders.DynamicInstant instantSource, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Instant> consumer) {
        return this.bindInternal(instantSource.toDynamicInstantProto(), new DynamicTypeValueReceiverOnExecutor<Instant>(executor, consumer));
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    BoundDynamicTypeImpl bindInternal(@NonNull DynamicProto.DynamicInstant instantSource, @NonNull DynamicTypeValueReceiver<Instant> consumer) {
        ArrayList resultBuilder = new ArrayList();
        this.bindRecursively(instantSource, new DynamicTypeValueReceiverOnExecutor<Instant>(consumer), resultBuilder);
        return new BoundDynamicTypeImpl(resultBuilder, this.mDynamicTypesQuotaManager);
    }

    @NonNull
    BoundDynamicTypeImpl bindInternal(@NonNull DynamicBuilders.DynamicBool boolSource, @NonNull Executor executor, @NonNull DynamicTypeValueReceiver<Boolean> consumer) {
        return this.bindInternal(boolSource.toDynamicBoolProto(), new DynamicTypeValueReceiverOnExecutor<Boolean>(executor, consumer));
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    BoundDynamicTypeImpl bindInternal(@NonNull DynamicProto.DynamicBool boolSource, @NonNull DynamicTypeValueReceiver<Boolean> consumer) {
        ArrayList resultBuilder = new ArrayList();
        this.bindRecursively(boolSource, new DynamicTypeValueReceiverOnExecutor<Boolean>(consumer), resultBuilder);
        return new BoundDynamicTypeImpl(resultBuilder, this.mDynamicTypesQuotaManager);
    }

    private void bindRecursively(@NonNull DynamicProto.DynamicString stringSource, @NonNull DynamicTypeValueReceiverWithPreUpdate<String> consumer, @NonNull ULocale locale, @NonNull List<DynamicDataNode<?>> resultBuilder) {
        DynamicDataNode<String> node;
        switch (stringSource.getInnerCase()) {
            case FIXED: {
                node = new StringNodes.FixedStringNode(stringSource.getFixed(), consumer);
                break;
            }
            case INT32_FORMAT_OP: {
                NumberFormatter formatter = new NumberFormatter(stringSource.getInt32FormatOp(), locale);
                StringNodes.Int32FormatNode int32FormatNode = new StringNodes.Int32FormatNode(formatter, consumer);
                node = int32FormatNode;
                this.bindRecursively(stringSource.getInt32FormatOp().getInput(), int32FormatNode.getIncomingCallback(), resultBuilder);
                break;
            }
            case FLOAT_FORMAT_OP: {
                NumberFormatter formatter = new NumberFormatter(stringSource.getFloatFormatOp(), locale);
                StringNodes.FloatFormatNode floatFormatNode = new StringNodes.FloatFormatNode(formatter, consumer);
                node = floatFormatNode;
                this.bindRecursively(stringSource.getFloatFormatOp().getInput(), floatFormatNode.getIncomingCallback(), resultBuilder);
                break;
            }
            case STATE_SOURCE: {
                node = new StringNodes.StateStringNode(this.mStateStore, stringSource.getStateSource(), consumer);
                break;
            }
            case CONDITIONAL_OP: {
                ConditionalOpNode<String> conditionalNode = new ConditionalOpNode<String>(consumer);
                DynamicProto.ConditionalStringOp op = stringSource.getConditionalOp();
                this.bindRecursively(op.getCondition(), conditionalNode.getConditionIncomingCallback(), resultBuilder);
                this.bindRecursively(op.getValueIfTrue(), conditionalNode.getTrueValueIncomingCallback(), locale, resultBuilder);
                this.bindRecursively(op.getValueIfFalse(), conditionalNode.getFalseValueIncomingCallback(), locale, resultBuilder);
                node = conditionalNode;
                break;
            }
            case CONCAT_OP: {
                StringNodes.StringConcatOpNode concatNode = new StringNodes.StringConcatOpNode(consumer);
                node = concatNode;
                this.bindRecursively(stringSource.getConcatOp().getInputLhs(), concatNode.getLhsIncomingCallback(), locale, resultBuilder);
                this.bindRecursively(stringSource.getConcatOp().getInputRhs(), concatNode.getRhsIncomingCallback(), locale, resultBuilder);
                break;
            }
            case INNER_NOT_SET: {
                throw new IllegalArgumentException("DynamicString has no inner source set");
            }
            default: {
                throw new IllegalArgumentException("Unknown DynamicString source type");
            }
        }
        resultBuilder.add(node);
    }

    private void bindRecursively(@NonNull DynamicProto.DynamicInt32 int32Source, @NonNull DynamicTypeValueReceiverWithPreUpdate<Integer> consumer, @NonNull List<DynamicDataNode<?>> resultBuilder) {
        DynamicDataNode<Integer> node;
        switch (int32Source.getInnerCase()) {
            case FIXED: {
                node = new Int32Nodes.FixedInt32Node(int32Source.getFixed(), consumer);
                break;
            }
            case PLATFORM_SOURCE: {
                node = new Int32Nodes.PlatformInt32SourceNode(int32Source.getPlatformSource(), this.mSensorGatewayDataSource, consumer);
                break;
            }
            case ARITHMETIC_OPERATION: {
                Int32Nodes.ArithmeticInt32Node arithmeticNode = new Int32Nodes.ArithmeticInt32Node(int32Source.getArithmeticOperation(), consumer);
                node = arithmeticNode;
                this.bindRecursively(int32Source.getArithmeticOperation().getInputLhs(), arithmeticNode.getLhsIncomingCallback(), resultBuilder);
                this.bindRecursively(int32Source.getArithmeticOperation().getInputRhs(), arithmeticNode.getRhsIncomingCallback(), resultBuilder);
                break;
            }
            case STATE_SOURCE: {
                node = new Int32Nodes.StateInt32SourceNode(this.mStateStore, int32Source.getStateSource(), consumer);
                break;
            }
            case CONDITIONAL_OP: {
                ConditionalOpNode<Integer> conditionalNode = new ConditionalOpNode<Integer>(consumer);
                DynamicProto.ConditionalInt32Op op = int32Source.getConditionalOp();
                this.bindRecursively(op.getCondition(), conditionalNode.getConditionIncomingCallback(), resultBuilder);
                this.bindRecursively(op.getValueIfTrue(), conditionalNode.getTrueValueIncomingCallback(), resultBuilder);
                this.bindRecursively(op.getValueIfFalse(), conditionalNode.getFalseValueIncomingCallback(), resultBuilder);
                node = conditionalNode;
                break;
            }
            case FLOAT_TO_INT: {
                Int32Nodes.FloatToInt32Node conversionNode = new Int32Nodes.FloatToInt32Node(int32Source.getFloatToInt(), consumer);
                node = conversionNode;
                this.bindRecursively(int32Source.getFloatToInt().getInput(), conversionNode.getIncomingCallback(), resultBuilder);
                break;
            }
            case DURATION_PART: {
                Int32Nodes.GetDurationPartOpNode durationPartOpNode = new Int32Nodes.GetDurationPartOpNode(int32Source.getDurationPart(), consumer);
                node = durationPartOpNode;
                this.bindRecursively(int32Source.getDurationPart().getInput(), durationPartOpNode.getIncomingCallback(), resultBuilder);
                break;
            }
            case ANIMATABLE_FIXED: {
                node = new Int32Nodes.AnimatableFixedInt32Node(int32Source.getAnimatableFixed(), consumer, this.mAnimationQuotaManager);
                break;
            }
            case ANIMATABLE_DYNAMIC: {
                DynamicProto.AnimatableDynamicInt32 dynamicNode = int32Source.getAnimatableDynamic();
                Int32Nodes.DynamicAnimatedInt32Node animationNode = new Int32Nodes.DynamicAnimatedInt32Node(consumer, dynamicNode.getAnimationSpec(), this.mAnimationQuotaManager);
                node = animationNode;
                this.bindRecursively(dynamicNode.getInput(), animationNode.getInputCallback(), resultBuilder);
                break;
            }
            case INNER_NOT_SET: {
                throw new IllegalArgumentException("DynamicInt32 has no inner source set");
            }
            default: {
                throw new IllegalArgumentException("Unknown DynamicInt32 source type");
            }
        }
        resultBuilder.add(node);
    }

    private void bindRecursively(@NonNull DynamicProto.DynamicDuration durationSource, @NonNull DynamicTypeValueReceiverWithPreUpdate<Duration> consumer, @NonNull List<DynamicDataNode<?>> resultBuilder) {
        DynamicDataNode<Duration> node;
        switch (durationSource.getInnerCase()) {
            case BETWEEN: {
                DurationNodes.BetweenInstancesNode betweenInstancesNode;
                node = betweenInstancesNode = new DurationNodes.BetweenInstancesNode(consumer);
                this.bindRecursively(durationSource.getBetween().getStartInclusive(), betweenInstancesNode.getLhsIncomingCallback(), resultBuilder);
                this.bindRecursively(durationSource.getBetween().getEndExclusive(), betweenInstancesNode.getRhsIncomingCallback(), resultBuilder);
                break;
            }
            case FIXED: {
                node = new DurationNodes.FixedDurationNode(durationSource.getFixed(), consumer);
                break;
            }
            case CONDITIONAL_OP: {
                ConditionalOpNode<Duration> conditionalNode = new ConditionalOpNode<Duration>(consumer);
                DynamicProto.ConditionalDurationOp op = durationSource.getConditionalOp();
                this.bindRecursively(op.getCondition(), conditionalNode.getConditionIncomingCallback(), resultBuilder);
                this.bindRecursively(op.getValueIfTrue(), conditionalNode.getTrueValueIncomingCallback(), resultBuilder);
                this.bindRecursively(op.getValueIfFalse(), conditionalNode.getFalseValueIncomingCallback(), resultBuilder);
                node = conditionalNode;
                break;
            }
            case INNER_NOT_SET: {
                throw new IllegalArgumentException("DynamicDuration has no inner source set");
            }
            default: {
                throw new IllegalArgumentException("Unknown DynamicDuration source type");
            }
        }
        resultBuilder.add(node);
    }

    private void bindRecursively(@NonNull DynamicProto.DynamicInstant instantSource, @NonNull DynamicTypeValueReceiverWithPreUpdate<Instant> consumer, @NonNull List<DynamicDataNode<?>> resultBuilder) {
        DynamicDataNode<Integer> node;
        switch (instantSource.getInnerCase()) {
            case FIXED: {
                node = new InstantNodes.FixedInstantNode(instantSource.getFixed(), consumer);
                break;
            }
            case PLATFORM_SOURCE: {
                node = new InstantNodes.PlatformTimeSourceNode(this.mTimeDataSource, consumer);
                break;
            }
            case CONDITIONAL_OP: {
                ConditionalOpNode<Instant> conditionalNode = new ConditionalOpNode<Instant>(consumer);
                DynamicProto.ConditionalInstantOp op = instantSource.getConditionalOp();
                this.bindRecursively(op.getCondition(), conditionalNode.getConditionIncomingCallback(), resultBuilder);
                this.bindRecursively(op.getValueIfTrue(), conditionalNode.getTrueValueIncomingCallback(), resultBuilder);
                this.bindRecursively(op.getValueIfFalse(), conditionalNode.getFalseValueIncomingCallback(), resultBuilder);
                node = conditionalNode;
                break;
            }
            case INNER_NOT_SET: {
                throw new IllegalArgumentException("DynamicInstant has no inner source set");
            }
            default: {
                throw new IllegalArgumentException("Unknown DynamicInstant source type");
            }
        }
        resultBuilder.add(node);
    }

    private void bindRecursively(@NonNull DynamicProto.DynamicFloat floatSource, @NonNull DynamicTypeValueReceiverWithPreUpdate<Float> consumer, @NonNull List<DynamicDataNode<?>> resultBuilder) {
        DynamicDataNode<Float> node;
        switch (floatSource.getInnerCase()) {
            case FIXED: {
                node = new FloatNodes.FixedFloatNode(floatSource.getFixed(), consumer);
                break;
            }
            case STATE_SOURCE: {
                node = new FloatNodes.StateFloatSourceNode(this.mStateStore, floatSource.getStateSource(), consumer);
                break;
            }
            case ARITHMETIC_OPERATION: {
                FloatNodes.ArithmeticFloatNode arithmeticNode = new FloatNodes.ArithmeticFloatNode(floatSource.getArithmeticOperation(), consumer);
                node = arithmeticNode;
                this.bindRecursively(floatSource.getArithmeticOperation().getInputLhs(), arithmeticNode.getLhsIncomingCallback(), resultBuilder);
                this.bindRecursively(floatSource.getArithmeticOperation().getInputRhs(), arithmeticNode.getRhsIncomingCallback(), resultBuilder);
                break;
            }
            case INT32_TO_FLOAT_OPERATION: {
                FloatNodes.Int32ToFloatNode toFloatNode = new FloatNodes.Int32ToFloatNode(consumer);
                node = toFloatNode;
                this.bindRecursively(floatSource.getInt32ToFloatOperation().getInput(), toFloatNode.getIncomingCallback(), resultBuilder);
                break;
            }
            case CONDITIONAL_OP: {
                ConditionalOpNode<Float> conditionalNode = new ConditionalOpNode<Float>(consumer);
                DynamicProto.ConditionalFloatOp op = floatSource.getConditionalOp();
                this.bindRecursively(op.getCondition(), conditionalNode.getConditionIncomingCallback(), resultBuilder);
                this.bindRecursively(op.getValueIfTrue(), conditionalNode.getTrueValueIncomingCallback(), resultBuilder);
                this.bindRecursively(op.getValueIfFalse(), conditionalNode.getFalseValueIncomingCallback(), resultBuilder);
                node = conditionalNode;
                break;
            }
            case ANIMATABLE_FIXED: {
                node = new FloatNodes.AnimatableFixedFloatNode(floatSource.getAnimatableFixed(), consumer, this.mAnimationQuotaManager);
                break;
            }
            case ANIMATABLE_DYNAMIC: {
                DynamicProto.AnimatableDynamicFloat dynamicNode = floatSource.getAnimatableDynamic();
                FloatNodes.DynamicAnimatedFloatNode animationNode = new FloatNodes.DynamicAnimatedFloatNode(consumer, dynamicNode.getAnimationSpec(), this.mAnimationQuotaManager);
                node = animationNode;
                this.bindRecursively(dynamicNode.getInput(), animationNode.getInputCallback(), resultBuilder);
                break;
            }
            case INNER_NOT_SET: {
                throw new IllegalArgumentException("DynamicFloat has no inner source set");
            }
            default: {
                throw new IllegalArgumentException("Unknown DynamicFloat source type");
            }
        }
        resultBuilder.add(node);
    }

    private void bindRecursively(@NonNull DynamicProto.DynamicColor colorSource, @NonNull DynamicTypeValueReceiverWithPreUpdate<Integer> consumer, @NonNull List<DynamicDataNode<?>> resultBuilder) {
        DynamicDataNode<Integer> node;
        switch (colorSource.getInnerCase()) {
            case FIXED: {
                node = new ColorNodes.FixedColorNode(colorSource.getFixed(), consumer);
                break;
            }
            case STATE_SOURCE: {
                node = new ColorNodes.StateColorSourceNode(this.mStateStore, colorSource.getStateSource(), consumer);
                break;
            }
            case ANIMATABLE_FIXED: {
                node = new ColorNodes.AnimatableFixedColorNode(colorSource.getAnimatableFixed(), consumer, this.mAnimationQuotaManager);
                break;
            }
            case ANIMATABLE_DYNAMIC: {
                DynamicProto.AnimatableDynamicColor dynamicNode = colorSource.getAnimatableDynamic();
                ColorNodes.DynamicAnimatedColorNode animationNode = new ColorNodes.DynamicAnimatedColorNode(consumer, dynamicNode.getAnimationSpec(), this.mAnimationQuotaManager);
                node = animationNode;
                this.bindRecursively(dynamicNode.getInput(), animationNode.getInputCallback(), resultBuilder);
                break;
            }
            case CONDITIONAL_OP: {
                ConditionalOpNode<Integer> conditionalNode = new ConditionalOpNode<Integer>(consumer);
                DynamicProto.ConditionalColorOp op = colorSource.getConditionalOp();
                this.bindRecursively(op.getCondition(), conditionalNode.getConditionIncomingCallback(), resultBuilder);
                this.bindRecursively(op.getValueIfTrue(), conditionalNode.getTrueValueIncomingCallback(), resultBuilder);
                this.bindRecursively(op.getValueIfFalse(), conditionalNode.getFalseValueIncomingCallback(), resultBuilder);
                node = conditionalNode;
                break;
            }
            case INNER_NOT_SET: {
                throw new IllegalArgumentException("DynamicColor has no inner source set");
            }
            default: {
                throw new IllegalArgumentException("Unknown DynamicColor source type");
            }
        }
        resultBuilder.add(node);
    }

    private void bindRecursively(@NonNull DynamicProto.DynamicBool boolSource, @NonNull DynamicTypeValueReceiverWithPreUpdate<Boolean> consumer, @NonNull List<DynamicDataNode<?>> resultBuilder) {
        DynamicDataNode<Boolean> node;
        switch (boolSource.getInnerCase()) {
            case FIXED: {
                node = new BoolNodes.FixedBoolNode(boolSource.getFixed(), consumer);
                break;
            }
            case STATE_SOURCE: {
                node = new BoolNodes.StateBoolNode(this.mStateStore, boolSource.getStateSource(), consumer);
                break;
            }
            case INT32_COMPARISON: {
                BoolNodes.ComparisonInt32Node compNode = new BoolNodes.ComparisonInt32Node(boolSource.getInt32Comparison(), consumer);
                node = compNode;
                this.bindRecursively(boolSource.getInt32Comparison().getInputLhs(), compNode.getLhsIncomingCallback(), resultBuilder);
                this.bindRecursively(boolSource.getInt32Comparison().getInputRhs(), compNode.getRhsIncomingCallback(), resultBuilder);
                break;
            }
            case LOGICAL_OP: {
                BoolNodes.LogicalBoolOp logicalNode = new BoolNodes.LogicalBoolOp(boolSource.getLogicalOp(), consumer);
                node = logicalNode;
                this.bindRecursively(boolSource.getLogicalOp().getInputLhs(), logicalNode.getLhsIncomingCallback(), resultBuilder);
                this.bindRecursively(boolSource.getLogicalOp().getInputRhs(), logicalNode.getRhsIncomingCallback(), resultBuilder);
                break;
            }
            case NOT_OP: {
                BoolNodes.NotBoolOp notNode = new BoolNodes.NotBoolOp(consumer);
                node = notNode;
                this.bindRecursively(boolSource.getNotOp().getInput(), notNode.getIncomingCallback(), resultBuilder);
                break;
            }
            case FLOAT_COMPARISON: {
                BoolNodes.ComparisonFloatNode compNode = new BoolNodes.ComparisonFloatNode(boolSource.getFloatComparison(), consumer);
                node = compNode;
                this.bindRecursively(boolSource.getFloatComparison().getInputLhs(), compNode.getLhsIncomingCallback(), resultBuilder);
                this.bindRecursively(boolSource.getFloatComparison().getInputRhs(), compNode.getRhsIncomingCallback(), resultBuilder);
                break;
            }
            case INNER_NOT_SET: {
                throw new IllegalArgumentException("DynamicBool has no inner source set");
            }
            default: {
                throw new IllegalArgumentException("Unknown DynamicBool source type");
            }
        }
        resultBuilder.add(node);
    }

    public static final class Config {
        @Nullable
        private final StateStore mStateStore;
        @Nullable
        private final QuotaManager mAnimationQuotaManager;
        @Nullable
        private final TimeGateway mTimeGateway;
        @Nullable
        private final SensorGateway mSensorGateway;
        @Nullable
        private final QuotaManager mDynamicTypesQuotaManager;

        Config(@Nullable StateStore stateStore, @Nullable QuotaManager animationQuotaManager, @Nullable QuotaManager dynamicTypesQuotaManager, @Nullable TimeGateway timeGateway, @Nullable SensorGateway sensorGateway) {
            this.mStateStore = stateStore;
            this.mAnimationQuotaManager = animationQuotaManager;
            this.mTimeGateway = timeGateway;
            this.mSensorGateway = sensorGateway;
            this.mDynamicTypesQuotaManager = dynamicTypesQuotaManager;
        }

        @Nullable
        public StateStore getStateStore() {
            return this.mStateStore;
        }

        @Nullable
        public QuotaManager getDynamicTypesQuotaManager() {
            return this.mDynamicTypesQuotaManager;
        }

        @Nullable
        public QuotaManager getAnimationQuotaManager() {
            return this.mAnimationQuotaManager;
        }

        @Nullable
        public SensorGateway getSensorGateway() {
            return this.mSensorGateway;
        }

        @Nullable
        public TimeGateway getTimeGateway() {
            return this.mTimeGateway;
        }

        public static final class Builder {
            @Nullable
            private StateStore mStateStore = null;
            @Nullable
            private QuotaManager mAnimationQuotaManager = null;
            @Nullable
            private QuotaManager mDynamicTypesQuotaManager;
            @Nullable
            private TimeGateway mTimeGateway = null;
            @Nullable
            private SensorGateway mSensorGateway = null;

            @NonNull
            public Builder setStateStore(@NonNull StateStore value) {
                this.mStateStore = value;
                return this;
            }

            @NonNull
            public Builder setDynamicTypesQuotaManager(@NonNull QuotaManager value) {
                this.mDynamicTypesQuotaManager = value;
                return this;
            }

            @NonNull
            public Builder setAnimationQuotaManager(@NonNull QuotaManager value) {
                this.mAnimationQuotaManager = value;
                return this;
            }

            @NonNull
            public Builder setTimeGateway(@NonNull TimeGateway value) {
                this.mTimeGateway = value;
                return this;
            }

            @NonNull
            public Builder setSensorGateway(@NonNull SensorGateway value) {
                this.mSensorGateway = value;
                return this;
            }

            @NonNull
            public Config build() {
                return new Config(this.mStateStore, this.mAnimationQuotaManager, this.mDynamicTypesQuotaManager, this.mTimeGateway, this.mSensorGateway);
            }
        }
    }

    public static class EvaluationException
    extends Exception {
        public EvaluationException(@NonNull String message) {
            super(message);
        }
    }

    private static class DynamicTypeValueReceiverOnExecutor<T>
    implements DynamicTypeValueReceiverWithPreUpdate<T> {
        @NonNull
        private final Executor mExecutor;
        @NonNull
        private final DynamicTypeValueReceiver<T> mConsumer;

        DynamicTypeValueReceiverOnExecutor(@NonNull DynamicTypeValueReceiver<T> consumer) {
            this(Runnable::run, consumer);
        }

        DynamicTypeValueReceiverOnExecutor(@NonNull Executor executor, @NonNull DynamicTypeValueReceiver<T> consumer) {
            this.mConsumer = consumer;
            this.mExecutor = executor;
        }

        @Override
        public void onPreUpdate() {
        }

        @Override
        public void onData(@NonNull T newData) {
            this.mExecutor.execute(() -> this.mConsumer.onData(newData));
        }

        @Override
        public void onInvalidated() {
            this.mExecutor.execute(this.mConsumer::onInvalidated);
        }
    }
}

