/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import androidx.collection.SimpleArrayMap;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiverWithPreUpdate;
import androidx.wear.protolayout.expression.pipeline.TimeGateway;
import java.time.Instant;
import java.util.concurrent.Executor;

class EpochTimePlatformDataSource {
    private final Executor mUiExecutor;
    private final TimeGateway mGateway;
    private final SimpleArrayMap<DynamicTypeValueReceiverWithPreUpdate<Instant>, TimeGateway.TimeCallback> mConsumerToTimeCallback = new SimpleArrayMap();

    EpochTimePlatformDataSource(Executor uiExecutor, TimeGateway gateway) {
        this.mUiExecutor = uiExecutor;
        this.mGateway = gateway;
    }

    public void registerForData(final DynamicTypeValueReceiverWithPreUpdate<Instant> consumer) {
        TimeGateway.TimeCallback timeCallback = new TimeGateway.TimeCallback(){

            @Override
            public void onPreUpdate() {
                consumer.onPreUpdate();
            }

            @Override
            public void onData() {
                consumer.onData(Instant.now());
            }
        };
        this.mGateway.registerForUpdates(this.mUiExecutor, timeCallback);
        this.mConsumerToTimeCallback.put(consumer, (Object)timeCallback);
    }

    public void unregisterForData(DynamicTypeValueReceiverWithPreUpdate<Instant> consumer) {
        TimeGateway.TimeCallback timeCallback = (TimeGateway.TimeCallback)this.mConsumerToTimeCallback.remove(consumer);
        if (timeCallback != null) {
            this.mGateway.unregisterForUpdates(timeCallback);
        }
    }
}

