/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.wear.protolayout.expression.pipeline.QuotaManager;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class FixedQuotaManagerImpl
implements QuotaManager {
    private final int mQuotaCap;
    private int mQuotaCounter = 0;

    public FixedQuotaManagerImpl(int quotaCap) {
        this.mQuotaCap = quotaCap;
    }

    @Override
    public boolean tryAcquireQuota(int quota) {
        if (this.mQuotaCounter + quota <= this.mQuotaCap) {
            this.mQuotaCounter += quota;
            return true;
        }
        return false;
    }

    @Override
    public void releaseQuota(int quota) {
        if (this.mQuotaCounter - quota < 0) {
            throw new IllegalArgumentException("Trying to release more quota than it was acquired!");
        }
        this.mQuotaCounter -= quota;
    }

    @VisibleForTesting
    public boolean isAllQuotaReleased() {
        return this.mQuotaCounter == 0;
    }

    @VisibleForTesting
    public int getRemainingQuota() {
        return this.mQuotaCap - this.mQuotaCounter;
    }
}

