/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.wear.protolayout.expression.pipeline.AnimatableNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataBiTransformNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataSourceNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataTransformNode;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiverWithPreUpdate;
import androidx.wear.protolayout.expression.pipeline.QuotaManager;
import androidx.wear.protolayout.expression.pipeline.StateSourceNode;
import androidx.wear.protolayout.expression.pipeline.StateStore;
import androidx.wear.protolayout.expression.proto.AnimationParameterProto;
import androidx.wear.protolayout.expression.proto.DynamicProto;
import androidx.wear.protolayout.expression.proto.FixedProto;

class FloatNodes {
    private FloatNodes() {
    }

    static class DynamicAnimatedFloatNode
    extends AnimatableNode
    implements DynamicDataNode<Float> {
        final DynamicTypeValueReceiverWithPreUpdate<Float> mDownstream;
        private final DynamicTypeValueReceiverWithPreUpdate<Float> mInputCallback;
        @Nullable
        Float mCurrentValue = null;
        int mPendingCalls = 0;

        DynamicAnimatedFloatNode(DynamicTypeValueReceiverWithPreUpdate<Float> downstream, @NonNull AnimationParameterProto.AnimationSpec spec, QuotaManager quotaManager) {
            super(quotaManager, spec);
            this.mDownstream = downstream;
            this.mQuotaAwareAnimator.addUpdateCallback(animatedValue -> {
                if (this.mPendingCalls == 0) {
                    this.mCurrentValue = (Float)animatedValue;
                    this.mDownstream.onData(this.mCurrentValue);
                }
            });
            this.mInputCallback = new DynamicTypeValueReceiverWithPreUpdate<Float>(){

                @Override
                public void onPreUpdate() {
                    ++mPendingCalls;
                    if (mPendingCalls == 1) {
                        mDownstream.onPreUpdate();
                    }
                }

                @Override
                public void onData(@NonNull Float newData) {
                    if (mPendingCalls > 0) {
                        --mPendingCalls;
                    }
                    if (mPendingCalls == 0) {
                        if (mCurrentValue == null) {
                            mCurrentValue = newData;
                            mDownstream.onData(mCurrentValue);
                        } else {
                            mQuotaAwareAnimator.setFloatValues(mCurrentValue.floatValue(), newData.floatValue());
                            this.startOrSkipAnimator();
                        }
                    }
                }

                @Override
                public void onInvalidated() {
                    if (mPendingCalls > 0) {
                        --mPendingCalls;
                    }
                    if (mPendingCalls == 0) {
                        mCurrentValue = null;
                        mDownstream.onInvalidated();
                    }
                }
            };
        }

        public DynamicTypeValueReceiverWithPreUpdate<Float> getInputCallback() {
            return this.mInputCallback;
        }
    }

    static class AnimatableFixedFloatNode
    extends AnimatableNode
    implements DynamicDataSourceNode<Float> {
        private final DynamicProto.AnimatableFixedFloat mProtoNode;
        private final DynamicTypeValueReceiverWithPreUpdate<Float> mDownstream;

        AnimatableFixedFloatNode(DynamicProto.AnimatableFixedFloat protoNode, DynamicTypeValueReceiverWithPreUpdate<Float> downstream, QuotaManager quotaManager) {
            super(quotaManager, protoNode.getAnimationSpec());
            this.mProtoNode = protoNode;
            this.mDownstream = downstream;
            this.mQuotaAwareAnimator.addUpdateCallback(animatedValue -> this.mDownstream.onData((Float)animatedValue));
        }

        @Override
        @UiThread
        public void preInit() {
            this.mDownstream.onPreUpdate();
        }

        @Override
        @UiThread
        public void init() {
            this.mQuotaAwareAnimator.setFloatValues(this.mProtoNode.getFromValue(), this.mProtoNode.getToValue());
            this.startOrSkipAnimator();
        }

        @Override
        @UiThread
        public void destroy() {
            this.mQuotaAwareAnimator.stopAnimator();
        }
    }

    static class Int32ToFloatNode
    extends DynamicDataTransformNode<Integer, Float> {
        Int32ToFloatNode(DynamicTypeValueReceiverWithPreUpdate<Float> downstream) {
            super(downstream, i -> Float.valueOf(i.intValue()));
        }
    }

    static class ArithmeticFloatNode
    extends DynamicDataBiTransformNode<Float, Float, Float> {
        private static final String TAG = "ArithmeticFloatNode";

        ArithmeticFloatNode(DynamicProto.ArithmeticFloatOp protoNode, DynamicTypeValueReceiverWithPreUpdate<Float> downstream) {
            super(downstream, (LhsT lhs, RhsT rhs) -> {
                try {
                    switch (protoNode.getOperationType()) {
                        case ARITHMETIC_OP_TYPE_UNDEFINED: 
                        case UNRECOGNIZED: {
                            Log.e((String)TAG, (String)"Unknown operation type in ArithmeticFloatNode");
                            return Float.valueOf(Float.NaN);
                        }
                        case ARITHMETIC_OP_TYPE_ADD: {
                            return Float.valueOf(lhs.floatValue() + rhs.floatValue());
                        }
                        case ARITHMETIC_OP_TYPE_SUBTRACT: {
                            return Float.valueOf(lhs.floatValue() - rhs.floatValue());
                        }
                        case ARITHMETIC_OP_TYPE_MULTIPLY: {
                            return Float.valueOf(lhs.floatValue() * rhs.floatValue());
                        }
                        case ARITHMETIC_OP_TYPE_DIVIDE: {
                            return Float.valueOf(lhs.floatValue() / rhs.floatValue());
                        }
                        case ARITHMETIC_OP_TYPE_MODULO: {
                            return Float.valueOf(lhs.floatValue() % rhs.floatValue());
                        }
                    }
                }
                catch (ArithmeticException ex) {
                    Log.e((String)TAG, (String)"ArithmeticException in ArithmeticFloatNode", (Throwable)ex);
                    return Float.valueOf(Float.NaN);
                }
                Log.e((String)TAG, (String)"Unknown operation type in ArithmeticFloatNode");
                return Float.valueOf(Float.NaN);
            });
        }
    }

    static class StateFloatSourceNode
    extends StateSourceNode<Float> {
        StateFloatSourceNode(StateStore stateStore, DynamicProto.StateFloatSource protoNode, DynamicTypeValueReceiverWithPreUpdate<Float> downstream) {
            super(stateStore, protoNode.getSourceKey(), se -> Float.valueOf(se.getFloatVal().getValue()), downstream);
        }
    }

    static class FixedFloatNode
    implements DynamicDataSourceNode<Float> {
        private final float mValue;
        private final DynamicTypeValueReceiverWithPreUpdate<Float> mDownstream;

        FixedFloatNode(FixedProto.FixedFloat protoNode, DynamicTypeValueReceiverWithPreUpdate<Float> downstream) {
            this.mValue = protoNode.getValue();
            this.mDownstream = downstream;
        }

        @Override
        @UiThread
        public void preInit() {
            this.mDownstream.onPreUpdate();
        }

        @Override
        @UiThread
        public void init() {
            if (Float.isNaN(this.mValue)) {
                this.mDownstream.onInvalidated();
            } else {
                this.mDownstream.onData(Float.valueOf(this.mValue));
            }
        }

        @Override
        @UiThread
        public void destroy() {
        }
    }
}

