/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.wear.protolayout.expression.pipeline.DynamicDataSourceNode;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiverWithPreUpdate;
import androidx.wear.protolayout.expression.pipeline.EpochTimePlatformDataSource;
import androidx.wear.protolayout.expression.proto.FixedProto;
import java.time.Instant;

class InstantNodes {
    private InstantNodes() {
    }

    static class PlatformTimeSourceNode
    implements DynamicDataSourceNode<Integer> {
        @Nullable
        private final EpochTimePlatformDataSource mEpochTimePlatformDataSource;
        private final DynamicTypeValueReceiverWithPreUpdate<Instant> mDownstream;

        PlatformTimeSourceNode(@Nullable EpochTimePlatformDataSource epochTimePlatformDataSource, DynamicTypeValueReceiverWithPreUpdate<Instant> downstream) {
            this.mEpochTimePlatformDataSource = epochTimePlatformDataSource;
            this.mDownstream = downstream;
        }

        @Override
        @UiThread
        public void preInit() {
        }

        @Override
        @UiThread
        public void init() {
            if (this.mEpochTimePlatformDataSource != null) {
                this.mEpochTimePlatformDataSource.registerForData(this.mDownstream);
            } else {
                this.mDownstream.onInvalidated();
            }
        }

        @Override
        @UiThread
        public void destroy() {
            if (this.mEpochTimePlatformDataSource != null) {
                this.mEpochTimePlatformDataSource.unregisterForData(this.mDownstream);
            }
        }
    }

    static class FixedInstantNode
    implements DynamicDataSourceNode<Integer> {
        private final Instant mValue;
        private final DynamicTypeValueReceiverWithPreUpdate<Instant> mDownstream;

        FixedInstantNode(FixedProto.FixedInstant protoNode, DynamicTypeValueReceiverWithPreUpdate<Instant> downstream) {
            this.mValue = Instant.ofEpochSecond(protoNode.getEpochSeconds());
            this.mDownstream = downstream;
        }

        @Override
        @UiThread
        public void preInit() {
            this.mDownstream.onPreUpdate();
        }

        @Override
        @UiThread
        public void init() {
            this.mDownstream.onData(this.mValue);
        }

        @Override
        public void destroy() {
        }
    }
}

