/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.wear.protolayout.expression.pipeline.AnimatableNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataBiTransformNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataSourceNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataTransformNode;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiverWithPreUpdate;
import androidx.wear.protolayout.expression.pipeline.QuotaManager;
import androidx.wear.protolayout.expression.pipeline.SensorGatewayPlatformDataSource;
import androidx.wear.protolayout.expression.pipeline.StateSourceNode;
import androidx.wear.protolayout.expression.pipeline.StateStore;
import androidx.wear.protolayout.expression.proto.AnimationParameterProto;
import androidx.wear.protolayout.expression.proto.DynamicProto;
import androidx.wear.protolayout.expression.proto.FixedProto;
import java.time.Duration;

class Int32Nodes {
    private Int32Nodes() {
    }

    static class DynamicAnimatedInt32Node
    extends AnimatableNode
    implements DynamicDataNode<Integer> {
        final DynamicTypeValueReceiverWithPreUpdate<Integer> mDownstream;
        private final DynamicTypeValueReceiverWithPreUpdate<Integer> mInputCallback;
        @Nullable
        Integer mCurrentValue = null;
        int mPendingCalls = 0;

        DynamicAnimatedInt32Node(DynamicTypeValueReceiverWithPreUpdate<Integer> downstream, @NonNull AnimationParameterProto.AnimationSpec spec, QuotaManager quotaManager) {
            super(quotaManager, spec);
            this.mDownstream = downstream;
            this.mQuotaAwareAnimator.addUpdateCallback(animatedValue -> {
                if (this.mPendingCalls == 0) {
                    this.mCurrentValue = (Integer)animatedValue;
                    this.mDownstream.onData(this.mCurrentValue);
                }
            });
            this.mInputCallback = new DynamicTypeValueReceiverWithPreUpdate<Integer>(){

                @Override
                public void onPreUpdate() {
                    ++mPendingCalls;
                    if (mPendingCalls == 1) {
                        mDownstream.onPreUpdate();
                    }
                }

                @Override
                public void onData(@NonNull Integer newData) {
                    if (mPendingCalls > 0) {
                        --mPendingCalls;
                    }
                    if (mPendingCalls == 0) {
                        if (mCurrentValue == null) {
                            mCurrentValue = newData;
                            mDownstream.onData(mCurrentValue);
                        } else {
                            mQuotaAwareAnimator.setIntValues(mCurrentValue, newData);
                            this.startOrSkipAnimator();
                        }
                    }
                }

                @Override
                public void onInvalidated() {
                    if (mPendingCalls > 0) {
                        --mPendingCalls;
                    }
                    if (mPendingCalls == 0) {
                        mCurrentValue = null;
                        mDownstream.onInvalidated();
                    }
                }
            };
        }

        public DynamicTypeValueReceiverWithPreUpdate<Integer> getInputCallback() {
            return this.mInputCallback;
        }
    }

    static class AnimatableFixedInt32Node
    extends AnimatableNode
    implements DynamicDataSourceNode<Integer> {
        private final DynamicProto.AnimatableFixedInt32 mProtoNode;
        private final DynamicTypeValueReceiverWithPreUpdate<Integer> mDownstream;

        AnimatableFixedInt32Node(DynamicProto.AnimatableFixedInt32 protoNode, DynamicTypeValueReceiverWithPreUpdate<Integer> downstream, QuotaManager quotaManager) {
            super(quotaManager, protoNode.getAnimationSpec());
            this.mProtoNode = protoNode;
            this.mDownstream = downstream;
            this.mQuotaAwareAnimator.addUpdateCallback(animatedValue -> this.mDownstream.onData((Integer)animatedValue));
        }

        @Override
        @UiThread
        public void preInit() {
            this.mDownstream.onPreUpdate();
        }

        @Override
        @UiThread
        public void init() {
            this.mQuotaAwareAnimator.setIntValues(this.mProtoNode.getFromValue(), this.mProtoNode.getToValue());
            this.startOrSkipAnimator();
        }

        @Override
        @UiThread
        public void destroy() {
            this.mQuotaAwareAnimator.stopAnimator();
        }
    }

    static class GetDurationPartOpNode
    extends DynamicDataTransformNode<Duration, Integer> {
        private static final String TAG = "GetDurationPartOpNode";

        GetDurationPartOpNode(DynamicProto.GetDurationPartOp protoNode, DynamicTypeValueReceiverWithPreUpdate<Integer> downstream) {
            super(downstream, (I duration) -> (int)GetDurationPartOpNode.getDurationPart(duration, protoNode.getDurationPart()));
        }

        private static long getDurationPart(Duration duration, DynamicProto.DurationPartType durationPartType) {
            switch (durationPartType) {
                case DURATION_PART_TYPE_UNDEFINED: 
                case UNRECOGNIZED: {
                    Log.e((String)TAG, (String)"Unknown duration part type in GetDurationPartOpNode");
                    return 0L;
                }
                case DURATION_PART_TYPE_DAYS: {
                    return Math.abs(duration.getSeconds() / 86400L);
                }
                case DURATION_PART_TYPE_HOURS: {
                    return Math.abs(duration.getSeconds() / 3600L % 24L);
                }
                case DURATION_PART_TYPE_MINUTES: {
                    return Math.abs(duration.getSeconds() / 60L % 60L);
                }
                case DURATION_PART_TYPE_SECONDS: {
                    return Math.abs(duration.getSeconds() % 60L);
                }
                case DURATION_PART_TYPE_TOTAL_DAYS: {
                    return duration.toDays();
                }
                case DURATION_PART_TYPE_TOTAL_HOURS: {
                    return duration.toHours();
                }
                case DURATION_PART_TYPE_TOTAL_MINUTES: {
                    return duration.toMinutes();
                }
                case DURATION_PART_TYPE_TOTAL_SECONDS: {
                    return duration.getSeconds();
                }
            }
            throw new IllegalArgumentException("Unknown duration part");
        }
    }

    static class FloatToInt32Node
    extends DynamicDataTransformNode<Float, Integer> {
        FloatToInt32Node(DynamicProto.FloatToInt32Op protoNode, DynamicTypeValueReceiverWithPreUpdate<Integer> downstream) {
            super(downstream, x -> {
                switch (protoNode.getRoundMode()) {
                    case ROUND_MODE_UNDEFINED: 
                    case ROUND_MODE_FLOOR: {
                        return (int)Math.floor(x.floatValue());
                    }
                    case ROUND_MODE_ROUND: {
                        return Math.round(x.floatValue());
                    }
                    case ROUND_MODE_CEILING: {
                        return (int)Math.ceil(x.floatValue());
                    }
                }
                throw new IllegalArgumentException("Unknown rounding mode");
            }, x -> x.floatValue() - 1.0f < 2.1474836E9f && x.floatValue() >= -2.1474836E9f);
        }
    }

    static class StateInt32SourceNode
    extends StateSourceNode<Integer> {
        StateInt32SourceNode(StateStore stateStore, DynamicProto.StateInt32Source protoNode, DynamicTypeValueReceiverWithPreUpdate<Integer> downstream) {
            super(stateStore, protoNode.getSourceKey(), se -> se.getInt32Val().getValue(), downstream);
        }
    }

    static class ArithmeticInt32Node
    extends DynamicDataBiTransformNode<Integer, Integer, Integer> {
        private static final String TAG = "ArithmeticInt32Node";

        ArithmeticInt32Node(DynamicProto.ArithmeticInt32Op protoNode, DynamicTypeValueReceiverWithPreUpdate<Integer> downstream) {
            super(downstream, (LhsT lhs, RhsT rhs) -> {
                try {
                    switch (protoNode.getOperationType()) {
                        case ARITHMETIC_OP_TYPE_UNDEFINED: 
                        case UNRECOGNIZED: {
                            Log.e((String)TAG, (String)"Unknown operation type in ArithmeticInt32Node");
                            return 0;
                        }
                        case ARITHMETIC_OP_TYPE_ADD: {
                            return lhs + rhs;
                        }
                        case ARITHMETIC_OP_TYPE_SUBTRACT: {
                            return lhs - rhs;
                        }
                        case ARITHMETIC_OP_TYPE_MULTIPLY: {
                            return lhs * rhs;
                        }
                        case ARITHMETIC_OP_TYPE_DIVIDE: {
                            return lhs / rhs;
                        }
                        case ARITHMETIC_OP_TYPE_MODULO: {
                            return lhs % rhs;
                        }
                    }
                }
                catch (ArithmeticException ex) {
                    Log.e((String)TAG, (String)"ArithmeticException in ArithmeticInt32Node", (Throwable)ex);
                    return 0;
                }
                Log.e((String)TAG, (String)"Unknown operation type in ArithmeticInt32Node");
                return 0;
            });
        }
    }

    static class PlatformInt32SourceNode
    implements DynamicDataSourceNode<Integer> {
        private static final String TAG = "PlatformInt32SourceNode";
        @Nullable
        private final SensorGatewayPlatformDataSource mSensorGatewaySource;
        private final DynamicProto.PlatformInt32SourceType mPlatformSourceType;
        private final DynamicTypeValueReceiverWithPreUpdate<Integer> mDownstream;

        PlatformInt32SourceNode(DynamicProto.PlatformInt32Source protoNode, @Nullable SensorGatewayPlatformDataSource sensorGatewaySource, DynamicTypeValueReceiverWithPreUpdate<Integer> downstream) {
            this.mPlatformSourceType = protoNode.getSourceType();
            if (this.mPlatformSourceType == DynamicProto.PlatformInt32SourceType.PLATFORM_INT32_SOURCE_TYPE_CURRENT_HEART_RATE || this.mPlatformSourceType == DynamicProto.PlatformInt32SourceType.PLATFORM_INT32_SOURCE_TYPE_DAILY_STEP_COUNT) {
                this.mSensorGatewaySource = sensorGatewaySource;
            } else {
                this.mSensorGatewaySource = null;
                Log.w((String)TAG, (String)("Unknown PlatformInt32SourceType: " + this.mPlatformSourceType));
            }
            this.mDownstream = downstream;
        }

        @Override
        @UiThread
        public void preInit() {
            if (this.mSensorGatewaySource != null) {
                this.mDownstream.onPreUpdate();
            }
        }

        @Override
        @UiThread
        public void init() {
            if (this.mSensorGatewaySource != null) {
                try {
                    this.mSensorGatewaySource.registerForData(this.mPlatformSourceType, this.mDownstream);
                }
                catch (SecurityException e) {
                    Log.w((String)TAG, (String)e.getMessage(), (Throwable)e);
                    this.mDownstream.onInvalidated();
                }
            } else {
                this.mDownstream.onInvalidated();
            }
        }

        @Override
        @UiThread
        public void destroy() {
            if (this.mSensorGatewaySource != null) {
                this.mSensorGatewaySource.unregisterForData(this.mPlatformSourceType, this.mDownstream);
            }
        }
    }

    static class FixedInt32Node
    implements DynamicDataSourceNode<Integer> {
        private final int mValue;
        private final DynamicTypeValueReceiverWithPreUpdate<Integer> mDownstream;

        FixedInt32Node(FixedProto.FixedInt32 protoNode, DynamicTypeValueReceiverWithPreUpdate<Integer> downstream) {
            this.mValue = protoNode.getValue();
            this.mDownstream = downstream;
        }

        @Override
        @UiThread
        public void preInit() {
            this.mDownstream.onPreUpdate();
        }

        @Override
        @UiThread
        public void init() {
            this.mDownstream.onData(this.mValue);
        }

        @Override
        @UiThread
        public void destroy() {
        }
    }
}

