/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import android.icu.number.IntegerWidth;
import android.icu.number.LocalizedNumberFormatter;
import android.icu.number.NumberFormatter;
import android.icu.number.Precision;
import android.icu.text.DecimalFormat;
import android.icu.text.NumberFormat;
import android.icu.util.ULocale;
import android.os.Build;
import android.util.Log;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.wear.protolayout.expression.proto.DynamicProto;

class NumberFormatter {
    Formatter mFormatter;
    private static final String TAG = "NumberFormatter";
    private static final int DEFAULT_MIN_INTEGER_DIGITS = 1;
    private static final int DEFAULT_MAX_FRACTION_DIGITS = 3;
    @VisibleForTesting
    static final int MAX_INTEGER_PART_LENGTH = 15;
    @VisibleForTesting
    static final int MAX_FRACTION_PART_LENGTH = 15;

    NumberFormatter(DynamicProto.FloatFormatOp floatFormatOp, ULocale currentLocale) {
        int maxFractionDigits;
        int minIntegerDigits = floatFormatOp.hasMinIntegerDigits() ? floatFormatOp.getMinIntegerDigits() : 1;
        int minFractionDigits = floatFormatOp.getMinFractionDigits();
        if (minFractionDigits > 15) {
            NumberFormatter.logLargeParam("MinFractionDigits", minFractionDigits, 15);
            minFractionDigits = 15;
        }
        if ((maxFractionDigits = Math.max(floatFormatOp.hasMaxFractionDigits() ? floatFormatOp.getMaxFractionDigits() : 3, minFractionDigits)) > 15) {
            NumberFormatter.logLargeParam("MaxFractionDigits", maxFractionDigits, 15);
            maxFractionDigits = 15;
        }
        if (minIntegerDigits > 15) {
            NumberFormatter.logLargeParam("MinIntegerDigits", minIntegerDigits, 15);
            minIntegerDigits = 15;
        }
        this.mFormatter = NumberFormatter.buildFormatter(minIntegerDigits, minFractionDigits, maxFractionDigits, floatFormatOp.getGroupingUsed(), currentLocale);
    }

    NumberFormatter(DynamicProto.Int32FormatOp int32FormatOp, ULocale currentLocale) {
        int minIntegerDigits;
        int n = minIntegerDigits = int32FormatOp.hasMinIntegerDigits() ? int32FormatOp.getMinIntegerDigits() : 1;
        if (minIntegerDigits > 15) {
            NumberFormatter.logLargeParam("MinIntegerDigits", minIntegerDigits, 15);
            minIntegerDigits = 15;
        }
        this.mFormatter = NumberFormatter.buildFormatter(minIntegerDigits, 0, 0, int32FormatOp.getGroupingUsed(), currentLocale);
    }

    String format(float value) {
        return this.mFormatter.format(value);
    }

    String format(int value) {
        return this.mFormatter.format(value);
    }

    private static void logLargeParam(String paramName, int oldValue, int newValue) {
        Log.w((String)TAG, (String)String.format("%s (%d) is too large. Using the maximum allowed value instead: %d", paramName, oldValue, newValue));
    }

    private static Formatter buildFormatter(final int minIntegerDigits, final int minFractionDigits, final int maxFractionDigits, final boolean groupingUsed, final ULocale currentLocale) {
        if (Build.VERSION.SDK_INT >= 30) {
            return new Formatter(){
                final LocalizedNumberFormatter mFmt;
                {
                    this.mFmt = Api30Impl.buildLocalizedNumberFormatter(minIntegerDigits, minFractionDigits, maxFractionDigits, groupingUsed, currentLocale);
                }

                @Override
                public String format(int value) {
                    return Api30Impl.callFormatToString(this.mFmt, value);
                }

                @Override
                public String format(float value) {
                    return Api30Impl.callFormatToString(this.mFmt, value);
                }
            };
        }
        return new Formatter(){
            final DecimalFormat mFmt;
            {
                this.mFmt = NumberFormatter.buildDecimalFormat(minIntegerDigits, minFractionDigits, maxFractionDigits, groupingUsed, currentLocale);
            }

            @Override
            public String format(int value) {
                return this.mFmt.format((long)value);
            }

            @Override
            public String format(float value) {
                return this.mFmt.format((double)value);
            }
        };
    }

    static DecimalFormat buildDecimalFormat(int minIntegerDigits, int minFractionDigits, int maxFractionDigits, boolean groupingUsed, ULocale currentLocale) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance((ULocale)currentLocale);
        decimalFormat.setMinimumIntegerDigits(minIntegerDigits);
        decimalFormat.setGroupingUsed(groupingUsed);
        decimalFormat.setMaximumFractionDigits(maxFractionDigits);
        decimalFormat.setMinimumFractionDigits(minFractionDigits);
        return decimalFormat;
    }

    private static interface Formatter {
        public String format(int var1);

        public String format(float var1);
    }

    @RequiresApi(value=30)
    private static class Api30Impl {
        private Api30Impl() {
        }

        @NonNull
        @DoNotInline
        static String callFormatToString(LocalizedNumberFormatter mFmt, int value) {
            return mFmt.format((long)value).toString();
        }

        @NonNull
        @DoNotInline
        static String callFormatToString(LocalizedNumberFormatter mFmt, float value) {
            return mFmt.format((double)value).toString();
        }

        @NonNull
        @DoNotInline
        static LocalizedNumberFormatter buildLocalizedNumberFormatter(int minIntegerDigits, int minFractionDigits, int maxFractionDigits, boolean groupingUsed, ULocale currentLocale) {
            return (LocalizedNumberFormatter)((LocalizedNumberFormatter)((LocalizedNumberFormatter)android.icu.number.NumberFormatter.withLocale((ULocale)currentLocale).grouping(groupingUsed ? NumberFormatter.GroupingStrategy.AUTO : NumberFormatter.GroupingStrategy.OFF)).integerWidth(IntegerWidth.zeroFillTo((int)minIntegerDigits))).precision((Precision)Precision.minMaxFraction((int)minFractionDigits, (int)maxFractionDigits));
        }
    }
}

