/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.core.os.HandlerCompat;
import androidx.wear.protolayout.expression.pipeline.AnimationsHelper;
import androidx.wear.protolayout.expression.pipeline.QuotaManager;
import androidx.wear.protolayout.expression.proto.AnimationParameterProto;
import java.util.concurrent.atomic.AtomicBoolean;

class QuotaAwareAnimator {
    @NonNull
    protected final ValueAnimator mAnimator;
    @NonNull
    protected final QuotaManager mQuotaManager;
    @NonNull
    protected final QuotaReleasingAnimatorListener mListener;
    @NonNull
    protected final Handler mUiHandler;
    private long mStartDelay = 0L;
    protected Runnable mAcquireQuotaAndAnimateRunnable = this::acquireQuotaAndAnimate;
    @Nullable
    protected final TypeEvaluator<?> mEvaluator;

    QuotaAwareAnimator(@NonNull QuotaManager quotaManager, @NonNull AnimationParameterProto.AnimationSpec spec) {
        this(quotaManager, spec, null);
    }

    QuotaAwareAnimator(@NonNull QuotaManager quotaManager, @NonNull AnimationParameterProto.AnimationSpec spec, @Nullable TypeEvaluator<?> evaluator) {
        this(quotaManager, spec, evaluator, false);
    }

    protected QuotaAwareAnimator(@NonNull QuotaManager quotaManager, @NonNull AnimationParameterProto.AnimationSpec spec, @Nullable TypeEvaluator<?> evaluator, boolean alwaysPauseWhenRepeatForward) {
        this.mQuotaManager = quotaManager;
        this.mAnimator = new ValueAnimator();
        this.mUiHandler = new Handler(Looper.getMainLooper());
        AnimationsHelper.applyAnimationSpecToAnimator(this.mAnimator, spec);
        this.mStartDelay = this.mAnimator.getStartDelay();
        this.mAnimator.setStartDelay(0L);
        AnimationsHelper.RepeatDelays repeatDelays = AnimationsHelper.getRepeatDelays(spec);
        this.mListener = new QuotaReleasingAnimatorListener(quotaManager, this.mAnimator.getRepeatMode(), repeatDelays.mForwardRepeatDelay, repeatDelays.mReverseRepeatDelay, () -> ((ValueAnimator)this.mAnimator).resume(), this.mUiHandler, alwaysPauseWhenRepeatForward);
        this.mAnimator.addListener((Animator.AnimatorListener)this.mListener);
        this.mEvaluator = evaluator;
    }

    void addUpdateCallback(@NonNull UpdateCallback updateCallback) {
        this.mAnimator.addUpdateListener(animation -> updateCallback.onUpdate(animation.getAnimatedValue()));
    }

    void setFloatValues(float ... values) {
        QuotaAwareAnimator.setFloatValues(this.mAnimator, this.mEvaluator, values);
    }

    protected static void setFloatValues(ValueAnimator animator, @Nullable TypeEvaluator<?> evaluator, float ... values) {
        animator.cancel();
        boolean needToSetEvaluator = animator.getValues() == null && evaluator != null;
        animator.setFloatValues(values);
        if (needToSetEvaluator) {
            animator.setEvaluator(evaluator);
        }
    }

    void setIntValues(int ... values) {
        QuotaAwareAnimator.setIntValues(this.mAnimator, this.mEvaluator, values);
    }

    protected static void setIntValues(ValueAnimator animator, @Nullable TypeEvaluator<?> evaluator, int ... values) {
        animator.cancel();
        boolean needToSetEvaluator = animator.getValues() == null && evaluator != null;
        animator.setIntValues(values);
        if (needToSetEvaluator) {
            animator.setEvaluator(evaluator);
        }
    }

    @UiThread
    void tryStartAnimation() {
        if (this.isRunning()) {
            return;
        }
        if (this.mStartDelay > 0L) {
            if (!HandlerCompat.hasCallbacks((Handler)this.mUiHandler, (Runnable)this.mAcquireQuotaAndAnimateRunnable)) {
                this.mUiHandler.postDelayed(this.mAcquireQuotaAndAnimateRunnable, this.mStartDelay);
            }
        } else {
            this.acquireQuotaAndAnimate();
        }
    }

    protected void acquireQuotaAndAnimate() {
        if (this.mAnimator.getValues() == null) {
            return;
        }
        if (this.mQuotaManager.tryAcquireQuota(1)) {
            this.mListener.mIsUsingQuota.set(true);
            this.mAnimator.start();
        } else {
            this.mListener.mIsUsingQuota.set(false);
            if (!this.isInfiniteAnimator()) {
                this.mAnimator.end();
            }
        }
    }

    @UiThread
    void tryStartOrResumeInfiniteAnimation() {
        if (!this.isInfiniteAnimator() || this.mAnimator.getValues() == null) {
            return;
        }
        if (this.isPaused()) {
            if (this.mQuotaManager.tryAcquireQuota(1)) {
                this.mListener.mIsUsingQuota.set(true);
                this.mAnimator.resume();
            }
        } else if (!this.isRunning()) {
            this.tryStartAnimation();
        }
    }

    @UiThread
    void stopOrPauseAnimator() {
        if (this.isInfiniteAnimator()) {
            this.mUiHandler.removeCallbacks(this.mAcquireQuotaAndAnimateRunnable);
            this.mUiHandler.removeCallbacks(this.mListener.mResumeRepeatRunnable);
            this.mAnimator.pause();
            if (this.mListener.mIsUsingQuota.compareAndSet(true, false)) {
                this.mQuotaManager.releaseQuota(1);
            }
        } else {
            this.stopAnimator();
        }
    }

    @UiThread
    void stopAnimator() {
        this.mUiHandler.removeCallbacks(this.mAcquireQuotaAndAnimateRunnable);
        if (this.mAnimator.getValues() != null) {
            this.endAnimator();
        }
    }

    protected void endAnimator() {
        this.mAnimator.end();
    }

    protected boolean isInfiniteAnimator() {
        return this.mAnimator.getTotalDuration() == -1L;
    }

    boolean isRunning() {
        return this.mAnimator.isRunning();
    }

    boolean isPaused() {
        return this.mAnimator.isPaused() && !HandlerCompat.hasCallbacks((Handler)this.mUiHandler, (Runnable)this.mListener.mResumeRepeatRunnable);
    }

    protected static final class QuotaReleasingAnimatorListener
    extends AnimatorListenerAdapter {
        @NonNull
        private final QuotaManager mQuotaManager;
        @NonNull
        final AtomicBoolean mIsUsingQuota = new AtomicBoolean(false);
        private final int mRepeatMode;
        private final long mForwardRepeatDelay;
        private final long mReverseRepeatDelay;
        @NonNull
        private final Handler mHandler;
        @NonNull
        Runnable mResumeRepeatRunnable;
        private boolean mIsReverse;
        private final boolean mAlwaysPauseWhenRepeatForward;

        QuotaReleasingAnimatorListener(@NonNull QuotaManager quotaManager, int repeatMode, long forwardRepeatDelay, long reverseRepeatDelay, @NonNull Runnable resumeRepeatRunnable, @NonNull Handler uiHandler, boolean alwaysPauseWhenRepeatForward) {
            this.mQuotaManager = quotaManager;
            this.mRepeatMode = repeatMode;
            this.mForwardRepeatDelay = forwardRepeatDelay;
            this.mReverseRepeatDelay = reverseRepeatDelay;
            this.mResumeRepeatRunnable = resumeRepeatRunnable;
            this.mHandler = uiHandler;
            this.mIsReverse = false;
            this.mAlwaysPauseWhenRepeatForward = alwaysPauseWhenRepeatForward;
        }

        void setResumeRunnable(@NonNull Runnable runnable) {
            this.mResumeRepeatRunnable = runnable;
        }

        @UiThread
        public void onAnimationStart(Animator animation, boolean isReverse) {
            super.onAnimationStart(animation, isReverse);
            this.mIsReverse = isReverse;
        }

        @UiThread
        public void onAnimationEnd(Animator animation) {
            if (this.mIsUsingQuota.compareAndSet(true, false)) {
                this.mQuotaManager.releaseQuota(1);
            }
            this.mHandler.removeCallbacks(this.mResumeRepeatRunnable);
        }

        @UiThread
        public void onAnimationRepeat(Animator animation) {
            this.mIsReverse = this.mRepeatMode == 2 ? !this.mIsReverse : false;
            if ((this.mAlwaysPauseWhenRepeatForward || this.mForwardRepeatDelay > 0L) && !this.mIsReverse) {
                animation.pause();
                this.mHandler.postDelayed(this.mResumeRepeatRunnable, this.mForwardRepeatDelay);
            } else if (this.mReverseRepeatDelay > 0L && this.mIsReverse) {
                animation.pause();
                this.mHandler.postDelayed(this.mResumeRepeatRunnable, this.mReverseRepeatDelay);
            }
        }
    }

    static interface UpdateCallback {
        public void onUpdate(@NonNull Object var1);
    }
}

