/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import android.animation.Animator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.os.HandlerCompat;
import androidx.wear.protolayout.expression.pipeline.AnimationsHelper;
import androidx.wear.protolayout.expression.pipeline.QuotaAwareAnimator;
import androidx.wear.protolayout.expression.pipeline.QuotaManager;
import androidx.wear.protolayout.expression.proto.AnimationParameterProto;

class QuotaAwareAnimatorWithAux
extends QuotaAwareAnimator {
    @NonNull
    private final QuotaAwareAnimator.QuotaReleasingAnimatorListener mAuxListener;
    @NonNull
    private final ValueAnimator mAuxAnimator = new ValueAnimator();
    private boolean mSuppressForwardUpdate = false;
    private boolean mSuppressReverseUpdate = false;
    private final boolean mEndsWithForward;

    QuotaAwareAnimatorWithAux(@NonNull QuotaManager quotaManager, @NonNull AnimationParameterProto.AnimationSpec spec, @NonNull AnimationParameterProto.AnimationSpec auxSpec, @Nullable TypeEvaluator<?> evaluator) {
        super(quotaManager, spec, evaluator, true);
        AnimationsHelper.applyAnimationSpecToAnimator(this.mAuxAnimator, auxSpec);
        AnimationsHelper.RepeatDelays repeatDelays = AnimationsHelper.getRepeatDelays(auxSpec);
        this.mAuxListener = new QuotaAwareAnimator.QuotaReleasingAnimatorListener(quotaManager, this.mAuxAnimator.getRepeatMode(), repeatDelays.mForwardRepeatDelay, repeatDelays.mReverseRepeatDelay, () -> ((ValueAnimator)this.mAnimator).resume(), this.mUiHandler, true);
        this.mAuxAnimator.addListener((Animator.AnimatorListener)this.mAuxListener);
        this.mAcquireQuotaAndAnimateRunnable = this::acquireQuotaAndAnimate;
        this.mListener.setResumeRunnable(() -> ((ValueAnimator)this.mAuxAnimator).resume());
        this.mEndsWithForward = this.mAnimator.getRepeatCount() > this.mAuxAnimator.getRepeatCount();
    }

    @Override
    void addUpdateCallback(@NonNull QuotaAwareAnimator.UpdateCallback updateCallback) {
        this.mAnimator.addUpdateListener(animation -> {
            if (!this.mSuppressForwardUpdate && !this.mAnimator.isPaused()) {
                updateCallback.onUpdate(animation.getAnimatedValue());
            }
        });
        this.mAuxAnimator.addUpdateListener(animation -> {
            if (!this.mSuppressReverseUpdate && !this.mAuxAnimator.isPaused()) {
                updateCallback.onUpdate(animation.getAnimatedValue());
            }
        });
    }

    @Override
    void setFloatValues(float ... values) {
        super.setFloatValues(values);
        for (int i = 0; i < values.length / 2; ++i) {
            float temp = values[i];
            values[i] = values[values.length - 1 - i];
            values[values.length - 1 - i] = temp;
        }
        QuotaAwareAnimatorWithAux.setFloatValues(this.mAuxAnimator, this.mEvaluator, values);
    }

    @Override
    void setIntValues(int ... values) {
        super.setIntValues(values);
        for (int i = 0; i < values.length / 2; ++i) {
            int temp = values[i];
            values[i] = values[values.length - 1 - i];
            values[values.length - 1 - i] = temp;
        }
        QuotaAwareAnimatorWithAux.setIntValues(this.mAuxAnimator, this.mEvaluator, values);
    }

    @Override
    protected void acquireQuotaAndAnimate() {
        super.acquireQuotaAndAnimate();
        if (this.mAnimator.isStarted()) {
            this.mAuxAnimator.start();
        }
    }

    @Override
    void tryStartOrResumeInfiniteAnimation() {
        if (!this.isInfiniteAnimator() || this.mAnimator.getValues() == null) {
            return;
        }
        if (this.isPaused()) {
            if (this.mQuotaManager.tryAcquireQuota(1)) {
                this.mListener.mIsUsingQuota.set(true);
                this.mAnimator.resume();
                this.mAuxAnimator.setCurrentFraction(0.0f);
            }
        } else if (!this.isRunning()) {
            this.tryStartAnimation();
        }
    }

    @Override
    void stopOrPauseAnimator() {
        super.stopOrPauseAnimator();
        if (this.isInfiniteAnimator()) {
            this.mAuxAnimator.pause();
            this.mUiHandler.removeCallbacks(this.mAuxListener.mResumeRepeatRunnable);
        }
    }

    @Override
    protected void endAnimator() {
        this.mSuppressForwardUpdate = !this.mEndsWithForward;
        this.mSuppressReverseUpdate = this.mEndsWithForward;
        this.mAnimator.end();
        this.mAuxAnimator.end();
        this.mSuppressForwardUpdate = false;
        this.mSuppressReverseUpdate = false;
    }

    @Override
    protected boolean isRunning() {
        return super.isRunning() || this.mAuxAnimator.isRunning();
    }

    @Override
    protected boolean isPaused() {
        return super.isPaused() && this.mAuxAnimator.isPaused() && !HandlerCompat.hasCallbacks((Handler)this.mUiHandler, (Runnable)this.mAuxListener.mResumeRepeatRunnable);
    }
}

