/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.collection.ArrayMap;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiverWithPreUpdate;
import androidx.wear.protolayout.expression.pipeline.sensor.SensorGateway;
import androidx.wear.protolayout.expression.proto.DynamicProto;
import java.util.Map;
import java.util.concurrent.Executor;

class SensorGatewayPlatformDataSource {
    private static final String TAG = "SensorGtwPltDataSource";
    final Executor mUiExecutor;
    private final SensorGateway mSensorGateway;
    private final Map<DynamicTypeValueReceiverWithPreUpdate<Integer>, SensorGateway.Consumer> mCallbackToRegisteredSensorConsumer = new ArrayMap();

    SensorGatewayPlatformDataSource(Executor uiExecutor, SensorGateway sensorGateway) {
        this.mUiExecutor = uiExecutor;
        this.mSensorGateway = sensorGateway;
    }

    private static int mapSensorPlatformSource(DynamicProto.PlatformInt32SourceType platformSource) {
        switch (platformSource) {
            case PLATFORM_INT32_SOURCE_TYPE_CURRENT_HEART_RATE: {
                return 0;
            }
            case PLATFORM_INT32_SOURCE_TYPE_DAILY_STEP_COUNT: {
                if (Build.VERSION.SDK_INT >= 29) {
                    return Api29Impl.getSensorDataTypeDailyStepCount();
                }
                return -1;
            }
        }
        throw new IllegalArgumentException("Unknown PlatformSourceType");
    }

    public void registerForData(DynamicProto.PlatformInt32SourceType sourceType, final DynamicTypeValueReceiverWithPreUpdate<Integer> callback) {
        int sensorDataType = SensorGatewayPlatformDataSource.mapSensorPlatformSource(sourceType);
        SensorGateway.Consumer sensorConsumer = new SensorGateway.Consumer(){

            @Override
            public void onPreUpdate() {
                SensorGatewayPlatformDataSource.this.mUiExecutor.execute(callback::onPreUpdate);
            }

            @Override
            public void onData(double value) {
                SensorGatewayPlatformDataSource.this.mUiExecutor.execute(() -> callback.onData((int)value));
            }

            @Override
            public void onInvalidated() {
                SensorGatewayPlatformDataSource.this.mUiExecutor.execute(callback::onInvalidated);
            }
        };
        this.mCallbackToRegisteredSensorConsumer.put(callback, sensorConsumer);
        this.mSensorGateway.registerSensorGatewayConsumer(sensorDataType, sensorConsumer);
    }

    public void unregisterForData(DynamicProto.PlatformInt32SourceType sourceType, DynamicTypeValueReceiverWithPreUpdate<Integer> consumer) {
        int sensorDataType = SensorGatewayPlatformDataSource.mapSensorPlatformSource(sourceType);
        SensorGateway.Consumer sensorConsumer = this.mCallbackToRegisteredSensorConsumer.get(consumer);
        if (sensorConsumer != null) {
            this.mSensorGateway.unregisterSensorGatewayConsumer(sensorDataType, sensorConsumer);
        }
    }

    @RequiresApi(value=29)
    private static class Api29Impl {
        private Api29Impl() {
        }

        @DoNotInline
        static int getSensorDataTypeDailyStepCount() {
            return 1;
        }
    }
}

