/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import androidx.annotation.NonNull;
import androidx.annotation.UiThread;
import androidx.wear.protolayout.expression.pipeline.DynamicDataSourceNode;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiverWithPreUpdate;
import androidx.wear.protolayout.expression.pipeline.StateStore;
import androidx.wear.protolayout.expression.proto.StateEntryProto;
import java.util.function.Function;

class StateSourceNode<T>
implements DynamicDataSourceNode<T>,
DynamicTypeValueReceiverWithPreUpdate<StateEntryProto.StateEntryValue> {
    private final StateStore mStateStore;
    private final String mBindKey;
    private final Function<StateEntryProto.StateEntryValue, T> mStateExtractor;
    private final DynamicTypeValueReceiverWithPreUpdate<T> mDownstream;

    StateSourceNode(StateStore stateStore, String bindKey, Function<StateEntryProto.StateEntryValue, T> stateExtractor, DynamicTypeValueReceiverWithPreUpdate<T> downstream) {
        this.mStateStore = stateStore;
        this.mBindKey = bindKey;
        this.mStateExtractor = stateExtractor;
        this.mDownstream = downstream;
    }

    @Override
    @UiThread
    public void preInit() {
        this.mDownstream.onPreUpdate();
    }

    @Override
    @UiThread
    public void init() {
        this.mStateStore.registerCallback(this.mBindKey, this);
        StateEntryProto.StateEntryValue item = this.mStateStore.getStateEntryValuesProto(this.mBindKey);
        if (item != null) {
            this.onData(item);
        } else {
            this.onInvalidated();
        }
    }

    @Override
    @UiThread
    public void destroy() {
        this.mStateStore.unregisterCallback(this.mBindKey, this);
    }

    @Override
    public void onPreUpdate() {
        this.mDownstream.onPreUpdate();
    }

    @Override
    public void onData(@NonNull StateEntryProto.StateEntryValue newData) {
        T actualValue = this.mStateExtractor.apply(newData);
        this.mDownstream.onData(actualValue);
    }

    @Override
    public void onInvalidated() {
        this.mDownstream.onInvalidated();
    }
}

