/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.collection.ArrayMap;
import androidx.collection.ArraySet;
import androidx.wear.protolayout.expression.StateEntryBuilders;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiverWithPreUpdate;
import androidx.wear.protolayout.expression.proto.StateEntryProto;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StateStore {
    @NonNull
    private final Map<String, StateEntryProto.StateEntryValue> mCurrentState = new ArrayMap();
    @NonNull
    private final Map<String, Set<DynamicTypeValueReceiverWithPreUpdate<StateEntryProto.StateEntryValue>>> mRegisteredCallbacks = new ArrayMap();

    @NonNull
    public static StateStore create(@NonNull Map<String, StateEntryBuilders.StateEntryValue> initialState) {
        return new StateStore(StateStore.toProto(initialState));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public StateStore(@NonNull Map<String, StateEntryProto.StateEntryValue> initialState) {
        this.mCurrentState.putAll(initialState);
    }

    @UiThread
    public void setStateEntryValues(@NonNull Map<String, StateEntryBuilders.StateEntryValue> newState) {
        this.setStateEntryValuesProto(StateStore.toProto(newState));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @UiThread
    public void setStateEntryValuesProto(@NonNull Map<String, StateEntryProto.StateEntryValue> newState) {
        Set<String> removedKeys = this.getRemovedKeys(newState);
        Map<String, StateEntryProto.StateEntryValue> changedEntries = this.getChangedEntries(newState);
        Stream.concat(removedKeys.stream(), changedEntries.keySet().stream()).forEach(key -> {
            for (DynamicTypeValueReceiverWithPreUpdate callback : this.mRegisteredCallbacks.getOrDefault(key, Collections.emptySet())) {
                callback.onPreUpdate();
            }
        });
        this.mCurrentState.clear();
        this.mCurrentState.putAll(newState);
        for (String string : removedKeys) {
            for (DynamicTypeValueReceiverWithPreUpdate callback : this.mRegisteredCallbacks.getOrDefault(string, Collections.emptySet())) {
                callback.onInvalidated();
            }
        }
        for (Map.Entry entry : changedEntries.entrySet()) {
            for (DynamicTypeValueReceiverWithPreUpdate callback : this.mRegisteredCallbacks.getOrDefault(entry.getKey(), Collections.emptySet())) {
                callback.onData((StateEntryProto.StateEntryValue)entry.getValue());
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @UiThread
    @Nullable
    public StateEntryProto.StateEntryValue getStateEntryValuesProto(@NonNull String key) {
        return this.mCurrentState.get(key);
    }

    @UiThread
    void registerCallback(@NonNull String key, @NonNull DynamicTypeValueReceiverWithPreUpdate<StateEntryProto.StateEntryValue> callback) {
        this.mRegisteredCallbacks.computeIfAbsent(key, k -> new ArraySet()).add(callback);
    }

    @UiThread
    void unregisterCallback(@NonNull String key, @NonNull DynamicTypeValueReceiverWithPreUpdate<StateEntryProto.StateEntryValue> callback) {
        Set<DynamicTypeValueReceiverWithPreUpdate<StateEntryProto.StateEntryValue>> callbackSet = this.mRegisteredCallbacks.get(key);
        if (callbackSet != null) {
            callbackSet.remove(callback);
        }
    }

    @NonNull
    private static Map<String, StateEntryProto.StateEntryValue> toProto(@NonNull Map<String, StateEntryBuilders.StateEntryValue> value) {
        return value.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((StateEntryBuilders.StateEntryValue)entry.getValue()).toStateEntryValueProto()));
    }

    @NonNull
    private Set<String> getRemovedKeys(@NonNull Map<String, StateEntryProto.StateEntryValue> newState) {
        ArraySet result = new ArraySet(this.mCurrentState.keySet());
        result.removeAll(newState.keySet());
        return result;
    }

    @NonNull
    private Map<String, StateEntryProto.StateEntryValue> getChangedEntries(@NonNull Map<String, StateEntryProto.StateEntryValue> newState) {
        ArrayMap result = new ArrayMap();
        for (Map.Entry<String, StateEntryProto.StateEntryValue> newEntry : newState.entrySet()) {
            StateEntryProto.StateEntryValue currentEntry = this.mCurrentState.get(newEntry.getKey());
            if (currentEntry != null && currentEntry.equals((Object)newEntry.getValue())) continue;
            result.put(newEntry.getKey(), newEntry.getValue());
        }
        return result;
    }
}

