/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import androidx.annotation.UiThread;
import androidx.wear.protolayout.expression.pipeline.DynamicDataBiTransformNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataSourceNode;
import androidx.wear.protolayout.expression.pipeline.DynamicDataTransformNode;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiverWithPreUpdate;
import androidx.wear.protolayout.expression.pipeline.NumberFormatter;
import androidx.wear.protolayout.expression.pipeline.StateSourceNode;
import androidx.wear.protolayout.expression.pipeline.StateStore;
import androidx.wear.protolayout.expression.proto.DynamicProto;
import androidx.wear.protolayout.expression.proto.FixedProto;

class StringNodes {
    static final int MAXIMUM_STRING_LENGTH = 200;

    private StringNodes() {
    }

    static String truncate(String input) {
        return input.substring(0, Math.min(input.length(), 200));
    }

    static class StateStringNode
    extends StateSourceNode<String> {
        StateStringNode(StateStore stateStore, DynamicProto.StateStringSource protoNode, DynamicTypeValueReceiverWithPreUpdate<String> downstream) {
            super(stateStore, protoNode.getSourceKey(), se -> StringNodes.truncate(se.getStringVal().getValue()), downstream);
        }
    }

    static class FloatFormatNode
    extends DynamicDataTransformNode<Float, String> {
        FloatFormatNode(NumberFormatter formatter, DynamicTypeValueReceiverWithPreUpdate<String> downstream) {
            super(downstream, (I value) -> StringNodes.truncate(formatter.format(value.floatValue())));
        }
    }

    static class StringConcatOpNode
    extends DynamicDataBiTransformNode<String, String, String> {
        StringConcatOpNode(DynamicTypeValueReceiverWithPreUpdate<String> downstream) {
            super(downstream, (lhs, rhs) -> {
                int lhsLength = lhs.length();
                int rhsLength = rhs.length();
                if (lhsLength >= 200) {
                    return StringNodes.truncate(lhs);
                }
                return lhs.concat(rhs.substring(0, Math.min(rhsLength, 200 - lhsLength)));
            });
        }
    }

    static class Int32FormatNode
    extends DynamicDataTransformNode<Integer, String> {
        Int32FormatNode(NumberFormatter formatter, DynamicTypeValueReceiverWithPreUpdate<String> downstream) {
            super(downstream, (I value) -> StringNodes.truncate(formatter.format((int)value)));
        }
    }

    static class FixedStringNode
    implements DynamicDataSourceNode<String> {
        private final String mValue;
        private final DynamicTypeValueReceiverWithPreUpdate<String> mDownstream;

        FixedStringNode(FixedProto.FixedString protoNode, DynamicTypeValueReceiverWithPreUpdate<String> downstream) {
            this.mValue = StringNodes.truncate(protoNode.getValue());
            this.mDownstream = downstream;
        }

        @Override
        @UiThread
        public void preInit() {
            this.mDownstream.onPreUpdate();
        }

        @Override
        @UiThread
        public void init() {
            this.mDownstream.onData(this.mValue);
        }

        @Override
        @UiThread
        public void destroy() {
        }
    }
}

