/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline;

import android.os.Handler;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.collection.ArrayMap;
import androidx.wear.protolayout.expression.pipeline.TimeGateway;
import java.util.Map;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class TimeGatewayImpl
implements TimeGateway,
AutoCloseable {
    private final Handler uiHandler;
    private final Map<TimeGateway.TimeCallback, Executor> registeredCallbacks = new ArrayMap();
    private boolean updatesEnabled = false;
    private final Runnable onTick;
    private long lastScheduleTimeMillis = 0L;

    public TimeGatewayImpl(@NonNull Handler uiHandler) {
        this.uiHandler = uiHandler;
        this.onTick = this::notifyNextSecond;
    }

    @Override
    public void registerForUpdates(@NonNull Executor executor, @NonNull TimeGateway.TimeCallback callback) {
        this.registeredCallbacks.put(callback, executor);
        if (this.registeredCallbacks.size() == 1 && this.updatesEnabled) {
            this.lastScheduleTimeMillis = SystemClock.uptimeMillis() + 1000L;
            this.uiHandler.postAtTime(this.onTick, (Object)this, this.lastScheduleTimeMillis);
        }
        if (this.updatesEnabled) {
            callback.onPreUpdate();
            callback.onData();
        }
    }

    @Override
    public void unregisterForUpdates(@NonNull TimeGateway.TimeCallback callback) {
        this.registeredCallbacks.remove(callback);
        if (this.registeredCallbacks.isEmpty() && this.updatesEnabled) {
            this.uiHandler.removeCallbacks(this.onTick, (Object)this);
        }
    }

    @UiThread
    public void enableUpdates() {
        this.setUpdatesEnabled(true);
    }

    @UiThread
    public void disableUpdates() {
        this.setUpdatesEnabled(false);
    }

    private void setUpdatesEnabled(boolean updatesEnabled) {
        if (updatesEnabled == this.updatesEnabled) {
            return;
        }
        this.updatesEnabled = updatesEnabled;
        if (!updatesEnabled) {
            this.uiHandler.removeCallbacks(this.onTick, (Object)this);
        } else if (!this.registeredCallbacks.isEmpty()) {
            this.lastScheduleTimeMillis = SystemClock.uptimeMillis() + 1000L;
            this.uiHandler.postAtTime(this.onTick, (Object)this, this.lastScheduleTimeMillis);
        }
    }

    private void notifyNextSecond() {
        if (!this.updatesEnabled) {
            return;
        }
        for (Map.Entry<TimeGateway.TimeCallback, Executor> callback : this.registeredCallbacks.entrySet()) {
            callback.getValue().execute(callback.getKey()::onPreUpdate);
        }
        for (Map.Entry<TimeGateway.TimeCallback, Executor> callback : this.registeredCallbacks.entrySet()) {
            callback.getValue().execute(callback.getKey()::onData);
        }
        this.lastScheduleTimeMillis += 1000L;
        if (this.lastScheduleTimeMillis < SystemClock.uptimeMillis()) {
            long missedTime = SystemClock.uptimeMillis() - this.lastScheduleTimeMillis;
            missedTime = (missedTime / 1000L + 1L) * 1000L;
            this.lastScheduleTimeMillis += missedTime;
        }
        this.uiHandler.postAtTime(this.onTick, (Object)this, this.lastScheduleTimeMillis);
    }

    @Override
    public void close() {
        this.setUpdatesEnabled(false);
        this.registeredCallbacks.clear();
    }
}

