/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.expression.pipeline.sensor;

import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RequiresPermission;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import java.io.Closeable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

public interface SensorGateway
extends Closeable {
    public static final int SENSOR_DATA_TYPE_INVALID = -1;
    @RequiresPermission(value="android.permission.BODY_SENSORS")
    public static final int SENSOR_DATA_TYPE_HEART_RATE = 0;
    @RequiresApi(value=29)
    @RequiresPermission(value="android.permission.ACTIVITY_RECOGNITION")
    public static final int SENSOR_DATA_TYPE_DAILY_STEP_COUNT = 1;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public void enableUpdates();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public void disableUpdates();

    @UiThread
    public void registerSensorGatewayConsumer(int var1, @NonNull Consumer var2);

    @UiThread
    public void registerSensorGatewayConsumer(int var1, @NonNull Executor var2, @NonNull Consumer var3);

    @UiThread
    public void unregisterSensorGatewayConsumer(int var1, @NonNull Consumer var2);

    @Override
    public void close();

    public static interface Consumer {
        @AnyThread
        default public void onPreUpdate() {
        }

        @AnyThread
        public void onData(double var1);

        @AnyThread
        default public void onInvalidated() {
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=29)
    public static @interface SensorDataType {
    }
}

