/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.material;

import android.content.Context;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.wear.protolayout.ColorBuilders;
import androidx.wear.protolayout.DeviceParametersBuilders;
import androidx.wear.protolayout.DimensionBuilders;
import androidx.wear.protolayout.LayoutElementBuilders;
import androidx.wear.protolayout.ModifiersBuilders;
import androidx.wear.protolayout.TypeBuilders;
import androidx.wear.protolayout.expression.Fingerprint;
import androidx.wear.protolayout.material.ChipColors;
import androidx.wear.protolayout.material.ChipDefaults;
import androidx.wear.protolayout.material.Helper;
import androidx.wear.protolayout.material.Text;
import androidx.wear.protolayout.proto.LayoutElementProto;
import java.util.HashMap;
import java.util.Map;

public class Chip
implements LayoutElementBuilders.LayoutElement {
    static final String METADATA_TAG_TEXT = "TXTCHP";
    static final String METADATA_TAG_ICON = "ICNCHP";
    static final String METADATA_TAG_CUSTOM_CONTENT = "CSTCHP";
    @NonNull
    private final LayoutElementBuilders.Box mElement;

    Chip(@NonNull LayoutElementBuilders.Box element) {
        this.mElement = element;
    }

    @NonNull
    public DimensionBuilders.ContainerDimension getHeight() {
        return Helper.checkNotNull(this.mElement.getHeight());
    }

    @NonNull
    public DimensionBuilders.ContainerDimension getWidth() {
        return Helper.checkNotNull(this.mElement.getWidth());
    }

    @NonNull
    public ModifiersBuilders.Clickable getClickable() {
        return Helper.checkNotNull(Helper.checkNotNull(this.mElement.getModifiers()).getClickable());
    }

    @NonNull
    private ColorBuilders.ColorProp getBackgroundColor() {
        return Helper.checkNotNull(Helper.checkNotNull(Helper.checkNotNull(this.mElement.getModifiers()).getBackground()).getColor());
    }

    @NonNull
    public ChipColors getChipColors() {
        ColorBuilders.ColorProp backgroundColor = this.getBackgroundColor();
        ColorBuilders.ColorProp contentColor = null;
        ColorBuilders.ColorProp secondaryContentColor = null;
        ColorBuilders.ColorProp iconTintColor = null;
        if (!this.getMetadataTag().equals(METADATA_TAG_CUSTOM_CONTENT)) {
            if (this.getMetadataTag().equals(METADATA_TAG_ICON)) {
                LayoutElementBuilders.Image icon = Helper.checkNotNull(this.getIconContentObject());
                iconTintColor = Helper.checkNotNull(Helper.checkNotNull(icon.getColorFilter()).getTint());
            }
            contentColor = Helper.checkNotNull(this.getPrimaryLabelContentObject()).getColor();
            Text label = this.getSecondaryLabelContentObject();
            if (label != null) {
                secondaryContentColor = label.getColor();
            }
        }
        if (contentColor == null) {
            contentColor = new ColorBuilders.ColorProp.Builder(0).build();
        }
        if (secondaryContentColor == null) {
            secondaryContentColor = contentColor;
        }
        if (iconTintColor == null) {
            iconTintColor = contentColor;
        }
        return new ChipColors(backgroundColor, iconTintColor, contentColor, secondaryContentColor);
    }

    @Nullable
    public TypeBuilders.StringProp getContentDescription() {
        ModifiersBuilders.Semantics semantics = Helper.checkNotNull(this.mElement.getModifiers()).getSemantics();
        if (semantics == null) {
            return null;
        }
        return semantics.getContentDescription();
    }

    @Nullable
    public LayoutElementBuilders.LayoutElement getCustomContent() {
        if (this.getMetadataTag().equals(METADATA_TAG_CUSTOM_CONTENT)) {
            return Helper.checkNotNull((LayoutElementBuilders.LayoutElement)Helper.checkNotNull(this.mElement.getContents()).get(0));
        }
        return null;
    }

    @Nullable
    public String getPrimaryLabelContent() {
        Text primaryLabel = this.getPrimaryLabelContentObject();
        return primaryLabel != null ? primaryLabel.getText() : null;
    }

    @Nullable
    public String getSecondaryLabelContent() {
        Text label = this.getSecondaryLabelContentObject();
        return label != null ? label.getText() : null;
    }

    @Nullable
    public String getIconContent() {
        LayoutElementBuilders.Image icon = this.getIconContentObject();
        return icon != null ? Helper.checkNotNull(icon.getResourceId()).getValue() : null;
    }

    @Nullable
    private Text getPrimaryLabelContentObject() {
        return this.getPrimaryOrSecondaryLabelContent(0);
    }

    @Nullable
    private Text getSecondaryLabelContentObject() {
        return this.getPrimaryOrSecondaryLabelContent(1);
    }

    @Nullable
    private LayoutElementBuilders.Image getIconContentObject() {
        if (!this.getMetadataTag().equals(METADATA_TAG_ICON)) {
            return null;
        }
        return (LayoutElementBuilders.Image)((LayoutElementBuilders.Row)this.mElement.getContents().get(0)).getContents().get(0);
    }

    @Nullable
    private Text getPrimaryOrSecondaryLabelContent(int index) {
        String metadataTag = this.getMetadataTag();
        if (metadataTag.equals(METADATA_TAG_CUSTOM_CONTENT)) {
            return null;
        }
        LayoutElementBuilders.Column content = metadataTag.equals(METADATA_TAG_ICON) ? (LayoutElementBuilders.Column)((LayoutElementBuilders.Box)((LayoutElementBuilders.Row)this.mElement.getContents().get(0)).getContents().get(2)).getContents().get(0) : (LayoutElementBuilders.Column)((LayoutElementBuilders.Box)this.mElement.getContents().get(0)).getContents().get(0);
        return index < content.getContents().size() ? Text.fromLayoutElement((LayoutElementBuilders.LayoutElement)((LayoutElementBuilders.Box)content.getContents().get(index)).getContents().get(0)) : null;
    }

    public int getHorizontalAlignment() {
        return Helper.checkNotNull(this.mElement.getHorizontalAlignment()).getValue();
    }

    @NonNull
    String getMetadataTag() {
        return Helper.getMetadataTagName(Helper.checkNotNull(Helper.checkNotNull(this.mElement.getModifiers()).getMetadata()));
    }

    @Nullable
    public static Chip fromLayoutElement(@NonNull LayoutElementBuilders.LayoutElement element) {
        if (element instanceof Chip) {
            return (Chip)element;
        }
        if (!(element instanceof LayoutElementBuilders.Box)) {
            return null;
        }
        LayoutElementBuilders.Box boxElement = (LayoutElementBuilders.Box)element;
        if (!Helper.checkTag(boxElement.getModifiers(), Builder.TYPE_TO_TAG.values())) {
            return null;
        }
        return new Chip(boxElement);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public LayoutElementProto.LayoutElement toLayoutElementProto() {
        return this.mElement.toLayoutElementProto();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Fingerprint getFingerprint() {
        return this.mElement.getFingerprint();
    }

    public static final class Builder
    implements LayoutElementBuilders.LayoutElement.Builder {
        private static final int NOT_SET = 0;
        private static final int TEXT = 1;
        private static final int ICON = 2;
        private static final int CUSTOM_CONTENT = 3;
        @NonNull
        private final Context mContext;
        @Nullable
        private LayoutElementBuilders.LayoutElement mCustomContent;
        @Nullable
        private String mImageResourceId = null;
        @Nullable
        private String mPrimaryLabel = null;
        @Nullable
        private String mSecondaryLabel = null;
        @NonNull
        private final ModifiersBuilders.Clickable mClickable;
        @Nullable
        private TypeBuilders.StringProp mContentDescription = null;
        @NonNull
        private DimensionBuilders.ContainerDimension mWidth;
        @NonNull
        private DimensionBuilders.DpProp mHeight = ChipDefaults.DEFAULT_HEIGHT;
        @NonNull
        private ChipColors mChipColors = ChipDefaults.PRIMARY_COLORS;
        private int mHorizontalAlign = 0;
        private int mPrimaryLabelTypography;
        @NonNull
        private DimensionBuilders.DpProp mHorizontalPadding = ChipDefaults.HORIZONTAL_PADDING;
        private boolean mIsScalable = true;
        private int mMaxLines = 0;
        @NonNull
        private String mMetadataTag = "";
        @NonNull
        static final Map<Integer, String> TYPE_TO_TAG = new HashMap<Integer, String>();

        public Builder(@NonNull Context context, @NonNull ModifiersBuilders.Clickable clickable, @NonNull DeviceParametersBuilders.DeviceParameters deviceParameters) {
            this.mContext = context;
            this.mClickable = clickable;
            this.mWidth = DimensionBuilders.dp((float)(89.6f * (float)deviceParameters.getScreenWidthDp() / 100.0f));
            this.mPrimaryLabelTypography = 9;
        }

        @NonNull
        public Builder setWidth(@NonNull DimensionBuilders.ContainerDimension width) {
            this.mWidth = width;
            return this;
        }

        @NonNull
        public Builder setWidth(@Dimension(unit=0) float width) {
            this.mWidth = DimensionBuilders.dp((float)width);
            return this;
        }

        @NonNull
        public Builder setCustomContent(@NonNull LayoutElementBuilders.LayoutElement content) {
            this.mCustomContent = content;
            this.mPrimaryLabel = "";
            this.mSecondaryLabel = "";
            this.mImageResourceId = "";
            return this;
        }

        @NonNull
        public Builder setContentDescription(@NonNull CharSequence contentDescription) {
            this.mContentDescription = new TypeBuilders.StringProp.Builder(contentDescription.toString()).build();
            return this;
        }

        @NonNull
        public Builder setContentDescription(@NonNull TypeBuilders.StringProp contentDescription) {
            this.mContentDescription = contentDescription;
            return this;
        }

        @NonNull
        public Builder setPrimaryLabelContent(@NonNull String primaryLabel) {
            this.mPrimaryLabel = primaryLabel;
            this.mCustomContent = null;
            return this;
        }

        @NonNull
        Builder setPrimaryLabelTypography(int typography) {
            this.mPrimaryLabelTypography = typography;
            return this;
        }

        @NonNull
        Builder setIsPrimaryLabelScalable(boolean isScalable) {
            this.mIsScalable = isScalable;
            return this;
        }

        @NonNull
        public Builder setSecondaryLabelContent(@NonNull String secondaryLabel) {
            this.mSecondaryLabel = secondaryLabel;
            this.mCustomContent = null;
            return this;
        }

        @NonNull
        public Builder setIconContent(@NonNull String imageResourceId) {
            this.mImageResourceId = imageResourceId;
            this.mCustomContent = null;
            return this;
        }

        @NonNull
        public Builder setChipColors(@NonNull ChipColors chipColors) {
            this.mChipColors = chipColors;
            return this;
        }

        @NonNull
        public Builder setHorizontalAlignment(int horizontalAlignment) {
            this.mHorizontalAlign = horizontalAlignment;
            return this;
        }

        @NonNull
        Builder setHorizontalPadding(@NonNull DimensionBuilders.DpProp horizontalPadding) {
            this.mHorizontalPadding = horizontalPadding;
            return this;
        }

        @NonNull
        Builder setHeight(@NonNull DimensionBuilders.DpProp height) {
            this.mHeight = height;
            return this;
        }

        @NonNull
        Builder setMaxLines(int maxLines) {
            this.mMaxLines = maxLines;
            return this;
        }

        @NonNull
        Builder setMetadataTag(@NonNull String metadataTag) {
            this.mMetadataTag = metadataTag;
            return this;
        }

        @NonNull
        public Chip build() {
            ModifiersBuilders.Modifiers.Builder modifiers = new ModifiersBuilders.Modifiers.Builder().setClickable(this.mClickable).setPadding(new ModifiersBuilders.Padding.Builder().setStart(this.mHorizontalPadding).setEnd(this.mHorizontalPadding).build()).setBackground(new ModifiersBuilders.Background.Builder().setColor(this.mChipColors.getBackgroundColor()).setCorner(new ModifiersBuilders.Corner.Builder().setRadius(Helper.radiusOf(this.mHeight)).build()).build()).setMetadata(new ModifiersBuilders.ElementMetadata.Builder().setTagData(Helper.getTagBytes(this.getCorrectMetadataTag())).build()).setSemantics(new ModifiersBuilders.Semantics.Builder().setContentDescription(this.getCorrectContentDescription()).build());
            LayoutElementBuilders.Box.Builder element = new LayoutElementBuilders.Box.Builder().setWidth(this.mWidth).setHeight((DimensionBuilders.ContainerDimension)this.mHeight).setHorizontalAlignment(this.getCorrectHorizontalAlignment()).addContent(this.getCorrectContent()).setModifiers(modifiers.build());
            return new Chip(element.build());
        }

        @NonNull
        private TypeBuilders.StringProp getCorrectContentDescription() {
            if (this.mContentDescription == null) {
                String staticValue = "";
                if (this.mPrimaryLabel != null) {
                    staticValue = staticValue + this.mPrimaryLabel;
                }
                if (this.mSecondaryLabel != null) {
                    staticValue = staticValue + "\n" + this.mSecondaryLabel;
                }
                if (!staticValue.isEmpty()) {
                    this.mContentDescription = new TypeBuilders.StringProp.Builder(staticValue).build();
                }
            }
            return Helper.checkNotNull(this.mContentDescription);
        }

        private int getCorrectHorizontalAlignment() {
            if (this.mHorizontalAlign != 0) {
                return this.mHorizontalAlign;
            }
            if (this.mPrimaryLabel != null && this.mSecondaryLabel == null && this.mImageResourceId == null) {
                return 2;
            }
            return 4;
        }

        private String getCorrectMetadataTag() {
            if (!this.mMetadataTag.isEmpty()) {
                return this.mMetadataTag;
            }
            if (this.mCustomContent != null) {
                return Chip.METADATA_TAG_CUSTOM_CONTENT;
            }
            if (this.mImageResourceId != null) {
                return Chip.METADATA_TAG_ICON;
            }
            return Chip.METADATA_TAG_TEXT;
        }

        @NonNull
        private LayoutElementBuilders.LayoutElement getCorrectContent() {
            if (this.mCustomContent != null) {
                return this.mCustomContent;
            }
            Text mainTextElement = new Text.Builder(this.mContext, Helper.checkNotNull(this.mPrimaryLabel)).setTypography(this.mPrimaryLabelTypography).setColor(this.mChipColors.getContentColor()).setMaxLines(this.getCorrectMaxLines()).setOverflow(2).setMultilineAlignment(1).setIsScalable(this.mIsScalable).build();
            LayoutElementBuilders.Column.Builder column = new LayoutElementBuilders.Column.Builder().setHorizontalAlignment(4).addContent((LayoutElementBuilders.LayoutElement)this.putLayoutInBox(mainTextElement).build());
            if (this.mSecondaryLabel != null) {
                Text labelTextElement = new Text.Builder(this.mContext, this.mSecondaryLabel).setTypography(11).setColor(this.mChipColors.getSecondaryContentColor()).setMaxLines(1).setOverflow(2).setMultilineAlignment(1).build();
                column.addContent((LayoutElementBuilders.LayoutElement)this.putLayoutInBox(labelTextElement).build());
            }
            LayoutElementBuilders.Box texts = this.putLayoutInBox((LayoutElementBuilders.LayoutElement)column.build()).build();
            if (this.mImageResourceId == null) {
                return texts;
            }
            return new LayoutElementBuilders.Row.Builder().addContent((LayoutElementBuilders.LayoutElement)new LayoutElementBuilders.Image.Builder().setResourceId(this.mImageResourceId).setWidth((DimensionBuilders.ImageDimension)ChipDefaults.ICON_SIZE).setHeight((DimensionBuilders.ImageDimension)ChipDefaults.ICON_SIZE).setColorFilter(new LayoutElementBuilders.ColorFilter.Builder().setTint(this.mChipColors.getIconColor()).build()).build()).addContent((LayoutElementBuilders.LayoutElement)new LayoutElementBuilders.Spacer.Builder().setHeight((DimensionBuilders.SpacerDimension)this.mHeight).setWidth((DimensionBuilders.SpacerDimension)ChipDefaults.ICON_SPACER_WIDTH).build()).addContent((LayoutElementBuilders.LayoutElement)texts).setVerticalAlignment(2).build();
        }

        private int getCorrectMaxLines() {
            if (this.mMaxLines > 0) {
                return this.mMaxLines;
            }
            return this.mSecondaryLabel != null ? 1 : 2;
        }

        private LayoutElementBuilders.Box.Builder putLayoutInBox(@NonNull LayoutElementBuilders.LayoutElement element) {
            return new LayoutElementBuilders.Box.Builder().addContent(element);
        }

        static {
            TYPE_TO_TAG.put(2, Chip.METADATA_TAG_ICON);
            TYPE_TO_TAG.put(1, Chip.METADATA_TAG_TEXT);
            TYPE_TO_TAG.put(3, Chip.METADATA_TAG_CUSTOM_CONTENT);
        }
    }
}

