/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.material;

import androidx.annotation.Dimension;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.wear.protolayout.DimensionBuilders;
import androidx.wear.protolayout.LayoutElementBuilders;
import androidx.wear.protolayout.ModifiersBuilders;
import androidx.wear.protolayout.TypeBuilders;
import androidx.wear.protolayout.expression.Fingerprint;
import androidx.wear.protolayout.material.Helper;
import androidx.wear.protolayout.material.ProgressIndicatorColors;
import androidx.wear.protolayout.material.ProgressIndicatorDefaults;
import androidx.wear.protolayout.proto.LayoutElementProto;

public class CircularProgressIndicator
implements LayoutElementBuilders.LayoutElement {
    static final String METADATA_TAG = "CPI";
    @NonNull
    private final LayoutElementBuilders.Arc mElement;
    @NonNull
    private final LayoutElementBuilders.ArcLine mProgress;
    @NonNull
    private final LayoutElementBuilders.ArcLine mBackground;

    CircularProgressIndicator(@NonNull LayoutElementBuilders.Arc element) {
        this.mElement = element;
        this.mBackground = (LayoutElementBuilders.ArcLine)element.getContents().get(0);
        this.mProgress = (LayoutElementBuilders.ArcLine)element.getContents().get(2);
    }

    @NonNull
    public DimensionBuilders.DegreesProp getProgress() {
        return Helper.checkNotNull(this.mProgress.getLength());
    }

    @NonNull
    public DimensionBuilders.DpProp getStrokeWidth() {
        return Helper.checkNotNull(this.mProgress.getThickness());
    }

    @NonNull
    public DimensionBuilders.DegreesProp getStartAngle() {
        return Helper.checkNotNull(this.mElement.getAnchorAngle());
    }

    @NonNull
    public DimensionBuilders.DegreesProp getEndAngle() {
        float backArcLength = Helper.checkNotNull(this.mBackground.getLength()).getValue();
        return DimensionBuilders.degrees((float)(this.getStartAngle().getValue() + backArcLength));
    }

    @NonNull
    public ProgressIndicatorColors getCircularProgressIndicatorColors() {
        return new ProgressIndicatorColors(Helper.checkNotNull(this.mProgress.getColor()), Helper.checkNotNull(this.mBackground.getColor()));
    }

    @Nullable
    public TypeBuilders.StringProp getContentDescription() {
        ModifiersBuilders.Semantics semantics = Helper.checkNotNull(this.mElement.getModifiers()).getSemantics();
        if (semantics == null) {
            return null;
        }
        return semantics.getContentDescription();
    }

    @NonNull
    String getMetadataTag() {
        return Helper.getMetadataTagName(Helper.checkNotNull(Helper.checkNotNull(this.mElement.getModifiers()).getMetadata()));
    }

    @Nullable
    public static CircularProgressIndicator fromLayoutElement(@NonNull LayoutElementBuilders.LayoutElement element) {
        if (element instanceof CircularProgressIndicator) {
            return (CircularProgressIndicator)element;
        }
        if (!(element instanceof LayoutElementBuilders.Arc)) {
            return null;
        }
        LayoutElementBuilders.Arc arcElement = (LayoutElementBuilders.Arc)element;
        if (!Helper.checkTag(arcElement.getModifiers(), METADATA_TAG)) {
            return null;
        }
        return new CircularProgressIndicator(arcElement);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public LayoutElementProto.LayoutElement toLayoutElementProto() {
        return this.mElement.toLayoutElementProto();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Fingerprint getFingerprint() {
        return this.mElement.getFingerprint();
    }

    public static final class Builder
    implements LayoutElementBuilders.LayoutElement.Builder {
        @NonNull
        private ProgressIndicatorColors mCircularProgressIndicatorColors = ProgressIndicatorDefaults.DEFAULT_COLORS;
        @NonNull
        private DimensionBuilders.DpProp mStrokeWidth = ProgressIndicatorDefaults.DEFAULT_STROKE_WIDTH;
        @Nullable
        private TypeBuilders.StringProp mContentDescription;
        @NonNull
        private DimensionBuilders.DegreesProp mStartAngle = DimensionBuilders.degrees((float)0.0f);
        @NonNull
        private DimensionBuilders.DegreesProp mEndAngle = DimensionBuilders.degrees((float)360.0f);
        @FloatRange(from=0.0, to=1.0)
        private float mProgress = 0.0f;

        @NonNull
        public Builder setProgress(@FloatRange(from=0.0, to=1.0) float progressPercentage) {
            this.mProgress = progressPercentage;
            return this;
        }

        @NonNull
        public Builder setStartAngle(float startAngle) {
            this.mStartAngle = DimensionBuilders.degrees((float)startAngle);
            return this;
        }

        @NonNull
        public Builder setEndAngle(float endAngle) {
            this.mEndAngle = DimensionBuilders.degrees((float)endAngle);
            return this;
        }

        @NonNull
        public Builder setContentDescription(@NonNull CharSequence contentDescription) {
            this.mContentDescription = new TypeBuilders.StringProp.Builder(contentDescription.toString()).build();
            return this;
        }

        @NonNull
        public Builder setContentDescription(@NonNull TypeBuilders.StringProp contentDescription) {
            this.mContentDescription = contentDescription;
            return this;
        }

        @NonNull
        public Builder setCircularProgressIndicatorColors(@NonNull ProgressIndicatorColors circularProgressIndicatorColors) {
            this.mCircularProgressIndicatorColors = circularProgressIndicatorColors;
            return this;
        }

        @NonNull
        public Builder setStrokeWidth(@NonNull DimensionBuilders.DpProp strokeWidth) {
            this.mStrokeWidth = strokeWidth;
            return this;
        }

        @NonNull
        public Builder setStrokeWidth(@Dimension(unit=0) float strokeWidth) {
            this.mStrokeWidth = DimensionBuilders.dp((float)strokeWidth);
            return this;
        }

        @NonNull
        public CircularProgressIndicator build() {
            this.checkAngles();
            DimensionBuilders.DegreesProp length = this.getLength();
            ModifiersBuilders.Modifiers.Builder modifiers = new ModifiersBuilders.Modifiers.Builder().setPadding(new ModifiersBuilders.Padding.Builder().setAll(ProgressIndicatorDefaults.DEFAULT_PADDING).build()).setMetadata(new ModifiersBuilders.ElementMetadata.Builder().setTagData(Helper.getTagBytes(CircularProgressIndicator.METADATA_TAG)).build());
            if (this.mContentDescription != null) {
                modifiers.setSemantics(new ModifiersBuilders.Semantics.Builder().setContentDescription(this.mContentDescription).build());
            }
            LayoutElementBuilders.Arc.Builder element = new LayoutElementBuilders.Arc.Builder().setAnchorType(1).setAnchorAngle(this.mStartAngle).setModifiers(modifiers.build()).addContent((LayoutElementBuilders.ArcLayoutElement)new LayoutElementBuilders.ArcLine.Builder().setColor(this.mCircularProgressIndicatorColors.getTrackColor()).setThickness(this.mStrokeWidth).setLength(length).build()).addContent((LayoutElementBuilders.ArcLayoutElement)new LayoutElementBuilders.ArcSpacer.Builder().setLength(DimensionBuilders.degrees((float)(360.0f - length.getValue()))).build()).addContent((LayoutElementBuilders.ArcLayoutElement)new LayoutElementBuilders.ArcLine.Builder().setColor(this.mCircularProgressIndicatorColors.getIndicatorColor()).setThickness(this.mStrokeWidth).setLength(DimensionBuilders.degrees((float)(this.mProgress * length.getValue()))).build());
            return new CircularProgressIndicator(element.build());
        }

        private void checkAngles() {
            if (this.mEndAngle.getValue() < this.mStartAngle.getValue()) {
                throw new IllegalArgumentException("End angle must be bigger than start angle.");
            }
        }

        @NonNull
        private DimensionBuilders.DegreesProp getLength() {
            float startAngle = this.mStartAngle.getValue();
            float endAngle = this.mEndAngle.getValue();
            if (endAngle <= startAngle) {
                endAngle += 360.0f;
            }
            return DimensionBuilders.degrees((float)(endAngle - startAngle));
        }
    }
}

