/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.material;

import android.annotation.SuppressLint;
import android.content.Context;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.wear.protolayout.ColorBuilders;
import androidx.wear.protolayout.LayoutElementBuilders;
import androidx.wear.protolayout.ModifiersBuilders;
import androidx.wear.protolayout.expression.Fingerprint;
import androidx.wear.protolayout.expression.ProtoLayoutExperimental;
import androidx.wear.protolayout.material.Colors;
import androidx.wear.protolayout.material.Helper;
import androidx.wear.protolayout.material.Typography;
import androidx.wear.protolayout.proto.LayoutElementProto;

public class Text
implements LayoutElementBuilders.LayoutElement {
    @NonNull
    private final LayoutElementBuilders.Text mText;

    Text(@NonNull LayoutElementBuilders.Text mText) {
        this.mText = mText;
    }

    @NonNull
    public String getText() {
        return Helper.checkNotNull(Helper.checkNotNull(this.mText.getText()).getValue());
    }

    @NonNull
    public ColorBuilders.ColorProp getColor() {
        return Helper.checkNotNull(Helper.checkNotNull(this.mText.getFontStyle()).getColor());
    }

    @NonNull
    public LayoutElementBuilders.FontStyle getFontStyle() {
        return Helper.checkNotNull(this.mText.getFontStyle());
    }

    public float getLineHeight() {
        return Helper.checkNotNull(this.mText.getLineHeight()).getValue();
    }

    public int getMaxLines() {
        return Helper.checkNotNull(this.mText.getMaxLines()).getValue();
    }

    public int getMultilineAlignment() {
        return Helper.checkNotNull(this.mText.getMultilineAlignment()).getValue();
    }

    @NonNull
    public ModifiersBuilders.Modifiers getModifiers() {
        return Helper.checkNotNull(this.mText.getModifiers());
    }

    public int getOverflow() {
        return Helper.checkNotNull(this.mText.getOverflow()).getValue();
    }

    public int getWeight() {
        return Helper.checkNotNull(Helper.checkNotNull(this.mText.getFontStyle()).getWeight()).getValue();
    }

    public boolean isItalic() {
        return Helper.checkNotNull(Helper.checkNotNull(this.mText.getFontStyle()).getItalic()).getValue();
    }

    public boolean isUnderline() {
        return Helper.checkNotNull(Helper.checkNotNull(this.mText.getFontStyle()).getUnderline()).getValue();
    }

    @ProtoLayoutExperimental
    public boolean getExcludeFontPadding() {
        return Helper.checkNotNull(this.mText.getAndroidTextStyle()).getExcludeFontPadding();
    }

    @Nullable
    public static Text fromLayoutElement(@NonNull LayoutElementBuilders.LayoutElement element) {
        if (element instanceof Text) {
            return (Text)element;
        }
        if (!(element instanceof LayoutElementBuilders.Text)) {
            return null;
        }
        LayoutElementBuilders.Text textElement = (LayoutElementBuilders.Text)element;
        return new Text(textElement);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public LayoutElementProto.LayoutElement toLayoutElementProto() {
        return this.mText.toLayoutElementProto();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Fingerprint getFingerprint() {
        return this.mText.getFingerprint();
    }

    public static final class Builder
    implements LayoutElementBuilders.LayoutElement.Builder {
        @NonNull
        private final Context mContext;
        @NonNull
        private ColorBuilders.ColorProp mColor = ColorBuilders.argb((int)Colors.DEFAULT.getOnPrimary());
        private int mTypographyName = 1;
        private boolean mItalic = false;
        private boolean mUnderline = false;
        private boolean mIsScalable = true;
        @Nullable
        private Integer mCustomWeight = null;
        @NonNull
        private final LayoutElementBuilders.Text.Builder mElementBuilder = new LayoutElementBuilders.Text.Builder().setMaxLines(1).setMultilineAlignment(2).setOverflow(2);

        public Builder(@NonNull Context context, @NonNull String text) {
            this.mContext = context;
            this.mElementBuilder.setText(text);
        }

        @NonNull
        public Builder setTypography(int typography) {
            this.mTypographyName = typography;
            return this;
        }

        Builder setIsScalable(boolean isScalable) {
            this.mIsScalable = isScalable;
            return this;
        }

        @NonNull
        public Builder setColor(@NonNull ColorBuilders.ColorProp color) {
            this.mColor = color;
            return this;
        }

        @NonNull
        public Builder setItalic(boolean italic) {
            this.mItalic = italic;
            return this;
        }

        @NonNull
        public Builder setUnderline(boolean underline) {
            this.mUnderline = underline;
            return this;
        }

        @NonNull
        public Builder setMaxLines(@IntRange(from=1L) int maxLines) {
            this.mElementBuilder.setMaxLines(maxLines);
            return this;
        }

        @NonNull
        public Builder setMultilineAlignment(int multilineAlignment) {
            this.mElementBuilder.setMultilineAlignment(multilineAlignment);
            return this;
        }

        @NonNull
        public Builder setModifiers(@NonNull ModifiersBuilders.Modifiers modifiers) {
            this.mElementBuilder.setModifiers(modifiers);
            return this;
        }

        @NonNull
        public Builder setOverflow(int overflow) {
            this.mElementBuilder.setOverflow(overflow);
            return this;
        }

        @NonNull
        public Builder setWeight(int weight) {
            this.mCustomWeight = weight;
            return this;
        }

        @NonNull
        @SuppressLint(value={"MissingGetterMatchingBuilder"})
        @ProtoLayoutExperimental
        public Builder setExcludeFontPadding(boolean excludeFontPadding) {
            this.mElementBuilder.setAndroidTextStyle(new LayoutElementBuilders.AndroidTextStyle.Builder().setExcludeFontPadding(excludeFontPadding).build());
            return this;
        }

        @NonNull
        public Text build() {
            LayoutElementBuilders.FontStyle.Builder fontStyleBuilder = Typography.getFontStyleBuilder(this.mTypographyName, this.mContext, this.mIsScalable).setColor(this.mColor).setItalic(this.mItalic).setUnderline(this.mUnderline);
            if (this.mCustomWeight != null) {
                fontStyleBuilder.setWeight(this.mCustomWeight.intValue());
            }
            this.mElementBuilder.setFontStyle(fontStyleBuilder.build()).setLineHeight(Typography.getLineHeightForTypography(this.mTypographyName));
            return new Text(this.mElementBuilder.build());
        }
    }
}

