/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.material;

import android.content.Context;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.wear.protolayout.DeviceParametersBuilders;
import androidx.wear.protolayout.DimensionBuilders;
import androidx.wear.protolayout.LayoutElementBuilders;
import androidx.wear.protolayout.ModifiersBuilders;
import androidx.wear.protolayout.expression.Fingerprint;
import androidx.wear.protolayout.material.Chip;
import androidx.wear.protolayout.material.ChipColors;
import androidx.wear.protolayout.material.ChipDefaults;
import androidx.wear.protolayout.material.Helper;
import androidx.wear.protolayout.proto.LayoutElementProto;

public class TitleChip
implements LayoutElementBuilders.LayoutElement {
    static final String METADATA_TAG = "TTLCHP";
    @NonNull
    private final Chip mElement;

    TitleChip(@NonNull Chip element) {
        this.mElement = element;
    }

    @NonNull
    public DimensionBuilders.ContainerDimension getWidth() {
        return this.mElement.getWidth();
    }

    @NonNull
    public ModifiersBuilders.Clickable getClickable() {
        return this.mElement.getClickable();
    }

    @NonNull
    public ChipColors getChipColors() {
        return this.mElement.getChipColors();
    }

    @NonNull
    public String getText() {
        return Helper.checkNotNull(this.mElement.getPrimaryLabelContent());
    }

    public int getHorizontalAlignment() {
        return this.mElement.getHorizontalAlignment();
    }

    @NonNull
    String getMetadataTag() {
        return this.mElement.getMetadataTag();
    }

    @Nullable
    public static TitleChip fromLayoutElement(@NonNull LayoutElementBuilders.LayoutElement element) {
        if (element instanceof TitleChip) {
            return (TitleChip)element;
        }
        if (!(element instanceof LayoutElementBuilders.Box)) {
            return null;
        }
        LayoutElementBuilders.Box boxElement = (LayoutElementBuilders.Box)element;
        if (!Helper.checkTag(boxElement.getModifiers(), METADATA_TAG)) {
            return null;
        }
        return new TitleChip(new Chip(boxElement));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public LayoutElementProto.LayoutElement toLayoutElementProto() {
        return this.mElement.toLayoutElementProto();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Fingerprint getFingerprint() {
        return this.mElement.getFingerprint();
    }

    public static final class Builder
    implements LayoutElementBuilders.LayoutElement.Builder {
        @NonNull
        private final Context mContext;
        @NonNull
        private final String mText;
        @NonNull
        private final ModifiersBuilders.Clickable mClickable;
        @NonNull
        private final DeviceParametersBuilders.DeviceParameters mDeviceParameters;
        @NonNull
        private ChipColors mChipColors = ChipDefaults.TITLE_PRIMARY_COLORS;
        private int mHorizontalAlign = 2;
        @Nullable
        private DimensionBuilders.ContainerDimension mWidth = null;

        public Builder(@NonNull Context context, @NonNull String text, @NonNull ModifiersBuilders.Clickable clickable, @NonNull DeviceParametersBuilders.DeviceParameters deviceParameters) {
            this.mContext = context;
            this.mText = text;
            this.mClickable = clickable;
            this.mDeviceParameters = deviceParameters;
        }

        @NonNull
        public Builder setChipColors(@NonNull ChipColors chipColors) {
            this.mChipColors = chipColors;
            return this;
        }

        @NonNull
        public Builder setHorizontalAlignment(int horizontalAlignment) {
            this.mHorizontalAlign = horizontalAlignment;
            return this;
        }

        @NonNull
        public Builder setWidth(@NonNull DimensionBuilders.ContainerDimension width) {
            this.mWidth = width;
            return this;
        }

        @NonNull
        public Builder setWidth(@Dimension(unit=0) float width) {
            this.mWidth = DimensionBuilders.dp((float)width);
            return this;
        }

        @NonNull
        public TitleChip build() {
            Chip.Builder chipBuilder = new Chip.Builder(this.mContext, this.mClickable, this.mDeviceParameters).setMetadataTag(TitleChip.METADATA_TAG).setChipColors(this.mChipColors).setContentDescription(this.mText).setHorizontalAlignment(this.mHorizontalAlign).setHeight(ChipDefaults.TITLE_HEIGHT).setMaxLines(1).setHorizontalPadding(ChipDefaults.TITLE_HORIZONTAL_PADDING).setPrimaryLabelContent(this.mText).setPrimaryLabelTypography(5).setIsPrimaryLabelScalable(false);
            if (this.mWidth != null) {
                chipBuilder.setWidth(this.mWidth);
            }
            return new TitleChip(chipBuilder.build());
        }
    }
}

