/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.material;

import android.annotation.SuppressLint;
import android.content.Context;
import android.util.DisplayMetrics;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.wear.protolayout.DimensionBuilders;
import androidx.wear.protolayout.LayoutElementBuilders;
import androidx.wear.protolayout.material.Helper;
import java.util.HashMap;
import java.util.Map;

public class Typography {
    public static final int TYPOGRAPHY_DISPLAY1 = 1;
    public static final int TYPOGRAPHY_DISPLAY2 = 2;
    public static final int TYPOGRAPHY_DISPLAY3 = 3;
    public static final int TYPOGRAPHY_TITLE1 = 4;
    public static final int TYPOGRAPHY_TITLE2 = 5;
    public static final int TYPOGRAPHY_TITLE3 = 6;
    public static final int TYPOGRAPHY_BODY1 = 7;
    public static final int TYPOGRAPHY_BODY2 = 8;
    public static final int TYPOGRAPHY_BUTTON = 9;
    public static final int TYPOGRAPHY_CAPTION1 = 10;
    public static final int TYPOGRAPHY_CAPTION2 = 11;
    public static final int TYPOGRAPHY_CAPTION3 = 12;
    @NonNull
    private static final Map<Integer, Float> TYPOGRAPHY_TO_LINE_HEIGHT_SP = new HashMap<Integer, Float>();

    @NonNull
    static LayoutElementBuilders.FontStyle.Builder getFontStyleBuilder(int fontStyleCode, @NonNull Context context) {
        return Typography.getFontStyleBuilder(fontStyleCode, context, true);
    }

    private Typography() {
    }

    @NonNull
    static LayoutElementBuilders.FontStyle.Builder getFontStyleBuilder(int typographyCode, @NonNull Context context, boolean isScalable) {
        switch (typographyCode) {
            case 7: {
                return Typography.body1(isScalable, context);
            }
            case 8: {
                return Typography.body2(isScalable, context);
            }
            case 9: {
                return Typography.button(isScalable, context);
            }
            case 10: {
                return Typography.caption1(isScalable, context);
            }
            case 11: {
                return Typography.caption2(isScalable, context);
            }
            case 12: {
                return Typography.caption3(isScalable, context);
            }
            case 1: {
                return Typography.display1(isScalable, context);
            }
            case 2: {
                return Typography.display2(isScalable, context);
            }
            case 3: {
                return Typography.display3(isScalable, context);
            }
            case 4: {
                return Typography.title1(isScalable, context);
            }
            case 5: {
                return Typography.title2(isScalable, context);
            }
            case 6: {
                return Typography.title3(isScalable, context);
            }
        }
        throw new IllegalArgumentException("Typography " + typographyCode + " doesn't exist.");
    }

    @NonNull
    static DimensionBuilders.SpProp getLineHeightForTypography(int typography) {
        if (!TYPOGRAPHY_TO_LINE_HEIGHT_SP.containsKey(typography)) {
            throw new IllegalArgumentException("Typography " + typography + " doesn't exist.");
        }
        return DimensionBuilders.sp((float)Helper.checkNotNull(TYPOGRAPHY_TO_LINE_HEIGHT_SP.get(typography)).intValue());
    }

    @NonNull
    @SuppressLint(value={"ResourceType"})
    private static DimensionBuilders.SpProp dpToSp(@NonNull Context context, @Dimension(unit=0) float valueDp) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        float scaledSp = valueDp / metrics.scaledDensity * metrics.density;
        return DimensionBuilders.sp((float)scaledSp);
    }

    @SuppressLint(value={"ResourceType"})
    private static LayoutElementBuilders.FontStyle.Builder createFontStyleBuilder(@Dimension(unit=2) int size, int weight, int variant, float letterSpacing, boolean isScalable, @NonNull Context context) {
        return new LayoutElementBuilders.FontStyle.Builder().setSize(isScalable ? DimensionBuilders.sp((float)size) : Typography.dpToSp(context, size)).setLetterSpacing(DimensionBuilders.em((float)letterSpacing)).setVariant(variant).setWeight(weight);
    }

    @NonNull
    private static LayoutElementBuilders.FontStyle.Builder display1(boolean isScalable, @NonNull Context context) {
        return Typography.createFontStyleBuilder(40, 500, 1, 0.01f, isScalable, context);
    }

    @NonNull
    private static LayoutElementBuilders.FontStyle.Builder display2(boolean isScalable, @NonNull Context context) {
        return Typography.createFontStyleBuilder(34, 500, 1, 0.03f, isScalable, context);
    }

    @NonNull
    private static LayoutElementBuilders.FontStyle.Builder display3(boolean isScalable, @NonNull Context context) {
        return Typography.createFontStyleBuilder(30, 500, 1, 0.03f, isScalable, context);
    }

    @NonNull
    private static LayoutElementBuilders.FontStyle.Builder title1(boolean isScalable, @NonNull Context context) {
        return Typography.createFontStyleBuilder(24, 500, 1, 0.008f, isScalable, context);
    }

    @NonNull
    private static LayoutElementBuilders.FontStyle.Builder title2(boolean isScalable, @NonNull Context context) {
        return Typography.createFontStyleBuilder(20, 500, 1, 0.01f, isScalable, context);
    }

    @NonNull
    private static LayoutElementBuilders.FontStyle.Builder title3(boolean isScalable, @NonNull Context context) {
        return Typography.createFontStyleBuilder(16, 500, 1, 0.01f, isScalable, context);
    }

    @NonNull
    private static LayoutElementBuilders.FontStyle.Builder body1(boolean isScalable, @NonNull Context context) {
        return Typography.createFontStyleBuilder(16, 400, 2, 0.01f, isScalable, context);
    }

    @NonNull
    private static LayoutElementBuilders.FontStyle.Builder body2(boolean isScalable, @NonNull Context context) {
        return Typography.createFontStyleBuilder(14, 400, 2, 0.014f, isScalable, context);
    }

    @NonNull
    private static LayoutElementBuilders.FontStyle.Builder button(boolean isScalable, @NonNull Context context) {
        return Typography.createFontStyleBuilder(15, 700, 2, 0.03f, isScalable, context);
    }

    @NonNull
    private static LayoutElementBuilders.FontStyle.Builder caption1(boolean isScalable, @NonNull Context context) {
        return Typography.createFontStyleBuilder(14, 500, 2, 0.01f, isScalable, context);
    }

    @NonNull
    private static LayoutElementBuilders.FontStyle.Builder caption2(boolean isScalable, @NonNull Context context) {
        return Typography.createFontStyleBuilder(12, 500, 2, 0.01f, isScalable, context);
    }

    @NonNull
    private static LayoutElementBuilders.FontStyle.Builder caption3(boolean isScalable, @NonNull Context context) {
        return Typography.createFontStyleBuilder(10, 500, 2, 0.01f, isScalable, context);
    }

    static {
        TYPOGRAPHY_TO_LINE_HEIGHT_SP.put(1, Float.valueOf(46.0f));
        TYPOGRAPHY_TO_LINE_HEIGHT_SP.put(2, Float.valueOf(40.0f));
        TYPOGRAPHY_TO_LINE_HEIGHT_SP.put(3, Float.valueOf(36.0f));
        TYPOGRAPHY_TO_LINE_HEIGHT_SP.put(4, Float.valueOf(28.0f));
        TYPOGRAPHY_TO_LINE_HEIGHT_SP.put(5, Float.valueOf(24.0f));
        TYPOGRAPHY_TO_LINE_HEIGHT_SP.put(6, Float.valueOf(20.0f));
        TYPOGRAPHY_TO_LINE_HEIGHT_SP.put(7, Float.valueOf(20.0f));
        TYPOGRAPHY_TO_LINE_HEIGHT_SP.put(8, Float.valueOf(18.0f));
        TYPOGRAPHY_TO_LINE_HEIGHT_SP.put(9, Float.valueOf(19.0f));
        TYPOGRAPHY_TO_LINE_HEIGHT_SP.put(10, Float.valueOf(18.0f));
        TYPOGRAPHY_TO_LINE_HEIGHT_SP.put(11, Float.valueOf(16.0f));
        TYPOGRAPHY_TO_LINE_HEIGHT_SP.put(12, Float.valueOf(14.0f));
    }
}

