/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.material.layouts;

import android.annotation.SuppressLint;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.wear.protolayout.DimensionBuilders;
import androidx.wear.protolayout.LayoutElementBuilders;
import androidx.wear.protolayout.ModifiersBuilders;
import androidx.wear.protolayout.expression.Fingerprint;
import androidx.wear.protolayout.material.Helper;
import androidx.wear.protolayout.material.layouts.LayoutDefaults;
import androidx.wear.protolayout.proto.LayoutElementProto;
import java.util.ArrayList;
import java.util.List;

public class MultiSlotLayout
implements LayoutElementBuilders.LayoutElement {
    static final String METADATA_TAG = "MSL";
    @NonNull
    private final LayoutElementBuilders.Row mElement;

    MultiSlotLayout(@NonNull LayoutElementBuilders.Row mElement) {
        this.mElement = mElement;
    }

    @NonNull
    public List<LayoutElementBuilders.LayoutElement> getSlotContents() {
        ArrayList<LayoutElementBuilders.LayoutElement> slots = new ArrayList<LayoutElementBuilders.LayoutElement>();
        for (LayoutElementBuilders.LayoutElement slot : this.mElement.getContents()) {
            if (!(slot instanceof LayoutElementBuilders.Box)) continue;
            slots.add((LayoutElementBuilders.LayoutElement)((LayoutElementBuilders.Box)slot).getContents().get(0));
        }
        return slots;
    }

    @SuppressLint(value={"ResourceType"})
    @Dimension(unit=0)
    public float getHorizontalSpacerWidth() {
        for (LayoutElementBuilders.LayoutElement slot : this.mElement.getContents()) {
            DimensionBuilders.SpacerDimension width;
            if (!(slot instanceof LayoutElementBuilders.Spacer) || !((width = ((LayoutElementBuilders.Spacer)slot).getWidth()) instanceof DimensionBuilders.DpProp)) continue;
            return ((DimensionBuilders.DpProp)width).getValue();
        }
        return LayoutDefaults.MULTI_SLOT_LAYOUT_HORIZONTAL_SPACER_WIDTH.getValue();
    }

    @NonNull
    String getMetadataTag() {
        return Helper.getMetadataTagName(Helper.checkNotNull(Helper.checkNotNull(this.mElement.getModifiers()).getMetadata()));
    }

    @Nullable
    public static MultiSlotLayout fromLayoutElement(@NonNull LayoutElementBuilders.LayoutElement element) {
        if (element instanceof MultiSlotLayout) {
            return (MultiSlotLayout)element;
        }
        if (!(element instanceof LayoutElementBuilders.Row)) {
            return null;
        }
        LayoutElementBuilders.Row rowElement = (LayoutElementBuilders.Row)element;
        if (!Helper.checkTag(rowElement.getModifiers(), METADATA_TAG)) {
            return null;
        }
        return new MultiSlotLayout(rowElement);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public LayoutElementProto.LayoutElement toLayoutElementProto() {
        return this.mElement.toLayoutElementProto();
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Fingerprint getFingerprint() {
        return this.mElement.getFingerprint();
    }

    public static final class Builder
    implements LayoutElementBuilders.LayoutElement.Builder {
        @NonNull
        private final List<LayoutElementBuilders.LayoutElement> mSlotsContent = new ArrayList<LayoutElementBuilders.LayoutElement>();
        @NonNull
        private DimensionBuilders.DpProp mHorizontalSpacerWidth = LayoutDefaults.MULTI_SLOT_LAYOUT_HORIZONTAL_SPACER_WIDTH;

        @NonNull
        public Builder addSlotContent(@NonNull LayoutElementBuilders.LayoutElement slotContent) {
            this.mSlotsContent.add(slotContent);
            return this;
        }

        @NonNull
        public Builder setHorizontalSpacerWidth(@Dimension(unit=0) float width) {
            this.mHorizontalSpacerWidth = DimensionBuilders.dp((float)width);
            return this;
        }

        @NonNull
        @SuppressLint(value={"ResourceType"})
        public MultiSlotLayout build() {
            LayoutElementBuilders.Row.Builder rowBuilder = new LayoutElementBuilders.Row.Builder().setHeight((DimensionBuilders.ContainerDimension)DimensionBuilders.wrap()).setVerticalAlignment(2).setWidth((DimensionBuilders.ContainerDimension)DimensionBuilders.wrap()).setModifiers(new ModifiersBuilders.Modifiers.Builder().setMetadata(new ModifiersBuilders.ElementMetadata.Builder().setTagData(Helper.getTagBytes(MultiSlotLayout.METADATA_TAG)).build()).build());
            if (!this.mSlotsContent.isEmpty()) {
                boolean isFirst = true;
                for (LayoutElementBuilders.LayoutElement slot : this.mSlotsContent) {
                    if (!isFirst) {
                        rowBuilder.addContent((LayoutElementBuilders.LayoutElement)new LayoutElementBuilders.Spacer.Builder().setWidth((DimensionBuilders.SpacerDimension)this.mHorizontalSpacerWidth).build());
                    } else {
                        isFirst = false;
                    }
                    rowBuilder.addContent((LayoutElementBuilders.LayoutElement)new LayoutElementBuilders.Box.Builder().setWidth((DimensionBuilders.ContainerDimension)DimensionBuilders.wrap()).setHeight((DimensionBuilders.ContainerDimension)DimensionBuilders.wrap()).addContent(slot).build());
                }
            }
            return new MultiSlotLayout(rowBuilder.build());
        }
    }
}

