/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.common;

import android.annotation.SuppressLint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Preconditions;
import androidx.wear.protolayout.proto.FingerprintProto;
import androidx.wear.protolayout.proto.LayoutElementProto;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ProtoLayoutDiffer {
    @NonNull
    private static final String NODE_ID_PREFIX = "pT";
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @NonNull
    public static final String ROOT_NODE_ID = "pT1";
    @VisibleForTesting
    static final int DISCARDED_FINGERPRINT_VALUE = -1;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final boolean UPDATE_ALL_CHILDREN_AFTER_ADD_REMOVE = true;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final int FIRST_CHILD_INDEX = 0;

    private ProtoLayoutDiffer() {
    }

    @SuppressLint(value={"DefaultLocale"})
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static String createNodePosId(@NonNull String parentPosId, int childIndex) {
        return String.format("%s.%d", parentPosId, childIndex + 1);
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static String getParentNodePosId(@NonNull String posId) {
        if (!posId.startsWith(NODE_ID_PREFIX)) {
            return null;
        }
        int separatorIdx = posId.lastIndexOf(46);
        if (separatorIdx <= NODE_ID_PREFIX.length()) {
            return null;
        }
        return posId.substring(0, separatorIdx);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean isDescendantOf(@NonNull String posId, @NonNull String parentPosId) {
        return posId.length() > parentPosId.length() + 1 && posId.startsWith(parentPosId) && posId.charAt(parentPosId.length()) == '.';
    }

    @Nullable
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static LayoutDiff getDiff(@NonNull FingerprintProto.TreeFingerprint prevTreeFingerprint, @NonNull LayoutElementProto.Layout layout) {
        if (!layout.getFingerprint().hasRoot()) {
            return null;
        }
        FingerprintProto.NodeFingerprint prevRootFingerprint = prevTreeFingerprint.getRoot();
        TreeNode rootNode = TreeNode.ofLayoutElement(layout.getRoot(), layout.getFingerprint().getRoot(), ROOT_NODE_ID);
        ArrayList<TreeNodeWithChange> changedNodes = new ArrayList<TreeNodeWithChange>();
        try {
            ProtoLayoutDiffer.addChangedNodes(prevRootFingerprint, rootNode, changedNodes);
        }
        catch (InconsistentFingerprintException ignored) {
            return null;
        }
        return new LayoutDiff(changedNodes);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static boolean areNodesEquivalent(@NonNull FingerprintProto.NodeFingerprint nodeA, @NonNull FingerprintProto.NodeFingerprint nodeB) {
        return ProtoLayoutDiffer.getChangeType(nodeA, nodeB) == NodeChangeType.NO_CHANGE;
    }

    private static void addChangedNodes(@NonNull FingerprintProto.NodeFingerprint prevNodeFingerprint, @NonNull TreeNode node, @NonNull List<TreeNodeWithChange> changedNodes) throws InconsistentFingerprintException {
        switch (ProtoLayoutDiffer.getChangeType(prevNodeFingerprint, node.mFingerprint)) {
            case CHANGE_IN_SELF_ONLY: {
                changedNodes.add(node.withChange(true));
                break;
            }
            case CHANGE_IN_SELF_AND_ALL_CHILDREN: {
                changedNodes.add(node.withChange(false));
                break;
            }
            case CHANGE_IN_SELF_AND_SOME_CHILDREN: {
                changedNodes.add(node.withChange(true));
                ProtoLayoutDiffer.addChangedChildNodes(prevNodeFingerprint, node, changedNodes);
                break;
            }
            case CHANGE_IN_CHILDREN: {
                ProtoLayoutDiffer.addChangedChildNodes(prevNodeFingerprint, node, changedNodes);
                break;
            }
        }
    }

    @NonNull
    private static NodeChangeType getChangeType(@NonNull FingerprintProto.NodeFingerprint prevNode, @Nullable FingerprintProto.NodeFingerprint node) {
        boolean childrenChanged;
        if (node == null) {
            return NodeChangeType.CHANGE_IN_SELF_AND_ALL_CHILDREN;
        }
        if (prevNode.getSelfTypeValue() != node.getSelfTypeValue()) {
            return NodeChangeType.CHANGE_IN_SELF_AND_ALL_CHILDREN;
        }
        if (node.getSelfPropsValue() == -1 && node.getChildNodesValue() == -1) {
            if (node.getChildNodesCount() == 0) {
                return NodeChangeType.CHANGE_IN_SELF_AND_ALL_CHILDREN;
            }
            return NodeChangeType.CHANGE_IN_SELF_AND_SOME_CHILDREN;
        }
        if (prevNode.getChildNodesCount() != node.getChildNodesCount()) {
            return NodeChangeType.CHANGE_IN_SELF_AND_ALL_CHILDREN;
        }
        boolean selfChanged = node.getSelfPropsValue() == -1 || prevNode.getSelfPropsValue() != node.getSelfPropsValue();
        boolean bl = childrenChanged = node.getChildNodesValue() == -1 || prevNode.getChildNodesValue() != node.getChildNodesValue();
        if (selfChanged && childrenChanged) {
            return NodeChangeType.CHANGE_IN_SELF_AND_SOME_CHILDREN;
        }
        if (selfChanged) {
            return NodeChangeType.CHANGE_IN_SELF_ONLY;
        }
        if (childrenChanged) {
            return NodeChangeType.CHANGE_IN_CHILDREN;
        }
        return NodeChangeType.NO_CHANGE;
    }

    private static void addChangedChildNodes(@NonNull FingerprintProto.NodeFingerprint prevNodeFingerprint, @NonNull TreeNode node, @NonNull List<TreeNodeWithChange> changedNodes) throws InconsistentFingerprintException {
        List<TreeNode> childList = ProtoLayoutDiffer.getChildNodes(node);
        if (childList.isEmpty()) {
            return;
        }
        Preconditions.checkState((childList.size() == prevNodeFingerprint.getChildNodesCount() ? 1 : 0) != 0);
        for (int i = 0; i < childList.size(); ++i) {
            TreeNode childNode = childList.get(i);
            FingerprintProto.NodeFingerprint prevChildNodeFingerprint = prevNodeFingerprint.getChildNodes(i);
            ProtoLayoutDiffer.addChangedNodes(prevChildNodeFingerprint, childNode, changedNodes);
        }
    }

    @NonNull
    private static List<TreeNode> getChildNodes(@NonNull TreeNode node) throws InconsistentFingerprintException {
        LayoutElementProto.LayoutElement layoutElement = node.mLayoutElement;
        if (layoutElement == null) {
            return Collections.emptyList();
        }
        FingerprintProto.NodeFingerprint fingerprint = node.mFingerprint;
        switch (layoutElement.getInnerCase()) {
            case BOX: {
                return ProtoLayoutDiffer.getLinearChildNodes(layoutElement.getBox().getContentsList(), fingerprint.getChildNodesList(), node.mPosId);
            }
            case COLUMN: {
                return ProtoLayoutDiffer.getLinearChildNodes(layoutElement.getColumn().getContentsList(), fingerprint.getChildNodesList(), node.mPosId);
            }
            case ROW: {
                return ProtoLayoutDiffer.getLinearChildNodes(layoutElement.getRow().getContentsList(), fingerprint.getChildNodesList(), node.mPosId);
            }
            case ARC: {
                return ProtoLayoutDiffer.getRadialChildNodes(layoutElement.getArc().getContentsList(), fingerprint.getChildNodesList(), node.mPosId);
            }
        }
        return Collections.emptyList();
    }

    @NonNull
    private static List<TreeNode> getLinearChildNodes(@NonNull List<LayoutElementProto.LayoutElement> childElements, @NonNull List<FingerprintProto.NodeFingerprint> childElementFingerprints, @NonNull String parentPosId) throws InconsistentFingerprintException {
        if (childElements.isEmpty()) {
            return Collections.emptyList();
        }
        if (childElements.size() != childElementFingerprints.size()) {
            throw new InconsistentFingerprintException();
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(childElements.size());
        for (int i = 0; i < childElements.size(); ++i) {
            String childPosId = ProtoLayoutDiffer.createNodePosId(parentPosId, 0 + i);
            nodes.add(TreeNode.ofLayoutElement(childElements.get(i), childElementFingerprints.get(i), childPosId));
        }
        return nodes;
    }

    @NonNull
    private static List<TreeNode> getRadialChildNodes(@NonNull List<LayoutElementProto.ArcLayoutElement> childElements, @NonNull List<FingerprintProto.NodeFingerprint> childElementFingerprints, @NonNull String parentPosId) throws InconsistentFingerprintException {
        if (childElements.isEmpty()) {
            return Collections.emptyList();
        }
        if (childElements.size() != childElementFingerprints.size()) {
            throw new InconsistentFingerprintException();
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(childElements.size());
        for (int i = 0; i < childElements.size(); ++i) {
            String childPosId = ProtoLayoutDiffer.createNodePosId(parentPosId, 0 + i);
            nodes.add(TreeNode.ofArcLayoutElement(childElements.get(i), childElementFingerprints.get(i), childPosId));
        }
        return nodes;
    }

    private static final class TreeNode {
        @Nullable
        final LayoutElementProto.LayoutElement mLayoutElement;
        @Nullable
        final LayoutElementProto.ArcLayoutElement mArcLayoutElement;
        @NonNull
        final FingerprintProto.NodeFingerprint mFingerprint;
        @NonNull
        final String mPosId;

        private TreeNode(@Nullable LayoutElementProto.LayoutElement layoutElement, @Nullable LayoutElementProto.ArcLayoutElement arcLayoutElement, @NonNull FingerprintProto.NodeFingerprint fingerprint, @NonNull String posId) {
            this.mLayoutElement = layoutElement;
            this.mArcLayoutElement = arcLayoutElement;
            this.mFingerprint = fingerprint;
            this.mPosId = posId;
        }

        @NonNull
        static TreeNode ofLayoutElement(@NonNull LayoutElementProto.LayoutElement layoutElement, @NonNull FingerprintProto.NodeFingerprint fingerprint, @NonNull String posId) {
            return new TreeNode(layoutElement, null, fingerprint, posId);
        }

        @NonNull
        static TreeNode ofArcLayoutElement(@NonNull LayoutElementProto.ArcLayoutElement arcLayoutElement, @NonNull FingerprintProto.NodeFingerprint fingerprint, @NonNull String id) {
            return new TreeNode(null, arcLayoutElement, fingerprint, id);
        }

        @NonNull
        TreeNodeWithChange withChange(boolean isSelfOnlyChange) {
            return new TreeNodeWithChange(this, isSelfOnlyChange);
        }
    }

    static final class InconsistentFingerprintException
    extends Exception {
        InconsistentFingerprintException() {
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class LayoutDiff {
        @NonNull
        private final List<TreeNodeWithChange> mChangedNodes;

        LayoutDiff(@NonNull List<TreeNodeWithChange> changedNodes) {
            this.mChangedNodes = changedNodes;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public List<TreeNodeWithChange> getChangedNodes() {
            return this.mChangedNodes;
        }
    }

    private static enum NodeChangeType {
        NO_CHANGE,
        CHANGE_IN_SELF_ONLY,
        CHANGE_IN_SELF_AND_ALL_CHILDREN,
        CHANGE_IN_SELF_AND_SOME_CHILDREN,
        CHANGE_IN_CHILDREN;

    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class TreeNodeWithChange {
        @NonNull
        private final TreeNode mTreeNode;
        private final boolean mIsSelfOnlyChange;

        TreeNodeWithChange(@NonNull TreeNode treeNode, boolean isSelfOnlyChange) {
            this.mTreeNode = treeNode;
            this.mIsSelfOnlyChange = isSelfOnlyChange;
        }

        @Nullable
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public LayoutElementProto.LayoutElement getLayoutElement() {
            return this.mTreeNode.mLayoutElement;
        }

        @Nullable
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public LayoutElementProto.ArcLayoutElement getArcLayoutElement() {
            return this.mTreeNode.mArcLayoutElement;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public FingerprintProto.NodeFingerprint getFingerprint() {
            return this.mTreeNode.mFingerprint;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public String getPosId() {
            return this.mTreeNode.mPosId;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public boolean isSelfOnlyChange() {
            return this.mIsSelfOnlyChange;
        }
    }
}

