/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.dynamicdata;

import android.graphics.drawable.Animatable2;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArraySet;
import androidx.vectordrawable.graphics.drawable.SeekableAnimatedVectorDrawable;
import androidx.wear.protolayout.expression.pipeline.BoundDynamicType;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeBindingRequest;
import androidx.wear.protolayout.expression.pipeline.QuotaManager;
import androidx.wear.protolayout.expression.proto.DynamicProto;
import androidx.wear.protolayout.proto.ModifiersProto;
import androidx.wear.protolayout.proto.TriggerProto;
import androidx.wear.protolayout.renderer.dynamicdata.PositionIdTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

class NodeInfo
implements PositionIdTree.TreeNode {
    @NonNull
    private final List<BoundDynamicType> mActiveBoundTypes = new ArrayList<BoundDynamicType>();
    @NonNull
    private List<BoundDynamicType> mPendingBoundTypes = Collections.emptyList();
    @NonNull
    private final List<DynamicTypeBindingRequest> mFailedBindingRequests = new ArrayList<DynamicTypeBindingRequest>();
    @NonNull
    private final QuotaManager mAnimationQuotaManager;
    @NonNull
    private Set<ResolvedAvd> mResolvedAvds = Collections.emptySet();
    @NonNull
    private Set<ResolvedSeekableAvd> mResolvedSeekableAvds = Collections.emptySet();
    @Nullable
    private ModifiersProto.AnimatedVisibility mAnimatedVisibility = null;
    @NonNull
    private final String mPosId;

    NodeInfo(@NonNull String posId, @NonNull QuotaManager animationQuotaManager) {
        this.mPosId = posId;
        this.mAnimationQuotaManager = animationQuotaManager;
    }

    void addBoundType(@NonNull BoundDynamicType boundType) {
        this.mActiveBoundTypes.add(boundType);
        this.addPendingEvaluationBoundType(boundType);
    }

    private void addPendingEvaluationBoundType(@NonNull BoundDynamicType boundTYpe) {
        if (this.mPendingBoundTypes.isEmpty()) {
            this.mPendingBoundTypes = new ArrayList<BoundDynamicType>();
        }
        this.mPendingBoundTypes.add(boundTYpe);
    }

    void addFailedBindingRequest(@NonNull DynamicTypeBindingRequest request) {
        this.mFailedBindingRequests.add(request);
    }

    @UiThread
    void initPendingBoundTypes() {
        this.mPendingBoundTypes.forEach(BoundDynamicType::startEvaluation);
        this.mPendingBoundTypes.clear();
    }

    List<DynamicTypeBindingRequest> getFailedBindingRequest() {
        return this.mFailedBindingRequests;
    }

    @NonNull
    ResolvedAvd addResolvedAvd(@NonNull AnimatedVectorDrawable drawable, @NonNull TriggerProto.Trigger trigger) {
        if (this.mResolvedAvds.isEmpty()) {
            this.mResolvedAvds = new ArraySet();
        }
        ResolvedAvd avd = new ResolvedAvd(drawable, trigger, new QuotaReleasingAnimationCallback(this.mAnimationQuotaManager));
        this.mResolvedAvds.add(avd);
        return avd;
    }

    void addResolvedSeekableAvd(@NonNull ResolvedSeekableAvd seekableAvd) {
        if (this.mResolvedSeekableAvds.isEmpty()) {
            this.mResolvedSeekableAvds = new ArraySet();
        }
        this.mResolvedSeekableAvds.add(seekableAvd);
    }

    @Override
    @UiThread
    public void destroy() {
        this.mActiveBoundTypes.forEach(BoundDynamicType::close);
        this.mResolvedAvds.forEach(ResolvedAvd::unregisterCallback);
    }

    @VisibleForTesting(otherwise=5)
    int size() {
        return this.mActiveBoundTypes.stream().mapToInt(BoundDynamicType::getDynamicNodeCount).sum();
    }

    @UiThread
    void playAvdAnimations(@NonNull TriggerProto.Trigger.InnerCase triggerCase) {
        for (ResolvedAvd entry : this.mResolvedAvds) {
            if (entry.mTrigger.getInnerCase() != triggerCase || entry.mDrawable == null || entry.mDrawable.isRunning() || (triggerCase == TriggerProto.Trigger.InnerCase.ON_VISIBLE_ONCE_TRIGGER || triggerCase == TriggerProto.Trigger.InnerCase.ON_LOAD_TRIGGER) && entry.mPlayedAtLeastOnce || !this.mAnimationQuotaManager.tryAcquireQuota(1)) continue;
            entry.startAnimation();
        }
    }

    @UiThread
    void setVisibility(boolean visible) {
        for (ResolvedAvd resolvedAvd : this.mResolvedAvds) {
            resolvedAvd.mDrawable.setVisible(visible, false);
        }
        for (ResolvedSeekableAvd resolvedSeekableAvd : this.mResolvedSeekableAvds) {
            resolvedSeekableAvd.mDrawable.setVisible(visible, false);
        }
        this.mActiveBoundTypes.forEach(n -> n.setAnimationVisibility(visible));
    }

    @UiThread
    void resetAvdAnimations(@NonNull TriggerProto.Trigger.InnerCase triggerCase) {
        for (ResolvedAvd entry : this.mResolvedAvds) {
            if (entry.mTrigger.getInnerCase() != triggerCase || entry.mDrawable == null) continue;
            entry.mDrawable.reset();
        }
    }

    @UiThread
    void stopAvdAnimations(@NonNull TriggerProto.Trigger.InnerCase triggerCase) {
        for (ResolvedAvd entry : this.mResolvedAvds) {
            if (!entry.mDrawable.isRunning() || entry.mTrigger.getInnerCase() != triggerCase) continue;
            entry.mDrawable.stop();
            entry.mCallback.onAnimationEnd((Drawable)entry.mDrawable);
        }
    }

    @Nullable
    Long getSeekableAnimationTotalDurationMillis(@NonNull String sourceKey) {
        for (ResolvedSeekableAvd resourceEntry : this.mResolvedSeekableAvds) {
            if (!resourceEntry.hasStateSourceKey(sourceKey)) continue;
            return resourceEntry.mDrawable.getTotalDuration();
        }
        return null;
    }

    @VisibleForTesting(otherwise=5)
    int getRunningAnimationCount() {
        return (int)((long)this.mActiveBoundTypes.stream().mapToInt(BoundDynamicType::getRunningAnimationCount).sum() + this.mResolvedAvds.stream().filter(avd -> avd.mDrawable.isRunning()).count());
    }

    @VisibleForTesting(otherwise=5)
    public int getExpressionNodesCount() {
        return this.mActiveBoundTypes.stream().mapToInt(BoundDynamicType::getDynamicNodeCount).sum();
    }

    void setAnimatedVisibility(@NonNull ModifiersProto.AnimatedVisibility animatedVisibility) {
        this.mAnimatedVisibility = animatedVisibility;
    }

    @Nullable
    ModifiersProto.AnimatedVisibility getAnimatedVisibility() {
        return this.mAnimatedVisibility;
    }

    @NonNull
    String getPosId() {
        return this.mPosId;
    }

    @NonNull
    public String toString() {
        return this.mPosId;
    }

    static class ResolvedAvd {
        @NonNull
        final AnimatedVectorDrawable mDrawable;
        @NonNull
        final QuotaReleasingAnimationCallback mCallback;
        @NonNull
        final TriggerProto.Trigger mTrigger;
        boolean mPlayedAtLeastOnce;

        ResolvedAvd(@NonNull AnimatedVectorDrawable drawable, @NonNull TriggerProto.Trigger trigger, @NonNull QuotaReleasingAnimationCallback callback) {
            this.mDrawable = drawable;
            this.mCallback = callback;
            this.mTrigger = trigger;
            this.mPlayedAtLeastOnce = false;
            this.mDrawable.registerAnimationCallback((Animatable2.AnimationCallback)callback);
        }

        void unregisterCallback() {
            this.mDrawable.unregisterAnimationCallback((Animatable2.AnimationCallback)this.mCallback);
        }

        void startAnimation() {
            this.mDrawable.start();
            this.mCallback.mIsUsingQuota.set(true);
            this.mPlayedAtLeastOnce = true;
        }
    }

    private static final class QuotaReleasingAnimationCallback
    extends Animatable2.AnimationCallback {
        @NonNull
        private final QuotaManager mQuotaManager;
        @NonNull
        final AtomicBoolean mIsUsingQuota = new AtomicBoolean(false);

        QuotaReleasingAnimationCallback(@NonNull QuotaManager quotaManager) {
            this.mQuotaManager = quotaManager;
        }

        public void onAnimationEnd(@NonNull Drawable drawable) {
            if (this.mIsUsingQuota.compareAndSet(true, false)) {
                this.mQuotaManager.releaseQuota(1);
            }
        }

        public void onAnimationStart(@NonNull Drawable drawable) {
        }
    }

    static class ResolvedSeekableAvd {
        @NonNull
        final SeekableAnimatedVectorDrawable mDrawable;
        @NonNull
        final DynamicProto.DynamicFloat mBoundProgress;

        ResolvedSeekableAvd(@NonNull SeekableAnimatedVectorDrawable drawable, @NonNull DynamicProto.DynamicFloat boundProgress) {
            this.mDrawable = drawable;
            this.mBoundProgress = boundProgress;
        }

        boolean hasStateSourceKey(@NonNull String sourceKey) {
            return this.mBoundProgress.getStateSource().getSourceKey().equals(sourceKey);
        }
    }
}

