/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.dynamicdata;

import android.util.ArrayMap;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.core.util.Preconditions;
import androidx.wear.protolayout.renderer.common.ProtoLayoutDiffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;

final class PositionIdTree<T extends TreeNode> {
    @NonNull
    private final Map<String, T> mPosIdToTreeNode = new ArrayMap();

    PositionIdTree() {
    }

    void forEach(Consumer<T> action) {
        this.mPosIdToTreeNode.values().forEach(action);
    }

    void clear() {
        this.mPosIdToTreeNode.values().forEach(TreeNode::destroy);
        this.mPosIdToTreeNode.clear();
    }

    void removeChildNodesFor(@NonNull String posId) {
        this.removeChildNodesFor(posId, false);
    }

    private void removeChildNodesFor(@NonNull String posId, boolean removeRoot) {
        String possibleChildPosId;
        int childIndex = 0;
        while (this.mPosIdToTreeNode.containsKey(possibleChildPosId = ProtoLayoutDiffer.createNodePosId(posId, childIndex))) {
            this.removeChildNodesFor(possibleChildPosId, true);
            ++childIndex;
        }
        if (removeRoot) {
            ((TreeNode)Preconditions.checkNotNull((Object)((TreeNode)this.mPosIdToTreeNode.remove(posId)))).destroy();
        }
    }

    void addOrReplace(@NonNull String posId, @NonNull T newNode) {
        TreeNode oldNode = (TreeNode)this.mPosIdToTreeNode.put(posId, newNode);
        if (oldNode != null) {
            oldNode.destroy();
        }
    }

    @Nullable
    T findFirst(@NonNull Predicate<? super T> predicate) {
        return (T)((TreeNode)this.mPosIdToTreeNode.values().stream().filter(predicate).findFirst().orElse(null));
    }

    @Nullable
    T get(String posId) {
        return (T)((TreeNode)this.mPosIdToTreeNode.get(posId));
    }

    @NonNull
    List<T> findAncestorsFor(@NonNull String posId, @NonNull Predicate<? super T> predicate) {
        String parentPosId;
        ArrayList<TreeNode> result = new ArrayList<TreeNode>();
        while ((parentPosId = ProtoLayoutDiffer.getParentNodePosId(posId)) != null) {
            TreeNode value = (TreeNode)this.mPosIdToTreeNode.get(parentPosId);
            if (value != null && predicate.test(value)) {
                result.add(value);
            }
            posId = parentPosId;
        }
        return result;
    }

    @NonNull
    List<T> findChildrenFor(@NonNull String posId) {
        return this.findChildrenFor(posId, node -> true);
    }

    @NonNull
    List<T> findChildrenFor(@NonNull String posId, @NonNull Predicate<? super T> predicate) {
        ArrayList result = new ArrayList();
        this.addChildrenFor(posId, predicate, result);
        return result;
    }

    private void addChildrenFor(@NonNull String posId, @NonNull Predicate<? super T> predicate, @NonNull List<T> result) {
        String possibleChildPosId;
        int childIndex = 0;
        while (this.mPosIdToTreeNode.containsKey(possibleChildPosId = ProtoLayoutDiffer.createNodePosId(posId, childIndex))) {
            TreeNode value = (TreeNode)this.mPosIdToTreeNode.get(possibleChildPosId);
            if (value != null && predicate.test(value)) {
                result.add(value);
            }
            this.addChildrenFor(possibleChildPosId, predicate, result);
            ++childIndex;
        }
    }

    @VisibleForTesting(otherwise=5)
    @NonNull
    Collection<T> getAllNodes() {
        return Collections.unmodifiableCollection(this.mPosIdToTreeNode.values());
    }

    static interface TreeNode {
        public void destroy();
    }
}

