/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.dynamicdata;

import android.annotation.SuppressLint;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.icu.util.ULocale;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.collection.ArrayMap;
import androidx.collection.ArraySet;
import androidx.core.util.Preconditions;
import androidx.vectordrawable.graphics.drawable.SeekableAnimatedVectorDrawable;
import androidx.wear.protolayout.expression.pipeline.BoundDynamicType;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeBindingRequest;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeEvaluator;
import androidx.wear.protolayout.expression.pipeline.DynamicTypeValueReceiver;
import androidx.wear.protolayout.expression.pipeline.FixedQuotaManagerImpl;
import androidx.wear.protolayout.expression.pipeline.QuotaManager;
import androidx.wear.protolayout.expression.pipeline.StateStore;
import androidx.wear.protolayout.expression.pipeline.TimeGateway;
import androidx.wear.protolayout.expression.pipeline.TimeGatewayImpl;
import androidx.wear.protolayout.expression.pipeline.sensor.SensorGateway;
import androidx.wear.protolayout.expression.proto.DynamicProto;
import androidx.wear.protolayout.proto.ColorProto;
import androidx.wear.protolayout.proto.DimensionProto;
import androidx.wear.protolayout.proto.ModifiersProto;
import androidx.wear.protolayout.proto.TriggerProto;
import androidx.wear.protolayout.renderer.dynamicdata.NodeInfo;
import androidx.wear.protolayout.renderer.dynamicdata.PositionIdTree;
import androidx.wear.protolayout.renderer.dynamicdata.QuotaAwareAnimationSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class ProtoLayoutDynamicDataPipeline {
    @NonNull
    private static final String TAG = "DynamicDataPipeline";
    @NonNull
    private static final QuotaManager DISABLED_ANIMATIONS_QUOTA_MANAGER = new FixedQuotaManagerImpl(0);
    @NonNull
    final PositionIdTree<NodeInfo> mPositionIdTree = new PositionIdTree();
    @NonNull
    final List<QuotaAwareAnimationSet> mEnterAnimations = new ArrayList<QuotaAwareAnimationSet>();
    @NonNull
    final List<QuotaAwareAnimationSet> mExitAnimations = new ArrayList<QuotaAwareAnimationSet>();
    final boolean mEnableAnimations;
    boolean mFullyVisible;
    @NonNull
    final QuotaManager mAnimationQuotaManager;
    @NonNull
    private final DynamicTypeEvaluator mEvaluator;
    @NonNull
    private final TimeGatewayImpl mTimeGateway;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public ProtoLayoutDynamicDataPipeline(@Nullable SensorGateway sensorGateway, @NonNull StateStore stateStore) {
        this(sensorGateway, stateStore, false, DISABLED_ANIMATIONS_QUOTA_MANAGER, (QuotaManager)new FixedQuotaManagerImpl(Integer.MAX_VALUE));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public ProtoLayoutDynamicDataPipeline(@Nullable SensorGateway sensorGateway, @NonNull StateStore stateStore, @NonNull QuotaManager animationQuotaManager, @NonNull QuotaManager dynamicNodesQuotaManager) {
        this(sensorGateway, stateStore, true, animationQuotaManager, dynamicNodesQuotaManager);
    }

    private ProtoLayoutDynamicDataPipeline(@Nullable SensorGateway sensorGateway, @NonNull StateStore stateStore, boolean enableAnimations, @NonNull QuotaManager animationQuotaManager, @NonNull QuotaManager dynamicNodeQuotaManager) {
        this.mEnableAnimations = enableAnimations;
        this.mAnimationQuotaManager = animationQuotaManager;
        this.mTimeGateway = new TimeGatewayImpl(new Handler(Looper.getMainLooper()));
        DynamicTypeEvaluator.Config.Builder evaluatorConfigBuilder = new DynamicTypeEvaluator.Config.Builder().setTimeGateway((TimeGateway)this.mTimeGateway).setStateStore(stateStore);
        evaluatorConfigBuilder.setDynamicTypesQuotaManager(dynamicNodeQuotaManager);
        if (sensorGateway != null) {
            evaluatorConfigBuilder.setSensorGateway(sensorGateway);
        }
        if (enableAnimations) {
            evaluatorConfigBuilder.setAnimationQuotaManager(animationQuotaManager);
        }
        DynamicTypeEvaluator.Config evaluatorConfig = evaluatorConfigBuilder.build();
        this.mEvaluator = new DynamicTypeEvaluator(evaluatorConfig);
    }

    @VisibleForTesting
    public int size() {
        return this.mPositionIdTree.getAllNodes().stream().mapToInt(NodeInfo::size).sum();
    }

    @UiThread
    void clear() {
        this.mPositionIdTree.clear();
    }

    @UiThread
    void removeChildNodesFor(@NonNull String posId) {
        this.mPositionIdTree.removeChildNodesFor(posId);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public PipelineMaker newPipelineMaker(@NonNull BiFunction<ModifiersProto.EnterTransition, View, AnimationSet> enterAnimationInflator, @NonNull BiFunction<ModifiersProto.ExitTransition, View, AnimationSet> exitAnimationInflator) {
        return new PipelineMaker(this, enterAnimationInflator, exitAnimationInflator, this.mEvaluator);
    }

    @VisibleForTesting
    @NonNull
    public PipelineMaker newPipelineMaker() {
        return this.newPipelineMaker((enterTransition, view) -> new AnimationSet(false), (exitTransition, view) -> new AnimationSet(false));
    }

    @UiThread
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setUpdatesEnabled(boolean canUpdate) {
        if (canUpdate) {
            this.mTimeGateway.enableUpdates();
        } else {
            this.mTimeGateway.disableUpdates();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void close() {
        this.mPositionIdTree.clear();
        this.mTimeGateway.close();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @UiThread
    public void initWithoutContentTransition() {
        this.initNewLayout();
    }

    @UiThread
    void initNewLayout() {
        if (this.mFullyVisible) {
            this.playAvdAnimations(TriggerProto.Trigger.InnerCase.ON_VISIBLE_TRIGGER);
            this.playAvdAnimations(TriggerProto.Trigger.InnerCase.ON_VISIBLE_ONCE_TRIGGER);
        }
        this.playAvdAnimations(TriggerProto.Trigger.InnerCase.ON_LOAD_TRIGGER);
        this.setAnimationVisibility(this.mFullyVisible);
        this.mPositionIdTree.forEach(nodeInfo -> nodeInfo.getFailedBindingRequest().removeIf(request -> this.retryBindingRequest((NodeInfo)nodeInfo, (DynamicTypeBindingRequest)request)));
        this.mPositionIdTree.forEach(NodeInfo::initPendingBoundTypes);
    }

    private boolean retryBindingRequest(NodeInfo nodeInfo, DynamicTypeBindingRequest request) {
        BoundDynamicType dynamicType = null;
        try {
            dynamicType = this.mEvaluator.bind(request);
            nodeInfo.addBoundType(dynamicType);
            return true;
        }
        catch (DynamicTypeEvaluator.EvaluationException exception) {
            Log.v((String)TAG, (String)"Retry to bind dynamicType failed.", (Throwable)exception);
            return false;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @VisibleForTesting(otherwise=3)
    public void playAvdAnimations(@NonNull TriggerProto.Trigger.InnerCase triggerCase) {
        this.mPositionIdTree.forEach(info -> info.playAvdAnimations(triggerCase));
    }

    @UiThread
    private void setAnimationVisibility(boolean visible) {
        this.mPositionIdTree.forEach(info -> info.setVisibility(visible));
    }

    @UiThread
    @VisibleForTesting(otherwise=3)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void resetAvdAnimations(@NonNull TriggerProto.Trigger.InnerCase triggerCase) {
        this.mPositionIdTree.forEach(info -> info.resetAvdAnimations(triggerCase));
    }

    @UiThread
    @VisibleForTesting(otherwise=3)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void stopAvdAnimations(@NonNull TriggerProto.Trigger.InnerCase triggerCase) {
        this.mPositionIdTree.forEach(info -> info.stopAvdAnimations(triggerCase));
    }

    @UiThread
    void cancelContentTransitionAnimations() {
        this.mExitAnimations.forEach(QuotaAwareAnimationSet::cancelAnimations);
        this.mExitAnimations.clear();
        this.mEnterAnimations.forEach(QuotaAwareAnimationSet::cancelAnimations);
        this.mEnterAnimations.clear();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @UiThread
    public void setFullyVisible(boolean fullyVisible) {
        if (this.mFullyVisible == fullyVisible) {
            return;
        }
        this.mFullyVisible = fullyVisible;
        this.setAnimationVisibility(fullyVisible);
        if (fullyVisible) {
            this.playAvdAnimations(TriggerProto.Trigger.InnerCase.ON_VISIBLE_TRIGGER);
            this.playAvdAnimations(TriggerProto.Trigger.InnerCase.ON_VISIBLE_ONCE_TRIGGER);
        } else {
            this.cancelContentTransitionAnimations();
            this.stopAvdAnimations(TriggerProto.Trigger.InnerCase.ON_VISIBLE_TRIGGER);
            this.resetAvdAnimations(TriggerProto.Trigger.InnerCase.ON_VISIBLE_TRIGGER);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @Nullable
    public Long getSeekableAnimationTotalDurationMillis(@NonNull String sourceKey) {
        NodeInfo node = this.mPositionIdTree.findFirst(nodeInfo -> nodeInfo.getSeekableAnimationTotalDurationMillis(sourceKey) != null);
        if (node != null) {
            return node.getSeekableAnimationTotalDurationMillis(sourceKey);
        }
        return null;
    }

    @UiThread
    @NonNull
    List<NodeInfo> getNodesAffectedBy(@NonNull String posId, @NonNull Predicate<NodeInfo> predicate) {
        List<NodeInfo> affectedNodes = this.mPositionIdTree.findAncestorsFor(posId, predicate);
        NodeInfo currentNode = this.mPositionIdTree.get(posId);
        if (currentNode != null && predicate.test(currentNode)) {
            affectedNodes.add(currentNode);
        }
        return affectedNodes;
    }

    @VisibleForTesting
    public int getRunningAnimationsCount() {
        return this.mPositionIdTree.getAllNodes().stream().mapToInt(NodeInfo::getRunningAnimationCount).sum() + this.mEnterAnimations.stream().mapToInt(QuotaAwareAnimationSet::getRunningAnimationCount).sum() + this.mExitAnimations.stream().mapToInt(QuotaAwareAnimationSet::getRunningAnimationCount).sum();
    }

    @VisibleForTesting
    public int getDynamicExpressionsNodesCount() {
        return this.mPositionIdTree.getAllNodes().stream().mapToInt(NodeInfo::getExpressionNodesCount).sum();
    }

    @VisibleForTesting
    public boolean isAllQuotaReleased() {
        return this.mAnimationQuotaManager instanceof FixedQuotaManagerImpl && ((FixedQuotaManagerImpl)this.mAnimationQuotaManager).isAllQuotaReleased();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final class PipelineMaker {
        @NonNull
        private final ProtoLayoutDynamicDataPipeline mPipeline;
        @NonNull
        private final BiFunction<ModifiersProto.EnterTransition, View, AnimationSet> mEnterAnimationInflator;
        @NonNull
        private final BiFunction<ModifiersProto.ExitTransition, View, AnimationSet> mExitAnimationInflator;
        @NonNull
        private final Map<String, NodeInfo> mPosIdToNodeInfo = new ArrayMap();
        @NonNull
        private final List<String> mNodesPendingChildrenRemoval = new ArrayList<String>();
        @NonNull
        private final Set<String> mChangedNodes = new ArraySet();
        @NonNull
        private final Set<String> mParentsOfChangedNodes = new ArraySet();
        @NonNull
        private final DynamicTypeEvaluator mEvaluator;
        private int mExitAnimationsCounter = 0;

        PipelineMaker(@NonNull ProtoLayoutDynamicDataPipeline pipeline, @NonNull BiFunction<ModifiersProto.EnterTransition, View, AnimationSet> enterAnimationInflator, @NonNull BiFunction<ModifiersProto.ExitTransition, View, AnimationSet> exitAnimationInflator, @NonNull DynamicTypeEvaluator evaluator) {
            this.mPipeline = pipeline;
            this.mEnterAnimationInflator = enterAnimationInflator;
            this.mExitAnimationInflator = exitAnimationInflator;
            this.mEvaluator = evaluator;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @UiThread
        public void clearDataPipelineAndCommit(@NonNull ViewGroup parentView, boolean isReattaching) {
            this.mPipeline.clear();
            this.commit(parentView, isReattaching);
        }

        @UiThread
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public void playExitAnimations(@NonNull ViewGroup parentView, boolean isReattaching, @Nullable Runnable onEnd) {
            this.mPipeline.cancelContentTransitionAnimations();
            if (!isReattaching && this.mPipeline.mFullyVisible && this.mPipeline.mEnableAnimations) {
                ArrayMap animatingNodes = new ArrayMap();
                for (String string : this.mParentsOfChangedNodes) {
                    this.mPipeline.mPositionIdTree.findChildrenFor(string).forEach(arg_0 -> this.lambda$playExitAnimations$0((Map)animatingNodes, arg_0));
                }
                for (String string : this.mChangedNodes) {
                    this.addAffectedExitAnimations(string, (Map<String, ModifiersProto.ExitTransition>)animatingNodes);
                }
                this.mExitAnimationsCounter = 0;
                for (Map.Entry entry : animatingNodes.entrySet()) {
                    AnimationSet animationSet;
                    View associatedView = parentView.findViewWithTag(entry.getKey());
                    if (associatedView == null || (animationSet = this.mExitAnimationInflator.apply((ModifiersProto.ExitTransition)Preconditions.checkNotNull((Object)((ModifiersProto.ExitTransition)entry.getValue())), associatedView)) == null || animationSet.getAnimations().isEmpty()) continue;
                    QuotaAwareAnimationSet quotaAwareAnimationSet = new QuotaAwareAnimationSet(animationSet, this.mPipeline.mAnimationQuotaManager, associatedView, () -> {
                        if (onEnd != null) {
                            --this.mExitAnimationsCounter;
                            if (this.mExitAnimationsCounter == 0) {
                                this.mPipeline.mExitAnimations.clear();
                                onEnd.run();
                            }
                        }
                    });
                    quotaAwareAnimationSet.tryStartAnimation(() -> {
                        ++this.mExitAnimationsCounter;
                        this.mPipeline.mExitAnimations.add(quotaAwareAnimationSet);
                    });
                }
            }
            if (this.mPipeline.mExitAnimations.isEmpty() && onEnd != null) {
                onEnd.run();
            }
        }

        private void addAffectedExitAnimations(@NonNull String changedNode, @NonNull Map<String, ModifiersProto.ExitTransition> animatingNodes) {
            List<NodeInfo> nodesAffectedBy = this.mPipeline.getNodesAffectedBy(changedNode, node -> {
                ModifiersProto.AnimatedVisibility animatedVisibility = node.getAnimatedVisibility();
                return animatedVisibility != null && animatedVisibility.hasExitTransition();
            });
            for (NodeInfo affectedNode : nodesAffectedBy) {
                animatingNodes.putIfAbsent(affectedNode.getPosId(), ((ModifiersProto.AnimatedVisibility)Preconditions.checkNotNull((Object)affectedNode.getAnimatedVisibility())).getExitTransition());
            }
        }

        @UiThread
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public void commit(@NonNull ViewGroup parentView, boolean isReattaching) {
            for (String string : this.mNodesPendingChildrenRemoval) {
                this.mPipeline.removeChildNodesFor(string);
            }
            this.mNodesPendingChildrenRemoval.clear();
            for (Map.Entry entry : this.mPosIdToNodeInfo.entrySet()) {
                String key = (String)entry.getKey();
                if (key.isEmpty()) {
                    Log.e((String)ProtoLayoutDynamicDataPipeline.TAG, (String)"Ignoring empty posId.");
                    continue;
                }
                this.mPipeline.mPositionIdTree.addOrReplace(key, (NodeInfo)entry.getValue());
            }
            if (isReattaching || !this.mPipeline.mFullyVisible) {
                this.mChangedNodes.clear();
            }
            parentView.post(() -> {
                this.mPipeline.initNewLayout();
                this.playEnterAnimations(parentView, isReattaching);
            });
        }

        @UiThread
        private void playEnterAnimations(@NonNull ViewGroup parentView, boolean isReattaching) {
            this.mPipeline.mEnterAnimations.forEach(QuotaAwareAnimationSet::cancelAnimations);
            this.mPipeline.mEnterAnimations.clear();
            if (isReattaching || !this.mPipeline.mFullyVisible || !this.mPipeline.mEnableAnimations) {
                return;
            }
            ArrayMap animatingNodes = new ArrayMap();
            for (String string : this.mChangedNodes) {
                List<NodeInfo> nodesAffectedBy = this.mPipeline.getNodesAffectedBy(string, node -> {
                    ModifiersProto.AnimatedVisibility animatedVisibility = node.getAnimatedVisibility();
                    return animatedVisibility != null && animatedVisibility.hasEnterTransition();
                });
                for (NodeInfo affectedNode : nodesAffectedBy) {
                    animatingNodes.putIfAbsent(affectedNode.getPosId(), ((ModifiersProto.AnimatedVisibility)Preconditions.checkNotNull((Object)affectedNode.getAnimatedVisibility())).getEnterTransition());
                }
            }
            for (Map.Entry entry : animatingNodes.entrySet()) {
                AnimationSet animationSet;
                View associatedView = parentView.findViewWithTag(entry.getKey());
                if (associatedView == null || (animationSet = this.mEnterAnimationInflator.apply((ModifiersProto.EnterTransition)Preconditions.checkNotNull((Object)((ModifiersProto.EnterTransition)entry.getValue())), associatedView)) == null || animationSet.getAnimations().isEmpty()) continue;
                QuotaAwareAnimationSet quotaAwareAnimationSet = new QuotaAwareAnimationSet(animationSet, this.mPipeline.mAnimationQuotaManager, associatedView);
                quotaAwareAnimationSet.tryStartAnimation(() -> this.mPipeline.mEnterAnimations.add(quotaAwareAnimationSet));
            }
        }

        @NonNull
        private NodeInfo getNodeInfo(@NonNull String posId) {
            return this.mPosIdToNodeInfo.computeIfAbsent(posId, k -> new NodeInfo(posId, this.mPipeline.mAnimationQuotaManager));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull DynamicProto.DynamicString stringSource, @NonNull Locale locale, @NonNull String posId, @NonNull DynamicTypeValueReceiver<String> consumer) {
            DynamicTypeBindingRequest bindingRequest = DynamicTypeBindingRequest.forDynamicStringInternal((DynamicProto.DynamicString)stringSource, (ULocale)ULocale.forLocale((Locale)locale), consumer);
            this.tryBindRequest(posId, bindingRequest, () -> consumer.onInvalidated());
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull DynamicProto.DynamicInt32 int32Source, int invalidData, @NonNull String posId, @NonNull Consumer<Integer> consumer) {
            return this.addPipelineFor(int32Source, posId, this.buildStateUpdateCallback(invalidData, consumer));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull DynamicProto.DynamicInt32 int32Source, @NonNull String posId, @NonNull DynamicTypeValueReceiver<Integer> consumer) {
            DynamicTypeBindingRequest bindingRequest = DynamicTypeBindingRequest.forDynamicInt32Internal((DynamicProto.DynamicInt32)int32Source, consumer);
            this.tryBindRequest(posId, bindingRequest, () -> consumer.onInvalidated());
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull DynamicProto.DynamicString stringSource, @NonNull String invalidData, @NonNull Locale locale, @NonNull String posId, @NonNull Consumer<String> consumer) {
            return this.addPipelineFor(stringSource, locale, posId, this.buildStateUpdateCallback(invalidData, consumer));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull DynamicProto.DynamicFloat floatSource, @NonNull String posId, @NonNull DynamicTypeValueReceiver<Float> consumer) {
            DynamicTypeBindingRequest bindingRequest = DynamicTypeBindingRequest.forDynamicFloatInternal((DynamicProto.DynamicFloat)floatSource, consumer);
            this.tryBindRequest(posId, bindingRequest, () -> consumer.onInvalidated());
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull DynamicProto.DynamicFloat floatSource, float invalidData, @NonNull String posId, @NonNull Consumer<Float> consumer) {
            return this.addPipelineFor(floatSource, posId, this.buildStateUpdateCallback(Float.valueOf(invalidData), consumer));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull DynamicProto.DynamicColor colorSource, @NonNull String posId, @NonNull DynamicTypeValueReceiver<Integer> consumer) {
            DynamicTypeBindingRequest bindingRequest = DynamicTypeBindingRequest.forDynamicColorInternal((DynamicProto.DynamicColor)colorSource, consumer);
            this.tryBindRequest(posId, bindingRequest, () -> consumer.onInvalidated());
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull DynamicProto.DynamicColor colorSource, int invalidData, @NonNull String posId, @NonNull Consumer<Integer> consumer) {
            return this.addPipelineFor(colorSource, posId, this.buildStateUpdateCallback(invalidData, consumer));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull DynamicProto.DynamicBool boolSource, @NonNull String posId, @NonNull Runnable triggerAnimationRunnable) {
            DynamicTypeValueReceiver<Boolean> consumer = PipelineMaker.buildBooleanConditionTriggerCallback(triggerAnimationRunnable, this.mPipeline.mAnimationQuotaManager);
            return this.addPipelineFor(boolSource, posId, consumer);
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull DynamicProto.DynamicBool boolSource, @NonNull String posId, @NonNull DynamicTypeValueReceiver<Boolean> consumer) {
            DynamicTypeBindingRequest bindingRequest = DynamicTypeBindingRequest.forDynamicBoolInternal((DynamicProto.DynamicBool)boolSource, consumer);
            this.tryBindRequest(posId, bindingRequest, () -> consumer.onInvalidated());
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull DynamicProto.DynamicBool boolSource, boolean invalidData, @NonNull String posId, @NonNull Consumer<Boolean> consumer) {
            return this.addPipelineFor(boolSource, posId, this.buildStateUpdateCallback(invalidData, consumer));
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public PipelineMaker addPipelineFor(@NonNull DimensionProto.DpProp dpProp, @NonNull String posId, @NonNull DynamicTypeValueReceiver<Float> consumer) {
            DynamicTypeBindingRequest bindingRequest = DynamicTypeBindingRequest.forDynamicFloatInternal((DynamicProto.DynamicFloat)dpProp.getDynamicValue(), consumer);
            this.tryBindRequest(posId, bindingRequest, () -> consumer.onInvalidated());
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull DimensionProto.DegreesProp degreesProp, @NonNull String posId, @NonNull DynamicTypeValueReceiver<Float> consumer) {
            DynamicTypeBindingRequest bindingRequest = DynamicTypeBindingRequest.forDynamicFloatInternal((DynamicProto.DynamicFloat)degreesProp.getDynamicValue(), consumer);
            this.tryBindRequest(posId, bindingRequest, () -> consumer.onInvalidated());
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull ColorProto.ColorProp colorProp, @NonNull String posId, @NonNull DynamicTypeValueReceiver<Integer> consumer) {
            DynamicTypeBindingRequest bindingRequest = DynamicTypeBindingRequest.forDynamicColorInternal((DynamicProto.DynamicColor)colorProp.getDynamicValue(), consumer);
            this.tryBindRequest(posId, bindingRequest, () -> consumer.onInvalidated());
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull DimensionProto.DpProp dpProp, float invalidData, @NonNull String posId, @NonNull Consumer<Float> consumer) {
            return this.addPipelineFor(dpProp, posId, this.buildStateUpdateCallback(Float.valueOf(invalidData), consumer));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull DimensionProto.DegreesProp degreesProp, float invalidData, @NonNull String posId, @NonNull Consumer<Float> consumer) {
            return this.addPipelineFor(degreesProp, posId, this.buildStateUpdateCallback(Float.valueOf(invalidData), consumer));
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addPipelineFor(@NonNull ColorProto.ColorProp colorProp, int invalidData, @NonNull String posId, @NonNull Consumer<Integer> consumer) {
            return this.addPipelineFor(colorProp, posId, this.buildStateUpdateCallback(invalidData, consumer));
        }

        private void tryBindRequest(String posId, DynamicTypeBindingRequest request, Runnable onFailure) {
            BoundDynamicType dynamicType = null;
            NodeInfo nodeInfo = this.getNodeInfo(posId);
            try {
                dynamicType = this.mEvaluator.bind(request);
                nodeInfo.addBoundType(dynamicType);
            }
            catch (DynamicTypeEvaluator.EvaluationException exception) {
                Log.e((String)ProtoLayoutDynamicDataPipeline.TAG, (String)"Fails to bind dynamicType.", (Throwable)exception);
                nodeInfo.addFailedBindingRequest(request);
                onFailure.run();
            }
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @SuppressLint(value={"CheckReturnValue"})
        @NonNull
        public PipelineMaker addResolvedAnimatedImage(@NonNull AnimatedVectorDrawable drawable, @NonNull TriggerProto.Trigger trigger, @NonNull String posId) {
            if (!this.mPipeline.mEnableAnimations) {
                Log.w((String)ProtoLayoutDynamicDataPipeline.TAG, (String)"Cannot use ResolvedAnimationImage; animations are disabled.");
                return this;
            }
            this.getNodeInfo(posId).addResolvedAvd(drawable, trigger);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker addResolvedAnimatedImageWithBoolTrigger(@NonNull AnimatedVectorDrawable drawable, @NonNull TriggerProto.Trigger trigger, @NonNull String posId, @NonNull DynamicProto.DynamicBool boolTrigger) {
            if (!this.mPipeline.mEnableAnimations) {
                Log.w((String)ProtoLayoutDynamicDataPipeline.TAG, (String)"Cannot use ResolvedAnimationImage; animations are disabled.");
                return this;
            }
            if (trigger.getInnerCase() != TriggerProto.Trigger.InnerCase.ON_CONDITION_MET_TRIGGER) {
                Log.w((String)ProtoLayoutDynamicDataPipeline.TAG, (String)"Wrong trigger type.");
                return this;
            }
            NodeInfo.ResolvedAvd avd = this.getNodeInfo(posId).addResolvedAvd(drawable, trigger);
            this.addPipelineFor(boolTrigger, posId, avd::startAnimation);
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public PipelineMaker addResolvedSeekableAnimatedImage(@NonNull SeekableAnimatedVectorDrawable seekableDrawable, @NonNull DynamicProto.DynamicFloat boundProgress, @NonNull String posId) {
            if (!this.mPipeline.mEnableAnimations) {
                Log.w((String)ProtoLayoutDynamicDataPipeline.TAG, (String)"Cannot use ResolveSeekableAvd; animations are disabled.");
                return this;
            }
            this.addPipelineFor(boundProgress, 0.0f, posId, (Float aFloat) -> {
                float progress = Math.max(0.0f, Math.min(aFloat.floatValue(), 1.0f));
                seekableDrawable.setCurrentPlayTime((long)(progress * (float)seekableDrawable.getTotalDuration()));
            });
            this.getNodeInfo(posId).addResolvedSeekableAvd(new NodeInfo.ResolvedSeekableAvd(seekableDrawable, boundProgress));
            return this;
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public PipelineMaker storeAnimatedVisibilityFor(@NonNull String posId, @NonNull ModifiersProto.AnimatedVisibility animatedVisibility) {
            if (!this.mPipeline.mEnableAnimations) {
                Log.w((String)ProtoLayoutDynamicDataPipeline.TAG, (String)"Can't use AnimatedVisibility; animations are disabled.");
                return this;
            }
            this.getNodeInfo(posId).setAnimatedVisibility(animatedVisibility);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker markNodeAsChanged(@NonNull String posId, boolean includePreviousChildren) {
            if (this.mPipeline.mEnableAnimations) {
                this.mChangedNodes.add(posId);
                this.mParentsOfChangedNodes.add(posId);
            }
            return this;
        }

        @NonNull
        private static DynamicTypeValueReceiver<Boolean> buildBooleanConditionTriggerCallback(final @NonNull Runnable triggerAnimationRunnable, final @NonNull QuotaManager quotaManager) {
            return new DynamicTypeValueReceiver<Boolean>(){
                private boolean mCurrent;

                public void onData(@NonNull Boolean newData) {
                    if (newData.booleanValue() && !this.mCurrent && quotaManager.tryAcquireQuota(1)) {
                        triggerAnimationRunnable.run();
                    }
                    this.mCurrent = newData;
                }

                public void onInvalidated() {
                }
            };
        }

        @NonNull
        private <T> DynamicTypeValueReceiver<T> buildStateUpdateCallback(final @NonNull T invalidData, final @NonNull Consumer<T> consumer) {
            return new DynamicTypeValueReceiver<T>(){

                public void onData(@NonNull T newData) {
                    consumer.accept(newData);
                }

                public void onInvalidated() {
                    consumer.accept(invalidData);
                }
            };
        }

        @NonNull
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        public PipelineMaker markForChildRemoval(@NonNull String nodePosId) {
            this.mNodesPendingChildrenRemoval.add(nodePosId);
            return this;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NonNull
        public PipelineMaker rememberNode(@NonNull String nodePosId) {
            NodeInfo ignored = this.getNodeInfo(nodePosId);
            return this;
        }

        private /* synthetic */ void lambda$playExitAnimations$0(Map animatingNodes, NodeInfo node) {
            this.addAffectedExitAnimations(node.getPosId(), animatingNodes);
        }
    }
}

