/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.dynamicdata;

import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.core.os.HandlerCompat;
import androidx.wear.protolayout.expression.pipeline.QuotaManager;
import java.util.concurrent.atomic.AtomicBoolean;

final class QuotaAwareAnimationSet {
    @NonNull
    private final AnimationSet mAnimationSet;
    @NonNull
    private final QuotaManager mQuotaManager;
    @NonNull
    private final View mAssociatedView;
    @NonNull
    private final QuotaReleasingAnimationListener mListener;
    @Nullable
    private final Runnable mOnAnimationEnd;
    private final long mCommonDelay;
    @NonNull
    private final Handler mUiHandler;
    @NonNull
    private final Runnable mTryAcquireQuotaAndStartAnimation = this::tryAcquireQuotaAndStartAnimation;

    QuotaAwareAnimationSet(@NonNull AnimationSet animation, @NonNull QuotaManager quotaManager, @NonNull View associatedView) {
        this(animation, quotaManager, associatedView, null);
    }

    QuotaAwareAnimationSet(@NonNull AnimationSet animation, @NonNull QuotaManager quotaManager, @NonNull View associatedView, @Nullable Runnable onAnimationEnd) {
        this.mAnimationSet = animation;
        this.mQuotaManager = quotaManager;
        this.mAssociatedView = associatedView;
        this.mOnAnimationEnd = onAnimationEnd;
        this.mUiHandler = new Handler(Looper.getMainLooper());
        this.mCommonDelay = this.mAnimationSet.getAnimations().stream().mapToLong(Animation::getStartOffset).min().orElse(0L);
        this.mAnimationSet.getAnimations().forEach(anim -> anim.setStartOffset(anim.getStartOffset() - this.mCommonDelay));
        this.mListener = new QuotaReleasingAnimationListener(this.mQuotaManager, animation.getAnimations().size(), onAnimationEnd);
        this.mAnimationSet.setAnimationListener((Animation.AnimationListener)this.mListener);
    }

    @UiThread
    void tryStartAnimation(@NonNull Runnable beforeAnimationStart) {
        if (this.getRunningAnimationCount() > 0) {
            return;
        }
        beforeAnimationStart.run();
        if (this.mCommonDelay > 0L) {
            if (!HandlerCompat.hasCallbacks((Handler)this.mUiHandler, (Runnable)this.mTryAcquireQuotaAndStartAnimation)) {
                this.mUiHandler.postDelayed(this.mTryAcquireQuotaAndStartAnimation, this.mCommonDelay);
            }
        } else {
            this.tryAcquireQuotaAndStartAnimation();
        }
    }

    @UiThread
    private void tryAcquireQuotaAndStartAnimation() {
        if (this.mQuotaManager.tryAcquireQuota(this.mAnimationSet.getAnimations().size())) {
            this.mListener.mIsUsingQuota.set(true);
            this.mAssociatedView.startAnimation((Animation)this.mAnimationSet);
        } else if (this.mOnAnimationEnd != null) {
            this.mOnAnimationEnd.run();
        }
    }

    @UiThread
    void cancelAnimations() {
        this.mAnimationSet.cancel();
        this.mListener.onAnimationEnd((Animation)this.mAnimationSet);
        this.mUiHandler.removeCallbacks(this.mTryAcquireQuotaAndStartAnimation);
    }

    int getRunningAnimationCount() {
        return this.mAnimationSet.hasStarted() && !this.mAnimationSet.hasEnded() ? this.mAnimationSet.getAnimations().size() : 0;
    }

    private static final class QuotaReleasingAnimationListener
    implements Animation.AnimationListener {
        @Nullable
        private final Runnable mOnAnimationEnd;
        @NonNull
        private final QuotaManager mQuotaManager;
        private final int mAnimationNum;
        @NonNull
        final AtomicBoolean mIsUsingQuota = new AtomicBoolean(false);

        QuotaReleasingAnimationListener(@NonNull QuotaManager mQuotaManager, int animationNum, @Nullable Runnable mOnAnimationEnd) {
            this.mOnAnimationEnd = mOnAnimationEnd;
            this.mQuotaManager = mQuotaManager;
            this.mAnimationNum = animationNum;
        }

        @UiThread
        public void onAnimationStart(@NonNull Animation animation) {
        }

        @UiThread
        public void onAnimationEnd(@NonNull Animation animation) {
            if (this.mIsUsingQuota.compareAndSet(true, false)) {
                this.mQuotaManager.releaseQuota(this.mAnimationNum);
                if (this.mOnAnimationEnd != null) {
                    this.mOnAnimationEnd.run();
                }
            }
        }

        @UiThread
        public void onAnimationRepeat(@NonNull Animation animation) {
        }
    }
}

