/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.impl;

import android.content.Context;
import android.content.res.Resources;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.util.Preconditions;
import androidx.wear.protolayout.expression.pipeline.FixedQuotaManagerImpl;
import androidx.wear.protolayout.expression.pipeline.QuotaManager;
import androidx.wear.protolayout.expression.pipeline.StateStore;
import androidx.wear.protolayout.expression.pipeline.sensor.SensorGateway;
import androidx.wear.protolayout.proto.LayoutElementProto;
import androidx.wear.protolayout.proto.ResourceProto;
import androidx.wear.protolayout.proto.StateProto;
import androidx.wear.protolayout.renderer.ProtoLayoutExtensionViewProvider;
import androidx.wear.protolayout.renderer.ProtoLayoutTheme;
import androidx.wear.protolayout.renderer.dynamicdata.ProtoLayoutDynamicDataPipeline;
import androidx.wear.protolayout.renderer.inflater.ProtoLayoutInflater;
import androidx.wear.protolayout.renderer.inflater.ProtoLayoutThemeImpl;
import androidx.wear.protolayout.renderer.inflater.RenderedMetadata;
import androidx.wear.protolayout.renderer.inflater.ResourceResolvers;
import androidx.wear.protolayout.renderer.inflater.StandardResourceResolvers;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.SettableFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class ProtoLayoutViewInstance
implements AutoCloseable {
    private static final int DEFAULT_MAX_CONCURRENT_RUNNING_ANIMATIONS = 4;
    @NonNull
    private static final String TAG = "ProtoLayoutViewInstance";
    @NonNull
    private final Context mUiContext;
    @NonNull
    private final Resources mRendererResources;
    @NonNull
    private final ResourceResolversProvider mResourceResolversProvider;
    @NonNull
    private final ProtoLayoutTheme mProtoLayoutTheme;
    @Nullable
    private final ProtoLayoutDynamicDataPipeline mDataPipeline;
    @NonNull
    private final LoadActionListener mLoadActionListener;
    @NonNull
    private final ListeningExecutorService mUiExecutorService;
    @NonNull
    private final ListeningExecutorService mBgExecutorService;
    @NonNull
    private final String mClickableIdExtra;
    @Nullable
    private final ProtoLayoutExtensionViewProvider mExtensionViewProvider;
    private final boolean mAnimationEnabled;
    private final boolean mAdaptiveUpdateRatesEnabled;
    private boolean mWasFullyVisibleBefore;
    @Nullable
    private ViewGroup mInflateParent = null;
    @Nullable
    private ViewGroup mAttachParent = null;
    @Nullable
    private LayoutElementProto.Layout mPrevLayout = null;
    @VisibleForTesting
    @Nullable
    ListenableFuture<RenderResult> mRenderFuture = null;
    private boolean mCanReattachWithoutRendering = false;
    private static final int DYNAMIC_NODES_MAX_COUNT = Integer.MAX_VALUE;

    public ProtoLayoutViewInstance(@NonNull Config config) {
        this.mUiContext = config.getUiContext();
        this.mRendererResources = config.getRendererResources();
        this.mResourceResolversProvider = config.getResourceResolversProvider();
        this.mProtoLayoutTheme = ProtoLayoutThemeImpl.defaultTheme(this.mUiContext);
        this.mLoadActionListener = config.getLoadActionListener();
        this.mUiExecutorService = config.getUiExecutorService();
        this.mBgExecutorService = config.getBgExecutorService();
        this.mExtensionViewProvider = config.getExtensionViewProvider();
        this.mAnimationEnabled = config.getAnimationEnabled();
        this.mClickableIdExtra = config.getClickableIdExtra();
        this.mAdaptiveUpdateRatesEnabled = config.getAdaptiveUpdateRatesEnabled();
        this.mWasFullyVisibleBefore = false;
        StateStore stateStore = config.getStateStore();
        if (stateStore != null) {
            this.mDataPipeline = config.getAnimationEnabled() ? new ProtoLayoutDynamicDataPipeline(config.getSensorGateway(), stateStore, (QuotaManager)new FixedQuotaManagerImpl(config.getRunningAnimationsLimit()), (QuotaManager)new FixedQuotaManagerImpl(Integer.MAX_VALUE)) : new ProtoLayoutDynamicDataPipeline(config.getSensorGateway(), stateStore);
            this.mDataPipeline.setFullyVisible(config.getIsViewFullyVisible());
        } else {
            this.mDataPipeline = null;
        }
    }

    @WorkerThread
    @NonNull
    private RenderResult renderOrComputeMutations(@NonNull LayoutElementProto.Layout layout, @NonNull ResourceProto.Resources resources, @Nullable RenderedMetadata prevRenderedMetadata) {
        ResourceResolvers resolvers = this.mResourceResolversProvider.getResourceResolvers(this.mUiContext, resources, this.mUiExecutorService, this.mAnimationEnabled);
        if (resolvers == null) {
            Log.w((String)TAG, (String)"Resource resolvers cannot be retrieved.");
            return new FailedRenderResult();
        }
        ProtoLayoutInflater.Config.Builder inflaterConfigBuilder = new ProtoLayoutInflater.Config.Builder(this.mUiContext, layout, resolvers).setLoadActionExecutor((Executor)this.mUiExecutorService).setLoadActionListener(this.mLoadActionListener::onClick).setRendererResources(this.mRendererResources).setProtoLayoutTheme(this.mProtoLayoutTheme).setAnimationEnabled(this.mAnimationEnabled).setClickableIdExtra(this.mClickableIdExtra).setAllowLayoutChangingBindsWithoutDefault(true);
        if (this.mDataPipeline != null) {
            inflaterConfigBuilder.setDynamicDataPipeline(this.mDataPipeline);
        }
        if (this.mExtensionViewProvider != null) {
            inflaterConfigBuilder.setExtensionViewProvider(this.mExtensionViewProvider);
        }
        ProtoLayoutInflater inflater = new ProtoLayoutInflater(inflaterConfigBuilder.build());
        ProtoLayoutInflater.ViewGroupMutation mutation = null;
        if (this.mAdaptiveUpdateRatesEnabled && prevRenderedMetadata != null) {
            try {
                mutation = inflater.computeMutation(prevRenderedMetadata, layout);
            }
            catch (UnsupportedOperationException ex) {
                Log.w((String)TAG, (String)"Error computing mutation.", (Throwable)ex);
            }
        }
        if (mutation == null) {
            InflateParentData inflateParentData = this.inflateIntoNewParent(this.mUiContext, inflater);
            if (inflateParentData.mInflateResult == null) {
                return new FailedRenderResult();
            }
            return new InflatedIntoNewParentRenderResult(inflateParentData);
        }
        if (mutation.isNoOp()) {
            return new UnchangedRenderResult();
        }
        Preconditions.checkNotNull((Object)prevRenderedMetadata);
        return new ApplyToPrevParentRenderResult(inflater, mutation);
    }

    @WorkerThread
    @NonNull
    private InflateParentData inflateIntoNewParent(@NonNull Context uiContext, @NonNull ProtoLayoutInflater inflater) {
        FrameLayout inflateParent = new FrameLayout(uiContext);
        int gravity = 17;
        ProtoLayoutInflater.InflateResult result = inflater.inflate((ViewGroup)inflateParent);
        if (inflateParent.getChildCount() > 0) {
            View firstChild = inflateParent.getChildAt(0);
            FrameLayout.LayoutParams childLp = (FrameLayout.LayoutParams)firstChild.getLayoutParams();
            childLp.gravity = gravity;
            firstChild.setLayoutParams((ViewGroup.LayoutParams)childLp);
        }
        return new InflateParentData(result);
    }

    @UiThread
    @NonNull
    public ListenableFuture<Void> renderAndAttach(@NonNull LayoutElementProto.Layout layout, @NonNull ResourceProto.Resources resources, @NonNull ViewGroup parent) {
        ViewGroup prevInflateParent;
        RenderedMetadata prevRenderedMetadata;
        if (this.mAttachParent == null) {
            this.mAttachParent = parent;
            this.mAttachParent.removeAllViews();
            if (this.mInflateParent != null) {
                this.mAttachParent.addView((View)this.mInflateParent);
            }
        } else if (this.mAttachParent != parent) {
            throw new IllegalStateException("ProtoLayoutViewInstance is already attached!");
        }
        if (layout == this.mPrevLayout && this.mInflateParent != null) {
            return Futures.immediateVoidFuture();
        }
        boolean isReattaching = false;
        if (this.mRenderFuture != null) {
            if (!this.mRenderFuture.isDone()) {
                Log.w((String)TAG, (String)"Skipped layout update: previous layout update hasn't finished yet.");
                return Futures.immediateCancelledFuture();
            }
            if (layout == this.mPrevLayout && this.mCanReattachWithoutRendering) {
                isReattaching = true;
            } else {
                this.mRenderFuture = null;
            }
        }
        RenderedMetadata renderedMetadata = prevRenderedMetadata = (prevInflateParent = ProtoLayoutViewInstance.getOnlyChildViewGroup(this.mAttachParent)) != null ? ProtoLayoutInflater.getRenderedMetadata(prevInflateParent) : null;
        if (this.mRenderFuture == null) {
            this.mPrevLayout = layout;
            this.mRenderFuture = this.mBgExecutorService.submit(() -> this.renderOrComputeMutations(layout, resources, prevRenderedMetadata));
            this.mCanReattachWithoutRendering = false;
        }
        SettableFuture result = SettableFuture.create();
        if (!((ListenableFuture)Preconditions.checkNotNull(this.mRenderFuture)).isDone()) {
            this.mRenderFuture.addListener(() -> {
                if (this.mAttachParent == parent) {
                    try {
                        result.setFuture(this.postInflate(parent, prevInflateParent, (RenderResult)((ListenableFuture)Preconditions.checkNotNull(this.mRenderFuture)).get(), false, layout, resources));
                    }
                    catch (InterruptedException | CancellationException | ExecutionException e) {
                        Log.e((String)TAG, (String)"Failed to render layout", (Throwable)e);
                        result.setException((Throwable)e);
                    }
                } else {
                    Log.w((String)TAG, (String)"Layout is rendered, but inflater is no longer attached to the same parent. Cancelling inflation.");
                    result.cancel(false);
                }
            }, (Executor)this.mUiExecutorService);
        } else {
            try {
                result.setFuture(this.postInflate(parent, prevInflateParent, (RenderResult)this.mRenderFuture.get(), isReattaching, layout, resources));
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                Log.e((String)TAG, (String)"Failed to render layout", (Throwable)e);
                result.setException((Throwable)e);
            }
        }
        return result;
    }

    @Nullable
    private static ViewGroup getOnlyChildViewGroup(@NonNull ViewGroup parent) {
        View child;
        if (parent.getChildCount() == 1 && (child = parent.getChildAt(0)) instanceof ViewGroup) {
            return (ViewGroup)child;
        }
        return null;
    }

    @UiThread
    @NonNull
    private ListenableFuture<Void> postInflate(@NonNull ViewGroup parent, @Nullable ViewGroup prevInflateParent, @NonNull RenderResult renderResult, boolean isReattaching, @NonNull LayoutElementProto.Layout layout, @NonNull ResourceProto.Resources resources) {
        this.mCanReattachWithoutRendering = renderResult.canReattachWithoutRendering();
        if (renderResult instanceof InflatedIntoNewParentRenderResult) {
            InflateParentData newInflateParentData = ((InflatedIntoNewParentRenderResult)renderResult).mNewInflateParentData;
            this.mInflateParent = ((ProtoLayoutInflater.InflateResult)Preconditions.checkNotNull((Object)newInflateParentData.mInflateResult, (Object)"ProtoLayoutViewInstance - inflated result was null, but inflating was requested.")).inflateParent;
        }
        ListenableFuture<Void> postInflateFuture = renderResult.postInflate(parent, prevInflateParent, isReattaching);
        SettableFuture result = SettableFuture.create();
        if (postInflateFuture.isDone()) {
            try {
                postInflateFuture.get();
                return Futures.immediateVoidFuture();
            }
            catch (ProtoLayoutInflater.ViewMutationException | InterruptedException | CancellationException | ExecutionException e) {
                return this.handlePostInflateFailure(e, layout, resources, prevInflateParent, parent);
            }
        }
        postInflateFuture.addListener(() -> {
            try {
                result.set((Object)((Void)postInflateFuture.get()));
            }
            catch (InterruptedException | CancellationException | ExecutionException e) {
                result.setFuture(this.handlePostInflateFailure(e, layout, resources, prevInflateParent, parent));
            }
        }, (Executor)this.mUiExecutorService);
        return result;
    }

    @UiThread
    @NonNull
    private ListenableFuture<Void> handlePostInflateFailure(@NonNull Throwable error, @NonNull LayoutElementProto.Layout layout, @NonNull ResourceProto.Resources resources, @Nullable ViewGroup prevInflateParent, @NonNull ViewGroup parent) {
        Throwable e = error.getCause();
        if (e instanceof ProtoLayoutInflater.ViewMutationException) {
            Log.w((String)TAG, (String)("applyMutation failed." + e.getMessage()));
            if (this.mPrevLayout == layout && parent == this.mAttachParent) {
                Log.w((String)TAG, (String)"Retrying full inflation.");
                ProtoLayoutInflater.clearRenderedMetadata((ViewGroup)Preconditions.checkNotNull((Object)prevInflateParent));
                this.mPrevLayout = null;
                return this.renderAndAttach(layout, resources, parent);
            }
        } else {
            Log.e((String)TAG, (String)"postInflate failed.", (Throwable)error);
        }
        return Futures.immediateFailedFuture((Throwable)error);
    }

    @UiThread
    public void detach(@NonNull ViewGroup parent) {
        if (this.mAttachParent != null && this.mAttachParent != parent) {
            throw new IllegalStateException("Layout is not attached to parent " + parent);
        }
        this.detachInternal();
    }

    @UiThread
    private void detachInternal() {
        if (this.mRenderFuture != null && !this.mRenderFuture.isDone()) {
            this.mRenderFuture.cancel(false);
        }
        this.setLayoutVisibility(2);
        ViewGroup inflateParent = this.mInflateParent;
        if (inflateParent != null) {
            ViewGroup parent = (ViewGroup)inflateParent.getParent();
            if (this.mAttachParent != null && this.mAttachParent != parent) {
                Log.w((String)TAG, (String)"inflateParent was attached to the wrong parent.");
            }
            if (parent != null) {
                parent.removeView((View)inflateParent);
            }
        }
        this.mAttachParent = null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @UiThread
    public void setUpdatesEnabled(boolean updatesEnabled) {
        if (this.mDataPipeline != null) {
            this.mDataPipeline.setUpdatesEnabled(updatesEnabled);
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @UiThread
    public void setLayoutVisibility(int visibility) {
        if (this.mAnimationEnabled && this.mDataPipeline != null) {
            if (visibility == 0 && !this.mWasFullyVisibleBefore) {
                this.mDataPipeline.setFullyVisible(true);
                this.mWasFullyVisibleBefore = true;
            } else if (visibility == 2) {
                this.mDataPipeline.setFullyVisible(false);
                this.mWasFullyVisibleBefore = false;
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.detachInternal();
        this.mRenderFuture = null;
        this.mPrevLayout = null;
        if (this.mDataPipeline != null) {
            this.mDataPipeline.close();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final class Config {
        @NonNull
        private final Context mUiContext;
        @NonNull
        private final Resources mRendererResources;
        @NonNull
        private final ResourceResolversProvider mResourceResolversProvider;
        @NonNull
        private final ProtoLayoutTheme mProtoLayoutTheme;
        @Nullable
        private final SensorGateway mSensorGateway;
        @Nullable
        private final StateStore mStateStore;
        @NonNull
        private final LoadActionListener mLoadActionListener;
        @NonNull
        private final ListeningExecutorService mUiExecutorService;
        @NonNull
        private final ListeningExecutorService mBgExecutorService;
        @Nullable
        private final ProtoLayoutExtensionViewProvider mExtensionViewProvider;
        @NonNull
        private final String mClickableIdExtra;
        private final boolean mAnimationEnabled;
        private final int mRunningAnimationsLimit;
        private final boolean mUpdatesEnabled;
        private final boolean mAdaptiveUpdateRatesEnabled;
        private final boolean mIsViewFullyVisible;

        Config(@NonNull Context uiContext, @NonNull Resources rendererResources, @NonNull ResourceResolversProvider resourceResolversProvider, @NonNull ProtoLayoutTheme protoLayoutTheme, @Nullable SensorGateway sensorGateway, @Nullable StateStore stateStore, @NonNull LoadActionListener loadActionListener, @NonNull ListeningExecutorService uiExecutorService, @NonNull ListeningExecutorService bgExecutorService, @Nullable ProtoLayoutExtensionViewProvider extensionViewProvider, @NonNull String clickableIdExtra, boolean animationEnabled, int runningAnimationsLimit, boolean updatesEnabled, boolean adaptiveUpdateRatesEnabled, boolean isViewFullyVisible) {
            this.mUiContext = uiContext;
            this.mRendererResources = rendererResources;
            this.mResourceResolversProvider = resourceResolversProvider;
            this.mProtoLayoutTheme = protoLayoutTheme;
            this.mSensorGateway = sensorGateway;
            this.mStateStore = stateStore;
            this.mLoadActionListener = loadActionListener;
            this.mUiExecutorService = uiExecutorService;
            this.mBgExecutorService = bgExecutorService;
            this.mExtensionViewProvider = extensionViewProvider;
            this.mClickableIdExtra = clickableIdExtra;
            this.mAnimationEnabled = animationEnabled;
            this.mRunningAnimationsLimit = runningAnimationsLimit;
            this.mUpdatesEnabled = updatesEnabled;
            this.mAdaptiveUpdateRatesEnabled = adaptiveUpdateRatesEnabled;
            this.mIsViewFullyVisible = isViewFullyVisible;
        }

        @NonNull
        public Context getUiContext() {
            return this.mUiContext;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        public Resources getRendererResources() {
            return this.mRendererResources;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @NonNull
        public ResourceResolversProvider getResourceResolversProvider() {
            return this.mResourceResolversProvider;
        }

        @NonNull
        ProtoLayoutTheme getProtoLayoutTheme() {
            return this.mProtoLayoutTheme;
        }

        @Nullable
        public SensorGateway getSensorGateway() {
            return this.mSensorGateway;
        }

        @Nullable
        public StateStore getStateStore() {
            return this.mStateStore;
        }

        @NonNull
        public LoadActionListener getLoadActionListener() {
            return this.mLoadActionListener;
        }

        @NonNull
        public ListeningExecutorService getUiExecutorService() {
            return this.mUiExecutorService;
        }

        @NonNull
        public ListeningExecutorService getBgExecutorService() {
            return this.mBgExecutorService;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        @Nullable
        public ProtoLayoutExtensionViewProvider getExtensionViewProvider() {
            return this.mExtensionViewProvider;
        }

        @NonNull
        public String getClickableIdExtra() {
            return this.mClickableIdExtra;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean getAnimationEnabled() {
            return this.mAnimationEnabled;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public int getRunningAnimationsLimit() {
            return this.mRunningAnimationsLimit;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean getUpdatesEnabled() {
            return this.mUpdatesEnabled;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean getAdaptiveUpdateRatesEnabled() {
            return this.mAdaptiveUpdateRatesEnabled;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public boolean getIsViewFullyVisible() {
            return this.mIsViewFullyVisible;
        }

        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
        public static final class Builder {
            @NonNull
            private final Context mUiContext;
            @Nullable
            private Resources mRendererResources;
            @Nullable
            private ResourceResolversProvider mResourceResolversProvider;
            @Nullable
            private ProtoLayoutTheme mProtoLayoutTheme;
            @Nullable
            private SensorGateway mSensorGateway;
            @Nullable
            private StateStore mStateStore;
            @Nullable
            private LoadActionListener mLoadActionListener;
            @NonNull
            private final ListeningExecutorService mUiExecutorService;
            @NonNull
            private final ListeningExecutorService mBgExecutorService;
            @Nullable
            private ProtoLayoutExtensionViewProvider mExtensionViewProvider;
            @NonNull
            private final String mClickableIdExtra;
            private boolean mAnimationEnabled = true;
            private int mRunningAnimationsLimit = 4;
            private boolean mUpdatesEnabled = true;
            private boolean mAdaptiveUpdateRatesEnabled = true;
            private boolean mIsViewFullyVisible = true;

            public Builder(@NonNull Context uiContext, @NonNull ListeningExecutorService uiExecutorService, @NonNull ListeningExecutorService bgExecutorService, @NonNull String clickableIdExtra) {
                this.mUiContext = uiContext;
                this.mUiExecutorService = uiExecutorService;
                this.mBgExecutorService = bgExecutorService;
                this.mClickableIdExtra = clickableIdExtra;
            }

            @NonNull
            @RestrictTo(value={RestrictTo.Scope.LIBRARY})
            public Builder setResourceResolverProvider(@NonNull ResourceResolversProvider resourceResolversProvider) {
                this.mResourceResolversProvider = resourceResolversProvider;
                return this;
            }

            @NonNull
            @RestrictTo(value={RestrictTo.Scope.LIBRARY})
            public Builder setRendererResources(@NonNull Resources rendererResources) {
                this.mRendererResources = rendererResources;
                return this;
            }

            @NonNull
            public Builder setSensorGateway(@NonNull SensorGateway sensorGateway) {
                this.mSensorGateway = sensorGateway;
                return this;
            }

            @NonNull
            public Builder setStateStore(@NonNull StateStore stateStore) {
                this.mStateStore = stateStore;
                return this;
            }

            @NonNull
            public Builder setLoadActionListener(@NonNull LoadActionListener loadActionListener) {
                this.mLoadActionListener = loadActionListener;
                return this;
            }

            @RestrictTo(value={RestrictTo.Scope.LIBRARY})
            @NonNull
            public Builder setExtensionViewProvider(@NonNull ProtoLayoutExtensionViewProvider extensionViewProvider) {
                this.mExtensionViewProvider = extensionViewProvider;
                return this;
            }

            @RestrictTo(value={RestrictTo.Scope.LIBRARY})
            @NonNull
            public Builder setAnimationEnabled(boolean animationEnabled) {
                this.mAnimationEnabled = animationEnabled;
                return this;
            }

            @RestrictTo(value={RestrictTo.Scope.LIBRARY})
            @NonNull
            public Builder setRunningAnimationsLimit(int runningAnimationsLimit) {
                this.mRunningAnimationsLimit = runningAnimationsLimit;
                return this;
            }

            @RestrictTo(value={RestrictTo.Scope.LIBRARY})
            @NonNull
            public Builder setUpdatesEnabled(boolean updatesEnabled) {
                this.mUpdatesEnabled = updatesEnabled;
                return this;
            }

            @RestrictTo(value={RestrictTo.Scope.LIBRARY})
            @NonNull
            public Builder setAdaptiveUpdateRatesEnabled(boolean adaptiveUpdateRatesEnabled) {
                this.mAdaptiveUpdateRatesEnabled = adaptiveUpdateRatesEnabled;
                return this;
            }

            @RestrictTo(value={RestrictTo.Scope.LIBRARY})
            @NonNull
            public Builder setIsViewFullyVisible(boolean isViewFullyVisible) {
                this.mIsViewFullyVisible = isViewFullyVisible;
                return this;
            }

            @NonNull
            public Config build() {
                LoadActionListener loadActionListener = this.mLoadActionListener;
                if (loadActionListener == null) {
                    loadActionListener = p -> {};
                }
                if (this.mProtoLayoutTheme == null) {
                    this.mProtoLayoutTheme = ProtoLayoutThemeImpl.defaultTheme(this.mUiContext);
                }
                if (this.mResourceResolversProvider == null) {
                    this.mResourceResolversProvider = (context, resources, listeningExecutorService, animationEnabled) -> StandardResourceResolvers.forLocalApp(resources, this.mUiContext, (Executor)listeningExecutorService, this.mAnimationEnabled).build();
                }
                if (this.mRendererResources == null) {
                    this.mRendererResources = this.mUiContext.getResources();
                }
                return new Config(this.mUiContext, this.mRendererResources, this.mResourceResolversProvider, this.mProtoLayoutTheme, this.mSensorGateway, this.mStateStore, loadActionListener, this.mUiExecutorService, this.mBgExecutorService, this.mExtensionViewProvider, this.mClickableIdExtra, this.mAnimationEnabled, this.mRunningAnimationsLimit, this.mUpdatesEnabled, this.mAdaptiveUpdateRatesEnabled, this.mIsViewFullyVisible);
            }
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static interface ResourceResolversProvider {
        @Nullable
        public ResourceResolvers getResourceResolvers(@NonNull Context var1, @NonNull ResourceProto.Resources var2, @NonNull ListeningExecutorService var3, boolean var4);
    }

    public static interface LoadActionListener {
        public void onClick(@NonNull StateProto.State var1);
    }

    static final class FailedRenderResult
    implements RenderResult {
        FailedRenderResult() {
        }

        @Override
        public boolean canReattachWithoutRendering() {
            return false;
        }

        @Override
        @NonNull
        public ListenableFuture<Void> postInflate(@NonNull ViewGroup parent, @Nullable ViewGroup prevInflateParent, boolean isReattaching) {
            return Futures.immediateVoidFuture();
        }
    }

    static final class InflateParentData {
        @Nullable
        final ProtoLayoutInflater.InflateResult mInflateResult;

        InflateParentData(@Nullable ProtoLayoutInflater.InflateResult inflateResult) {
            this.mInflateResult = inflateResult;
        }
    }

    static final class InflatedIntoNewParentRenderResult
    implements RenderResult {
        @NonNull
        final InflateParentData mNewInflateParentData;

        InflatedIntoNewParentRenderResult(@NonNull InflateParentData newInflateParentData) {
            this.mNewInflateParentData = newInflateParentData;
        }

        @Override
        public boolean canReattachWithoutRendering() {
            return true;
        }

        @Override
        @NonNull
        @UiThread
        public ListenableFuture<Void> postInflate(@NonNull ViewGroup parent, @Nullable ViewGroup prevInflateParent, boolean isReattaching) {
            ProtoLayoutInflater.InflateResult inflateResult = (ProtoLayoutInflater.InflateResult)Preconditions.checkNotNull((Object)this.mNewInflateParentData.mInflateResult, (Object)"ProtoLayoutViewInstance - inflated result was null, but inflating into new parent requested.");
            inflateResult.updateDynamicDataPipeline(isReattaching);
            parent.removeAllViews();
            parent.addView((View)inflateResult.inflateParent, new ViewGroup.LayoutParams(-1, -1));
            return Futures.immediateVoidFuture();
        }
    }

    static final class UnchangedRenderResult
    implements RenderResult {
        UnchangedRenderResult() {
        }

        @Override
        public boolean canReattachWithoutRendering() {
            return false;
        }

        @Override
        @NonNull
        public ListenableFuture<Void> postInflate(@NonNull ViewGroup parent, @Nullable ViewGroup prevInflateParent, boolean isReattaching) {
            return Futures.immediateVoidFuture();
        }
    }

    static final class ApplyToPrevParentRenderResult
    implements RenderResult {
        @NonNull
        final ProtoLayoutInflater mInflater;
        @NonNull
        final ProtoLayoutInflater.ViewGroupMutation mMutation;

        ApplyToPrevParentRenderResult(@NonNull ProtoLayoutInflater inflater, @NonNull ProtoLayoutInflater.ViewGroupMutation mutation) {
            this.mInflater = inflater;
            this.mMutation = mutation;
        }

        @Override
        public boolean canReattachWithoutRendering() {
            return false;
        }

        @Override
        @NonNull
        @UiThread
        public ListenableFuture<Void> postInflate(@NonNull ViewGroup parent, @Nullable ViewGroup prevInflateParent, boolean isReattaching) {
            return this.mInflater.applyMutation((ViewGroup)Preconditions.checkNotNull((Object)prevInflateParent), this.mMutation);
        }
    }

    static interface RenderResult {
        public boolean canReattachWithoutRendering();

        @UiThread
        @NonNull
        public ListenableFuture<Void> postInflate(@NonNull ViewGroup var1, @Nullable ViewGroup var2, boolean var3);
    }
}

