/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.net.Uri;
import android.os.Process;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;

class ContentUriValidator {
    @NonNull
    final Context mAppContext;
    @NonNull
    private final PackageManager mPackageManager;
    @NonNull
    private final String mAllowedPackageName;
    @NonNull
    private final UriPermissionValidator mUriPermissionValidator;

    public ContentUriValidator(@NonNull Context appContext, @NonNull String allowedPackageName) {
        this.mAppContext = appContext;
        this.mPackageManager = appContext.getPackageManager();
        this.mAllowedPackageName = allowedPackageName;
        this.mUriPermissionValidator = new UriPermissionValidator();
    }

    @VisibleForTesting(otherwise=5)
    ContentUriValidator(@NonNull Context appContext, @NonNull String allowedPackageName, @NonNull UriPermissionValidator uriPermissionValidator) {
        this.mAppContext = appContext;
        this.mPackageManager = appContext.getPackageManager();
        this.mAllowedPackageName = allowedPackageName;
        this.mUriPermissionValidator = uriPermissionValidator;
    }

    public boolean validateUri(@NonNull Uri uri) {
        String scheme = uri.getScheme();
        String authority = uri.getAuthority();
        if (scheme == null || !scheme.equals("content")) {
            return false;
        }
        if (authority == null) {
            return false;
        }
        ProviderInfo providerInfo = this.mPackageManager.resolveContentProvider(authority, 0);
        if (providerInfo == null) {
            int authorityIndex = authority.lastIndexOf("@");
            if (authorityIndex != -1) {
                String actualAuthority = authority.substring(authorityIndex + 1);
                providerInfo = this.mPackageManager.resolveContentProvider(actualAuthority, 0);
            }
            if (providerInfo == null) {
                return false;
            }
        }
        if (!providerInfo.exported) {
            return false;
        }
        if (!this.mUriPermissionValidator.canAccessUri(uri)) {
            return false;
        }
        return providerInfo.packageName.equals(this.mAllowedPackageName);
    }

    class UriPermissionValidator {
        UriPermissionValidator() {
        }

        public boolean canAccessUri(@NonNull Uri uri) {
            int uid;
            int pid = Process.myPid();
            return ContentUriValidator.this.mAppContext.checkUriPermission(uri, pid, uid = Process.myUid(), 1) == 0;
        }
    }
}

