/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.wear.protolayout.proto.ResourceProto;
import androidx.wear.protolayout.renderer.inflater.ResourceResolvers;

public class DefaultAndroidAnimatedImageResourceByResIdResolver
implements ResourceResolvers.AndroidAnimatedImageResourceByResIdResolver {
    @NonNull
    private final Resources mAndroidResources;

    public DefaultAndroidAnimatedImageResourceByResIdResolver(@NonNull Resources androidResources) {
        this.mAndroidResources = androidResources;
    }

    @Override
    @NonNull
    public Drawable getDrawableOrThrow(@NonNull ResourceProto.AndroidAnimatedImageResourceByResId resource) throws ResourceResolvers.ResourceAccessException {
        if (resource.getAnimatedImageFormat() == ResourceProto.AnimatedImageFormat.ANIMATED_IMAGE_FORMAT_AVD) {
            return this.mAndroidResources.getDrawable(resource.getResourceId(), null);
        }
        throw new ResourceResolvers.ResourceAccessException("Unsupported animated image format");
    }
}

