/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import androidx.annotation.NonNull;
import androidx.concurrent.futures.ResolvableFuture;
import androidx.wear.protolayout.proto.ResourceProto;
import androidx.wear.protolayout.renderer.inflater.ContentUriValidator;
import androidx.wear.protolayout.renderer.inflater.ResourceResolvers;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;

public class DefaultAndroidImageResourceByContentUriResolver
implements ResourceResolvers.AndroidImageResourceByContentUriResolver {
    @NonNull
    private static final String TAG = "AndroidContentUriResolver";
    @NonNull
    private final ContentUriValidator mContentUriValidator;
    @NonNull
    private final Resources mPackageResources;
    @NonNull
    private final ContentResolver mContentResolver;
    @NonNull
    private final Executor mLoadExecutor;

    public DefaultAndroidImageResourceByContentUriResolver(@NonNull Context appContext, @NonNull String packageName, @NonNull Resources packageResources, @NonNull ContentResolver contentResolver, @NonNull Executor loadExecutor) {
        this.mContentUriValidator = new ContentUriValidator(appContext, packageName);
        this.mPackageResources = packageResources;
        this.mContentResolver = contentResolver;
        this.mLoadExecutor = loadExecutor;
    }

    @NonNull
    private Drawable getDrawableBlocking(@NonNull ResourceProto.AndroidImageResourceByContentUri resource) throws ResourceResolvers.ResourceAccessException {
        BitmapDrawable bitmapDrawable;
        block11: {
            Uri resourceUri = Uri.parse((String)resource.getContentUri());
            if (!this.mContentUriValidator.validateUri(resourceUri)) {
                throw new IllegalArgumentException("Provided content URI " + resource.getContentUri() + " cannot be opened");
            }
            InputStream inStream = this.mContentResolver.openInputStream(resourceUri);
            try {
                if (inStream == null) {
                    throw new ResourceResolvers.ResourceAccessException("Cannot read from URI " + resource.getContentUri());
                }
                bitmapDrawable = new BitmapDrawable(this.mPackageResources, BitmapFactory.decodeStream((InputStream)inStream));
                if (inStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException ex) {
                    throw new ResourceResolvers.ResourceAccessException("Cannot open file for URI " + resource.getContentUri(), ex);
                }
                catch (IOException ex) {
                    throw new ResourceResolvers.ResourceAccessException("Error while reading URI " + resource.getContentUri(), ex);
                }
            }
            inStream.close();
        }
        return bitmapDrawable;
    }

    @Override
    @NonNull
    public ListenableFuture<Drawable> getDrawable(@NonNull ResourceProto.AndroidImageResourceByContentUri resource) {
        ResolvableFuture resolvableFuture = ResolvableFuture.create();
        this.mLoadExecutor.execute(() -> {
            try {
                Drawable d = this.getDrawableBlocking(resource);
                resolvableFuture.set((Object)d);
            }
            catch (Exception ex) {
                resolvableFuture.setException((Throwable)ex);
            }
        });
        return resolvableFuture;
    }
}

