/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.wear.protolayout.proto.ResourceProto;
import androidx.wear.protolayout.renderer.inflater.ResourceResolvers;

public class DefaultAndroidImageResourceByResIdResolver
implements ResourceResolvers.AndroidImageResourceByResIdResolver {
    @NonNull
    private final Resources mAndroidResources;

    public DefaultAndroidImageResourceByResIdResolver(@NonNull Resources androidResources) {
        this.mAndroidResources = androidResources;
    }

    @Override
    @NonNull
    public Drawable getDrawableOrThrow(@NonNull ResourceProto.AndroidImageResourceByResId resource) throws ResourceResolvers.ResourceAccessException {
        try {
            return this.mAndroidResources.getDrawable(resource.getResourceId(), null);
        }
        catch (Resources.NotFoundException ex) {
            throw new ResourceResolvers.ResourceAccessException("ResId is not found in the resources", (Exception)((Object)ex));
        }
    }
}

