/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import androidx.annotation.NonNull;
import androidx.vectordrawable.graphics.drawable.SeekableAnimatedVectorDrawable;
import androidx.wear.protolayout.proto.ResourceProto;
import androidx.wear.protolayout.renderer.inflater.ResourceResolvers;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DefaultAndroidSeekableAnimatedImageResourceByResIdResolver
implements ResourceResolvers.AndroidSeekableAnimatedImageResourceByResIdResolver {
    @NonNull
    private final Resources mAndroidResources;

    public DefaultAndroidSeekableAnimatedImageResourceByResIdResolver(@NonNull Resources androidResources) {
        this.mAndroidResources = androidResources;
    }

    @Override
    @NonNull
    public Drawable getDrawableOrThrow(@NonNull ResourceProto.AndroidSeekableAnimatedImageResourceByResId resource) throws ResourceResolvers.ResourceAccessException {
        if (resource.getAnimatedImageFormat() == ResourceProto.AnimatedImageFormat.ANIMATED_IMAGE_FORMAT_AVD) {
            try {
                int type;
                XmlResourceParser parser = this.mAndroidResources.getXml(resource.getResourceId());
                AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
                while ((type = parser.next()) != 2 && type != 1) {
                }
                if (type != 2) {
                    throw new XmlPullParserException("No start tag found");
                }
                return SeekableAnimatedVectorDrawable.createFromXmlInner((Resources)this.mAndroidResources, (XmlPullParser)parser, (AttributeSet)attrs, null);
            }
            catch (IOException | XmlPullParserException e) {
                Log.e((String)"SeekableAVD", (String)"Error building pipeline", (Throwable)e);
            }
        }
        throw new ResourceResolvers.ResourceAccessException("Unsupported animated image format");
    }
}

