/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.wear.protolayout.proto.ResourceProto;
import androidx.wear.protolayout.renderer.inflater.ResourceResolvers;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class DefaultInlineImageResourceResolver
implements ResourceResolvers.InlineImageResourceResolver {
    private static final String TAG = "InlineImageResolver";
    @NonNull
    private final Context mAppContext;

    public DefaultInlineImageResourceResolver(@NonNull Context appContext) {
        this.mAppContext = appContext;
    }

    @Override
    @NonNull
    public Drawable getDrawableOrThrow(@NonNull ResourceProto.InlineImageResource inlineImage) throws ResourceResolvers.ResourceAccessException {
        Bitmap bitmap = null;
        if (inlineImage.getFormat() == ResourceProto.ImageFormat.IMAGE_FORMAT_RGB_565 || inlineImage.getFormat() == ResourceProto.ImageFormat.IMAGE_FORMAT_ARGB_8888) {
            bitmap = this.loadRawBitmap(inlineImage);
        } else if (inlineImage.getFormat() == ResourceProto.ImageFormat.IMAGE_FORMAT_UNDEFINED) {
            bitmap = this.loadStructuredBitmap(inlineImage);
        }
        if (bitmap == null) {
            throw new ResourceResolvers.ResourceAccessException("Unsupported image format in image resource.");
        }
        return new BitmapDrawable(this.mAppContext.getResources(), bitmap);
    }

    @Nullable
    private static Bitmap.Config imageFormatToBitmapConfig(ResourceProto.ImageFormat imageFormat) {
        switch (imageFormat) {
            case IMAGE_FORMAT_RGB_565: {
                return Bitmap.Config.RGB_565;
            }
            case IMAGE_FORMAT_ARGB_8888: {
                return Bitmap.Config.ARGB_8888;
            }
            case IMAGE_FORMAT_UNDEFINED: 
            case UNRECOGNIZED: {
                return null;
            }
        }
        return null;
    }

    private int getBytesPerPixel(Bitmap.Config config) {
        if (config == Bitmap.Config.RGB_565) {
            return 2;
        }
        if (config == Bitmap.Config.ARGB_8888) {
            return 4;
        }
        return -1;
    }

    @NonNull
    private Bitmap loadRawBitmap(@NonNull ResourceProto.InlineImageResource inlineImage) throws ResourceResolvers.ResourceAccessException {
        Bitmap.Config config = DefaultInlineImageResourceResolver.imageFormatToBitmapConfig(inlineImage.getFormat());
        if (config == null) {
            throw new ResourceResolvers.ResourceAccessException("Unknown image format in image resource.");
        }
        int widthPx = inlineImage.getWidthPx();
        int heightPx = inlineImage.getHeightPx();
        int bytesPerPixel = this.getBytesPerPixel(config);
        int expectedDataSize = widthPx * heightPx * bytesPerPixel;
        if (inlineImage.getData().size() != expectedDataSize) {
            throw new ResourceResolvers.ResourceAccessException("Mismatch between image data size and dimensions in image resource.");
        }
        Bitmap bitmap = Bitmap.createBitmap((int)widthPx, (int)heightPx, (Bitmap.Config)config);
        bitmap.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(inlineImage.getData().toByteArray()));
        return bitmap;
    }

    @Nullable
    private Bitmap loadStructuredBitmap(@NonNull ResourceProto.InlineImageResource inlineImage) {
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])inlineImage.getData().toByteArray(), (int)0, (int)inlineImage.getData().size());
        if (bitmap == null) {
            Log.e((String)TAG, (String)"Unable to load structured bitmap.");
            return null;
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)inlineImage.getWidthPx(), (int)inlineImage.getHeightPx(), (boolean)true);
    }
}

