/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.SpannableStringBuilder;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.MetricAffectingSpan;
import android.text.style.StyleSpan;
import android.text.style.UnderlineSpan;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewOutlineProvider;
import android.view.ViewParent;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Scroller;
import android.widget.Space;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.core.content.ContextCompat;
import androidx.core.util.Preconditions;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.vectordrawable.graphics.drawable.SeekableAnimatedVectorDrawable;
import androidx.wear.protolayout.expression.pipeline.AnimationsHelper;
import androidx.wear.protolayout.expression.proto.AnimationParameterProto;
import androidx.wear.protolayout.expression.proto.DynamicProto;
import androidx.wear.protolayout.proto.ActionProto;
import androidx.wear.protolayout.proto.AlignmentProto;
import androidx.wear.protolayout.proto.ColorProto;
import androidx.wear.protolayout.proto.DimensionProto;
import androidx.wear.protolayout.proto.FingerprintProto;
import androidx.wear.protolayout.proto.LayoutElementProto;
import androidx.wear.protolayout.proto.ModifiersProto;
import androidx.wear.protolayout.proto.StateProto;
import androidx.wear.protolayout.proto.TriggerProto;
import androidx.wear.protolayout.proto.TypesProto;
import androidx.wear.protolayout.renderer.ProtoLayoutExtensionViewProvider;
import androidx.wear.protolayout.renderer.ProtoLayoutTheme;
import androidx.wear.protolayout.renderer.R;
import androidx.wear.protolayout.renderer.common.ProtoLayoutDiffer;
import androidx.wear.protolayout.renderer.dynamicdata.ProtoLayoutDynamicDataPipeline;
import androidx.wear.protolayout.renderer.inflater.CustomTypefaceSpan;
import androidx.wear.protolayout.renderer.inflater.ImageViewWithoutIntrinsicSizes;
import androidx.wear.protolayout.renderer.inflater.LetterSpacingSpan;
import androidx.wear.protolayout.renderer.inflater.ProtoLayoutThemeImpl;
import androidx.wear.protolayout.renderer.inflater.RatioViewWrapper;
import androidx.wear.protolayout.renderer.inflater.RenderedMetadata;
import androidx.wear.protolayout.renderer.inflater.ResourceResolvers;
import androidx.wear.protolayout.renderer.inflater.SizedArcContainer;
import androidx.wear.protolayout.renderer.inflater.StandardLineHeightSpan;
import androidx.wear.protolayout.renderer.inflater.WearCurvedLineView;
import androidx.wear.protolayout.renderer.inflater.WearCurvedSpacer;
import androidx.wear.widget.ArcLayout;
import androidx.wear.widget.CurvedTextView;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public final class ProtoLayoutInflater {
    private static final String TAG = "ProtoLayoutInflater";
    private static final char ZERO_WIDTH_JOINER = '\u200d';
    private static final boolean DEBUG_DIFF_UPDATE_ENABLED = false;
    private static final float FADE_IN_TARGET_ALPHA = 1.0f;
    private static final float FADE_OUT_INITIAL_ALPHA = 1.0f;
    private static final TriggerProto.Trigger DEFAULT_ANIMATION_TRIGGER = (TriggerProto.Trigger)TriggerProto.Trigger.newBuilder().setOnLoadTrigger(TriggerProto.OnLoadTrigger.getDefaultInstance()).build();
    private static final int DEFAULT_MAX_BITMAP_RAW_SIZE = 0x1400000;
    private static final int HORIZONTAL_ALIGN_DEFAULT_GRAVITY = 1;
    private static final int VERTICAL_ALIGN_DEFAULT_GRAVITY = 16;
    private static final int TEXT_ALIGN_DEFAULT = 1;
    private static final ImageView.ScaleType IMAGE_DEFAULT_SCALE_TYPE = ImageView.ScaleType.FIT_CENTER;
    private static final int ARC_VERTICAL_ALIGN_DEFAULT = 1;
    private static final int ANGULAR_ALIGNMENT_DEFAULT = 1;
    private static final int SPAN_VERTICAL_ALIGN_DEFAULT = 0;
    @Nullable
    private static final TextUtils.TruncateAt TEXT_OVERFLOW_DEFAULT = null;
    private static final int TEXT_COLOR_DEFAULT = -1;
    private static final int TEXT_MAX_LINES_DEFAULT = 1;
    private static final int TEXT_MIN_LINES = 1;
    private static final DimensionProto.ContainerDimension CONTAINER_DIMENSION_DEFAULT = (DimensionProto.ContainerDimension)DimensionProto.ContainerDimension.newBuilder().setWrappedDimension(DimensionProto.WrappedDimensionProp.getDefaultInstance()).build();
    private static final int ARC_ANCHOR_DEFAULT = 1;
    private static final int LINE_COLOR_DEFAULT = -1;
    static final RenderedMetadata.PendingLayoutParams NO_OP_PENDING_LAYOUT_PARAMS = layoutParams -> layoutParams;
    final Context mUiContext;
    private final Context mProtoLayoutThemeContext;
    private final ProtoLayoutTheme mProtoLayoutTheme;
    private final LayoutElementProto.Layout mLayoutProto;
    private final ResourceResolvers mLayoutResourceResolvers;
    private final Optional<ProtoLayoutDynamicDataPipeline> mDataPipeline;
    @Nullable
    private final ProtoLayoutExtensionViewProvider mExtensionViewProvider;
    private final boolean mAllowLayoutChangingBindsWithoutDefault;
    final String mClickableIdExtra;
    @Nullable
    final Executor mLoadActionExecutor;
    final LoadActionListener mLoadActionListener;
    final boolean mAnimationEnabled;

    public ProtoLayoutInflater(@NonNull Config config) {
        Resources.Theme rendererTheme = config.getRendererResources().newTheme();
        rendererTheme.setTo(config.getUiContext().getTheme());
        this.mUiContext = new ContextThemeWrapper(config.getUiContext(), rendererTheme);
        this.mProtoLayoutTheme = config.getProtoLayoutTheme();
        this.mProtoLayoutThemeContext = new ContextThemeWrapper(this.mUiContext, this.mProtoLayoutTheme.getTheme());
        this.mLayoutProto = config.getLayout();
        this.mLayoutResourceResolvers = config.getLayoutResourceResolvers();
        this.mLoadActionExecutor = config.getLoadActionExecutor();
        this.mLoadActionListener = config.getLoadActionListener();
        this.mDataPipeline = Optional.ofNullable(config.getDynamicDataPipeline());
        this.mAnimationEnabled = config.getAnimationEnabled();
        this.mAllowLayoutChangingBindsWithoutDefault = config.getAllowLayoutChangingBindsWithoutDefault();
        this.mClickableIdExtra = config.getClickableIdExtra();
        this.mExtensionViewProvider = config.getExtensionViewProvider();
    }

    private int safeDpToPx(float dp) {
        return Math.round(Math.max(0.0f, dp) * this.mUiContext.getResources().getDisplayMetrics().density);
    }

    private int safeDpToPx(DimensionProto.DpProp dpProp) {
        return this.safeDpToPx(dpProp.getValue());
    }

    @Nullable
    private static Float safeAspectRatioOrNull(DimensionProto.ProportionalDimensionProp proportionalDimensionProp) {
        int dividend = proportionalDimensionProp.getAspectRatioWidth();
        int divisor = proportionalDimensionProp.getAspectRatioHeight();
        if (dividend <= 0 || divisor <= 0) {
            return null;
        }
        return Float.valueOf((float)dividend / (float)divisor);
    }

    private static Rect getSourceBounds(View v) {
        int[] pos = new int[2];
        v.getLocationOnScreen(pos);
        return new Rect(pos[0], pos[1], pos[0] + v.getWidth(), pos[1] + v.getHeight());
    }

    private static ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-2, -2);
    }

    private ViewGroup.LayoutParams updateLayoutParamsInLinearLayout(RenderedMetadata.LinearLayoutProperties linearLayoutProperties, ViewGroup.LayoutParams layoutParams, DimensionProto.ContainerDimension width, DimensionProto.ContainerDimension height) {
        float weight;
        LinearLayout.LayoutParams linearLayoutParams = new LinearLayout.LayoutParams(layoutParams);
        ViewGroup.LayoutParams parentLayoutParams = linearLayoutProperties.getRawLayoutParams();
        if (linearLayoutProperties.getOrientation() == 0 && width.getInnerCase() == DimensionProto.ContainerDimension.InnerCase.EXPANDED_DIMENSION) {
            if (parentLayoutParams.width == -2) {
                linearLayoutParams.width = -2;
            } else {
                linearLayoutParams.width = 0;
                weight = width.getExpandedDimension().getLayoutWeight().getValue();
                linearLayoutParams.weight = weight != 0.0f ? weight : 1.0f;
            }
        } else {
            linearLayoutParams.width = this.dimensionToPx(width);
        }
        if (linearLayoutProperties.getOrientation() == 1 && height.getInnerCase() == DimensionProto.ContainerDimension.InnerCase.EXPANDED_DIMENSION) {
            if (parentLayoutParams.height == -2) {
                linearLayoutParams.height = -2;
            } else {
                linearLayoutParams.height = 0;
                weight = height.getExpandedDimension().getLayoutWeight().getValue();
                linearLayoutParams.weight = weight != 0.0f ? weight : 1.0f;
            }
        } else {
            linearLayoutParams.height = this.dimensionToPx(height);
        }
        return linearLayoutParams;
    }

    private ViewGroup.LayoutParams updateLayoutParams(RenderedMetadata.ViewProperties viewProperties, ViewGroup.LayoutParams layoutParams, DimensionProto.ContainerDimension width, DimensionProto.ContainerDimension height) {
        if (viewProperties instanceof RenderedMetadata.LinearLayoutProperties) {
            return this.updateLayoutParamsInLinearLayout((RenderedMetadata.LinearLayoutProperties)viewProperties, layoutParams, width, height);
        }
        layoutParams.width = this.dimensionToPx(width);
        layoutParams.height = this.dimensionToPx(height);
        return layoutParams;
    }

    private void resolveMinimumDimensions(View view, DimensionProto.ContainerDimension width, DimensionProto.ContainerDimension height) {
        if (width.getWrappedDimension().hasMinimumSize()) {
            view.setMinimumWidth(this.safeDpToPx(width.getWrappedDimension().getMinimumSize()));
        }
        if (height.getWrappedDimension().hasMinimumSize()) {
            view.setMinimumHeight(this.safeDpToPx(height.getWrappedDimension().getMinimumSize()));
        }
    }

    @VisibleForTesting
    static int getFrameLayoutGravity(AlignmentProto.HorizontalAlignment horizontalAlignment, AlignmentProto.VerticalAlignment verticalAlignment) {
        return ProtoLayoutInflater.horizontalAlignmentToGravity(horizontalAlignment) | ProtoLayoutInflater.verticalAlignmentToGravity(verticalAlignment);
    }

    @SuppressLint(value={"RtlHardcoded"})
    private static int horizontalAlignmentToGravity(AlignmentProto.HorizontalAlignment alignment) {
        switch (alignment) {
            case HORIZONTAL_ALIGN_START: {
                return 0x800003;
            }
            case HORIZONTAL_ALIGN_CENTER: {
                return 1;
            }
            case HORIZONTAL_ALIGN_END: {
                return 0x800005;
            }
            case HORIZONTAL_ALIGN_LEFT: {
                return 3;
            }
            case HORIZONTAL_ALIGN_RIGHT: {
                return 5;
            }
            case UNRECOGNIZED: 
            case HORIZONTAL_ALIGN_UNDEFINED: {
                return 1;
            }
        }
        return 1;
    }

    private static int verticalAlignmentToGravity(AlignmentProto.VerticalAlignment alignment) {
        switch (alignment) {
            case VERTICAL_ALIGN_TOP: {
                return 48;
            }
            case VERTICAL_ALIGN_CENTER: {
                return 16;
            }
            case VERTICAL_ALIGN_BOTTOM: {
                return 80;
            }
            case UNRECOGNIZED: 
            case VERTICAL_ALIGN_UNDEFINED: {
                return 16;
            }
        }
        return 16;
    }

    private static int verticalAlignmentToArcVAlign(AlignmentProto.VerticalAlignmentProp alignment) {
        switch (alignment.getValue()) {
            case VERTICAL_ALIGN_TOP: {
                return 0;
            }
            case VERTICAL_ALIGN_CENTER: {
                return 1;
            }
            case VERTICAL_ALIGN_BOTTOM: {
                return 2;
            }
            case UNRECOGNIZED: 
            case VERTICAL_ALIGN_UNDEFINED: {
                return 1;
            }
        }
        return 1;
    }

    private static ImageView.ScaleType contentScaleModeToScaleType(LayoutElementProto.ContentScaleMode contentScaleMode) {
        switch (contentScaleMode) {
            case CONTENT_SCALE_MODE_FIT: {
                return ImageView.ScaleType.FIT_CENTER;
            }
            case CONTENT_SCALE_MODE_CROP: {
                return ImageView.ScaleType.CENTER_CROP;
            }
            case CONTENT_SCALE_MODE_FILL_BOUNDS: {
                return ImageView.ScaleType.FIT_XY;
            }
            case CONTENT_SCALE_MODE_UNDEFINED: 
            case UNRECOGNIZED: {
                return IMAGE_DEFAULT_SCALE_TYPE;
            }
        }
        return IMAGE_DEFAULT_SCALE_TYPE;
    }

    private static int spanVerticalAlignmentToImgSpanAlignment(LayoutElementProto.SpanVerticalAlignmentProp alignment) {
        switch (alignment.getValue()) {
            case SPAN_VERTICAL_ALIGN_TEXT_BASELINE: {
                return 1;
            }
            case SPAN_VERTICAL_ALIGN_BOTTOM: {
                return 0;
            }
            case SPAN_VERTICAL_ALIGN_UNDEFINED: 
            case UNRECOGNIZED: {
                return 0;
            }
        }
        return 0;
    }

    private static boolean isBold(LayoutElementProto.FontStyle fontStyle) {
        switch (fontStyle.getWeight().getValue()) {
            case FONT_WEIGHT_BOLD: {
                return true;
            }
            case FONT_WEIGHT_NORMAL: 
            case FONT_WEIGHT_MEDIUM: 
            case FONT_WEIGHT_UNDEFINED: 
            case UNRECOGNIZED: {
                return false;
            }
        }
        return false;
    }

    private Typeface fontStyleToTypeface(LayoutElementProto.FontStyle fontStyle) {
        ProtoLayoutTheme.FontSet fonts = this.mProtoLayoutTheme.getFontSet(fontStyle.getVariant().getValue().getNumber());
        switch (fontStyle.getWeight().getValue()) {
            case FONT_WEIGHT_BOLD: {
                return fonts.getBoldFont();
            }
            case FONT_WEIGHT_MEDIUM: {
                return fonts.getMediumFont();
            }
            case FONT_WEIGHT_NORMAL: 
            case FONT_WEIGHT_UNDEFINED: 
            case UNRECOGNIZED: {
                return fonts.getNormalFont();
            }
        }
        return fonts.getNormalFont();
    }

    private static int fontStyleToTypefaceStyle(LayoutElementProto.FontStyle fontStyle) {
        boolean isBold = ProtoLayoutInflater.isBold(fontStyle);
        boolean isItalic = fontStyle.getItalic().getValue();
        if (isBold && isItalic) {
            return 3;
        }
        if (isBold) {
            return 1;
        }
        if (isItalic) {
            return 2;
        }
        return 0;
    }

    private Typeface createTypeface(LayoutElementProto.FontStyle fontStyle) {
        return Typeface.create((Typeface)this.fontStyleToTypeface(fontStyle), (int)ProtoLayoutInflater.fontStyleToTypefaceStyle(fontStyle));
    }

    private static MetricAffectingSpan createTypefaceSpan(LayoutElementProto.FontStyle fontStyle) {
        return new StyleSpan(ProtoLayoutInflater.fontStyleToTypefaceStyle(fontStyle));
    }

    private static boolean hasDefaultTypefaceStyle(LayoutElementProto.FontStyle fontStyle) {
        return !fontStyle.getItalic().getValue() && !ProtoLayoutInflater.isBold(fontStyle);
    }

    private float toPx(DimensionProto.SpProp spField) {
        return TypedValue.applyDimension((int)2, (float)spField.getValue(), (DisplayMetrics)this.mUiContext.getResources().getDisplayMetrics());
    }

    private void applyFontStyle(LayoutElementProto.FontStyle style2, TextView textView, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        textView.setTypeface(this.createTypeface(style2), ProtoLayoutInflater.fontStyleToTypefaceStyle(style2));
        if (style2.hasSize()) {
            textView.setTextSize(2, style2.getSize().getValue());
        }
        if (style2.hasLetterSpacing()) {
            textView.setLetterSpacing(style2.getLetterSpacing().getValue());
        }
        if (style2.hasColor()) {
            this.handleProp(style2.getColor(), arg_0 -> ((TextView)textView).setTextColor(arg_0), posId, pipelineMaker);
        } else {
            textView.setTextColor(-1);
        }
    }

    private void applyFontStyle(LayoutElementProto.FontStyle style2, CurvedTextView textView) {
        textView.setTypeface(this.createTypeface(style2), ProtoLayoutInflater.fontStyleToTypefaceStyle(style2));
        if (style2.hasSize()) {
            textView.setTextSize(this.toPx(style2.getSize()));
        }
    }

    void dispatchLaunchActionIntent(Intent i) {
        ActivityInfo ai = i.resolveActivityInfo(this.mUiContext.getPackageManager(), 0);
        if (ai != null && ai.exported && (ai.permission == null || ai.permission.isEmpty())) {
            this.mUiContext.startActivity(i);
        }
    }

    private void applyClickable(View view, ModifiersProto.Clickable clickable) {
        view.setTag(R.id.clickable_id_tag, (Object)clickable.getId());
        boolean hasAction = false;
        switch (clickable.getOnClick().getValueCase()) {
            case LAUNCH_ACTION: {
                Intent i = ProtoLayoutInflater.buildLaunchActionIntent(clickable.getOnClick().getLaunchAction(), clickable.getId(), this.mClickableIdExtra);
                if (i == null) break;
                hasAction = true;
                view.setOnClickListener(v -> {
                    i.setSourceBounds(ProtoLayoutInflater.getSourceBounds(view));
                    this.dispatchLaunchActionIntent(i);
                });
                break;
            }
            case LOAD_ACTION: {
                hasAction = true;
                if (this.mLoadActionExecutor == null) {
                    Log.w((String)TAG, (String)"Ignoring load action since an executor has not been provided.");
                    break;
                }
                view.setOnClickListener(v -> ((Executor)Preconditions.checkNotNull((Object)this.mLoadActionExecutor)).execute(() -> this.mLoadActionListener.onClick(ProtoLayoutInflater.buildState(clickable.getOnClick().getLoadAction(), clickable.getId()))));
                break;
            }
        }
        if (hasAction) {
            TypedValue outValue = new TypedValue();
            boolean isValid = this.mUiContext.getTheme().resolveAttribute(16843534, outValue, true);
            if (isValid) {
                view.setForeground(this.mUiContext.getDrawable(outValue.resourceId));
            } else {
                Log.e((String)TAG, (String)"Could not resolve android.R.attr.selectableItemBackground from Ui Context.");
            }
        }
    }

    private void applyPadding(View view, ModifiersProto.Padding padding) {
        if (padding.getRtlAware().getValue()) {
            view.setPaddingRelative(this.safeDpToPx(padding.getStart()), this.safeDpToPx(padding.getTop()), this.safeDpToPx(padding.getEnd()), this.safeDpToPx(padding.getBottom()));
        } else {
            view.setPadding(this.safeDpToPx(padding.getStart()), this.safeDpToPx(padding.getTop()), this.safeDpToPx(padding.getEnd()), this.safeDpToPx(padding.getBottom()));
        }
    }

    private GradientDrawable applyBackground(View view, ModifiersProto.Background background, @Nullable GradientDrawable drawable, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        int radiusPx;
        if (drawable == null) {
            drawable = new GradientDrawable();
        }
        if (background.hasColor()) {
            this.handleProp(background.getColor(), arg_0 -> ((GradientDrawable)drawable).setColor(arg_0), posId, pipelineMaker);
        }
        if (background.hasCorner() && (radiusPx = this.safeDpToPx(background.getCorner().getRadius())) != 0) {
            drawable.setCornerRadius((float)radiusPx);
            view.setClipToOutline(true);
            view.setOutlineProvider(ViewOutlineProvider.BACKGROUND);
        }
        return drawable;
    }

    private GradientDrawable applyBorder(ModifiersProto.Border border, @Nullable GradientDrawable drawable, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        if (drawable == null) {
            drawable = new GradientDrawable();
        }
        GradientDrawable finalDrawable = drawable;
        int width = this.safeDpToPx(border.getWidth());
        this.handleProp(border.getColor(), (Integer borderColor) -> finalDrawable.setStroke(width, borderColor.intValue()), posId, pipelineMaker);
        return drawable;
    }

    private View applyModifiers(View view, ModifiersProto.Modifiers modifiers, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        if (modifiers.hasClickable()) {
            this.applyClickable(view, modifiers.getClickable());
        }
        if (modifiers.hasSemantics()) {
            this.applySemantics(view, modifiers.getSemantics(), posId, pipelineMaker);
        }
        if (modifiers.hasPadding()) {
            this.applyPadding(view, modifiers.getPadding());
        }
        GradientDrawable backgroundDrawable = null;
        if (modifiers.hasBackground()) {
            backgroundDrawable = this.applyBackground(view, modifiers.getBackground(), backgroundDrawable, posId, pipelineMaker);
        }
        if (modifiers.hasBorder()) {
            backgroundDrawable = this.applyBorder(modifiers.getBorder(), backgroundDrawable, posId, pipelineMaker);
        }
        if (backgroundDrawable != null) {
            view.setBackground(backgroundDrawable);
        }
        if (this.mAnimationEnabled && modifiers.hasContentUpdateAnimation()) {
            pipelineMaker.ifPresent(p -> p.storeAnimatedVisibilityFor(posId, modifiers.getContentUpdateAnimation()));
        }
        return view;
    }

    static AnimationSet getEnterAnimations(@NonNull ModifiersProto.EnterTransition enterTransition, @NonNull View view) {
        AnimationSet animations = new AnimationSet(false);
        if (enterTransition.hasFadeIn()) {
            ModifiersProto.FadeInTransition fadeIn = enterTransition.getFadeIn();
            AlphaAnimation alphaAnimation = new AlphaAnimation(fadeIn.getInitialAlpha(), 1.0f);
            AnimationParameterProto.AnimationSpec spec = fadeIn.getAnimationSpec();
            AnimationsHelper.applyAnimationSpecToAnimation((Animation)alphaAnimation, (AnimationParameterProto.AnimationSpec)spec);
            animations.addAnimation((Animation)alphaAnimation);
        }
        if (enterTransition.hasSlideIn()) {
            ModifiersProto.SlideInTransition slideIn = enterTransition.getSlideIn();
            AnimationParameterProto.AnimationSpec spec = slideIn.getAnimationSpec();
            float fromXDelta = 0.0f;
            float toXDelta = 0.0f;
            float fromYDelta = 0.0f;
            float toYDelta = 0.0f;
            switch (slideIn.getDirectionValue()) {
                case 0: 
                case 1: 
                case 2: {
                    fromXDelta = ProtoLayoutInflater.getInitialOffsetOrDefaultX(slideIn, view);
                    break;
                }
                case 3: 
                case 4: {
                    fromYDelta = ProtoLayoutInflater.getInitialOffsetOrDefaultY(slideIn, view);
                    break;
                }
            }
            TranslateAnimation translateAnimation = new TranslateAnimation(fromXDelta, toXDelta, fromYDelta, toYDelta);
            AnimationsHelper.applyAnimationSpecToAnimation((Animation)translateAnimation, (AnimationParameterProto.AnimationSpec)spec);
            animations.addAnimation((Animation)translateAnimation);
        }
        return animations;
    }

    static AnimationSet getExitAnimations(@NonNull ModifiersProto.ExitTransition exitTransition, @NonNull View view) {
        ModifiersProto.SlideOutTransition slideOut;
        AnimationParameterProto.AnimationSpec spec;
        AnimationSet animations = new AnimationSet(false);
        if (exitTransition.hasFadeOut()) {
            ModifiersProto.FadeOutTransition fadeOut = exitTransition.getFadeOut();
            AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, fadeOut.getTargetAlpha());
            AnimationParameterProto.AnimationSpec spec2 = fadeOut.getAnimationSpec();
            if (!spec2.hasRepeatable() || spec2.getRepeatable().getIterations() != 0) {
                AnimationsHelper.applyAnimationSpecToAnimation((Animation)alphaAnimation, (AnimationParameterProto.AnimationSpec)spec2);
                animations.addAnimation((Animation)alphaAnimation);
            }
        }
        if (exitTransition.hasSlideOut() && (!(spec = (slideOut = exitTransition.getSlideOut()).getAnimationSpec()).hasRepeatable() || spec.getRepeatable().getIterations() != 0)) {
            float fromXDelta = 0.0f;
            float toXDelta = 0.0f;
            float fromYDelta = 0.0f;
            float toYDelta = 0.0f;
            switch (slideOut.getDirectionValue()) {
                case 0: 
                case 1: 
                case 2: {
                    toXDelta = ProtoLayoutInflater.getTargetOffsetOrDefaultX(slideOut, view);
                    break;
                }
                case 3: 
                case 4: {
                    toYDelta = ProtoLayoutInflater.getTargetOffsetOrDefaultY(slideOut, view);
                    break;
                }
            }
            TranslateAnimation translateAnimation = new TranslateAnimation(fromXDelta, toXDelta, fromYDelta, toYDelta);
            AnimationsHelper.applyAnimationSpecToAnimation((Animation)translateAnimation, (AnimationParameterProto.AnimationSpec)spec);
            animations.addAnimation((Animation)translateAnimation);
        }
        return animations;
    }

    private static float getInitialOffsetOrDefaultX(@NonNull ModifiersProto.SlideInTransition slideIn, @NonNull View view) {
        int sign;
        int n = sign = slideIn.getDirectionValue() == 1 ? -1 : 1;
        if (slideIn.hasInitialSlideBound()) {
            switch (slideIn.getInitialSlideBound().getInnerCase()) {
                case LINEAR_BOUND: {
                    return slideIn.getInitialSlideBound().getLinearBound().getOffsetDp() * (float)sign;
                }
                case PARENT_BOUND: {
                    if (slideIn.getInitialSlideBound().getParentBound().getSnapTo() != ModifiersProto.SlideParentSnapOption.SLIDE_PARENT_SNAP_TO_OUTSIDE) break;
                    return (sign == -1 ? view.getLeft() + view.getWidth() : view.getRight()) * sign;
                }
            }
        }
        return (sign == -1 ? view.getLeft() : view.getRight() - view.getWidth()) * sign;
    }

    private static float getInitialOffsetOrDefaultY(@NonNull ModifiersProto.SlideInTransition slideIn, @NonNull View view) {
        int sign;
        int n = sign = slideIn.getDirectionValue() == 3 ? -1 : 1;
        if (slideIn.hasInitialSlideBound()) {
            switch (slideIn.getInitialSlideBound().getInnerCase()) {
                case LINEAR_BOUND: {
                    return slideIn.getInitialSlideBound().getLinearBound().getOffsetDp() * (float)sign;
                }
                case PARENT_BOUND: {
                    if (slideIn.getInitialSlideBound().getParentBound().getSnapTo() != ModifiersProto.SlideParentSnapOption.SLIDE_PARENT_SNAP_TO_OUTSIDE) break;
                    return (sign == -1 ? view.getTop() + view.getHeight() : view.getBottom()) * sign;
                }
            }
        }
        return (sign == -1 ? view.getTop() : view.getBottom() - view.getHeight()) * sign;
    }

    private static float getTargetOffsetOrDefaultX(@NonNull ModifiersProto.SlideOutTransition slideOut, @NonNull View view) {
        int sign;
        int n = sign = slideOut.getDirectionValue() == 1 ? 1 : -1;
        if (slideOut.hasTargetSlideBound()) {
            switch (slideOut.getTargetSlideBound().getInnerCase()) {
                case LINEAR_BOUND: {
                    return slideOut.getTargetSlideBound().getLinearBound().getOffsetDp() * (float)sign;
                }
                case PARENT_BOUND: {
                    if (slideOut.getTargetSlideBound().getParentBound().getSnapTo() != ModifiersProto.SlideParentSnapOption.SLIDE_PARENT_SNAP_TO_OUTSIDE) break;
                    return (sign == -1 ? view.getLeft() + view.getWidth() : view.getRight()) * sign;
                }
            }
        }
        return (sign == 1 ? view.getLeft() : view.getRight() - view.getWidth()) * sign;
    }

    private static float getTargetOffsetOrDefaultY(@NonNull ModifiersProto.SlideOutTransition slideOut, @NonNull View view) {
        int sign;
        int n = sign = slideOut.getDirectionValue() == 3 ? 1 : -1;
        if (slideOut.hasTargetSlideBound()) {
            switch (slideOut.getTargetSlideBound().getInnerCase()) {
                case LINEAR_BOUND: {
                    return slideOut.getTargetSlideBound().getLinearBound().getOffsetDp() * (float)sign;
                }
                case PARENT_BOUND: {
                    if (slideOut.getTargetSlideBound().getParentBound().getSnapTo() != ModifiersProto.SlideParentSnapOption.SLIDE_PARENT_SNAP_TO_OUTSIDE) break;
                    return (sign == -1 ? view.getTop() + view.getHeight() : view.getBottom()) * sign;
                }
            }
        }
        return (sign == 1 ? view.getTop() : view.getBottom() - view.getHeight()) * sign;
    }

    private View applyModifiersToArcLayoutView(View view, ModifiersProto.ArcModifiers modifiers, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        if (!(view instanceof ArcLayout.Widget)) {
            Log.e((String)TAG, (String)"applyModifiersToArcLayoutView should only be called with an ArcLayout.Widget");
            return view;
        }
        if (modifiers.hasClickable()) {
            this.applyClickable(view, modifiers.getClickable());
        }
        if (modifiers.hasSemantics()) {
            this.applySemantics(view, modifiers.getSemantics(), posId, pipelineMaker);
        }
        return view;
    }

    private static int textAlignToAndroidGravity(AlignmentProto.TextAlignment alignment) {
        switch (alignment) {
            case TEXT_ALIGN_START: {
                return 0x800003;
            }
            case TEXT_ALIGN_CENTER: {
                return 1;
            }
            case TEXT_ALIGN_END: {
                return 0x800005;
            }
            case TEXT_ALIGN_UNDEFINED: 
            case UNRECOGNIZED: {
                return 1;
            }
        }
        return 1;
    }

    @Nullable
    private static TextUtils.TruncateAt textTruncationToEllipsize(LayoutElementProto.TextOverflowProp type) {
        switch (type.getValue()) {
            case TEXT_OVERFLOW_TRUNCATE: {
                return null;
            }
            case TEXT_OVERFLOW_ELLIPSIZE_END: {
                return TextUtils.TruncateAt.END;
            }
            case TEXT_OVERFLOW_MARQUEE: {
                return TextUtils.TruncateAt.MARQUEE;
            }
            case TEXT_OVERFLOW_UNDEFINED: 
            case UNRECOGNIZED: {
                return TEXT_OVERFLOW_DEFAULT;
            }
        }
        return TEXT_OVERFLOW_DEFAULT;
    }

    private static int anchorTypeToAnchorPos(AlignmentProto.ArcAnchorType type) {
        switch (type) {
            case ARC_ANCHOR_START: {
                return 0;
            }
            case ARC_ANCHOR_CENTER: {
                return 1;
            }
            case ARC_ANCHOR_END: {
                return 2;
            }
            case ARC_ANCHOR_UNDEFINED: 
            case UNRECOGNIZED: {
                return 1;
            }
        }
        return 1;
    }

    private static int angularAlignmentProtoToAngularAlignment(AlignmentProto.AngularAlignment angularAlignment) {
        switch (angularAlignment) {
            case ANGULAR_ALIGNMENT_START: {
                return 0;
            }
            case ANGULAR_ALIGNMENT_CENTER: {
                return 1;
            }
            case ANGULAR_ALIGNMENT_END: {
                return 2;
            }
            case ANGULAR_ALIGNMENT_UNDEFINED: 
            case UNRECOGNIZED: {
                return 1;
            }
        }
        return 1;
    }

    private int dimensionToPx(DimensionProto.ContainerDimension containerDimension) {
        switch (containerDimension.getInnerCase()) {
            case LINEAR_DIMENSION: {
                return this.safeDpToPx(containerDimension.getLinearDimension());
            }
            case EXPANDED_DIMENSION: {
                return -1;
            }
            case WRAPPED_DIMENSION: {
                return -2;
            }
            case INNER_NOT_SET: {
                return this.dimensionToPx(CONTAINER_DIMENSION_DEFAULT);
            }
        }
        return this.dimensionToPx(CONTAINER_DIMENSION_DEFAULT);
    }

    private static int extractTextColorArgb(LayoutElementProto.FontStyle fontStyle) {
        if (fontStyle.hasColor()) {
            return fontStyle.getColor().getArgb();
        }
        return -1;
    }

    @Nullable
    public static Intent buildLaunchActionIntent(@NonNull ActionProto.LaunchAction launchAction, @NonNull String clickableId, @NonNull String clickableIdExtra) {
        if (launchAction.hasAndroidActivity()) {
            ActionProto.AndroidActivity activity = launchAction.getAndroidActivity();
            Intent i = new Intent().setClassName(activity.getPackageName(), activity.getClassName());
            i.setFlags(0x10000000);
            if (!clickableId.isEmpty() && !clickableIdExtra.isEmpty()) {
                i.putExtra(clickableIdExtra, clickableId);
            }
            for (Map.Entry entry : activity.getKeyToExtraMap().entrySet()) {
                if (((ActionProto.AndroidExtra)entry.getValue()).hasStringVal()) {
                    i.putExtra((String)entry.getKey(), ((ActionProto.AndroidExtra)entry.getValue()).getStringVal().getValue());
                    continue;
                }
                if (((ActionProto.AndroidExtra)entry.getValue()).hasIntVal()) {
                    i.putExtra((String)entry.getKey(), ((ActionProto.AndroidExtra)entry.getValue()).getIntVal().getValue());
                    continue;
                }
                if (((ActionProto.AndroidExtra)entry.getValue()).hasLongVal()) {
                    i.putExtra((String)entry.getKey(), ((ActionProto.AndroidExtra)entry.getValue()).getLongVal().getValue());
                    continue;
                }
                if (((ActionProto.AndroidExtra)entry.getValue()).hasDoubleVal()) {
                    i.putExtra((String)entry.getKey(), ((ActionProto.AndroidExtra)entry.getValue()).getDoubleVal().getValue());
                    continue;
                }
                if (!((ActionProto.AndroidExtra)entry.getValue()).hasBooleanVal()) continue;
                i.putExtra((String)entry.getKey(), ((ActionProto.AndroidExtra)entry.getValue()).getBooleanVal().getValue());
            }
            return i;
        }
        return null;
    }

    static StateProto.State buildState(ActionProto.LoadAction loadAction, String clickableId) {
        return (StateProto.State)((StateProto.State.Builder)loadAction.getRequestState().toBuilder()).setLastClickableId(clickableId).build();
    }

    @Nullable
    private InflatedView inflateColumn(ParentViewWrapper parentViewWrapper, LayoutElementProto.Column column, String columnPosId, boolean includeChildren, RenderedMetadata.LayoutInfo.Builder layoutInfoBuilder, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        DimensionProto.ContainerDimension height;
        DimensionProto.ContainerDimension width = column.hasWidth() ? column.getWidth() : CONTAINER_DIMENSION_DEFAULT;
        DimensionProto.ContainerDimension containerDimension = height = column.hasHeight() ? column.getHeight() : CONTAINER_DIMENSION_DEFAULT;
        if (!this.canMeasureContainer(width, height, column.getContentsList())) {
            Log.w((String)TAG, (String)"Column set to wrap but contents are unmeasurable. Ignoring.");
            return null;
        }
        LinearLayout linearLayout = new LinearLayout(this.mUiContext);
        linearLayout.setOrientation(1);
        ViewGroup.LayoutParams layoutParams = ProtoLayoutInflater.generateDefaultLayoutParams();
        linearLayout.setGravity(ProtoLayoutInflater.horizontalAlignmentToGravity(column.getHorizontalAlignment().getValue()));
        layoutParams = this.updateLayoutParams(parentViewWrapper.getParentProperties(), layoutParams, width, height);
        this.resolveMinimumDimensions((View)linearLayout, width, height);
        View wrappedView = this.applyModifiers((View)linearLayout, column.getModifiers(), columnPosId, pipelineMaker);
        parentViewWrapper.maybeAddView(wrappedView, layoutParams);
        if (includeChildren) {
            this.inflateChildElements((ViewGroup)linearLayout, layoutParams, NO_OP_PENDING_LAYOUT_PARAMS, column.getContentsList(), columnPosId, layoutInfoBuilder, pipelineMaker);
            layoutInfoBuilder.removeSubtree(columnPosId);
        }
        int numMissingChildren = includeChildren ? 0 : column.getContentsCount();
        return new InflatedView(wrappedView, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams(layoutParams), NO_OP_PENDING_LAYOUT_PARAMS, numMissingChildren);
    }

    @Nullable
    private InflatedView inflateRow(ParentViewWrapper parentViewWrapper, LayoutElementProto.Row row, String rowPosId, boolean includeChildren, RenderedMetadata.LayoutInfo.Builder layoutInfoBuilder, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        DimensionProto.ContainerDimension height;
        DimensionProto.ContainerDimension width = row.hasWidth() ? row.getWidth() : CONTAINER_DIMENSION_DEFAULT;
        DimensionProto.ContainerDimension containerDimension = height = row.hasHeight() ? row.getHeight() : CONTAINER_DIMENSION_DEFAULT;
        if (!this.canMeasureContainer(width, height, row.getContentsList())) {
            Log.w((String)TAG, (String)"Row set to wrap but contents are unmeasurable. Ignoring.");
            return null;
        }
        LinearLayout linearLayout = new LinearLayout(this.mUiContext);
        linearLayout.setOrientation(0);
        ViewGroup.LayoutParams layoutParams = ProtoLayoutInflater.generateDefaultLayoutParams();
        linearLayout.setGravity(ProtoLayoutInflater.verticalAlignmentToGravity(row.getVerticalAlignment().getValue()));
        layoutParams = this.updateLayoutParams(parentViewWrapper.getParentProperties(), layoutParams, width, height);
        this.resolveMinimumDimensions((View)linearLayout, width, height);
        View wrappedView = this.applyModifiers((View)linearLayout, row.getModifiers(), rowPosId, pipelineMaker);
        parentViewWrapper.maybeAddView(wrappedView, layoutParams);
        if (includeChildren) {
            this.inflateChildElements((ViewGroup)linearLayout, layoutParams, NO_OP_PENDING_LAYOUT_PARAMS, row.getContentsList(), rowPosId, layoutInfoBuilder, pipelineMaker);
            layoutInfoBuilder.removeSubtree(rowPosId);
        }
        int numMissingChildren = includeChildren ? 0 : row.getContentsCount();
        return new InflatedView(wrappedView, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams(layoutParams), NO_OP_PENDING_LAYOUT_PARAMS, numMissingChildren);
    }

    @Nullable
    private InflatedView inflateBox(ParentViewWrapper parentViewWrapper, LayoutElementProto.Box box, String boxPosId, boolean includeChildren, RenderedMetadata.LayoutInfo.Builder layoutInfoBuilder, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        DimensionProto.ContainerDimension height;
        DimensionProto.ContainerDimension width = box.hasWidth() ? box.getWidth() : CONTAINER_DIMENSION_DEFAULT;
        DimensionProto.ContainerDimension containerDimension = height = box.hasHeight() ? box.getHeight() : CONTAINER_DIMENSION_DEFAULT;
        if (!this.canMeasureContainer(width, height, box.getContentsList())) {
            Log.w((String)TAG, (String)"Box set to wrap but contents are unmeasurable. Ignoring.");
            return null;
        }
        FrameLayout frame = new FrameLayout(this.mUiContext);
        ViewGroup.LayoutParams layoutParams = ProtoLayoutInflater.generateDefaultLayoutParams();
        layoutParams = this.updateLayoutParams(parentViewWrapper.getParentProperties(), layoutParams, width, height);
        this.resolveMinimumDimensions((View)frame, width, height);
        int gravity = ProtoLayoutInflater.getFrameLayoutGravity(box.getHorizontalAlignment().getValue(), box.getVerticalAlignment().getValue());
        RenderedMetadata.PendingFrameLayoutParams childLayoutParams = new RenderedMetadata.PendingFrameLayoutParams(gravity);
        View wrappedView = this.applyModifiers((View)frame, box.getModifiers(), boxPosId, pipelineMaker);
        parentViewWrapper.maybeAddView(wrappedView, layoutParams);
        if (includeChildren) {
            this.inflateChildElements((ViewGroup)frame, layoutParams, childLayoutParams, box.getContentsList(), boxPosId, layoutInfoBuilder, pipelineMaker);
            layoutInfoBuilder.removeSubtree(boxPosId);
        }
        try {
            ProtoLayoutInflater.applyGravityToFrameLayoutChildren(frame, gravity);
        }
        catch (IllegalStateException ex) {
            Log.e((String)TAG, (String)"Error applying Gravity to FrameLayout children.", (Throwable)ex);
        }
        int numMatchParentChildren = 0;
        for (int i = 0; i < frame.getChildCount(); ++i) {
            ViewGroup.LayoutParams lp = frame.getChildAt(i).getLayoutParams();
            if (lp.width != -1 && lp.height != -1) continue;
            ++numMatchParentChildren;
        }
        if (numMatchParentChildren == 1) {
            Space hackSpace = new Space(this.mUiContext);
            ViewGroup.LayoutParams hackSpaceLp = new ViewGroup.LayoutParams(-1, -1);
            frame.addView((View)hackSpace, hackSpaceLp);
        }
        int numMissingChildren = includeChildren ? 0 : box.getContentsCount();
        return new InflatedView(wrappedView, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams(layoutParams), childLayoutParams, numMissingChildren);
    }

    @Nullable
    private InflatedView inflateSpacer(ParentViewWrapper parentViewWrapper, LayoutElementProto.Spacer spacer, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        Space view;
        ViewGroup.LayoutParams layoutParams = ProtoLayoutInflater.generateDefaultLayoutParams();
        FrameLayout sizeWrapper = null;
        if (this.needsSizeWrapper(spacer.getWidth()) || this.needsSizeWrapper(spacer.getHeight())) {
            sizeWrapper = new FrameLayout(this.mUiContext);
            ViewGroup.LayoutParams spaceWrapperLayoutParams = ProtoLayoutInflater.generateDefaultLayoutParams();
            spaceWrapperLayoutParams.width = -2;
            spaceWrapperLayoutParams.height = -2;
            if (spacer.getWidth().getLinearDimension().hasDynamicValue()) {
                float widthForLayout = spacer.getWidth().getLinearDimension().getValueForLayout();
                spaceWrapperLayoutParams.width = this.safeDpToPx(widthForLayout);
            }
            if (spacer.getHeight().getLinearDimension().hasDynamicValue()) {
                float heightForLayout = spacer.getHeight().getLinearDimension().getValueForLayout();
                spaceWrapperLayoutParams.height = this.safeDpToPx(heightForLayout);
            }
            int gravity = ProtoLayoutInflater.horizontalAlignmentToGravity(spacer.getWidth().getLinearDimension().getHorizontalAlignmentForLayout()) | ProtoLayoutInflater.verticalAlignmentToGravity(spacer.getHeight().getLinearDimension().getVerticalAlignmentForLayout());
            FrameLayout.LayoutParams frameLayoutLayoutParams = new FrameLayout.LayoutParams(layoutParams);
            frameLayoutLayoutParams.gravity = gravity;
            layoutParams = frameLayoutLayoutParams;
            parentViewWrapper.maybeAddView((View)sizeWrapper, spaceWrapperLayoutParams);
            parentViewWrapper = new ParentViewWrapper((ViewGroup)sizeWrapper, spaceWrapperLayoutParams);
        }
        if (spacer.hasModifiers()) {
            view = this.applyModifiers(new View(this.mUiContext), spacer.getModifiers(), posId, pipelineMaker);
            layoutParams.width = 0;
            layoutParams.height = 0;
            parentViewWrapper.maybeAddView((View)view, layoutParams);
            this.handleProp(spacer.getWidth().getLinearDimension(), arg_0 -> this.lambda$inflateSpacer$6((View)view, arg_0), posId, pipelineMaker);
            this.handleProp(spacer.getHeight().getLinearDimension(), arg_0 -> this.lambda$inflateSpacer$7((View)view, arg_0), posId, pipelineMaker);
        } else {
            view = new Space(this.mUiContext);
            this.handleProp(spacer.getWidth().getLinearDimension(), arg_0 -> this.lambda$inflateSpacer$8((View)view, arg_0), posId, pipelineMaker);
            this.handleProp(spacer.getHeight().getLinearDimension(), arg_0 -> this.lambda$inflateSpacer$9((View)view, arg_0), posId, pipelineMaker);
            parentViewWrapper.maybeAddView((View)view, layoutParams);
        }
        if (sizeWrapper != null) {
            return new InflatedView((View)sizeWrapper, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams(layoutParams));
        }
        return new InflatedView((View)view, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams(layoutParams));
    }

    @Nullable
    private InflatedView inflateArcSpacer(ParentViewWrapper parentViewWrapper, LayoutElementProto.ArcSpacer spacer, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        float lengthDegrees = 0.0f;
        int thicknessPx = this.safeDpToPx(spacer.getThickness());
        WearCurvedSpacer space = new WearCurvedSpacer(this.mUiContext);
        ArcLayout.LayoutParams layoutParams = new ArcLayout.LayoutParams(ProtoLayoutInflater.generateDefaultLayoutParams());
        if (spacer.hasAngularLength()) {
            DimensionProto.ArcSpacerLength angularLength = spacer.getAngularLength();
            switch (angularLength.getInnerCase()) {
                case DEGREES: {
                    lengthDegrees = Math.max(0.0f, angularLength.getDegrees().getValue());
                    break;
                }
                case EXPANDED_ANGULAR_DIMENSION: {
                    float weight = angularLength.getExpandedAngularDimension().getLayoutWeight().getValue();
                    if (weight == 0.0f && thicknessPx == 0) {
                        return null;
                    }
                    layoutParams.setWeight(weight);
                    space.setThickness(thicknessPx);
                    View wrappedView = this.applyModifiersToArcLayoutView(space, spacer.getModifiers(), posId, pipelineMaker);
                    parentViewWrapper.maybeAddView(wrappedView, (ViewGroup.LayoutParams)layoutParams);
                    return new InflatedView(wrappedView, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams((ViewGroup.LayoutParams)layoutParams));
                }
            }
        } else {
            lengthDegrees = Math.max(0.0f, spacer.getLength().getValue());
        }
        if (lengthDegrees == 0.0f && thicknessPx == 0) {
            return null;
        }
        space.setSweepAngleDegrees(lengthDegrees);
        space.setThickness(thicknessPx);
        View wrappedView = this.applyModifiersToArcLayoutView(space, spacer.getModifiers(), posId, pipelineMaker);
        parentViewWrapper.maybeAddView(wrappedView, (ViewGroup.LayoutParams)layoutParams);
        return new InflatedView(wrappedView, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams((ViewGroup.LayoutParams)layoutParams));
    }

    private static void applyTextOverflow(TextView textView, LayoutElementProto.TextOverflowProp overflow, LayoutElementProto.MarqueeParameters marqueeParameters) {
        textView.setEllipsize(ProtoLayoutInflater.textTruncationToEllipsize(overflow));
        if (overflow.getValue() == LayoutElementProto.TextOverflow.TEXT_OVERFLOW_MARQUEE && textView.getMaxLines() == 1) {
            int marqueeIterations = marqueeParameters.hasIterations() ? marqueeParameters.getIterations() : -1;
            textView.setMarqueeRepeatLimit(marqueeIterations);
            textView.setSelected(true);
            textView.setSingleLine();
            textView.setHorizontalFadingEdgeEnabled(true);
        }
    }

    private InflatedView inflateText(ParentViewWrapper parentViewWrapper, LayoutElementProto.Text text, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        float fontHeightPx;
        float lineHeightPx;
        TextView textView = this.newThemedTextView();
        ViewGroup.LayoutParams layoutParams = ProtoLayoutInflater.generateDefaultLayoutParams();
        boolean needsSizeWrapper = this.needsSizeWrapper(text.getText());
        this.handleProp(text.getText(), (String t) -> {
            SpannableStringBuilder ssb = new SpannableStringBuilder();
            ssb.append((CharSequence)t);
            if (text.getFontStyle().getUnderline().getValue()) {
                ssb.setSpan((Object)new UnderlineSpan(), 0, ssb.length(), 17);
            }
            textView.setText((CharSequence)ssb);
        }, posId, pipelineMaker);
        textView.setGravity(ProtoLayoutInflater.textAlignToAndroidGravity(text.getMultilineAlignment().getValue()));
        if (text.hasMaxLines() && !needsSizeWrapper) {
            textView.setMaxLines(Math.max(1, text.getMaxLines().getValue()));
        } else {
            textView.setMaxLines(1);
        }
        ProtoLayoutInflater.applyTextOverflow(textView, text.getOverflow(), text.getMarqueeParameters());
        if (text.hasFontStyle()) {
            this.applyFontStyle(text.getFontStyle(), textView, posId, pipelineMaker);
        } else {
            this.applyFontStyle(LayoutElementProto.FontStyle.getDefaultInstance(), textView, posId, pipelineMaker);
        }
        boolean excludeFontPadding = false;
        if (text.hasAndroidTextStyle()) {
            excludeFontPadding = text.getAndroidTextStyle().getExcludeFontPadding();
        }
        this.applyExcludeFontPadding(textView, excludeFontPadding);
        if (text.hasLineHeight() && (lineHeightPx = this.toPx(text.getLineHeight())) != (fontHeightPx = textView.getPaint().getFontSpacing())) {
            textView.setLineSpacing(lineHeightPx - fontHeightPx, 1.0f);
        }
        textView.setImportantForAccessibility(2);
        View wrappedView = this.applyModifiers((View)textView, text.getModifiers(), posId, pipelineMaker);
        if (needsSizeWrapper) {
            String valueForLayout = text.getText().getValueForLayout();
            FrameLayout sizeChangingTextWrapper = new FrameLayout(this.mUiContext);
            ViewGroup.LayoutParams sizeChangingTextWrapperLayoutParams = ProtoLayoutInflater.generateDefaultLayoutParams();
            sizeChangingTextWrapperLayoutParams.width = (int)textView.getPaint().measureText(valueForLayout);
            sizeChangingTextWrapperLayoutParams.height = -2;
            int gravity = ProtoLayoutInflater.textAlignToAndroidGravity(text.getText().getTextAlignmentForLayout());
            FrameLayout.LayoutParams frameLayoutLayoutParams = new FrameLayout.LayoutParams(layoutParams);
            frameLayoutLayoutParams.gravity = gravity;
            layoutParams = frameLayoutLayoutParams;
            sizeChangingTextWrapper.addView(wrappedView, layoutParams);
            parentViewWrapper.maybeAddView((View)sizeChangingTextWrapper, sizeChangingTextWrapperLayoutParams);
            return new InflatedView((View)sizeChangingTextWrapper, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams(sizeChangingTextWrapperLayoutParams));
        }
        parentViewWrapper.maybeAddView(wrappedView, layoutParams);
        return new InflatedView(wrappedView, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams(layoutParams));
    }

    private void applyExcludeFontPadding(TextView textView, boolean excludeFontPadding) {
        textView.setIncludeFontPadding(!excludeFontPadding);
        if (!excludeFontPadding) {
            return;
        }
        float ascent = textView.getPaint().getFontMetrics().ascent;
        float descent = textView.getPaint().getFontMetrics().descent;
        String text = textView.getText().toString();
        Rect bounds = new Rect();
        textView.getPaint().getTextBounds(text, 0, Math.max(0, text.length() - 1), bounds);
        int topPadding = textView.getPaddingTop();
        int bottomPadding = textView.getPaddingBottom();
        if (ascent > (float)bounds.top) {
            topPadding = (int)(ascent - (float)bounds.top);
        }
        if (descent < (float)bounds.bottom) {
            bottomPadding = (int)((float)bounds.bottom - descent);
        }
        textView.setPadding(textView.getPaddingLeft(), topPadding, textView.getPaddingRight(), bottomPadding);
    }

    private InflatedView inflateArcText(ParentViewWrapper parentViewWrapper, LayoutElementProto.ArcText text, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        CurvedTextView textView = this.newThemedCurvedTextView();
        ViewGroup.LayoutParams layoutParams = ProtoLayoutInflater.generateDefaultLayoutParams();
        layoutParams.width = -1;
        layoutParams.height = -1;
        textView.setText(text.getText().getValue());
        if (text.hasFontStyle()) {
            this.applyFontStyle(text.getFontStyle(), textView);
        }
        textView.setTextColor(ProtoLayoutInflater.extractTextColorArgb(text.getFontStyle()));
        View wrappedView = this.applyModifiersToArcLayoutView((View)textView, text.getModifiers(), posId, pipelineMaker);
        parentViewWrapper.maybeAddView(wrappedView, layoutParams);
        return new InflatedView(wrappedView, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams(layoutParams));
    }

    private static boolean isZeroLengthImageDimension(DimensionProto.ImageDimension dimension) {
        return dimension.getInnerCase() == DimensionProto.ImageDimension.InnerCase.LINEAR_DIMENSION && dimension.getLinearDimension().getValue() == 0.0f;
    }

    private static DimensionProto.ContainerDimension imageDimensionToContainerDimension(DimensionProto.ImageDimension dimension) {
        switch (dimension.getInnerCase()) {
            case LINEAR_DIMENSION: {
                return (DimensionProto.ContainerDimension)DimensionProto.ContainerDimension.newBuilder().setLinearDimension(dimension.getLinearDimension()).build();
            }
            case EXPANDED_DIMENSION: {
                return (DimensionProto.ContainerDimension)DimensionProto.ContainerDimension.newBuilder().setExpandedDimension(DimensionProto.ExpandedDimensionProp.getDefaultInstance()).build();
            }
            case PROPORTIONAL_DIMENSION: {
                return (DimensionProto.ContainerDimension)DimensionProto.ContainerDimension.newBuilder().setWrappedDimension(DimensionProto.WrappedDimensionProp.getDefaultInstance()).build();
            }
        }
        throw new IllegalArgumentException("ImageDimension has an unknown dimension type: " + dimension.getInnerCase().name());
    }

    @Nullable
    private InflatedView inflateImage(ParentViewWrapper parentViewWrapper, LayoutElementProto.Image image, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        RatioViewWrapper ratioViewWrapper;
        ViewGroup.LayoutParams ratioWrapperLayoutParams;
        ImageViewWithoutIntrinsicSizes imageView;
        String protoResId;
        block28: {
            protoResId = image.getResourceId().getValue();
            if (image.getWidth().getInnerCase() == DimensionProto.ImageDimension.InnerCase.INNER_NOT_SET || image.getHeight().getInnerCase() == DimensionProto.ImageDimension.InnerCase.INNER_NOT_SET) {
                Log.w((String)TAG, (String)("One of width and height not set on image " + protoResId));
                return null;
            }
            if (ProtoLayoutInflater.isZeroLengthImageDimension(image.getWidth()) || ProtoLayoutInflater.isZeroLengthImageDimension(image.getHeight())) {
                Log.w((String)TAG, (String)("One of width and height was zero on image " + protoResId));
                return null;
            }
            if (image.getWidth().getInnerCase() == DimensionProto.ImageDimension.InnerCase.PROPORTIONAL_DIMENSION && image.getHeight().getInnerCase() == DimensionProto.ImageDimension.InnerCase.PROPORTIONAL_DIMENSION) {
                Log.w((String)TAG, (String)("Both width and height were proportional for image " + protoResId));
                return null;
            }
            Float ratio = Float.valueOf(-1.0f);
            if (image.getWidth().getInnerCase() == DimensionProto.ImageDimension.InnerCase.PROPORTIONAL_DIMENSION) {
                ratio = ProtoLayoutInflater.safeAspectRatioOrNull(image.getWidth().getProportionalDimension());
            }
            if (image.getHeight().getInnerCase() == DimensionProto.ImageDimension.InnerCase.PROPORTIONAL_DIMENSION) {
                ratio = ProtoLayoutInflater.safeAspectRatioOrNull(image.getHeight().getProportionalDimension());
            }
            if (ratio == null) {
                Log.w((String)TAG, (String)("Invalid aspect ratio for image " + protoResId));
                return null;
            }
            imageView = new ImageViewWithoutIntrinsicSizes(this.mUiContext);
            if (image.hasContentScaleMode()) {
                imageView.setScaleType(ProtoLayoutInflater.contentScaleModeToScaleType(image.getContentScaleMode().getValue()));
            }
            if (image.getWidth().getInnerCase() == DimensionProto.ImageDimension.InnerCase.LINEAR_DIMENSION) {
                imageView.setMinimumWidth(this.safeDpToPx(image.getWidth().getLinearDimension()));
            }
            if (image.getHeight().getInnerCase() == DimensionProto.ImageDimension.InnerCase.LINEAR_DIMENSION) {
                imageView.setMinimumHeight(this.safeDpToPx(image.getHeight().getLinearDimension()));
            }
            ratioWrapperLayoutParams = ProtoLayoutInflater.generateDefaultLayoutParams();
            ratioWrapperLayoutParams = this.updateLayoutParams(parentViewWrapper.getParentProperties(), ratioWrapperLayoutParams, ProtoLayoutInflater.imageDimensionToContainerDimension(image.getWidth()), ProtoLayoutInflater.imageDimensionToContainerDimension(image.getHeight()));
            View wrappedImageView = this.applyModifiers((View)imageView, image.getModifiers(), posId, pipelineMaker);
            ratioViewWrapper = new RatioViewWrapper(this.mUiContext);
            ratioViewWrapper.setAspectRatio(ratio.floatValue());
            ratioViewWrapper.addView(wrappedImageView);
            parentViewWrapper.maybeAddView((View)ratioViewWrapper, ratioWrapperLayoutParams);
            ListenableFuture<Drawable> drawableFuture = this.mLayoutResourceResolvers.getDrawable(protoResId);
            Drawable immediatelySetDrawable = null;
            if (drawableFuture.isDone() && !drawableFuture.isCancelled()) {
                immediatelySetDrawable = ProtoLayoutInflater.setImageDrawable((ImageView)imageView, drawableFuture, protoResId);
            }
            if (immediatelySetDrawable != null && pipelineMaker.isPresent()) {
                if (immediatelySetDrawable instanceof AnimatedVectorDrawable) {
                    AnimatedVectorDrawable avd = (AnimatedVectorDrawable)immediatelySetDrawable;
                    try {
                        TriggerProto.Trigger trigger = this.mLayoutResourceResolvers.getAnimationTrigger(protoResId);
                        if (trigger != null && trigger.getInnerCase() == TriggerProto.Trigger.InnerCase.ON_CONDITION_MET_TRIGGER) {
                            TriggerProto.OnConditionMetTrigger conditionTrigger = trigger.getOnConditionMetTrigger();
                            pipelineMaker.get().addResolvedAnimatedImageWithBoolTrigger(avd, trigger, posId, conditionTrigger.getTrigger());
                            break block28;
                        }
                        if (trigger == null || trigger.getInnerCase() == TriggerProto.Trigger.InnerCase.INNER_NOT_SET) {
                            trigger = DEFAULT_ANIMATION_TRIGGER;
                        }
                        pipelineMaker.get().addResolvedAnimatedImage(avd, trigger, posId);
                    }
                    catch (RuntimeException ex) {
                        Log.e((String)TAG, (String)"Error setting up animation trigger", (Throwable)ex);
                    }
                } else if (immediatelySetDrawable instanceof SeekableAnimatedVectorDrawable) {
                    SeekableAnimatedVectorDrawable seekableAvd = (SeekableAnimatedVectorDrawable)immediatelySetDrawable;
                    try {
                        DynamicProto.DynamicFloat progress = this.mLayoutResourceResolvers.getBoundProgress(protoResId);
                        if (progress != null) {
                            pipelineMaker.get().addResolvedSeekableAnimatedImage(seekableAvd, progress, posId);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        Log.e((String)TAG, (String)"Error setting up seekable animated image", (Throwable)ex);
                    }
                }
            } else {
                try {
                    if (this.mLayoutResourceResolvers.hasPlaceholderDrawable(protoResId) && ProtoLayoutInflater.setImageDrawable((ImageView)imageView, this.mLayoutResourceResolvers.getPlaceholderDrawableOrThrow(protoResId), protoResId) == null) {
                        Log.w((String)TAG, (String)("Failed to set the placeholder for " + protoResId));
                    }
                }
                catch (ResourceResolvers.ResourceAccessException | IllegalArgumentException ex) {
                    Log.e((String)TAG, (String)("Exception loading placeholder for resource " + protoResId), (Throwable)ex);
                }
                drawableFuture.addListener(() -> ProtoLayoutInflater.setImageDrawable((ImageView)imageView, (Future<Drawable>)drawableFuture, protoResId), ContextCompat.getMainExecutor((Context)this.mUiContext));
            }
        }
        boolean canImageBeTinted = false;
        try {
            canImageBeTinted = this.mLayoutResourceResolvers.canImageBeTinted(protoResId);
        }
        catch (IllegalArgumentException ex) {
            Log.e((String)TAG, (String)("Exception tinting image " + protoResId), (Throwable)ex);
        }
        if (image.getColorFilter().hasTint() && canImageBeTinted) {
            this.handleProp(image.getColorFilter().getTint(), (Integer tintColor) -> {
                ColorStateList tint = ColorStateList.valueOf((int)tintColor);
                imageView.setImageTintList(tint);
                imageView.setImageTintMode(PorterDuff.Mode.SRC_IN);
            }, posId, pipelineMaker);
        }
        return new InflatedView((View)ratioViewWrapper, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams(ratioWrapperLayoutParams));
    }

    @Nullable
    private static Drawable setImageDrawable(ImageView imageView, Future<Drawable> drawableFuture, String protoResId) {
        try {
            return ProtoLayoutInflater.setImageDrawable(imageView, drawableFuture.get(), protoResId);
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            Log.w((String)TAG, (String)("Could not get drawable for image " + protoResId), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Drawable setImageDrawable(ImageView imageView, Drawable drawable, String protoResId) {
        if (drawable instanceof BitmapDrawable && ((BitmapDrawable)drawable).getBitmap().getByteCount() > 0x1400000) {
            Log.w((String)TAG, (String)("Ignoring image " + protoResId + " as it's too large."));
            return null;
        }
        imageView.setImageDrawable(drawable);
        return drawable;
    }

    @Nullable
    private InflatedView inflateArcLine(ParentViewWrapper parentViewWrapper, LayoutElementProto.ArcLine line, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        DimensionProto.DegreesProp length;
        float lengthDegrees = 0.0f;
        if (line.hasAngularLength()) {
            if (line.getAngularLength().getInnerCase() == DimensionProto.ArcLineLength.InnerCase.DEGREES) {
                lengthDegrees = Math.max(0.0f, line.getAngularLength().getDegrees().getValue());
            }
        } else {
            lengthDegrees = Math.max(0.0f, line.getLength().getValue());
        }
        int thicknessPx = this.safeDpToPx(line.getThickness());
        if (lengthDegrees == 0.0f && thicknessPx == 0) {
            return null;
        }
        WearCurvedLineView lineView = new WearCurvedLineView(this.mUiContext);
        ArcLayout.LayoutParams layoutParams = new ArcLayout.LayoutParams(ProtoLayoutInflater.generateDefaultLayoutParams());
        layoutParams.width = -1;
        layoutParams.height = -1;
        if (line.hasColor()) {
            this.handleProp(line.getColor(), lineView::setColor, posId, pipelineMaker);
        } else {
            lineView.setColor(-1);
        }
        if (line.hasStrokeCap()) {
            switch (line.getStrokeCap().getValue()) {
                case STROKE_CAP_BUTT: {
                    lineView.setStrokeCap(Paint.Cap.BUTT);
                    break;
                }
                case STROKE_CAP_ROUND: {
                    lineView.setStrokeCap(Paint.Cap.ROUND);
                    break;
                }
                case STROKE_CAP_SQUARE: {
                    lineView.setStrokeCap(Paint.Cap.SQUARE);
                    break;
                }
                case UNRECOGNIZED: 
                case STROKE_CAP_UNDEFINED: {
                    Log.w((String)TAG, (String)"Undefined StrokeCap value.");
                }
            }
        }
        lineView.setThickness(thicknessPx);
        if (line.hasAngularLength()) {
            DimensionProto.ArcLineLength angularLength = line.getAngularLength();
            switch (angularLength.getInnerCase()) {
                case DEGREES: {
                    length = line.getAngularLength().getDegrees();
                    this.handleProp(length, lineView::setLineSweepAngleDegrees, posId, pipelineMaker);
                    break;
                }
                case EXPANDED_ANGULAR_DIMENSION: {
                    DimensionProto.ExpandedAngularDimensionProp expandedAngularDimension = angularLength.getExpandedAngularDimension();
                    layoutParams.setWeight(expandedAngularDimension.hasLayoutWeight() ? expandedAngularDimension.getLayoutWeight().getValue() : 1.0f);
                    length = DimensionProto.DegreesProp.getDefaultInstance();
                    break;
                }
                default: {
                    length = DimensionProto.DegreesProp.getDefaultInstance();
                    break;
                }
            }
        } else {
            length = line.getLength();
            this.handleProp(length, lineView::setLineSweepAngleDegrees, posId, pipelineMaker);
        }
        float sizeForLayout = this.getSizeForLayout(line.getLength(), -1.0f);
        SizedArcContainer sizeWrapper = null;
        SizedArcContainer.LayoutParams sizedLp = new SizedArcContainer.LayoutParams(-1, -1);
        if (this.needsSizeWrapper(length)) {
            sizeWrapper = new SizedArcContainer(this.mUiContext);
            sizeWrapper.setSweepAngleDegrees(sizeForLayout);
            sizedLp.setAngularAlignment(ProtoLayoutInflater.angularAlignmentProtoToAngularAlignment(length.getAngularAlignmentForLayout()));
            lineView.setMaxSweepAngleDegrees(sizeForLayout);
        }
        View wrappedView = this.applyModifiersToArcLayoutView(lineView, line.getModifiers(), posId, pipelineMaker);
        if (sizeWrapper != null) {
            sizeWrapper.addView(wrappedView, sizedLp);
            parentViewWrapper.maybeAddView((View)sizeWrapper, (ViewGroup.LayoutParams)layoutParams);
            return new InflatedView((View)sizeWrapper, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams((ViewGroup.LayoutParams)layoutParams));
        }
        parentViewWrapper.maybeAddView(wrappedView, (ViewGroup.LayoutParams)layoutParams);
        return new InflatedView(wrappedView, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams((ViewGroup.LayoutParams)layoutParams));
    }

    @Nullable
    private InflatedView inflateArc(ParentViewWrapper parentViewWrapper, LayoutElementProto.Arc arc, String arcPosId, boolean includeChildren, RenderedMetadata.LayoutInfo.Builder layoutInfoBuilder, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        ArcLayout arcLayout = new ArcLayout(this.mUiContext);
        ViewGroup.LayoutParams layoutParams = ProtoLayoutInflater.generateDefaultLayoutParams();
        layoutParams.width = -1;
        layoutParams.height = -1;
        this.handleProp(arc.getAnchorAngle(), (Float angle) -> {
            arcLayout.setAnchorAngleDegrees(angle.floatValue());
            arcLayout.requestLayout();
        }, arcPosId, pipelineMaker);
        arcLayout.setAnchorAngleDegrees(arc.getAnchorAngle().getValue());
        arcLayout.setAnchorType(ProtoLayoutInflater.anchorTypeToAnchorPos(arc.getAnchorType().getValue()));
        if (arc.hasMaxAngle()) {
            arcLayout.setMaxAngleDegrees(arc.getMaxAngle().getValue());
        }
        if (includeChildren) {
            int index = 0;
            for (LayoutElementProto.ArcLayoutElement child : arc.getContentsList()) {
                String childPosId;
                InflatedView childView = this.inflateArcLayoutElement(new ParentViewWrapper((ViewGroup)arcLayout, layoutParams), child, childPosId = ProtoLayoutDiffer.createNodePosId(arcPosId, index++), layoutInfoBuilder, pipelineMaker);
                if (childView == null) continue;
                ArcLayout.LayoutParams childLayoutParams = (ArcLayout.LayoutParams)childView.mView.getLayoutParams();
                boolean rotate = false;
                if (child.hasAdapter()) {
                    rotate = child.getAdapter().getRotateContents().getValue();
                }
                childLayoutParams.setRotated(rotate);
                childLayoutParams.setVerticalAlignment(ProtoLayoutInflater.verticalAlignmentToArcVAlign(arc.getVerticalAlign()));
            }
            layoutInfoBuilder.removeSubtree(arcPosId);
        }
        View wrappedView = this.applyModifiers((View)arcLayout, arc.getModifiers(), arcPosId, pipelineMaker);
        parentViewWrapper.maybeAddView(wrappedView, layoutParams);
        int numMissingChildren = includeChildren ? 0 : arc.getContentsCount();
        return new InflatedView(wrappedView, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams(layoutParams), NO_OP_PENDING_LAYOUT_PARAMS, numMissingChildren);
    }

    private void applyStylesToSpan(SpannableStringBuilder builder, int start, int end, LayoutElementProto.FontStyle fontStyle) {
        Object span;
        if (fontStyle.hasSize()) {
            span = new AbsoluteSizeSpan(Math.round(this.toPx(fontStyle.getSize())));
            builder.setSpan(span, start, end, 17);
        }
        if (fontStyle.hasWeight() || fontStyle.hasVariant()) {
            span = new CustomTypefaceSpan(this.fontStyleToTypeface(fontStyle));
            builder.setSpan(span, start, end, 17);
        }
        if (!ProtoLayoutInflater.hasDefaultTypefaceStyle(fontStyle)) {
            span = ProtoLayoutInflater.createTypefaceSpan(fontStyle);
            builder.setSpan(span, start, end, 17);
        }
        if (fontStyle.getUnderline().getValue()) {
            span = new UnderlineSpan();
            builder.setSpan(span, start, end, 17);
        }
        if (fontStyle.hasLetterSpacing()) {
            span = new LetterSpacingSpan(fontStyle.getLetterSpacing().getValue());
            builder.setSpan(span, start, end, 17);
        }
        ForegroundColorSpan colorSpan = new ForegroundColorSpan(ProtoLayoutInflater.extractTextColorArgb(fontStyle));
        builder.setSpan((Object)colorSpan, start, end, 17);
    }

    private void applyModifiersToSpan(SpannableStringBuilder builder, int start, int end, ModifiersProto.SpanModifiers modifiers) {
        if (modifiers.hasClickable()) {
            ProtoLayoutClickableSpan clickableSpan = new ProtoLayoutClickableSpan(modifiers.getClickable());
            builder.setSpan((Object)clickableSpan, start, end, 17);
        }
    }

    private SpannableStringBuilder inflateTextInSpannable(SpannableStringBuilder builder, LayoutElementProto.SpanText text) {
        int currentPos = builder.length();
        int lastPos = currentPos + text.getText().getValue().length();
        builder.append((CharSequence)text.getText().getValue());
        this.applyStylesToSpan(builder, currentPos, lastPos, text.getFontStyle());
        this.applyModifiersToSpan(builder, currentPos, lastPos, text.getModifiers());
        return builder;
    }

    private SpannableStringBuilder inflateImageInSpannable(SpannableStringBuilder builder, LayoutElementProto.SpanImage protoImage, TextView textView) {
        String protoResId = protoImage.getResourceId().getValue();
        if (protoImage.getWidth().getValue() == 0.0f || protoImage.getHeight().getValue() == 0.0f) {
            Log.w((String)TAG, (String)("One of width and height was zero on image " + protoResId));
            return builder;
        }
        ListenableFuture<Drawable> drawableFuture = this.mLayoutResourceResolvers.getDrawable(protoResId);
        if (drawableFuture.isDone()) {
            try {
                Drawable drawable = (Drawable)drawableFuture.get();
                this.appendSpanDrawable(builder, drawable, protoImage);
            }
            catch (InterruptedException | ExecutionException e) {
                Log.w((String)TAG, (String)("Could not get drawable for image " + protoImage.getResourceId().getValue()));
            }
        } else {
            Drawable placeholderDrawable = null;
            try {
                if (this.mLayoutResourceResolvers.hasPlaceholderDrawable(protoResId)) {
                    placeholderDrawable = this.mLayoutResourceResolvers.getPlaceholderDrawableOrThrow(protoResId);
                }
            }
            catch (ResourceResolvers.ResourceAccessException | IllegalArgumentException ex) {
                Log.e((String)TAG, (String)("Could not get placeholder for image " + protoResId), (Throwable)ex);
            }
            if (placeholderDrawable == null) {
                placeholderDrawable = new ColorDrawable(0);
            }
            int startInclusive = builder.length();
            FixedImageSpan placeholderDrawableSpan = this.appendSpanDrawable(builder, placeholderDrawable, protoImage);
            int endExclusive = builder.length();
            drawableFuture.addListener(() -> {
                builder.removeSpan((Object)placeholderDrawableSpan);
                this.setSpanDrawable(builder, drawableFuture, startInclusive, endExclusive, protoImage);
                textView.setText((CharSequence)builder);
            }, ContextCompat.getMainExecutor((Context)this.mUiContext));
        }
        return builder;
    }

    private FixedImageSpan appendSpanDrawable(SpannableStringBuilder builder, Drawable drawable, LayoutElementProto.SpanImage protoImage) {
        drawable.setBounds(0, 0, this.safeDpToPx(protoImage.getWidth()), this.safeDpToPx(protoImage.getHeight()));
        FixedImageSpan imgSpan = new FixedImageSpan(drawable, ProtoLayoutInflater.spanVerticalAlignmentToImgSpanAlignment(protoImage.getAlignment()));
        int startPos = builder.length();
        builder.append((CharSequence)"\u200d \u200d", (Object)imgSpan, 17);
        int endPos = builder.length();
        this.applyModifiersToSpan(builder, startPos, endPos, protoImage.getModifiers());
        return imgSpan;
    }

    private void setSpanDrawable(SpannableStringBuilder builder, ListenableFuture<Drawable> drawableFuture, int startInclusive, int endExclusive, LayoutElementProto.SpanImage protoImage) {
        String protoResourceId = protoImage.getResourceId().getValue();
        try {
            Drawable drawable = (Drawable)drawableFuture.get();
            drawable.setBounds(0, 0, this.safeDpToPx(protoImage.getWidth()), this.safeDpToPx(protoImage.getHeight()));
            FixedImageSpan imgSpan = new FixedImageSpan(drawable, ProtoLayoutInflater.spanVerticalAlignmentToImgSpanAlignment(protoImage.getAlignment()));
            builder.setSpan((Object)imgSpan, startInclusive, endExclusive, 17);
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            Log.w((String)TAG, (String)("Could not get drawable for image " + protoResourceId));
        }
    }

    private InflatedView inflateSpannable(ParentViewWrapper parentViewWrapper, LayoutElementProto.Spannable spannable, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        TextView tv = this.newThemedTextView();
        ViewGroup.LayoutParams layoutParams = ProtoLayoutInflater.generateDefaultLayoutParams();
        SpannableStringBuilder builder = new SpannableStringBuilder();
        boolean isAnySpanClickable = false;
        boolean excludeFontPadding = false;
        block4: for (LayoutElementProto.Span element : spannable.getSpansList()) {
            switch (element.getInnerCase()) {
                case IMAGE: {
                    LayoutElementProto.SpanImage protoImage = element.getImage();
                    builder = this.inflateImageInSpannable(builder, protoImage, tv);
                    if (!protoImage.getModifiers().hasClickable()) continue block4;
                    isAnySpanClickable = true;
                    continue block4;
                }
                case TEXT: {
                    LayoutElementProto.SpanText protoText = element.getText();
                    builder = this.inflateTextInSpannable(builder, protoText);
                    if (protoText.getModifiers().hasClickable()) {
                        isAnySpanClickable = true;
                    }
                    if (!protoText.hasAndroidTextStyle() || !protoText.getAndroidTextStyle().getExcludeFontPadding()) continue block4;
                    excludeFontPadding = true;
                    continue block4;
                }
            }
            Log.w((String)TAG, (String)"Unknown Span child type.");
        }
        tv.setGravity(ProtoLayoutInflater.horizontalAlignmentToGravity(spannable.getMultilineAlignment().getValue()));
        if (spannable.hasMaxLines()) {
            tv.setMaxLines(Math.max(1, spannable.getMaxLines().getValue()));
        } else {
            tv.setMaxLines(1);
        }
        ProtoLayoutInflater.applyTextOverflow(tv, spannable.getOverflow(), spannable.getMarqueeParameters());
        if (spannable.hasLineHeight()) {
            StandardLineHeightSpan span = new StandardLineHeightSpan((int)this.toPx(spannable.getLineHeight()));
            builder.setSpan((Object)span, 0, builder.length(), 17);
        } else if (spannable.hasLineSpacing()) {
            tv.setLineSpacing(this.toPx(spannable.getLineSpacing()), 1.0f);
        }
        tv.setText((CharSequence)builder);
        this.applyExcludeFontPadding(tv, excludeFontPadding);
        if (isAnySpanClickable) {
            tv.setMovementMethod(LinkMovementMethod.getInstance());
            tv.setHighlightColor(0);
            tv.setScroller((Scroller)new InhibitingScroller(this.mUiContext));
        }
        View wrappedView = this.applyModifiers((View)tv, spannable.getModifiers(), posId, pipelineMaker);
        parentViewWrapper.maybeAddView(wrappedView, layoutParams);
        return new InflatedView(wrappedView, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams(layoutParams));
    }

    @Nullable
    private InflatedView inflateArcLayoutElement(ParentViewWrapper parentViewWrapper, LayoutElementProto.ArcLayoutElement element, String nodePosId, RenderedMetadata.LayoutInfo.Builder layoutInfoBuilder, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        InflatedView inflatedView = null;
        switch (element.getInnerCase()) {
            case ADAPTER: {
                inflatedView = this.inflateLayoutElement(parentViewWrapper, element.getAdapter().getContent(), nodePosId, true, layoutInfoBuilder, pipelineMaker);
                break;
            }
            case SPACER: {
                inflatedView = this.inflateArcSpacer(parentViewWrapper, element.getSpacer(), nodePosId, pipelineMaker);
                break;
            }
            case LINE: {
                inflatedView = this.inflateArcLine(parentViewWrapper, element.getLine(), nodePosId, pipelineMaker);
                break;
            }
            case TEXT: {
                inflatedView = this.inflateArcText(parentViewWrapper, element.getText(), nodePosId, pipelineMaker);
                break;
            }
        }
        if (inflatedView == null) {
            Log.w((String)TAG, (String)"Unknown child type");
        } else if (nodePosId.isEmpty()) {
            Log.w((String)TAG, (String)("No node ID for " + element.getInnerCase().name()));
        } else {
            inflatedView.mView.setTag((Object)nodePosId);
            if (inflatedView.mView instanceof ViewGroup) {
                layoutInfoBuilder.add(nodePosId, RenderedMetadata.ViewProperties.fromViewGroup((ViewGroup)inflatedView.mView, inflatedView.mLayoutParams, inflatedView.mChildLayoutParams));
            }
            pipelineMaker.ifPresent(pipe -> pipe.rememberNode(nodePosId));
        }
        return inflatedView;
    }

    @Nullable
    private InflatedView inflateLayoutElement(ParentViewWrapper parentViewWrapper, LayoutElementProto.LayoutElement element, String nodePosId, boolean includeChildren, RenderedMetadata.LayoutInfo.Builder layoutInfoBuilder, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        InflatedView inflatedView = null;
        switch (element.getInnerCase()) {
            case COLUMN: {
                inflatedView = this.inflateColumn(parentViewWrapper, element.getColumn(), nodePosId, includeChildren, layoutInfoBuilder, pipelineMaker);
                break;
            }
            case ROW: {
                inflatedView = this.inflateRow(parentViewWrapper, element.getRow(), nodePosId, includeChildren, layoutInfoBuilder, pipelineMaker);
                break;
            }
            case BOX: {
                inflatedView = this.inflateBox(parentViewWrapper, element.getBox(), nodePosId, includeChildren, layoutInfoBuilder, pipelineMaker);
                break;
            }
            case SPACER: {
                inflatedView = this.inflateSpacer(parentViewWrapper, element.getSpacer(), nodePosId, pipelineMaker);
                break;
            }
            case TEXT: {
                inflatedView = this.inflateText(parentViewWrapper, element.getText(), nodePosId, pipelineMaker);
                break;
            }
            case IMAGE: {
                inflatedView = this.inflateImage(parentViewWrapper, element.getImage(), nodePosId, pipelineMaker);
                break;
            }
            case ARC: {
                inflatedView = this.inflateArc(parentViewWrapper, element.getArc(), nodePosId, includeChildren, layoutInfoBuilder, pipelineMaker);
                break;
            }
            case SPANNABLE: {
                inflatedView = this.inflateSpannable(parentViewWrapper, element.getSpannable(), nodePosId, pipelineMaker);
                break;
            }
            case EXTENSION: {
                try {
                    inflatedView = this.inflateExtension(parentViewWrapper, element.getExtension());
                }
                catch (IllegalStateException ex) {
                    Log.w((String)TAG, (String)"Error inflating Extension.", (Throwable)ex);
                }
                break;
            }
            case INNER_NOT_SET: {
                Log.w((String)TAG, (String)("Unknown child type: " + element.getInnerCase().name()));
            }
        }
        if (inflatedView == null) {
            Log.w((String)TAG, (String)("Error inflating " + element.getInnerCase().name()));
        } else if (nodePosId.isEmpty()) {
            Log.w((String)TAG, (String)("No node ID for " + element.getInnerCase().name()));
        } else {
            inflatedView.mView.setTag((Object)nodePosId);
            if (inflatedView.mView instanceof ViewGroup) {
                layoutInfoBuilder.add(nodePosId, RenderedMetadata.ViewProperties.fromViewGroup((ViewGroup)inflatedView.mView, inflatedView.mLayoutParams, inflatedView.mChildLayoutParams));
            }
            pipelineMaker.ifPresent(pipe -> pipe.rememberNode(nodePosId));
        }
        return inflatedView;
    }

    @Nullable
    private InflatedView inflateExtension(ParentViewWrapper parentViewWrapper, LayoutElementProto.ExtensionLayoutElement element) {
        int widthPx = this.safeDpToPx(element.getWidth().getLinearDimension());
        int heightPx = this.safeDpToPx(element.getHeight().getLinearDimension());
        if (widthPx == 0 && heightPx == 0) {
            return null;
        }
        if (this.mExtensionViewProvider == null) {
            Log.e((String)TAG, (String)"Layout has extension payload, but no extension provider is available.");
            return this.inflateFailedExtension(parentViewWrapper, element);
        }
        View view = this.mExtensionViewProvider.provideView(element.getPayload().toByteArray(), element.getExtensionId());
        if (view == null) {
            Log.w((String)TAG, (String)"Extension view provider returned null.");
            return this.inflateFailedExtension(parentViewWrapper, element);
        }
        if (view.getTag() != null) {
            throw new IllegalStateException("Extension must not set View's default tag");
        }
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(widthPx, heightPx);
        parentViewWrapper.maybeAddView(view, lp);
        return new InflatedView(view, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams(lp));
    }

    private InflatedView inflateFailedExtension(ParentViewWrapper parentViewWrapper, LayoutElementProto.ExtensionLayoutElement element) {
        int widthPx = this.safeDpToPx(element.getWidth().getLinearDimension());
        int heightPx = this.safeDpToPx(element.getHeight().getLinearDimension());
        Space space = new Space(this.mUiContext);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(widthPx, heightPx);
        parentViewWrapper.maybeAddView((View)space, lp);
        return new InflatedView((View)space, parentViewWrapper.getParentProperties().applyPendingChildLayoutParams(lp));
    }

    private void handleProp(TypesProto.StringProp stringProp, Consumer<String> consumer, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        if (stringProp.hasDynamicValue() && pipelineMaker.isPresent()) {
            try {
                pipelineMaker.get().addPipelineFor(stringProp.getDynamicValue(), stringProp.getValue(), this.mUiContext.getResources().getConfiguration().getLocales().get(0), posId, consumer);
            }
            catch (RuntimeException ex) {
                Log.e((String)TAG, (String)"Error building pipeline", (Throwable)ex);
                consumer.accept(stringProp.getValue());
            }
        } else {
            consumer.accept(stringProp.getValue());
        }
    }

    private void handleProp(DimensionProto.DegreesProp degreesProp, Consumer<Float> consumer, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        if (degreesProp.hasDynamicValue() && pipelineMaker.isPresent()) {
            try {
                pipelineMaker.get().addPipelineFor(degreesProp, degreesProp.getValue(), posId, consumer);
            }
            catch (RuntimeException ex) {
                Log.e((String)TAG, (String)"Error building pipeline", (Throwable)ex);
                consumer.accept(Float.valueOf(degreesProp.getValue()));
            }
        } else {
            consumer.accept(Float.valueOf(degreesProp.getValue()));
        }
    }

    private void handleProp(DimensionProto.DpProp dpProp, Consumer<Float> consumer, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        if (dpProp.hasDynamicValue() && pipelineMaker.isPresent()) {
            try {
                pipelineMaker.get().addPipelineFor(dpProp, dpProp.getValue(), posId, consumer);
            }
            catch (RuntimeException ex) {
                Log.e((String)TAG, (String)"Error building pipeline", (Throwable)ex);
                consumer.accept(Float.valueOf(dpProp.getValue()));
            }
        } else {
            consumer.accept(Float.valueOf(dpProp.getValue()));
        }
    }

    private void handleProp(ColorProto.ColorProp colorProp, Consumer<Integer> consumer, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        if (colorProp.hasDynamicValue() && pipelineMaker.isPresent()) {
            try {
                pipelineMaker.get().addPipelineFor(colorProp, colorProp.getArgb(), posId, consumer);
            }
            catch (RuntimeException ex) {
                Log.e((String)TAG, (String)"Error building pipeline", (Throwable)ex);
                consumer.accept(colorProp.getArgb());
            }
        } else {
            consumer.accept(colorProp.getArgb());
        }
    }

    private boolean needsSizeWrapper(TypesProto.StringProp stringProp) {
        if (stringProp.hasDynamicValue() && this.mDataPipeline.isPresent()) {
            if (!stringProp.getValueForLayout().isEmpty()) {
                return true;
            }
            return !this.mAllowLayoutChangingBindsWithoutDefault;
        }
        return false;
    }

    private boolean needsSizeWrapper(DimensionProto.SpacerDimension spacerDimension) {
        DimensionProto.DpProp dimension = spacerDimension.getLinearDimension();
        if (dimension.hasDynamicValue() && this.mDataPipeline.isPresent()) {
            if (dimension.getValueForLayout() > 0.0f) {
                return true;
            }
            return !this.mAllowLayoutChangingBindsWithoutDefault;
        }
        return false;
    }

    private boolean needsSizeWrapper(DimensionProto.DegreesProp degreesProp) {
        if (degreesProp.hasDynamicValue() && this.mDataPipeline.isPresent()) {
            if (degreesProp.getValueForLayout() > 0.0f) {
                return true;
            }
            return !this.mAllowLayoutChangingBindsWithoutDefault;
        }
        return false;
    }

    private float getSizeForLayout(DimensionProto.DegreesProp degreesProp, float otherwise) {
        if (degreesProp.hasDynamicValue() && this.mDataPipeline.isPresent()) {
            if (degreesProp.getValueForLayout() > 0.0f) {
                return degreesProp.getValueForLayout();
            }
            if (this.mAllowLayoutChangingBindsWithoutDefault) {
                return otherwise;
            }
            return 0.0f;
        }
        return otherwise;
    }

    private boolean canMeasureContainer(DimensionProto.ContainerDimension containerWidth, DimensionProto.ContainerDimension containerHeight, List<LayoutElementProto.LayoutElement> elements) {
        if (containerWidth.hasWrappedDimension() && !this.containsMeasurableWidth(containerHeight, elements)) {
            return false;
        }
        return !containerHeight.hasWrappedDimension() || this.containsMeasurableHeight(containerWidth, elements);
    }

    private boolean containsMeasurableWidth(DimensionProto.ContainerDimension containerHeight, List<LayoutElementProto.LayoutElement> elements) {
        for (LayoutElementProto.LayoutElement element : elements) {
            if (!this.isWidthMeasurable(element, containerHeight)) continue;
            return true;
        }
        return false;
    }

    private boolean containsMeasurableHeight(DimensionProto.ContainerDimension containerWidth, List<LayoutElementProto.LayoutElement> elements) {
        for (LayoutElementProto.LayoutElement element : elements) {
            if (!this.isHeightMeasurable(element, containerWidth)) continue;
            return true;
        }
        return false;
    }

    private boolean isWidthMeasurable(LayoutElementProto.LayoutElement element, DimensionProto.ContainerDimension containerHeight) {
        switch (element.getInnerCase()) {
            case COLUMN: {
                return this.isMeasurable(element.getColumn().getWidth());
            }
            case ROW: {
                return this.isMeasurable(element.getRow().getWidth());
            }
            case BOX: {
                return this.isMeasurable(element.getBox().getWidth());
            }
            case SPACER: {
                return ProtoLayoutInflater.isMeasurable(element.getSpacer().getWidth());
            }
            case IMAGE: {
                LayoutElementProto.Image img = element.getImage();
                if (img.getWidth().hasProportionalDimension()) {
                    boolean isContainerHeightKnown = containerHeight.hasExpandedDimension() || containerHeight.hasLinearDimension();
                    return img.getHeight().hasLinearDimension() || img.getHeight().hasExpandedDimension() && isContainerHeightKnown;
                }
                return ProtoLayoutInflater.isMeasurable(element.getImage().getWidth());
            }
            case TEXT: 
            case ARC: 
            case SPANNABLE: {
                return true;
            }
            case INNER_NOT_SET: {
                return false;
            }
        }
        return false;
    }

    private boolean isHeightMeasurable(LayoutElementProto.LayoutElement element, DimensionProto.ContainerDimension containerWidth) {
        switch (element.getInnerCase()) {
            case COLUMN: {
                return this.isMeasurable(element.getColumn().getHeight());
            }
            case ROW: {
                return this.isMeasurable(element.getRow().getHeight());
            }
            case BOX: {
                return this.isMeasurable(element.getBox().getHeight());
            }
            case SPACER: {
                return ProtoLayoutInflater.isMeasurable(element.getSpacer().getHeight());
            }
            case IMAGE: {
                LayoutElementProto.Image img = element.getImage();
                if (img.getHeight().hasProportionalDimension()) {
                    boolean isContainerWidthKnown = containerWidth.hasExpandedDimension() || containerWidth.hasLinearDimension();
                    return img.getWidth().hasLinearDimension() || img.getWidth().hasExpandedDimension() && isContainerWidthKnown;
                }
                return ProtoLayoutInflater.isMeasurable(element.getImage().getHeight());
            }
            case TEXT: 
            case ARC: 
            case SPANNABLE: {
                return true;
            }
            case INNER_NOT_SET: {
                return false;
            }
        }
        return false;
    }

    private boolean isMeasurable(DimensionProto.ContainerDimension dimension) {
        return this.dimensionToPx(dimension) != -1;
    }

    private static boolean isMeasurable(DimensionProto.ImageDimension dimension) {
        switch (dimension.getInnerCase()) {
            case LINEAR_DIMENSION: 
            case PROPORTIONAL_DIMENSION: {
                return true;
            }
            case EXPANDED_DIMENSION: 
            case INNER_NOT_SET: {
                return false;
            }
        }
        return false;
    }

    private static boolean isMeasurable(DimensionProto.SpacerDimension dimension) {
        switch (dimension.getInnerCase()) {
            case LINEAR_DIMENSION: {
                return true;
            }
            case INNER_NOT_SET: {
                return false;
            }
        }
        return false;
    }

    private void inflateChildElements(@NonNull ViewGroup parent, @NonNull ViewGroup.LayoutParams parentLayoutParams, RenderedMetadata.PendingLayoutParams childLayoutParams, List<LayoutElementProto.LayoutElement> childElements, String parentPosId, RenderedMetadata.LayoutInfo.Builder layoutInfoBuilder, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        int index = 0;
        for (LayoutElementProto.LayoutElement childElement : childElements) {
            String childPosId = ProtoLayoutDiffer.createNodePosId(parentPosId, index++);
            this.inflateLayoutElement(new ParentViewWrapper(parent, parentLayoutParams, childLayoutParams), childElement, childPosId, true, layoutInfoBuilder, pipelineMaker);
        }
    }

    @Nullable
    public InflateResult inflate(@NonNull ViewGroup parent) {
        RenderedMetadata.LayoutInfo.Builder layoutInfoBuilder = new RenderedMetadata.LayoutInfo.Builder(null);
        Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker = this.mDataPipeline.map(p -> p.newPipelineMaker(ProtoLayoutInflater::getEnterAnimations, ProtoLayoutInflater::getExitAnimations));
        InflatedView firstInflatedChild = this.inflateLayoutElement(new ParentViewWrapper(parent, new ViewGroup.LayoutParams(-1, -1)), this.mLayoutProto.getRoot(), "pT1", true, layoutInfoBuilder, pipelineMaker);
        if (firstInflatedChild == null) {
            return null;
        }
        if (this.mLayoutProto.hasFingerprint()) {
            parent.setTag(R.id.rendered_metadata_tag, (Object)new RenderedMetadata(this.mLayoutProto.getFingerprint(), layoutInfoBuilder.build()));
        }
        return new InflateResult(parent, firstInflatedChild.mView, pipelineMaker);
    }

    @Nullable
    public ViewGroupMutation computeMutation(@NonNull RenderedMetadata prevRenderedMetadata, @NonNull LayoutElementProto.Layout targetLayout) {
        if (prevRenderedMetadata.getTreeFingerprint() == null) {
            Log.w((String)TAG, (String)"No previous fingerprint available.");
            return null;
        }
        ProtoLayoutDiffer.LayoutDiff diff = ProtoLayoutDiffer.getDiff(prevRenderedMetadata.getTreeFingerprint(), targetLayout);
        if (diff == null) {
            Log.w((String)TAG, (String)"getDiff failed");
            return null;
        }
        ArrayList<InflatedView> inflatedViews = new ArrayList<InflatedView>();
        RenderedMetadata.LayoutInfo.Builder layoutInfoBuilder = new RenderedMetadata.LayoutInfo.Builder(prevRenderedMetadata.getLayoutInfo());
        RenderedMetadata.LayoutInfo prevLayoutInfo = prevRenderedMetadata.getLayoutInfo();
        Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker = this.mDataPipeline.map(p -> p.newPipelineMaker(ProtoLayoutInflater::getEnterAnimations, ProtoLayoutInflater::getExitAnimations));
        for (ProtoLayoutDiffer.TreeNodeWithChange changedNode : diff.getChangedNodes()) {
            RenderedMetadata.ViewProperties parentInfo;
            String nodePosId = changedNode.getPosId();
            if (nodePosId.isEmpty()) {
                Log.w((String)TAG, (String)"Empty nodePosId");
                return null;
            }
            if (nodePosId.equals("pT1")) {
                parentInfo = RenderedMetadata.ViewProperties.EMPTY;
            } else {
                String parentNodePosId = ProtoLayoutDiffer.getParentNodePosId(nodePosId);
                if (parentNodePosId == null || !prevLayoutInfo.contains(parentNodePosId)) {
                    Log.w((String)TAG, (String)("Can't find view " + nodePosId));
                    return null;
                }
                RenderedMetadata.ViewProperties possibleUpdatedParentInfo = layoutInfoBuilder.getViewPropertiesFor(parentNodePosId);
                parentInfo = possibleUpdatedParentInfo != null ? possibleUpdatedParentInfo : (RenderedMetadata.ViewProperties)Preconditions.checkNotNull((Object)prevLayoutInfo.getViewPropertiesFor(parentNodePosId));
            }
            InflatedView inflatedView = null;
            LayoutElementProto.LayoutElement updatedLayoutElement = changedNode.getLayoutElement();
            LayoutElementProto.ArcLayoutElement updatedArcLayoutElement = changedNode.getArcLayoutElement();
            if (updatedLayoutElement != null) {
                inflatedView = this.inflateLayoutElement(new ParentViewWrapper(parentInfo), updatedLayoutElement, nodePosId, !changedNode.isSelfOnlyChange(), layoutInfoBuilder, pipelineMaker);
            } else if (updatedArcLayoutElement != null) {
                inflatedView = this.inflateArcLayoutElement(new ParentViewWrapper(parentInfo), updatedArcLayoutElement, nodePosId, layoutInfoBuilder, pipelineMaker);
            }
            if (inflatedView == null) {
                Log.w((String)TAG, (String)"No inflatedView");
                return null;
            }
            inflatedViews.add(inflatedView);
            if (!changedNode.isSelfOnlyChange()) {
                pipelineMaker.ifPresent(p -> p.markForChildRemoval(nodePosId));
            }
            pipelineMaker.ifPresent(p -> p.markNodeAsChanged(nodePosId, !changedNode.isSelfOnlyChange()));
        }
        return new ViewGroupMutation(inflatedViews, new RenderedMetadata(targetLayout.getFingerprint(), layoutInfoBuilder.build()), prevRenderedMetadata.getTreeFingerprint().getRoot(), pipelineMaker);
    }

    @UiThread
    @NonNull
    public ListenableFuture<Void> applyMutation(@NonNull ViewGroup parent, @NonNull ViewGroupMutation groupMutation) {
        RenderedMetadata prevRenderedMetadata = ProtoLayoutInflater.getRenderedMetadata(parent);
        if (prevRenderedMetadata == null || !ProtoLayoutDiffer.areNodesEquivalent(prevRenderedMetadata.getTreeFingerprint().getRoot(), groupMutation.mPreMutationRootNodeFingerprint)) {
            // empty if block
        }
        if (groupMutation.isNoOp()) {
            return Futures.immediateVoidFuture();
        }
        if (groupMutation.mPipelineMaker.isPresent()) {
            SettableFuture result = SettableFuture.create();
            groupMutation.mPipelineMaker.get().playExitAnimations(parent, false, () -> {
                try {
                    this.applyMutationInternal(parent, groupMutation);
                    result.set(null);
                }
                catch (ViewMutationException ex) {
                    result.setException((Throwable)ex);
                }
            });
            return result;
        }
        try {
            this.applyMutationInternal(parent, groupMutation);
            return Futures.immediateVoidFuture();
        }
        catch (ViewMutationException ex) {
            return Futures.immediateFailedFuture((Throwable)ex);
        }
    }

    private void applyMutationInternal(@NonNull ViewGroup parent, @NonNull ViewGroupMutation groupMutation) {
        for (InflatedView inflatedView : groupMutation.mInflatedViews) {
            String posId = inflatedView.getTag();
            if (posId == null) {
                throw new ViewMutationException("View has no tag");
            }
            View viewToUpdate = parent.findViewWithTag((Object)posId);
            if (viewToUpdate == null) {
                throw new ViewMutationException("Can't find view " + posId);
            }
            ViewParent potentialImmediateParent = viewToUpdate.getParent();
            if (!(potentialImmediateParent instanceof ViewGroup)) {
                throw new ViewMutationException("Parent not a ViewGroup");
            }
            ViewGroup immediateParent = (ViewGroup)potentialImmediateParent;
            int childIndex = immediateParent.indexOfChild(viewToUpdate);
            if (childIndex == -1) {
                throw new ViewMutationException("Can't find child at " + childIndex);
            }
            if (!inflatedView.addMissingChildrenFrom(viewToUpdate)) {
                throw new ViewMutationException("Failed to add missing children " + posId);
            }
            immediateParent.removeViewAt(childIndex);
            immediateParent.addView(inflatedView.mView, childIndex, inflatedView.mLayoutParams);
        }
        groupMutation.mPipelineMaker.ifPresent(pipe -> pipe.commit(parent, false));
        parent.setTag(R.id.rendered_metadata_tag, (Object)groupMutation.mRenderedMetadataAfterMutation);
    }

    @UiThread
    @Nullable
    public static RenderedMetadata getRenderedMetadata(@NonNull ViewGroup inflateParent) {
        Object prevMetadataObject = inflateParent.getTag(R.id.rendered_metadata_tag);
        if (prevMetadataObject instanceof RenderedMetadata) {
            return (RenderedMetadata)prevMetadataObject;
        }
        if (prevMetadataObject != null) {
            Log.w((String)TAG, (String)"Incompatible prevMetadataObject");
        }
        return null;
    }

    @UiThread
    public static void clearRenderedMetadata(@NonNull ViewGroup inflateParent) {
        Log.d((String)TAG, (String)"Clearing rendered metadata. Next inflation won't use diff update.");
        inflateParent.setTag(R.id.rendered_metadata_tag, null);
    }

    private static void applyGravityToFrameLayoutChildren(FrameLayout parent, int gravity) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            View child = parent.getChildAt(i);
            if (!(child.getLayoutParams() instanceof FrameLayout.LayoutParams)) {
                throw new IllegalStateException("Layout params of child is not a descendant of FrameLayout.LayoutParams.");
            }
            ((FrameLayout.LayoutParams)child.getLayoutParams()).gravity = gravity;
        }
    }

    static String roleToClassName(ModifiersProto.SemanticsRole role) {
        switch (role) {
            case SEMANTICS_ROLE_IMAGE: {
                return "android.widget.ImageView";
            }
            case SEMANTICS_ROLE_BUTTON: {
                return "android.widget.Button";
            }
            case SEMANTICS_ROLE_CHECKBOX: {
                return "android.widget.CheckBox";
            }
            case SEMANTICS_ROLE_SWITCH: {
                return "android.widget.Switch";
            }
            case SEMANTICS_ROLE_RADIOBUTTON: {
                return "android.widget.RadioButton";
            }
        }
        return "";
    }

    private void applySemantics(View view, final ModifiersProto.Semantics semantics, String posId, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
        view.setImportantForAccessibility(1);
        ViewCompat.setAccessibilityDelegate((View)view, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onInitializeAccessibilityNodeInfo(@NonNull View host, @NonNull AccessibilityNodeInfoCompat info) {
                super.onInitializeAccessibilityNodeInfo(host, info);
                String className = ProtoLayoutInflater.roleToClassName(semantics.getRole());
                if (!className.isEmpty()) {
                    info.setClassName((CharSequence)className);
                }
                info.setFocusable(true);
                info.setImportantForAccessibility(true);
            }
        });
        if (semantics.hasContentDescription()) {
            this.handleProp(semantics.getContentDescription(), arg_0 -> ((View)view).setContentDescription(arg_0), posId, pipelineMaker);
        } else {
            view.setContentDescription((CharSequence)semantics.getObsoleteContentDescription());
        }
        if (semantics.hasStateDescription()) {
            this.handleProp(semantics.getStateDescription(), (String state) -> ViewCompat.setStateDescription((View)view, (CharSequence)state), posId, pipelineMaker);
        }
    }

    private TextView newThemedTextView() {
        return new TextView(this.mProtoLayoutThemeContext, null, this.mProtoLayoutTheme.getFallbackTextAppearanceResId());
    }

    private CurvedTextView newThemedCurvedTextView() {
        return new CurvedTextView(this.mProtoLayoutThemeContext, null, this.mProtoLayoutTheme.getFallbackTextAppearanceResId());
    }

    private static /* synthetic */ void lambda$applyMutationInternal$22(InflatedView inflatedView) {
        inflatedView.mView.animate().alpha(1.0f).setDuration(50L);
    }

    private /* synthetic */ void lambda$inflateSpacer$9(View view, Float height) {
        view.setMinimumHeight(this.safeDpToPx(height.floatValue()));
    }

    private /* synthetic */ void lambda$inflateSpacer$8(View view, Float width) {
        view.setMinimumWidth(this.safeDpToPx(width.floatValue()));
    }

    private /* synthetic */ void lambda$inflateSpacer$7(View view, Float height) {
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp == null) {
            Log.e((String)TAG, (String)"LayoutParams was null when updating spacer height");
            return;
        }
        lp.height = this.safeDpToPx(height.floatValue());
        view.requestLayout();
    }

    private /* synthetic */ void lambda$inflateSpacer$6(View view, Float width) {
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp == null) {
            Log.e((String)TAG, (String)"LayoutParams was null when updating spacer width");
            return;
        }
        lp.width = this.safeDpToPx(width.floatValue());
        view.requestLayout();
    }

    public static final class Config {
        @NonNull
        private final Context mUiContext;
        @NonNull
        private final LayoutElementProto.Layout mLayout;
        @NonNull
        private final ResourceResolvers mLayoutResourceResolvers;
        @Nullable
        private final Executor mLoadActionExecutor;
        @NonNull
        private final LoadActionListener mLoadActionListener;
        @NonNull
        private final Resources mRendererResources;
        @NonNull
        private final ProtoLayoutTheme mProtoLayoutTheme;
        @Nullable
        private final ProtoLayoutDynamicDataPipeline mDataPipeline;
        @NonNull
        private final String mClickableIdExtra;
        @Nullable
        private final ProtoLayoutExtensionViewProvider mExtensionViewProvider;
        private final boolean mAnimationEnabled;
        private final boolean mAllowLayoutChangingBindsWithoutDefault;

        Config(@NonNull Context uiContext, @NonNull LayoutElementProto.Layout layout, @NonNull ResourceResolvers layoutResourceResolvers, @Nullable Executor loadActionExecutor, @NonNull LoadActionListener loadActionListener, @NonNull Resources rendererResources, @NonNull ProtoLayoutTheme protoLayoutTheme, @Nullable ProtoLayoutDynamicDataPipeline dataPipeline, @Nullable ProtoLayoutExtensionViewProvider extensionViewProvider, @NonNull String clickableIdExtra, boolean animationEnabled, boolean allowLayoutChangingBindsWithoutDefault) {
            this.mUiContext = uiContext;
            this.mLayout = layout;
            this.mLayoutResourceResolvers = layoutResourceResolvers;
            this.mLoadActionExecutor = loadActionExecutor;
            this.mLoadActionListener = loadActionListener;
            this.mRendererResources = rendererResources;
            this.mProtoLayoutTheme = protoLayoutTheme;
            this.mDataPipeline = dataPipeline;
            this.mAnimationEnabled = animationEnabled;
            this.mAllowLayoutChangingBindsWithoutDefault = allowLayoutChangingBindsWithoutDefault;
            this.mClickableIdExtra = clickableIdExtra;
            this.mExtensionViewProvider = extensionViewProvider;
        }

        @NonNull
        public Context getUiContext() {
            return this.mUiContext;
        }

        @NonNull
        public LayoutElementProto.Layout getLayout() {
            return this.mLayout;
        }

        @NonNull
        public ResourceResolvers getLayoutResourceResolvers() {
            return this.mLayoutResourceResolvers;
        }

        @Nullable
        public Executor getLoadActionExecutor() {
            return this.mLoadActionExecutor;
        }

        @NonNull
        public LoadActionListener getLoadActionListener() {
            return this.mLoadActionListener;
        }

        @NonNull
        public Resources getRendererResources() {
            return this.mRendererResources;
        }

        @NonNull
        public ProtoLayoutTheme getProtoLayoutTheme() {
            return this.mProtoLayoutTheme;
        }

        @Nullable
        public ProtoLayoutDynamicDataPipeline getDynamicDataPipeline() {
            return this.mDataPipeline;
        }

        @NonNull
        public String getClickableIdExtra() {
            return this.mClickableIdExtra;
        }

        @Nullable
        public ProtoLayoutExtensionViewProvider getExtensionViewProvider() {
            return this.mExtensionViewProvider;
        }

        public boolean getAnimationEnabled() {
            return this.mAnimationEnabled;
        }

        public boolean getAllowLayoutChangingBindsWithoutDefault() {
            return this.mAllowLayoutChangingBindsWithoutDefault;
        }

        public static final class Builder {
            @NonNull
            private final Context mUiContext;
            @NonNull
            private final LayoutElementProto.Layout mLayout;
            @NonNull
            private final ResourceResolvers mLayoutResourceResolvers;
            @Nullable
            private Executor mLoadActionExecutor;
            @Nullable
            private LoadActionListener mLoadActionListener;
            @NonNull
            private Resources mRendererResources;
            @Nullable
            private ProtoLayoutTheme mProtoLayoutTheme;
            @Nullable
            private ProtoLayoutDynamicDataPipeline mDataPipeline = null;
            private boolean mAnimationEnabled = true;
            private boolean mAllowLayoutChangingBindsWithoutDefault = false;
            @Nullable
            private String mClickableIdExtra;
            @Nullable
            private ProtoLayoutExtensionViewProvider mExtensionViewProvider = null;

            public Builder(@NonNull Context uiContext, @NonNull LayoutElementProto.Layout layout, @NonNull ResourceResolvers layoutResourceResolvers) {
                this.mUiContext = uiContext;
                this.mRendererResources = uiContext.getResources();
                this.mLayout = layout;
                this.mLayoutResourceResolvers = layoutResourceResolvers;
            }

            @NonNull
            public Builder setLoadActionExecutor(@NonNull Executor loadActionExecutor) {
                this.mLoadActionExecutor = loadActionExecutor;
                return this;
            }

            @NonNull
            public Builder setLoadActionListener(@NonNull LoadActionListener loadActionListener) {
                this.mLoadActionListener = loadActionListener;
                return this;
            }

            @NonNull
            public Builder setRendererResources(@NonNull Resources rendererResources) {
                this.mRendererResources = rendererResources;
                return this;
            }

            @NonNull
            public Builder setProtoLayoutTheme(@NonNull ProtoLayoutTheme protoLayoutTheme) {
                this.mProtoLayoutTheme = protoLayoutTheme;
                return this;
            }

            @NonNull
            public Builder setDynamicDataPipeline(@NonNull ProtoLayoutDynamicDataPipeline dataPipeline) {
                this.mDataPipeline = dataPipeline;
                return this;
            }

            @NonNull
            public Builder setExtensionViewProvider(@NonNull ProtoLayoutExtensionViewProvider extensionViewProvider) {
                this.mExtensionViewProvider = extensionViewProvider;
                return this;
            }

            @NonNull
            public Builder setAnimationEnabled(boolean animationEnabled) {
                this.mAnimationEnabled = animationEnabled;
                return this;
            }

            @NonNull
            public Builder setClickableIdExtra(@NonNull String clickableIdExtra) {
                this.mClickableIdExtra = clickableIdExtra;
                return this;
            }

            @NonNull
            public Builder setAllowLayoutChangingBindsWithoutDefault(boolean allowLayoutChangingBindsWithoutDefault) {
                this.mAllowLayoutChangingBindsWithoutDefault = allowLayoutChangingBindsWithoutDefault;
                return this;
            }

            @NonNull
            public Config build() {
                if (this.mLoadActionListener != null && this.mLoadActionExecutor == null) {
                    throw new IllegalArgumentException("A loadActionExecutor should always be set if setting a loadActionListener.");
                }
                if (this.mLoadActionListener == null && this.mLoadActionExecutor != null) {
                    throw new IllegalArgumentException("A loadActionExecutor has been provided but no loadActionListener was set.");
                }
                if (this.mLoadActionListener == null) {
                    this.mLoadActionListener = p -> {};
                }
                if (this.mProtoLayoutTheme == null) {
                    this.mProtoLayoutTheme = ProtoLayoutThemeImpl.defaultTheme(this.mUiContext);
                }
                return new Config(this.mUiContext, this.mLayout, this.mLayoutResourceResolvers, this.mLoadActionExecutor, (LoadActionListener)Preconditions.checkNotNull((Object)this.mLoadActionListener), this.mRendererResources, (ProtoLayoutTheme)Preconditions.checkNotNull((Object)this.mProtoLayoutTheme), this.mDataPipeline, this.mExtensionViewProvider, (String)Preconditions.checkNotNull((Object)this.mClickableIdExtra), this.mAnimationEnabled, this.mAllowLayoutChangingBindsWithoutDefault);
            }
        }
    }

    public static interface LoadActionListener {
        public void onClick(@NonNull StateProto.State var1);
    }

    private static final class ParentViewWrapper {
        @Nullable
        private final ViewGroup mParent;
        private final RenderedMetadata.ViewProperties mParentProps;

        ParentViewWrapper(ViewGroup parent, ViewGroup.LayoutParams parentLayoutParams) {
            this.mParent = parent;
            this.mParentProps = RenderedMetadata.ViewProperties.fromViewGroup(parent, parentLayoutParams, NO_OP_PENDING_LAYOUT_PARAMS);
        }

        ParentViewWrapper(ViewGroup parent, ViewGroup.LayoutParams parentLayoutParams, RenderedMetadata.PendingLayoutParams childLayoutParams) {
            this.mParent = parent;
            this.mParentProps = RenderedMetadata.ViewProperties.fromViewGroup(parent, parentLayoutParams, childLayoutParams);
        }

        ParentViewWrapper(RenderedMetadata.ViewProperties parentProps) {
            this.mParent = null;
            this.mParentProps = parentProps;
        }

        RenderedMetadata.ViewProperties getParentProperties() {
            return this.mParentProps;
        }

        void maybeAddView(View child, ViewGroup.LayoutParams layoutParams) {
            if (this.mParent != null) {
                this.mParent.addView(child, layoutParams);
            }
        }
    }

    private static final class InflatedView {
        final View mView;
        final ViewGroup.LayoutParams mLayoutParams;
        final RenderedMetadata.PendingLayoutParams mChildLayoutParams;
        private int mNumMissingChildren;

        InflatedView(View view, ViewGroup.LayoutParams layoutParams, RenderedMetadata.PendingLayoutParams childLayoutParams, int numMissingChildren) {
            this.mView = view;
            this.mLayoutParams = layoutParams;
            this.mChildLayoutParams = childLayoutParams;
            this.mNumMissingChildren = numMissingChildren;
        }

        InflatedView(View view, ViewGroup.LayoutParams layoutParams) {
            this(view, layoutParams, NO_OP_PENDING_LAYOUT_PARAMS, 0);
        }

        boolean addMissingChildrenFrom(View source) {
            String tag;
            if (this.mNumMissingChildren == 0) {
                return true;
            }
            Object tagObj = source.getTag();
            String string = tag = tagObj == null ? "unknown" : (String)tagObj;
            if (!(this.mView instanceof ViewGroup)) {
                Log.w((String)ProtoLayoutInflater.TAG, (String)("Destination is not a group: " + tag));
                return false;
            }
            ViewGroup destinationGroup = (ViewGroup)this.mView;
            if (destinationGroup.getChildCount() > 0) {
                Log.w((String)ProtoLayoutInflater.TAG, (String)("Destination already has children: " + tag));
                return false;
            }
            if (!(source instanceof ViewGroup)) {
                Log.w((String)ProtoLayoutInflater.TAG, (String)("Source is not a group: " + tag));
                return false;
            }
            ViewGroup sourceGroup = (ViewGroup)source;
            if (sourceGroup.getChildCount() != this.mNumMissingChildren) {
                Log.w((String)ProtoLayoutInflater.TAG, (String)String.format("Expected %d children in %s found %d", this.mNumMissingChildren, tag, sourceGroup.getChildCount()));
                return false;
            }
            ArrayList<View> children = new ArrayList<View>(sourceGroup.getChildCount());
            for (int i = 0; i < this.mNumMissingChildren; ++i) {
                children.add(sourceGroup.getChildAt(i));
            }
            sourceGroup.removeAllViews();
            for (View child : children) {
                destinationGroup.addView(child);
                child.setLayoutParams(this.mChildLayoutParams.apply((ViewGroup.LayoutParams)Preconditions.checkNotNull((Object)child.getLayoutParams())));
            }
            this.mNumMissingChildren = 0;
            return true;
        }

        @Nullable
        String getTag() {
            return (String)this.mView.getTag();
        }
    }

    private class ProtoLayoutClickableSpan
    extends ClickableSpan {
        private final ModifiersProto.Clickable mClickable;

        ProtoLayoutClickableSpan(ModifiersProto.Clickable clickable) {
            this.mClickable = clickable;
        }

        public void onClick(@NonNull View widget) {
            ActionProto.Action action = this.mClickable.getOnClick();
            switch (action.getValueCase()) {
                case LAUNCH_ACTION: {
                    Intent i = ProtoLayoutInflater.buildLaunchActionIntent(action.getLaunchAction(), this.mClickable.getId(), ProtoLayoutInflater.this.mClickableIdExtra);
                    if (i == null) break;
                    ProtoLayoutInflater.this.dispatchLaunchActionIntent(i);
                    break;
                }
                case LOAD_ACTION: {
                    if (ProtoLayoutInflater.this.mLoadActionExecutor == null) {
                        Log.w((String)ProtoLayoutInflater.TAG, (String)"Ignoring load action since an executor has not been provided.");
                        break;
                    }
                    ProtoLayoutInflater.this.mLoadActionExecutor.execute(() -> ProtoLayoutInflater.this.mLoadActionListener.onClick(ProtoLayoutInflater.buildState(action.getLoadAction(), this.mClickable.getId())));
                    break;
                }
            }
        }

        public void updateDrawState(@NonNull TextPaint ds) {
        }
    }

    @VisibleForTesting
    static class FixedImageSpan
    extends ImageSpan {
        @Nullable
        private WeakReference<Drawable> mDrawableRef;

        FixedImageSpan(@NonNull Drawable drawable) {
            super(drawable);
        }

        FixedImageSpan(@NonNull Drawable drawable, int verticalAlignment) {
            super(drawable, verticalAlignment);
        }

        public void draw(@NonNull Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, @NonNull Paint paint) {
            Drawable b = this.getCachedDrawable();
            canvas.save();
            int transY = bottom - b.getBounds().bottom;
            if (this.mVerticalAlignment == 1) {
                transY = y - b.getBounds().bottom;
            } else if (this.mVerticalAlignment == 2) {
                transY = (bottom - top) / 2 - b.getBounds().height() / 2;
            }
            canvas.translate(x, (float)transY);
            b.draw(canvas);
            canvas.restore();
        }

        @VisibleForTesting
        Drawable getCachedDrawable() {
            WeakReference<Drawable> wr = this.mDrawableRef;
            Drawable d = null;
            if (wr != null) {
                d = (Drawable)wr.get();
            }
            if (d == null) {
                d = this.getDrawable();
                this.mDrawableRef = new WeakReference<Drawable>(d);
            }
            return d;
        }
    }

    private static class InhibitingScroller
    extends Scroller {
        InhibitingScroller(Context context) {
            super(context);
        }

        public void startScroll(int startX, int startY, int dx, int dy) {
        }

        public void startScroll(int startX, int startY, int dx, int dy, int duration) {
        }
    }

    public static final class InflateResult {
        public final ViewGroup inflateParent;
        public final View firstChild;
        private final Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> mPipelineMaker;

        InflateResult(ViewGroup inflateParent, View firstChild, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
            this.inflateParent = inflateParent;
            this.firstChild = firstChild;
            this.mPipelineMaker = pipelineMaker;
        }

        @UiThread
        public void updateDynamicDataPipeline(boolean isReattaching) {
            this.mPipelineMaker.ifPresent(pipe -> pipe.clearDataPipelineAndCommit(this.inflateParent, isReattaching));
        }
    }

    public static final class ViewGroupMutation {
        final List<InflatedView> mInflatedViews;
        final RenderedMetadata mRenderedMetadataAfterMutation;
        final FingerprintProto.NodeFingerprint mPreMutationRootNodeFingerprint;
        final Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> mPipelineMaker;

        ViewGroupMutation(List<InflatedView> inflatedViews, RenderedMetadata renderedMetadataAfterMutation, FingerprintProto.NodeFingerprint preMutationRootNodeFingerprint, Optional<ProtoLayoutDynamicDataPipeline.PipelineMaker> pipelineMaker) {
            this.mInflatedViews = inflatedViews;
            this.mRenderedMetadataAfterMutation = renderedMetadataAfterMutation;
            this.mPreMutationRootNodeFingerprint = preMutationRootNodeFingerprint;
            this.mPipelineMaker = pipelineMaker;
        }

        public boolean isNoOp() {
            return this.mInflatedViews.isEmpty();
        }
    }

    public static class ViewMutationException
    extends RuntimeException {
        public ViewMutationException(@NonNull String message) {
            super(message);
        }
    }
}

