/*
 * Decompiled with CFR 0.152.
 */
package androidx.wear.protolayout.renderer.inflater;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Typeface;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.StyleRes;
import androidx.annotation.StyleableRes;
import androidx.collection.ArrayMap;
import androidx.core.util.Preconditions;
import androidx.wear.protolayout.renderer.ProtoLayoutTheme;
import androidx.wear.protolayout.renderer.R;
import java.util.Map;

public class ProtoLayoutThemeImpl
implements ProtoLayoutTheme {
    private final Map<Integer, ProtoLayoutTheme.FontSet> mVariantToFontSet = new ArrayMap();
    private final Resources.Theme mTheme;
    @AttrRes
    private final int mFallbackTextAppearanceAttrId;

    @NonNull
    public static ProtoLayoutTheme defaultTheme(@NonNull Context context) {
        return new ProtoLayoutThemeImpl(context.getResources(), R.style.ProtoLayoutBaseTheme);
    }

    @NonNull
    public static ProtoLayoutTheme defaultTheme(@NonNull Resources resources) {
        return new ProtoLayoutThemeImpl(resources, R.style.ProtoLayoutBaseTheme);
    }

    public ProtoLayoutThemeImpl(@NonNull Context context, @StyleRes int themeResId) {
        this(context.getResources(), themeResId, R.attr.protoLayoutFallbackTextAppearance);
    }

    public ProtoLayoutThemeImpl(@NonNull Resources resources, @StyleRes int themeResId) {
        this(resources, themeResId, R.attr.protoLayoutFallbackTextAppearance);
    }

    public ProtoLayoutThemeImpl(@NonNull Resources resources, @StyleRes int themeResId, @AttrRes int fallbackTextAppearanceAttrId) {
        this.mTheme = resources.newTheme();
        this.mTheme.applyStyle(themeResId, true);
        this.mFallbackTextAppearanceAttrId = fallbackTextAppearanceAttrId;
        TypedArray a = this.mTheme.obtainStyledAttributes(R.styleable.ProtoLayoutTheme);
        this.mVariantToFontSet.put(1, new FontSetImpl(this.mTheme, a.getResourceId(R.styleable.ProtoLayoutTheme_protoLayoutTitleFont, -1)));
        this.mVariantToFontSet.put(2, new FontSetImpl(this.mTheme, a.getResourceId(R.styleable.ProtoLayoutTheme_protoLayoutBodyFont, -1)));
        a.recycle();
    }

    @Override
    @NonNull
    public ProtoLayoutTheme.FontSet getFontSet(int fontVariant) {
        ProtoLayoutTheme.FontSet defaultFontSet = (ProtoLayoutTheme.FontSet)Preconditions.checkNotNull((Object)this.mVariantToFontSet.get(2));
        return this.mVariantToFontSet.getOrDefault(fontVariant, defaultFontSet);
    }

    @Override
    @NonNull
    public Resources.Theme getTheme() {
        return this.mTheme;
    }

    @Override
    @AttrRes
    public int getFallbackTextAppearanceResId() {
        return this.mFallbackTextAppearanceAttrId;
    }

    public static class FontSetImpl
    implements ProtoLayoutTheme.FontSet {
        final Typeface mNormalFont;
        final Typeface mMediumFont;
        final Typeface mBoldFont;

        FontSetImpl(@NonNull Resources.Theme theme, @StyleRes int style2) {
            TypedArray a = theme.obtainStyledAttributes(style2, R.styleable.ProtoLayoutFontSet);
            this.mNormalFont = FontSetImpl.loadTypeface(a, R.styleable.ProtoLayoutFontSet_protoLayoutNormalFont);
            this.mMediumFont = FontSetImpl.loadTypeface(a, R.styleable.ProtoLayoutFontSet_protoLayoutMediumFont);
            this.mBoldFont = FontSetImpl.loadTypeface(a, R.styleable.ProtoLayoutFontSet_protoLayoutBoldFont);
            a.recycle();
        }

        private static Typeface loadTypeface(TypedArray array, @StyleableRes int styleableResId) {
            int resType = array.getType(styleableResId);
            if (array.getResourceId(styleableResId, -1) != -1 && array.getFont(styleableResId) != null) {
                return (Typeface)Preconditions.checkNotNull((Object)array.getFont(styleableResId));
            }
            if (resType == 3 && array.getString(styleableResId) != null) {
                return Typeface.create((String)((String)Preconditions.checkNotNull((Object)array.getString(styleableResId))), (int)0);
            }
            throw new IllegalArgumentException("Unknown resource value type " + resType);
        }

        @Override
        @NonNull
        public Typeface getNormalFont() {
            return this.mNormalFont;
        }

        @Override
        @NonNull
        public Typeface getMediumFont() {
            return this.mMediumFont;
        }

        @Override
        @NonNull
        public Typeface getBoldFont() {
            return this.mBoldFont;
        }
    }
}

